/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.common;

import com.xforceplus.bss.external.client.model.GetCompanyServiceInfoRequest;
import com.xforceplus.bss.external.client.model.GetCompanyServiceInfoResponse;
import com.xforceplus.bss.external.client.model.SearchCompanyListRequest;
import com.xforceplus.bss.external.client.model.SearchCompanyListResponse;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.PageInfo;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryInfo;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.seller.config.client.CompanyApiClient;
import com.xforceplus.seller.config.client.OrgApiClient;
import com.xforceplus.seller.config.client.model.MsCompanyModel;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsResponsePageInfo;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.service.BaseService;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseConfigService
extends BaseService {
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    protected OrgApiClient orgApiClient;
    @Autowired
    private CompanyApiClient companyApiClient;
    private final Integer DEFAULT_PAGENO = 1;
    private final Integer DEFAULT_PAGESIZE = 9999;

    protected OperateInfo getUpdateOperateInfo() {
        OperateInfo operateInfo = new OperateInfo();
        UserInfo userInfo = this.getCurrentUserInfo();
        operateInfo.setUpdatedBy(userInfo.getUserId() + "");
        return operateInfo;
    }

    protected OperateInfo getAddOperateInfo() {
        OperateInfo operateInfo = new OperateInfo();
        UserInfo userInfo = this.getCurrentUserInfo();
        operateInfo.setCreatedBy(userInfo.getUserId() + "");
        return operateInfo;
    }

    protected UserInfo getCurrentUserInfo() {
        return (UserInfo)this.userInfoHolder.get();
    }

    protected MsResponsePageInfo getDefaultResponsePageInfo(Integer total) {
        return this.generateResponsePageInfo(this.DEFAULT_PAGENO, total);
    }

    protected PageInfo getDefaultRequestPageInfo() {
        return this.generateRequestPageInfo(this.DEFAULT_PAGENO, this.DEFAULT_PAGESIZE);
    }

    protected MsResponsePageInfo generateResponsePageInfo(Integer pageNo, Integer total) {
        MsResponsePageInfo pageInfo = new MsResponsePageInfo();
        pageInfo.setPageNo(pageNo);
        pageInfo.setTotal(total);
        return pageInfo;
    }

    protected PageInfo generateRequestPageInfo(Integer pageNo, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(pageNo);
        pageInfo.setPageSize(pageSize);
        return pageInfo;
    }

    protected CompanyInfo generateCompanyInfo(CompanyInfo sourceInfo) {
        if (null == sourceInfo) {
            sourceInfo = new CompanyInfo();
        }
        if (null == sourceInfo.getTenantId()) {
            sourceInfo.setTenantId(Long.valueOf(this.getCurrentUserInfo().getGroupId()));
        }
        return sourceInfo;
    }

    protected TerminalQueryInfo generateTerminalQueryInfo(TerminalQueryInfo terminalQueryInfo) {
        if (null == terminalQueryInfo) {
            terminalQueryInfo = new TerminalQueryInfo();
        }
        terminalQueryInfo.setCompanyInfo(this.generateCompanyInfo(terminalQueryInfo.getCompanyInfo()));
        return terminalQueryInfo;
    }

    protected OrgModel getOrgModel(long groupId, long companyId) {
        GetOrgInfoRequest getOrgInfoRequest = new GetOrgInfoRequest();
        getOrgInfoRequest.setGroupID(Long.valueOf(groupId));
        getOrgInfoRequest.setAppid("phoenix-seller-config");
        getOrgInfoRequest.setRid(UUID.randomUUID().toString());
        getOrgInfoRequest.setDataType(GetOrgInfoRequest.DataTypeEnum.COMPANYID);
        getOrgInfoRequest.setDataValue(Long.toString(companyId));
        GetOrgInfoResponse getOrgInfoResponse = this.orgApiClient.getOrgInfo(getOrgInfoRequest);
        if (!getOrgInfoResponse.getCode().equals(BaseResponse.OK)) {
            this.logger.error("get org error:{}", (Object)getOrgInfoResponse.getMessage());
            return null;
        }
        return getOrgInfoResponse.getResult();
    }

    protected MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest) {
        long tenantId = this.getCurrentUserInfo().getGroupId();
        MsConfigDeviceGetCompanyListResponse msConfigDeviceGetCompanyListResponse = new MsConfigDeviceGetCompanyListResponse();
        SearchCompanyListRequest searchCompanyListRequest = new SearchCompanyListRequest();
        searchCompanyListRequest.setGroupId(Long.valueOf(tenantId));
        searchCompanyListRequest.setRid(UUID.randomUUID().toString());
        searchCompanyListRequest.setAppid("phoenix-seller-config");
        SearchCompanyListResponse searchCompanyListResponse = this.companyApiClient.searchCompanyList(searchCompanyListRequest);
        if (!searchCompanyListResponse.getCode().equals(BaseResponse.OK)) {
            msConfigDeviceGetCompanyListResponse.code(searchCompanyListResponse.getCode()).message(searchCompanyListResponse.getMessage());
            return msConfigDeviceGetCompanyListResponse;
        }
        List msCompanyModels = BeanMapper.mapList((Collection)searchCompanyListResponse.getResult(), MsCompanyModel.class);
        msConfigDeviceGetCompanyListResponse.result(msCompanyModels).code(BaseResponse.OK);
        return msConfigDeviceGetCompanyListResponse;
    }

    protected GetCompanyServiceInfoResponse getCompanyServiceInfo(long companyId) {
        GetCompanyServiceInfoRequest request = new GetCompanyServiceInfoRequest();
        request.setCompanyID(Long.valueOf(companyId));
        request.setRid(UUID.randomUUID().toString());
        request.setAppid("phoenix-seller-config");
        return this.companyApiClient.getCompanyServiceInfo(request);
    }

    protected String formatExpireAt(String expireAt) {
        Date sourceDate = DateUtils.toDateTime19((String)expireAt);
        return DateUtils.toDateStr((Date)sourceDate, (String)"yyyy/MM/dd");
    }
}

