/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.custom.service.impl;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.MsImportField;
import com.xforceplus.seller.config.client.model.MsImportFieldResponse;
import com.xforceplus.seller.config.custom.service.CustomDefinitionService;
import com.xforceplus.seller.config.exception.CustomDefinitionException;
import com.xforceplus.seller.config.repository.dao.CfgUserCustomDefinitionDao;
import com.xforceplus.seller.config.repository.model.CfgUserCustomDefinitionEntity;
import com.xforceplus.seller.config.repository.model.CfgUserCustomDefinitionExample;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.json.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomDefinitionServiceImpl
implements CustomDefinitionService {
    @Autowired
    private CfgUserCustomDefinitionDao cfgUserCustomDefinitionDao;

    public MsImportFieldResponse getCustomImportFields(Long userId, Long tenantId, String pageCode, String functionPoint) {
        MsImportFieldResponse response = new MsImportFieldResponse();
        if (CommonTools.isEmpty((String)pageCode)) {
            throw new CustomDefinitionException("\u8bf7\u8f93\u5165\u9875\u9762\u4ee3\u7801");
        }
        if (CommonTools.isEmpty((String)functionPoint)) {
            throw new CustomDefinitionException("\u8bf7\u8f93\u5165\u529f\u80fd\u70b9");
        }
        CfgUserCustomDefinitionEntity entity = this.queryEntity(userId, tenantId, pageCode, functionPoint);
        if (entity == null) {
            entity = this.queryEntity(Long.valueOf(0L), Long.valueOf(0L), pageCode, functionPoint);
        }
        if (entity == null) {
            response.setCode(Response.Fail);
            response.setMessage("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u914d\u7f6e");
            return response;
        }
        String context = entity.getCustomContent();
        Map map = JsonUtils.writeJsonToMap((String)context);
        ArrayList list = Lists.newArrayList();
        map.forEach((key, value) -> {
            MsImportField field = new MsImportField();
            field.setFieldCode(key);
            field.setFieldName(value);
            list.add(field);
        });
        response.setResult((List)list);
        response.setCode(Response.OK);
        return response;
    }

    private CfgUserCustomDefinitionEntity queryEntity(Long userId, Long tenantId, String pageCode, String functionPoint) {
        CfgUserCustomDefinitionExample example = new CfgUserCustomDefinitionExample();
        CfgUserCustomDefinitionExample.Criteria criteria = example.createCriteria().andUserIdEqualTo(userId).andTenantIdEqualTo(tenantId).andPageCodeEqualTo(pageCode);
        if (!CommonTools.isEmpty((String)functionPoint)) {
            criteria.andFunctionPointEqualTo(functionPoint);
        }
        return this.cfgUserCustomDefinitionDao.selectOneByExample(example);
    }
}

