/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.device.service.business.impl;

import com.xforceplus.micro.tax.device.contract.model.AddDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.AddDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.CompanyQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.PageInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.TaxDeviceQueryRequestInfo;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusResponse;
import com.xforceplus.seller.config.client.DeviceApiClient;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsCompanyModel;
import com.xforceplus.seller.config.client.model.MsCompanyQueryInfo;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddResult;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateResponse;
import com.xforceplus.seller.config.client.model.MsConfigUpdateDeviceStatusRequest;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsDeviceQueryInfo;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryRequest;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryResponse;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryResult;
import com.xforceplus.seller.config.client.model.MsQueryAllTaxDeviceByTaxDeviceTypesRequest;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResult;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsResponsePageInfo;
import com.xforceplus.seller.config.client.model.MsUpdateDeviceInfo;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.device.service.business.ConfigDeviceService;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigDeviceServiceImpl
extends BaseConfigService
implements ConfigDeviceService {
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private DeviceApiClient deviceApiClient;

    private long getGroupId() {
        return ((UserInfo)this.userInfoHolder.get()).getGroupId();
    }

    public MsConfigDeviceUpdateResponse updateDevice(MsConfigDeviceUpdateRequest configDeviceUpdateRequest) {
        MsResponse msResponse;
        BiFunction<Integer, String, MsConfigDeviceUpdateResponse> quickReturn = (code, message) -> {
            MsConfigDeviceUpdateResponse response = new MsConfigDeviceUpdateResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        Function<ResponseHead, MsConfigDeviceUpdateResponse> quickProcessResult = responseHead -> (MsConfigDeviceUpdateResponse)quickReturn.apply(responseHead.getCode(), responseHead.getMessage());
        MsUpdateDeviceInfo msUpdateDeviceInfo = configDeviceUpdateRequest.getDeviceInfo();
        long deviceId = msUpdateDeviceInfo.getId();
        QueryDeviceResponse queryDeviceResponse = this.queryDeviceById(Collections.singletonList(deviceId));
        if (!queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            return quickProcessResult.apply(queryDeviceResponse.getHead());
        }
        List deviceInfoList = queryDeviceResponse.getDevices();
        if (deviceInfoList == null || deviceInfoList.size() != 1) {
            return quickReturn.apply(BaseResponse.Fail, "\u5bf9\u5e94\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        DeviceInfo deviceInfo = (DeviceInfo)deviceInfoList.get(0);
        if (!deviceInfo.getCompanyInfo().getTenantId().equals(this.getGroupId())) {
            return quickReturn.apply(BaseResponse.Fail, "\u60a8\u65e0\u6743\u9650\u66f4\u65b0\u6b64\u6570\u636e");
        }
        Integer taxDeviceType = msUpdateDeviceInfo.getTaxDeviceInfo().getTaxDeviceType();
        if (taxDeviceType == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((taxDeviceType.equals(Integer.parseInt("1")) || taxDeviceType.equals(Integer.parseInt("2"))) && msUpdateDeviceInfo.getDeviceNo() != null && !deviceInfo.getDeviceNo().equals(msUpdateDeviceInfo.getDeviceNo()) && !(msResponse = this.checkDeviceNo(msUpdateDeviceInfo.getDeviceNo())).getCode().equals(BaseResponse.OK)) {
            return quickReturn.apply(msResponse.getCode(), msResponse.getMessage());
        }
        if (!deviceInfo.getStatus().equals(2) && !deviceInfo.getStatus().equals(0)) {
            return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        MsUpdateDeviceInfo msDeviceInfo = configDeviceUpdateRequest.getDeviceInfo();
        if (!msDeviceInfo.getDeviceType().equals("taxDevice")) {
            return quickReturn.apply(BaseResponse.Fail, "\u6682\u4e0d\u652f\u6301\u7a0e\u63a7\u94a5\u5319");
        }
        UpdateDeviceRequest updateDeviceRequest = new UpdateDeviceRequest();
        BeanMapper.copy((Object)configDeviceUpdateRequest, (Object)updateDeviceRequest);
        updateDeviceRequest.getDeviceInfo().setOperateInfo(this.getUpdateOperateInfo());
        UpdateDeviceResponse updateDeviceResponse = this.deviceApiClient.deviceUpdatePost(updateDeviceRequest);
        MsConfigDeviceUpdateResponse msConfigDeviceUpdateResponse = new MsConfigDeviceUpdateResponse();
        msConfigDeviceUpdateResponse.setCode(updateDeviceResponse.getHead().getCode());
        msConfigDeviceUpdateResponse.setMessage(updateDeviceResponse.getHead().getMessage());
        this.logger.debug("msConfigDeviceUpdateResponse:{}", (Object)msConfigDeviceUpdateResponse);
        if (!msConfigDeviceUpdateResponse.getCode().equals(BaseResponse.OK)) {
            return msConfigDeviceUpdateResponse;
        }
        UpdateDeviceStatusRequest updateStatusRequest = new UpdateDeviceStatusRequest();
        updateStatusRequest.setDeviceId(Collections.singletonList(deviceId));
        updateStatusRequest.setStatus(Integer.valueOf(0));
        updateStatusRequest.setOperateInfo(this.getUpdateOperateInfo());
        UpdateDeviceStatusResponse updateStatusResponse = this.deviceApiClient.deviceUpdateStatusPost(updateStatusRequest);
        this.logger.debug("UpdateDeviceStatusResponse:{}", (Object)updateStatusResponse);
        if (!updateStatusResponse.getHead().getCode().equals(BaseResponse.OK)) {
            msConfigDeviceUpdateResponse.setCode(updateStatusResponse.getHead().getCode());
            msConfigDeviceUpdateResponse.setMessage(updateStatusResponse.getHead().getMessage());
        }
        return msConfigDeviceUpdateResponse;
    }

    private QueryDeviceResponse queryDeviceById(List<Long> idList) {
        QueryDeviceRequest queryDeviceRequest = new QueryDeviceRequest();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        deviceQueryInfo.setDeviceType("taxDevice");
        deviceQueryInfo.setDeviceIds(idList);
        PageInfo pageInfo = this.getPageInfo(idList.size());
        queryDeviceRequest.setQueryInfo(deviceQueryInfo);
        queryDeviceRequest.setPageInfo(pageInfo);
        QueryDeviceResponse queryDeviceResponse = this.deviceApiClient.deviceQueryPost(queryDeviceRequest);
        this.logger.debug("queryDeviceResponse:{}", (Object)queryDeviceResponse);
        return queryDeviceResponse;
    }

    private MsResponse checkDeviceNo(String deviceNo) {
        QueryDeviceRequest queryDeviceRequest = new QueryDeviceRequest();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        deviceQueryInfo.setDeviceType("taxDevice");
        deviceQueryInfo.setDeviceNo(deviceNo);
        PageInfo pageInfo = this.getPageInfo(1);
        queryDeviceRequest.setQueryInfo(deviceQueryInfo);
        queryDeviceRequest.setPageInfo(pageInfo);
        QueryDeviceResponse queryDeviceResponse = this.deviceApiClient.deviceQueryPost(queryDeviceRequest);
        Function<ResponseHead, MsResponse> quickProcessResult = responseHead -> new MsResponse().code(responseHead.getCode()).message(responseHead.getMessage());
        if (!queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            return quickProcessResult.apply(queryDeviceResponse.getHead());
        }
        if (queryDeviceResponse.getDevices() != null && !queryDeviceResponse.getDevices().isEmpty()) {
            return new MsResponse().code(BaseResponse.Fail).message("\u7a0e\u63a7\u8bbe\u5907\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u3002");
        }
        return new MsResponse().code(BaseResponse.OK);
    }

    public MsConfigDeviceAddResponse addDevice(MsConfigDeviceAddRequest msConfigDeviceAddRequest) {
        MsResponse msResponse;
        BiFunction<Integer, String, MsConfigDeviceAddResponse> quickReturn = (code, message) -> {
            MsConfigDeviceAddResponse response = new MsConfigDeviceAddResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        MsConfigDeviceGetCompanyListResponse msConfigDeviceGetCompanyListResponse = this.configDeviceGetCompanyList(new MsConfigDeviceGetCompanyListRequest());
        if (!msConfigDeviceGetCompanyListResponse.getCode().equals(BaseResponse.OK)) {
            return quickReturn.apply(msConfigDeviceGetCompanyListResponse.getCode(), msConfigDeviceGetCompanyListResponse.getMessage());
        }
        List companyModelList = msConfigDeviceGetCompanyListResponse.getResult();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsCompanyInfo msCompanyInfo = msConfigDeviceAddRequest.getDeviceInfo().getCompanyInfo();
        if (msCompanyInfo == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u6ca1\u6709\u586b\u5199\u516c\u53f8\u4fe1\u606f");
        }
        Optional<MsCompanyModel> optionalMsCompanyModel = companyModelList.stream().filter(msCompanyModel -> msCompanyModel.getCompanyId().equals(msCompanyInfo.getCompanyId())).findFirst();
        if (!optionalMsCompanyModel.isPresent()) {
            return quickReturn.apply(BaseResponse.Fail, "\u4f60\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4fe1\u606f");
        }
        MsCompanyModel msCompanyModel2 = optionalMsCompanyModel.get();
        long companyId = msCompanyModel2.getCompanyId();
        OrgModel orgModel = this.getOrgModel(userInfo.getGroupId(), companyId);
        if (orgModel == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
        }
        msCompanyInfo.setCompanyId(Long.valueOf(companyId));
        msCompanyInfo.setCompanyName(msCompanyModel2.getCompanyName());
        msCompanyInfo.setTaxNo(msCompanyModel2.getTaxNum());
        msCompanyInfo.setTenantId(Long.valueOf(userInfo.getGroupId()));
        msCompanyInfo.setTenantName(userInfo.getGroupName());
        msCompanyInfo.setOrganizationId(orgModel.getOrgStructId());
        msCompanyInfo.setOrganizationName(orgModel.getOrgName());
        Integer taxDeviceType = msConfigDeviceAddRequest.getDeviceInfo().getTaxDeviceInfo().getTaxDeviceType();
        if (taxDeviceType == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((taxDeviceType.equals(Integer.parseInt("1")) || taxDeviceType.equals(Integer.parseInt("2"))) && !(msResponse = this.checkDeviceNo(msConfigDeviceAddRequest.getDeviceInfo().getDeviceNo())).getCode().equals(BaseResponse.OK)) {
            return quickReturn.apply(msResponse.getCode(), msResponse.getMessage());
        }
        MsDeviceInfo msDeviceInfo = msConfigDeviceAddRequest.getDeviceInfo();
        msDeviceInfo.setHasLicenseFlag(null);
        msDeviceInfo.setStatus(Integer.valueOf(0));
        if (!msDeviceInfo.getDeviceType().equals("taxDevice")) {
            return quickReturn.apply(BaseResponse.Fail, "\u6682\u4e0d\u652f\u6301\u7a0e\u63a7\u94a5\u5319");
        }
        AddDeviceRequest addDeviceRequest = new AddDeviceRequest();
        BeanMapper.copy((Object)msConfigDeviceAddRequest, (Object)addDeviceRequest);
        addDeviceRequest.getDeviceInfo().setOperateInfo(this.getAddOperateInfo());
        AddDeviceResponse addDeviceResponse = this.deviceApiClient.deviceAddPost(addDeviceRequest);
        MsConfigDeviceAddResponse msConfigDeviceAddResponse = new MsConfigDeviceAddResponse();
        msConfigDeviceAddResponse.setCode(addDeviceResponse.getHead().getCode());
        msConfigDeviceAddResponse.setMessage(addDeviceResponse.getHead().getMessage());
        MsConfigDeviceAddResult msConfigDeviceAddResult = new MsConfigDeviceAddResult();
        msConfigDeviceAddResult.setDeviceId(addDeviceResponse.getDeviceId());
        msConfigDeviceAddResponse.setResult(msConfigDeviceAddResult);
        this.logger.debug("msConfigDeviceAddResponse:{}", (Object)msConfigDeviceAddResponse);
        return msConfigDeviceAddResponse;
    }

    public MsQueryDeviceResponse getDeviceList(MsConfigDeviceQueryRequest request) {
        if (request.getIsAppOrigin() != null && request.getIsAppOrigin().booleanValue()) {
            MsDeviceQueryInfo msDeviceQueryInfo = request.getQueryInfo();
            request.setQueryInfo(this.buildDeviceQueryInfo(msDeviceQueryInfo));
        }
        QueryDeviceRequest destinationRequest = new QueryDeviceRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        QueryDeviceResponse sourceResponse = this.deviceApiClient.deviceQueryPost(destinationRequest);
        MsQueryDeviceResponse response = new MsQueryDeviceResponse();
        MsQueryDeviceResult destinationResponse = new MsQueryDeviceResult();
        BeanMapper.copy((Object)sourceResponse, (Object)destinationResponse);
        response.setResult(destinationResponse);
        response.setCode(sourceResponse.getHead().getCode());
        response.setMessage(sourceResponse.getHead().getMessage());
        this.logger.debug("MsQueryDeviceResponse:{}", (Object)response);
        return response;
    }

    private PageInfo getPageInfo(int pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(Integer.valueOf(1));
        pageInfo.setPageSize(Integer.valueOf(pageSize));
        return pageInfo;
    }

    public MsResponse updateStatus(MsConfigUpdateDeviceStatusRequest request) {
        List deviceIdList = request.getDeviceId();
        int updateStatus = request.getStatus();
        BiFunction<Integer, String, MsResponse> quickReturn = (code, message) -> {
            MsResponse response = new MsResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        this.logger.debug("id list:{}", (Object)deviceIdList);
        QueryDeviceResponse queryDeviceResponse = this.queryDeviceById(deviceIdList);
        Function<ResponseHead, MsResponse> quickProcessResult = responseHead -> (MsResponse)quickReturn.apply(responseHead.getCode(), responseHead.getMessage());
        if (!queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            return quickProcessResult.apply(queryDeviceResponse.getHead());
        }
        List deviceInfoList = queryDeviceResponse.getDevices();
        if (deviceInfoList == null || deviceInfoList.size() != deviceIdList.size()) {
            return quickReturn.apply(BaseResponse.Fail, "\u5bf9\u5e94\u7684\u8bbe\u5907Id\u4e0d\u5b58\u5728");
        }
        long tenantId = this.getGroupId();
        for (DeviceInfo deviceInfo : deviceInfoList) {
            if (deviceInfo.getStatus().equals(0) || deviceInfo.getStatus().equals(2)) {
                return quickReturn.apply(BaseResponse.Fail, "\u4e0d\u80fd\u4fee\u6539\u672a\u5ba1\u6838\u901a\u8fc7\u8bbe\u5907\u7684\u72b6\u6001");
            }
            if (updateStatus == 12 && deviceInfo.getStatus().equals(12)) {
                return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u5df2\u7ecf\u505c\u7528\uff0c\u4e0d\u9700\u8981\u518d\u505c\u7528");
            }
            if (updateStatus == 11 && deviceInfo.getStatus().equals(11)) {
                return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u9700\u8981\u518d\u542f\u7528");
            }
            if (updateStatus == 22 && (deviceInfo.getStatus().equals(11) || deviceInfo.getStatus().equals(12))) {
                return quickReturn.apply(BaseResponse.Fail, "\u672a\u542f\u7528\u6216\u8005\u5df2\u542f\u7528\u7684\u7a0e\u63a7\u8bbe\u5907\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
            }
            if (deviceInfo.getCompanyInfo().getTenantId().equals(tenantId)) continue;
            return quickReturn.apply(BaseResponse.Fail, "\u60a8\u65e0\u6743\u9650\u66f4\u65b0\u6b64\u6570\u636e");
        }
        UpdateDeviceStatusRequest destinationRequest = new UpdateDeviceStatusRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        destinationRequest.setOperateInfo(this.getUpdateOperateInfo());
        UpdateDeviceStatusResponse sourceResponse = this.deviceApiClient.deviceUpdateStatusPost(destinationRequest);
        this.logger.debug("UpdateDeviceStatusResponse:{}", (Object)sourceResponse);
        return quickProcessResult.apply(sourceResponse.getHead());
    }

    public MsQueryDeviceResponse queryAllTaxDeviceByTaxDeviceTypes(MsQueryAllTaxDeviceByTaxDeviceTypesRequest queryAllTaxDeviceByTaxDeviceTypesRequest) {
        List taxDeviceTypes = queryAllTaxDeviceByTaxDeviceTypesRequest.getTaxDeviceTypes();
        QueryDeviceRequest queryDeviceRequest = new QueryDeviceRequest();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        CompanyQueryInfo companyQueryInfo = new CompanyQueryInfo();
        companyQueryInfo.setTenantId(Collections.singletonList(this.getGroupId()));
        deviceQueryInfo.setDeviceType("taxDevice");
        deviceQueryInfo.setCompanyInfo(companyQueryInfo);
        deviceQueryInfo.setStatus(Collections.singletonList(11));
        PageInfo onePageInfo = this.getPageInfo(1);
        queryDeviceRequest.setQueryInfo(deviceQueryInfo);
        queryDeviceRequest.setPageInfo(onePageInfo);
        TaxDeviceQueryRequestInfo taxDeviceQueryRequestInfo = new TaxDeviceQueryRequestInfo();
        deviceQueryInfo.setTaxDeviceInfo(taxDeviceQueryRequestInfo);
        LinkedList deviceInfos = new LinkedList();
        PageInfo maxPageInfo = this.getPageInfo(1);
        Iterator iterator = taxDeviceTypes.iterator();
        while (iterator.hasNext()) {
            int taxDeviceType = (Integer)iterator.next();
            taxDeviceQueryRequestInfo.setTaxDeviceType(Integer.valueOf(taxDeviceType));
            QueryDeviceResponse queryDeviceResponse = this.deviceApiClient.deviceQueryPost(queryDeviceRequest);
            if (queryDeviceResponse.getHead().getCode().equals(BaseResponse.Fail)) {
                this.logger.error("\u6279\u91cf\u83b7\u53d6\u51fa\u9519\u4e86:{}", (Object)queryDeviceResponse.getHead().getMessage());
                continue;
            }
            Integer total = queryDeviceResponse.getPageInfo() == null ? Integer.valueOf(0) : queryDeviceResponse.getPageInfo().getTotal();
            if (total == null || total == 0) continue;
            maxPageInfo.setPageSize(total);
            queryDeviceRequest.setPageInfo(maxPageInfo);
            queryDeviceResponse = this.deviceApiClient.deviceQueryPost(queryDeviceRequest);
            if (queryDeviceResponse.getHead().getCode().equals(BaseResponse.Fail)) {
                this.logger.error("\u6279\u91cf\u83b7\u53d6\u51fa\u9519\u4e86:{}", (Object)queryDeviceResponse.getHead().getMessage());
                continue;
            }
            deviceInfos.addAll(queryDeviceResponse.getDevices());
        }
        MsQueryDeviceResponse msQueryDeviceResponse = new MsQueryDeviceResponse();
        msQueryDeviceResponse.setCode(BaseResponse.OK);
        msQueryDeviceResponse.setMessage("");
        List msDeviceInfos = BeanMapper.mapList(deviceInfos, MsDeviceInfo.class);
        msQueryDeviceResponse.setResult(new MsQueryDeviceResult().devices(msDeviceInfos).pageInfo(new MsResponsePageInfo().pageNo(Integer.valueOf(1)).total(Integer.valueOf(msDeviceInfos.size()))));
        this.logger.debug("msQueryDeviceResponse:{}", (Object)msQueryDeviceResponse);
        return msQueryDeviceResponse;
    }

    private MsDeviceQueryInfo buildDeviceQueryInfo(MsDeviceQueryInfo msDeviceQueryInfo) {
        if (msDeviceQueryInfo == null) {
            msDeviceQueryInfo = new MsDeviceQueryInfo();
        }
        MsCompanyQueryInfo msCompanyQueryInfo = msDeviceQueryInfo.getCompanyInfo();
        List<Long> tenantIdList = Collections.singletonList(this.getGroupId());
        if (msCompanyQueryInfo == null) {
            msCompanyQueryInfo = new MsCompanyQueryInfo();
            msCompanyQueryInfo.setTenantId(tenantIdList);
            msDeviceQueryInfo.setCompanyInfo(msCompanyQueryInfo);
        } else {
            msCompanyQueryInfo.setTenantId(tenantIdList);
        }
        return msDeviceQueryInfo;
    }

    public MsDeviceSummaryQueryResponse deviceSummaryQuery(MsDeviceSummaryQueryRequest request) {
        QueryDeviceResponse sourceResponse;
        MsDeviceQueryInfo msDeviceQueryInfo = request.getQueryInfo();
        msDeviceQueryInfo = this.buildDeviceQueryInfo(msDeviceQueryInfo);
        MsDeviceSummaryQueryResponse response = new MsDeviceSummaryQueryResponse();
        if (msDeviceQueryInfo.getStatus() != null && !msDeviceQueryInfo.getStatus().isEmpty() && !msDeviceQueryInfo.getStatus().stream().allMatch(status -> status.equals(11) || status.equals(12) || status.equals(21))) {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u8f93\u5165\u72b6\u6001\u9519\u8bef");
            return response;
        }
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        BeanMapper.copy((Object)msDeviceQueryInfo, (Object)deviceQueryInfo);
        QueryDeviceRequest destinationRequest = new QueryDeviceRequest();
        destinationRequest.setPageInfo(this.getPageInfo(1));
        destinationRequest.setQueryInfo(deviceQueryInfo);
        MsDeviceSummaryQueryResult auditPassResult = new MsDeviceSummaryQueryResult();
        auditPassResult.setCode(Integer.valueOf(1));
        auditPassResult.setName("\u5ba1\u6838\u901a\u8fc7");
        ArrayList<Integer> auditPassStatusList = new ArrayList<Integer>(3);
        auditPassStatusList.add(11);
        auditPassStatusList.add(12);
        auditPassStatusList.add(21);
        if (deviceQueryInfo.getStatus() == null || deviceQueryInfo.getStatus().isEmpty()) {
            deviceQueryInfo.setStatus(auditPassStatusList);
        }
        if (!BaseResponse.OK.equals((sourceResponse = this.deviceApiClient.deviceQueryPost(destinationRequest)).getHead().getCode())) {
            response.setCode(sourceResponse.getHead().getCode());
            response.setMessage(sourceResponse.getHead().getMessage());
            this.logger.debug("deviceQueryPost result:{}", (Object)response);
            return response;
        }
        auditPassResult.setCount(Long.valueOf(sourceResponse.getPageInfo().getTotal().longValue()));
        deviceQueryInfo.setStatus(Collections.singletonList(2));
        sourceResponse = this.deviceApiClient.deviceQueryPost(destinationRequest);
        if (!BaseResponse.OK.equals(sourceResponse.getHead().getCode())) {
            response.setCode(sourceResponse.getHead().getCode());
            response.setMessage(sourceResponse.getHead().getMessage());
            this.logger.debug("result:{}", (Object)response);
            return response;
        }
        ArrayList<MsDeviceSummaryQueryResult> deviceSummaryQueryResultList = new ArrayList<MsDeviceSummaryQueryResult>(2);
        MsDeviceSummaryQueryResult auditFailResult = new MsDeviceSummaryQueryResult();
        auditFailResult.setCode(Integer.valueOf(2));
        auditFailResult.setName("\u5ba1\u6838\u672a\u901a\u8fc7");
        auditFailResult.setCount(Long.valueOf(sourceResponse.getPageInfo().getTotal().longValue()));
        deviceSummaryQueryResultList.add(auditPassResult);
        deviceSummaryQueryResultList.add(auditFailResult);
        response.setResult(deviceSummaryQueryResultList);
        response.setCode(BaseResponse.OK);
        this.logger.debug("result:{}", (Object)response);
        return response;
    }

    public MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest) {
        return super.configDeviceGetCompanyList(configDeviceGetCompanyListRequest);
    }
}

