/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.metadata.controller;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.MetaApi;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsGroupTypeMetaDataResponse;
import com.xforceplus.seller.config.client.model.MsGroupTypeResponse;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataDeleteRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetaDataPageDTO;
import com.xforceplus.seller.config.client.model.MsMetaDataResponse;
import com.xforceplus.seller.config.client.model.MsMetaDataSummaryResponse;
import com.xforceplus.seller.config.client.model.MsMetadataItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMetadataItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetadataItemResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.common.UserCheckUtils;
import com.xforceplus.seller.config.metadata.service.ConfigMetaDataService;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataEntity;
import com.xforceplus.seller.config.translater.MetaDataObjTranslater;
import com.xforceplus.seller.config.translater.MetaDataTranslater;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.base.BaseMicroController;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@MSApiV1SellerConfig
@RestController
public class ConfigMetaDataController
extends BaseMicroController
implements MetaApi {
    @Autowired
    private ConfigMetaDataService configMetaDataService;

    public MsMetadataItemResponse batchQueryWithObjCodeFiledName(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataBatchQueryRequest mataDataBatchQueryRequest) {
        List cfgBusinessObjMetadataEntities = this.configMetaDataService.batchQueryWithObjCodeFiledName(mataDataBatchQueryRequest);
        MsMetadataItemResponse response = new MsMetadataItemResponse();
        response.setCode(Response.OK);
        ArrayList<MsBusinessObjMetadataBean> result = new ArrayList<MsBusinessObjMetadataBean>();
        for (CfgBusinessObjMetadataEntity entity : cfgBusinessObjMetadataEntities) {
            MsBusinessObjMetadataBean businessObjMetadataBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)entity);
            result.add(businessObjMetadataBean);
        }
        response.setResult(result);
        return response;
    }

    public MsResponse metaDataDelete(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u5220\u9664", required=true) @RequestBody MsMataDataDeleteRequestWithUserInfo mataDataDeleteRequest) {
        MsResponse response = new MsResponse();
        MsCommonUserInfo msCommonUserInfo = mataDataDeleteRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response;
        }
        try {
            this.configMetaDataService.deleteMetaData(mataDataDeleteRequest.getItems(), msCommonUserInfo);
            response.setCode(Response.OK);
            return response;
        }
        catch (RuntimeException e) {
            response.setCode(Response.Fail);
            response.setMessage(e.getMessage());
            return response;
        }
    }

    public MsMetaDataSummaryResponse metaDataSummary(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List msMetaDataSummaryDTOs = this.configMetaDataService.metaDataSummary(msMataDataQueryRequest);
        MsMetaDataSummaryResponse response = new MsMetaDataSummaryResponse();
        response.setCode(Response.OK);
        response.setResult(msMetaDataSummaryDTOs);
        return response;
    }

    public MsMetadataItemResponse queryEffctiveMetaData(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List cfgBusinessObjMetadataEntities = this.configMetaDataService.queryEffectiveMetaDataList(mataDataQueryRequest);
        ArrayList<MsBusinessObjMetadataBean> msBusinessObjBeans = new ArrayList<MsBusinessObjMetadataBean>();
        for (CfgBusinessObjMetadataEntity tmp : cfgBusinessObjMetadataEntities) {
            MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)tmp);
            msBusinessObjBeans.add(msBusinessObjBean);
        }
        MsMetadataItemResponse response = new MsMetadataItemResponse();
        response.setCode(Response.OK);
        response.setResult(msBusinessObjBeans);
        return response;
    }

    public MsMetadataItemResponse queryTemplateMetaData(@ApiParam(value="\u6a21\u677f\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List cfgBusinessObjMetadataEntities = this.configMetaDataService.queryTemplateMetaDataList(mataDataQueryRequest);
        ArrayList<MsBusinessObjMetadataBean> msBusinessObjBeans = new ArrayList<MsBusinessObjMetadataBean>();
        for (CfgBusinessObjMetadataEntity tmp : cfgBusinessObjMetadataEntities) {
            MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)tmp);
            msBusinessObjBeans.add(msBusinessObjBean);
        }
        MsMetadataItemResponse response = new MsMetadataItemResponse();
        response.setCode(Response.OK);
        response.setResult(msBusinessObjBeans);
        return response;
    }

    public MsGroupTypeMetaDataResponse queryGroupMetaDataWithObjType(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest groupId) {
        List result = this.configMetaDataService.queryMetaDataByObjType(groupId);
        MsGroupTypeMetaDataResponse msGroupTypeMetaDataResponse = new MsGroupTypeMetaDataResponse();
        msGroupTypeMetaDataResponse.setCode(Response.OK);
        msGroupTypeMetaDataResponse.setResult(result);
        return msGroupTypeMetaDataResponse;
    }

    public MsGroupTypeResponse queryGroupObjType(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List result = this.configMetaDataService.queryGroupObjType(msMataDataQueryRequest);
        MsGroupTypeResponse msGroupTypeResponse = new MsGroupTypeResponse();
        msGroupTypeResponse.setCode(Response.OK);
        msGroupTypeResponse.setResult(result);
        return msGroupTypeResponse;
    }

    public MsMetaDataResponse queryMetaData(@ApiParam(value="\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        ArrayList<MsBusinessObjBean> msBusinessObjBeans = new ArrayList<MsBusinessObjBean>();
        for (CfgBusinessObjEntity tmp : cfgBusinessObjEntities) {
            MsBusinessObjBean msBusinessObjBean = MetaDataObjTranslater.convertFromConfigEntity((CfgBusinessObjEntity)tmp);
            msBusinessObjBeans.add(msBusinessObjBean);
        }
        MsMetaDataPageDTO msMetaDataPageDTO = new MsMetaDataPageDTO();
        msMetaDataPageDTO.setResult(msBusinessObjBeans);
        Long count = this.configMetaDataService.queryMetaDataCount(mataDataQueryRequest);
        msMetaDataPageDTO.setTotal(Integer.valueOf(count.intValue()));
        msMetaDataPageDTO.setPageNo(mataDataQueryRequest.getPageNo());
        MsMetaDataResponse response = new MsMetaDataResponse();
        response.setResult(msMetaDataPageDTO);
        response.setCode(Response.OK);
        return response;
    }

    public MsMetadataItemResponse queryMetaDataItem(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMetadataItemQueryRequest metadataItemQueryRequest) {
        this.logger.info("queryMetaDataItem metadataItemQueryRequest==========={}", (Object)JsonUtils.writeObjectToFastJson((Object)metadataItemQueryRequest));
        List cfgBusinessObjMetadataEntityList = this.configMetaDataService.queryMetaDataItemListByObjId(metadataItemQueryRequest);
        ArrayList msBusinessObjBeanList = Lists.newArrayList();
        for (CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity : cfgBusinessObjMetadataEntityList) {
            MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntity);
            msBusinessObjBeanList.add(msBusinessObjBean);
        }
        MsMetadataItemResponse msMetadataItemResponse = new MsMetadataItemResponse();
        msMetadataItemResponse.setCode(Response.OK);
        msMetadataItemResponse.setResult((List)msBusinessObjBeanList);
        return msMetadataItemResponse;
    }

    public MsResponse saveMetaData(@ApiParam(value="\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58", required=true) @RequestBody MsMataDataAddRequestWithUserInfo mataDataAddRequest) {
        MsResponse response = new MsResponse();
        MsCommonUserInfo msCommonUserInfo = mataDataAddRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55.");
            return response;
        }
        try {
            int isOk = this.configMetaDataService.addMetaObjData(mataDataAddRequest);
            if (isOk == Response.OK) {
                response.setCode(Response.OK);
            } else {
                response.setCode(Response.Fail);
                response.setMessage("\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58\u5931\u8d25.");
            }
        }
        catch (Exception e) {
            response.setCode(Response.Fail);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    public MsResponse saveMetaDataItem(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMetadataItemAddRequestWithUserInfo metadataItemAddRequest) {
        MsResponse msResponse = new MsResponse();
        MsCommonUserInfo userInfo = metadataItemAddRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)userInfo)) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return msResponse;
        }
        this.configMetaDataService.addMetaDataItem(metadataItemAddRequest);
        msResponse.setCode(Response.OK);
        return msResponse;
    }
}

