/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.metadata.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.model.BillConfigRequest;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.BillConfigClient;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.DisplayTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeMetaDataDTO;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetaDataSummaryDTO;
import com.xforceplus.seller.config.client.model.MsMetadataItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMetadataItemQueryRequest;
import com.xforceplus.seller.config.common.ObjCodeExtEnum;
import com.xforceplus.seller.config.exception.ConfigMetaDataEnumRepeatException;
import com.xforceplus.seller.config.exception.ConfigMetaDataItemNullException;
import com.xforceplus.seller.config.exception.ConfigMetaDataRepeatException;
import com.xforceplus.seller.config.exception.ConfigMetaExistException;
import com.xforceplus.seller.config.exception.ConfigUpdateExpireException;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjMetadataDao;
import com.xforceplus.seller.config.repository.dao.CfgCodesetDao;
import com.xforceplus.seller.config.repository.dao.CfgCodesetItemDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigHistoryDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjMetadataDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjExample;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExample;
import com.xforceplus.seller.config.repository.model.CfgCodesetEntity;
import com.xforceplus.seller.config.repository.model.CfgCodesetExample;
import com.xforceplus.seller.config.repository.model.CfgCodesetItemEntity;
import com.xforceplus.seller.config.repository.model.CfgCodesetItemExample;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigHistoryEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataExample;
import com.xforceplus.seller.config.translater.ConfigTmpEntityTranslater;
import com.xforceplus.seller.config.translater.MetaDataExampleTranslater;
import com.xforceplus.seller.config.translater.MetaDataObjTranslater;
import com.xforceplus.seller.config.translater.MetaDataTranslater;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigMetaDataService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMetaDataService.class);
    private CfgBusinessObjDao cfgBusinessObjDao;
    private CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao;
    private CfgTemplateObjDao cfgTemplateObjDao;
    private CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao;
    private CfgConfigHistoryDao cfgConfigHistoryDao;
    private CfgCodesetDao cfgCodesetDao;
    private CfgCodesetItemDao cfgCodesetItemDao;
    private IDGenerator generator;
    private CfgConfigDao cfgConfigDao;
    private BillConfigClient billConfigClient;

    @Autowired
    public ConfigMetaDataService(CfgBusinessObjDao cfgBusinessObjDao, CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao, CfgTemplateObjDao cfgTemplateObjDao, CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao, CfgConfigHistoryDao cfgConfigHistoryDao, CfgCodesetDao cfgCodesetDao, CfgCodesetItemDao cfgCodesetItemDao, CfgConfigDao cfgConfigDao, BillConfigClient billConfigClient, IDGenerator generator) {
        this.cfgBusinessObjDao = cfgBusinessObjDao;
        this.cfgBusinessObjMetadataDao = cfgBusinessObjMetadataDao;
        this.cfgTemplateObjDao = cfgTemplateObjDao;
        this.cfgTemplateObjMetadataDao = cfgTemplateObjMetadataDao;
        this.cfgConfigHistoryDao = cfgConfigHistoryDao;
        this.cfgCodesetDao = cfgCodesetDao;
        this.cfgCodesetItemDao = cfgCodesetItemDao;
        this.cfgConfigDao = cfgConfigDao;
        this.billConfigClient = billConfigClient;
        this.generator = generator;
    }

    @Transactional(rollbackFor={Exception.class})
    public int addMetaObjData(MsMataDataAddRequestWithUserInfo msMataDataAddRequestWithUserInfo) {
        List businessObjBeans = msMataDataAddRequestWithUserInfo.getItemDTOList();
        MsCommonUserInfo userInfo = msMataDataAddRequestWithUserInfo.getUserInfo();
        if (CollectionUtils.isEmpty((Collection)businessObjBeans)) {
            return 0;
        }
        for (MsBusinessObjBean tmp : businessObjBeans) {
            int operationRet;
            CfgBusinessObjEntity entity = MetaDataObjTranslater.convertFromMsBusinessObjBean((MsBusinessObjBean)tmp, (MsCommonUserInfo)userInfo);
            Long id = entity.getBusinessObjId();
            if (id == null || id == 0L) {
                boolean isExist = this.checkObjNameExist(tmp.getObjCode(), tmp.getObjName(), userInfo.getGroupId());
                if (!isExist) {
                    throw new ConfigMetaExistException();
                }
                id = this.generator.nextId();
                entity.setBusinessObjId(id);
                entity.setObjStatus(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
                entity.setCreateTime(entity.getUpdateTime());
                entity.setCreateUser(userInfo.getUserId());
                operationRet = this.cfgBusinessObjDao.insertSelective(entity);
            } else {
                operationRet = this.cfgBusinessObjDao.updateByPrimaryKeySelective(entity);
            }
            if (operationRet <= 0) {
                throw new ConfigMetaExistException();
            }
            List msBusinessObjMetadataBeans = tmp.getItems();
            this.checkMetaItem(msBusinessObjMetadataBeans);
            if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeans)) continue;
            MsMetadataItemAddRequestWithUserInfo msMetadataItemAddRequest = new MsMetadataItemAddRequestWithUserInfo();
            msMetadataItemAddRequest.setItemDTOList(msBusinessObjMetadataBeans);
            msMetadataItemAddRequest.setObjId(id);
            msMetadataItemAddRequest.setUserInfo(userInfo);
            this.addMetaDataItem(msMetadataItemAddRequest);
        }
        return 1;
    }

    public List<CfgBusinessObjEntity> queryMetaDataList(MsMataDataQueryRequest cfgBusinessObjRequest) {
        CfgBusinessObjExample cfgBusinessObjExample = MetaDataExampleTranslater.createExampleByRequest((MsMataDataQueryRequest)cfgBusinessObjRequest);
        cfgBusinessObjExample.setLimit(cfgBusinessObjRequest.getPageSize());
        cfgBusinessObjExample.setOffset(this.getOffset(cfgBusinessObjRequest));
        return this.cfgBusinessObjDao.selectByExample(cfgBusinessObjExample);
    }

    public Long queryMetaDataCount(MsMataDataQueryRequest cfgBusinessObjRequest) {
        CfgBusinessObjExample cfgBusinessObjExample = MetaDataExampleTranslater.createExampleByRequest((MsMataDataQueryRequest)cfgBusinessObjRequest);
        return this.cfgBusinessObjDao.countByExample(cfgBusinessObjExample);
    }

    public List<CfgBusinessObjMetadataEntity> queryEffectiveMetaDataList(MsMataDataQueryRequest cfgBusinessObjRequest) {
        List customMsEnumBeanList;
        List<CfgBusinessObjMetadataEntity> cfgBusinessObjMetadataEntityList;
        String objType = cfgBusinessObjRequest.getObjType();
        String objCode = cfgBusinessObjRequest.getObjCode();
        Long groupId = cfgBusinessObjRequest.getGroupId();
        String ext1 = cfgBusinessObjRequest.getExt1();
        logger.info("queryEffectiveMetadataList======groupId:{},objCode:{},ext1:{},objType:{}", new Object[]{groupId, objCode, ext1, objType});
        if (StringUtils.isEmpty((CharSequence)objCode)) {
            return Lists.newArrayList();
        }
        String objCodeExt = objCode;
        if (!StringUtils.isEmpty((CharSequence)ext1)) {
            ObjCodeExtEnum objCodeExtEnum = ObjCodeExtEnum.getValueByObjCode((String)objCode, (String)ext1);
            if (null == objCodeExtEnum) {
                return Lists.newArrayList();
            }
            objCodeExt = objCodeExtEnum.getObjCodeExt();
        }
        if (!CollectionUtils.isEmpty((Collection)(cfgBusinessObjMetadataEntityList = this.queryCustomCfgBusinessObjMetadataList(groupId, objCodeExt, objType, true)))) {
            return cfgBusinessObjMetadataEntityList;
        }
        List cfgTemplateObjMetadataEntityList = this.queryTemplateObjMetadataListByCodeAndType(objCodeExt, objType);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjMetadataEntityList)) {
            return Lists.newArrayList();
        }
        cfgBusinessObjMetadataEntityList = cfgTemplateObjMetadataEntityList.stream().filter(Objects::nonNull).map(arg_0 -> this.templateObjMetaDataConvert2BusOjbMetaData(arg_0)).collect(Collectors.toList());
        if (!StringUtils.isEmpty((CharSequence)objType) && !CollectionUtils.isEmpty((Collection)(customMsEnumBeanList = this.queryCustomCfgBusinessObjMetadataByGroupIdAndObjType(groupId, objType)))) {
            cfgBusinessObjMetadataEntityList.forEach(cfgBusinessObjMetadataEntity -> this.fillCfgBusinessObjMetadataEntity(cfgBusinessObjMetadataEntity, customMsEnumBeanList));
        }
        return cfgBusinessObjMetadataEntityList;
    }

    public List<CfgBusinessObjMetadataEntity> queryTemplateMetaDataList(MsMataDataQueryRequest cfgBusinessObjRequest) {
        String objCode = cfgBusinessObjRequest.getObjCode();
        String objType = cfgBusinessObjRequest.getObjType();
        Long groupId = cfgBusinessObjRequest.getGroupId();
        logger.info("queryTemplateMetaDataList objCode:{},objType:{}, groupId:{}", new Object[]{objCode, objType, groupId});
        List cfgTemplateObjMetadataEntityList = this.queryTemplateObjMetadataListByCodeAndType(objCode, objType);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjMetadataEntityList)) {
            return Lists.newArrayList();
        }
        List<CfgBusinessObjMetadataEntity> cfgBusinessObjMetadataEntityList = cfgTemplateObjMetadataEntityList.stream().filter(Objects::nonNull).map(arg_0 -> this.templateObjMetaDataConvert2BusOjbMetaData(arg_0)).collect(Collectors.toList());
        return cfgBusinessObjMetadataEntityList;
    }

    private List<CfgBusinessObjMetadataEntity> queryCustomCfgBusinessObjMetadataList(Long groupId, String objCode, String objType, boolean isFixed) {
        List cfgBusinessObjMetadataEntityList = null;
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        CfgBusinessObjExample.Criteria criteria = cfgBusinessObjExample.createCriteria();
        criteria.andGroupIdEqualTo(groupId);
        criteria.andObjCodeEqualTo(objCode);
        if (!StringUtils.isEmpty((CharSequence)objType)) {
            criteria.andObjTypeEqualTo(objType);
        }
        criteria.andObjStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
        if (null != cfgBusinessObjEntity) {
            CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
            CfgBusinessObjMetadataExample.Criteria metadataCriteria = cfgBusinessObjMetadataExample.createCriteria();
            metadataCriteria.andBusinessObjIdEqualTo(cfgBusinessObjEntity.getBusinessObjId());
            if (!isFixed) {
                metadataCriteria.andFixedEqualTo(Integer.valueOf(0));
            }
            cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
        }
        return cfgBusinessObjMetadataEntityList;
    }

    public int addMetaDataItem(MsMetadataItemAddRequestWithUserInfo msMetadataItemAddRequest) {
        List entities = msMetadataItemAddRequest.getItemDTOList();
        Long id = msMetadataItemAddRequest.getObjId();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return 0;
        }
        if (!this.updateExistConfigItem(entities, id, msMetadataItemAddRequest.getUpdateTime(), msMetadataItemAddRequest.getUserInfo())) {
            return 1;
        }
        return 1;
    }

    public List<MsGroupTypeMetaDataDTO> queryMetaDataByObjType(MsMataDataQueryRequest msMataDataQueryRequest) {
        List objTypeList = this.queryGroupObjType(msMataDataQueryRequest);
        ArrayList<MsGroupTypeMetaDataDTO> result = new ArrayList<MsGroupTypeMetaDataDTO>();
        for (MsGroupTypeBean objType : objTypeList) {
            MsGroupTypeMetaDataDTO groupTypeMetaDataDTO = new MsGroupTypeMetaDataDTO();
            String objCodeExt = msMataDataQueryRequest.getObjCode();
            if (!StringUtils.isEmpty((CharSequence)msMataDataQueryRequest.getExt1())) {
                ObjCodeExtEnum objCodeExtEnum = ObjCodeExtEnum.getValueByObjCode((String)msMataDataQueryRequest.getObjCode(), (String)msMataDataQueryRequest.getExt1());
                if (null == objCodeExtEnum) {
                    return Lists.newArrayList();
                }
                objCodeExt = objCodeExtEnum.getObjCodeExt();
            }
            List cfgBusinessObjMetadataEntities = this.queryCustomCfgBusinessObjMetadataList(msMataDataQueryRequest.getGroupId(), objCodeExt, objType.getObjType(), false);
            groupTypeMetaDataDTO.setObjType(objType.getObjType());
            ArrayList<MsBusinessObjMetadataBean> msBusinessObjBeans = new ArrayList<MsBusinessObjMetadataBean>();
            for (CfgBusinessObjMetadataEntity tmp : cfgBusinessObjMetadataEntities) {
                MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)tmp);
                msBusinessObjBeans.add(msBusinessObjBean);
            }
            groupTypeMetaDataDTO.setMetaList(msBusinessObjBeans);
            result.add(groupTypeMetaDataDTO);
        }
        return result;
    }

    public List<MsGroupTypeBean> queryGroupObjType(MsMataDataQueryRequest msMataDataQueryRequest) {
        msMataDataQueryRequest.setObjStatus(StatusEnum.NORMAL.getStatus());
        List cfgBusinessObjEntities = this.queryMetaDataList(msMataDataQueryRequest);
        return cfgBusinessObjEntities.stream().filter(Objects::nonNull).map(entry -> {
            MsGroupTypeBean msGroupTypeBean = new MsGroupTypeBean();
            msGroupTypeBean.setObjId(String.valueOf(entry.getBusinessObjId()));
            msGroupTypeBean.setObjType(entry.getObjName());
            return msGroupTypeBean;
        }).collect(Collectors.toList());
    }

    public List<CfgBusinessObjMetadataEntity> queryMetaDataItemListByObjId(MsMetadataItemQueryRequest cfgBusinessObjMetadataRequest) {
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectByPrimaryKey(cfgBusinessObjMetadataRequest.getBusinessObjId());
        if (cfgBusinessObjEntity == null) {
            return Lists.newArrayList();
        }
        List cfgBusinessObjMetadataEntityList = this.queryMetaDataItemListByBusinessObjId(cfgBusinessObjEntity.getBusinessObjId());
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntityList)) {
            List cfgTemplateObjMetadataEntityList = this.queryTemplateObjMetadataListByCodeAndType(cfgBusinessObjEntity.getObjCode(), cfgBusinessObjEntity.getObjType());
            if (!CollectionUtils.isEmpty((Collection)cfgTemplateObjMetadataEntityList)) {
                cfgBusinessObjMetadataEntityList = cfgTemplateObjMetadataEntityList.stream().filter(Objects::nonNull).map(arg_0 -> this.templateObjMetaDataConvert2BusOjbMetaData(arg_0)).collect(Collectors.toList());
            }
        } else {
            logger.info("queryMetaDataItemListByObjId \u52a0\u8f7d\u7528\u6237\u81ea\u5b9a\u4e49\u914d\u7f6e\u6570\u636e.");
        }
        return cfgBusinessObjMetadataEntityList;
    }

    private List<CfgBusinessObjMetadataEntity> queryMetaDataItemListByBusinessObjId(Long businessObjId) {
        CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
        CfgBusinessObjMetadataExample.Criteria criteria = cfgBusinessObjMetadataExample.createCriteria();
        criteria.andBusinessObjIdEqualTo(businessObjId);
        List cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
        this.fillCodeSetData2MetaDataEntity(cfgBusinessObjMetadataEntityList);
        return cfgBusinessObjMetadataEntityList;
    }

    private void fillCodeSetData2MetaDataEntity(List<CfgBusinessObjMetadataEntity> cfgBusinessObjMetadataEntityList) {
        if (CollectionUtils.isEmpty(cfgBusinessObjMetadataEntityList)) {
            return;
        }
        cfgBusinessObjMetadataEntityList.forEach(cfgBusinessObjMetadataEntity -> {
            String enumList;
            String displayType = cfgBusinessObjMetadataEntity.getDisplayType();
            if ((DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.PULL_DOWN || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.RADIO || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.CHECK_BOX) && StringUtils.isEmpty((CharSequence)(enumList = cfgBusinessObjMetadataEntity.getFieldEnumValue()))) {
                cfgBusinessObjMetadataEntity.setFieldEnumValue(this.getDataFromCodeSet(cfgBusinessObjMetadataEntity.getFieldName()));
            }
        });
    }

    private List<CfgTemplateObjMetadataEntity> queryTemplateObjMetadataListByCodeAndType(String templateObjCode, String templateObjType) {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        CfgTemplateObjExample.Criteria cfgTemplateObjCriteria = cfgTemplateObjExample.createCriteria();
        cfgTemplateObjCriteria.andTemplateObjCodeEqualTo(templateObjCode);
        CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
        logger.info("queryMetaDataItemListByBusinessObjId cfgTemplateObjEntity========={}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgTemplateObjEntity));
        if (null == cfgTemplateObjEntity) {
            return Lists.newArrayList();
        }
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        CfgTemplateObjMetadataExample.Criteria cfgTemplateObjMetadataCriteria = cfgTemplateObjMetadataExample.createCriteria();
        cfgTemplateObjMetadataCriteria.andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId());
        return this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
    }

    public List<CfgBusinessObjMetadataEntity> batchQueryWithObjCodeFiledName(MsMataDataBatchQueryRequest msMataDataBatchQueryRequest) {
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        String objType = msMataDataBatchQueryRequest.getObjType();
        CfgBusinessObjExample.Criteria criteria = cfgBusinessObjExample.createCriteria();
        if (StringUtils.isEmpty((CharSequence)msMataDataBatchQueryRequest.getObjCode())) {
            return new ArrayList<CfgBusinessObjMetadataEntity>();
        }
        criteria.andObjCodeEqualTo(msMataDataBatchQueryRequest.getObjCode());
        if (msMataDataBatchQueryRequest.getGroupId() != null && msMataDataBatchQueryRequest.getGroupId() > 0L) {
            criteria.andGroupIdEqualTo(msMataDataBatchQueryRequest.getGroupId());
        }
        if (!StringUtils.isEmpty((CharSequence)objType)) {
            criteria.andObjTypeEqualTo(msMataDataBatchQueryRequest.getObjType());
        }
        cfgBusinessObjExample.clear();
        cfgBusinessObjExample.getOredCriteria().add(criteria);
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
        if (cfgBusinessObjEntity == null) {
            return this.getMetaDataItem(null, msMataDataBatchQueryRequest.getFiledNameList(), msMataDataBatchQueryRequest.getObjCode(), msMataDataBatchQueryRequest.getObjType());
        }
        return this.getMetaDataItem(cfgBusinessObjEntity.getBusinessObjId(), msMataDataBatchQueryRequest.getFiledNameList(), msMataDataBatchQueryRequest.getObjCode(), msMataDataBatchQueryRequest.getObjType());
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteMetaData(List<Long> metaDataIdList, MsCommonUserInfo msCommonUserInfo) {
        if (CollectionUtils.isEmpty(metaDataIdList)) {
            return 1;
        }
        for (Long metaDataId : metaDataIdList) {
            CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectByPrimaryKey(metaDataId);
            CfgConfigExample cfgConfigExample = new CfgConfigExample();
            CfgConfigExample.Criteria purchaserCriteria = cfgConfigExample.createCriteria();
            CfgConfigExample.Criteria sellerCriteria = cfgConfigExample.createCriteria();
            purchaserCriteria.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType());
            purchaserCriteria.andPurchaserGroupIdEqualTo(msCommonUserInfo.getGroupId());
            purchaserCriteria.andSalesbillTypeEqualTo(cfgBusinessObjEntity.getObjType());
            purchaserCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            sellerCriteria.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
            sellerCriteria.andSellerGroupIdEqualTo(msCommonUserInfo.getGroupId());
            sellerCriteria.andSalesbillTypeEqualTo(cfgBusinessObjEntity.getObjType());
            sellerCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            cfgConfigExample.getOredCriteria().add(purchaserCriteria);
            cfgConfigExample.or(sellerCriteria);
            long count = this.cfgConfigDao.countByExample(cfgConfigExample);
            if (count > 0L) {
                throw new RuntimeException("\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25,\u4e1a\u52a1\u5206\u7c7b" + cfgBusinessObjEntity.getObjType() + "\u5df2\u914d\u7f6e\u62c6\u7968\u89c4\u5219");
            }
            BillConfigRequest billConfigRequest = new BillConfigRequest();
            billConfigRequest.setGroupId(msCommonUserInfo.getGroupId());
            billConfigRequest.setSalesBillType(cfgBusinessObjEntity.getObjType());
            Response response = this.billConfigClient.getBillCountByBillType(billConfigRequest);
            if (null != response && Response.OK.equals(response.getCode())) {
                long count2 = Long.valueOf((String)response.getResult());
                if (count2 > 0L) {
                    throw new RuntimeException("\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25,\u5df2\u5b58\u5728\u4e1a\u52a1\u5206\u7c7b[" + cfgBusinessObjEntity.getObjType() + "]\u7684\u5355\u636e");
                }
            } else {
                throw new RuntimeException("billConfigClient-\u5355\u636e\u67e5\u8be2\u5931\u8d25");
            }
            CfgBusinessObjEntity entity = new CfgBusinessObjEntity();
            entity.setBusinessObjId(metaDataId);
            entity.setObjStatus(Byte.valueOf(StatusEnum.DELETE.getStatus().byteValue()));
            int updateRet = this.cfgBusinessObjDao.updateByPrimaryKeySelective(entity);
            if (updateRet > 0) continue;
            throw new RuntimeException("\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25,\u4e1a\u52a1Id" + metaDataId);
        }
        return 1;
    }

    public List<MsMetaDataSummaryDTO> metaDataSummary(MsMataDataQueryRequest msMataDataQueryRequest) {
        StatusEnum[] statusEnums = StatusEnum.values();
        ArrayList result = Lists.newArrayList();
        for (StatusEnum statusEnum : statusEnums) {
            msMataDataQueryRequest.setObjStatus(statusEnum.getStatus());
            MsMetaDataSummaryDTO msMetaDataSummaryDTO = new MsMetaDataSummaryDTO();
            Long count = this.queryMetaDataCount(msMataDataQueryRequest);
            msMetaDataSummaryDTO.setCode(String.valueOf(statusEnum.getStatus()));
            msMetaDataSummaryDTO.setCount(Integer.valueOf(count.intValue()));
            msMetaDataSummaryDTO.setName(statusEnum.getStatusDesc());
            result.add(msMetaDataSummaryDTO);
        }
        return result;
    }

    private List<CfgBusinessObjMetadataEntity> getTempMateData(String objCode, String objType, List<String> fieldNameList) {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        CfgTemplateObjExample.Criteria criteria = cfgTemplateObjExample.createCriteria();
        criteria.andTemplateObjCodeEqualTo(objCode);
        if (!StringUtils.isEmpty((CharSequence)objType)) {
            CfgTemplateObjExample cfgTemplateObjExampleExt = new CfgTemplateObjExample();
            CfgTemplateObjExample.Criteria criteriaExt = cfgTemplateObjExample.createCriteria();
            criteriaExt.andTemplateObjTypeEqualTo(objType);
            criteriaExt.getCriteria().addAll(criteria.getAllCriteria());
            cfgTemplateObjExampleExt.getOredCriteria().add(criteriaExt);
            Long count = this.cfgTemplateObjDao.countByExample(cfgTemplateObjExampleExt);
            if (count > 0L) {
                criteria.andTemplateObjTypeEqualTo(objType);
            }
        }
        cfgTemplateObjExample.clear();
        cfgTemplateObjExample.getOredCriteria().add(criteria);
        CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
        CfgTemplateObjMetadataExample example = new CfgTemplateObjMetadataExample();
        CfgTemplateObjMetadataExample.Criteria tmpCriteria = example.createCriteria();
        tmpCriteria.andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId());
        if (!CollectionUtils.isEmpty(fieldNameList)) {
            tmpCriteria.andFieldNameIn(fieldNameList);
        }
        example.clear();
        example.getOredCriteria().add(tmpCriteria);
        List cfgTemplateObjMetadataEntities = this.cfgTemplateObjMetadataDao.selectByExample(example);
        List<CfgBusinessObjMetadataEntity> cfgConfigItemEntities = cfgTemplateObjMetadataEntities.stream().filter(Objects::nonNull).map(arg_0 -> this.templateObjMetaDataConvert2BusOjbMetaData(arg_0)).collect(Collectors.toList());
        return cfgConfigItemEntities;
    }

    private CfgBusinessObjMetadataEntity fillCfgBusinessObjMetadataEntity(CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity, List<MsEnumBean> customMsEnumBeanList) {
        String displayType;
        if (CollectionUtils.isEmpty(customMsEnumBeanList)) {
            return cfgBusinessObjMetadataEntity;
        }
        String associativeUrl = cfgBusinessObjMetadataEntity.getAssociativeUrl();
        if (!(StringUtils.isEmpty((CharSequence)associativeUrl) || DisplayTypeEnum.getDisplayTypeByCode((String)(displayType = cfgBusinessObjMetadataEntity.getDisplayType())) != DisplayTypeEnum.PULL_DOWN && DisplayTypeEnum.getDisplayTypeByCode((String)displayType) != DisplayTypeEnum.RADIO && DisplayTypeEnum.getDisplayTypeByCode((String)displayType) != DisplayTypeEnum.CHECK_BOX)) {
            List msTemplateEnumBeanList;
            ArrayList msEnumBeanList = Lists.newArrayList();
            String enumList = cfgBusinessObjMetadataEntity.getFieldEnumValue();
            if (!StringUtils.isEmpty((CharSequence)enumList) && !CollectionUtils.isEmpty((Collection)(msTemplateEnumBeanList = JsonUtils.writeJsonToListObject((String)enumList, MsEnumBean.class)))) {
                msEnumBeanList.addAll(msTemplateEnumBeanList);
            }
            msEnumBeanList.addAll(customMsEnumBeanList);
            cfgBusinessObjMetadataEntity.setFieldEnumValue(JsonUtils.writeObjectToFastJson((Object)msEnumBeanList));
        }
        return cfgBusinessObjMetadataEntity;
    }

    private List<MsEnumBean> queryTemplateEnumValue(String templateCode) {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo(templateCode);
        CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
        if (cfgTemplateObjEntity == null) {
            return null;
        }
        Long templateObjId = cfgTemplateObjEntity.getTemplateObjId();
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(templateObjId);
        List cfgTemplateObjMetadataEntities = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
        return this.convertCfgTemplateObjMetadata2MsEnumBean(cfgTemplateObjMetadataEntities);
    }

    private List<MsEnumBean> convertCfgTemplateObjMetadata2MsEnumBean(List<CfgTemplateObjMetadataEntity> cfgTemplateObjMetadataEntities) {
        ArrayList list = Lists.newArrayList();
        for (CfgTemplateObjMetadataEntity cfgTemplateObjMetadataEntity : cfgTemplateObjMetadataEntities) {
            MsEnumBean msEnumBean = new MsEnumBean();
            msEnumBean.setText(cfgTemplateObjMetadataEntity.getFieldDisplayName());
            msEnumBean.setValue(cfgTemplateObjMetadataEntity.getFieldName());
            list.add(msEnumBean);
        }
        return list;
    }

    private List<MsEnumBean> queryCustomCfgBusinessObjMetadataByGroupIdAndObjType(Long groupId, String objType) {
        List customMsEnumBeanList = null;
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        cfgBusinessObjExample.createCriteria().andGroupIdEqualTo(groupId).andObjTypeEqualTo(objType).andObjStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        List cfgBusinessObjEntityList = this.cfgBusinessObjDao.selectByExample(cfgBusinessObjExample);
        if (!CollectionUtils.isEmpty((Collection)cfgBusinessObjEntityList)) {
            CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
            cfgBusinessObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(((CfgBusinessObjEntity)cfgBusinessObjEntityList.get(0)).getBusinessObjId()).andFixedEqualTo(Integer.valueOf(0));
            List cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
            customMsEnumBeanList = this.convertCfgBusinessObjMetadata2MsEnumBean(cfgBusinessObjMetadataEntityList);
        }
        return customMsEnumBeanList;
    }

    private List<MsEnumBean> convertCfgBusinessObjMetadata2MsEnumBean(List<CfgBusinessObjMetadataEntity> cfgBusinessObjMetadataEntityList) {
        if (CollectionUtils.isEmpty(cfgBusinessObjMetadataEntityList)) {
            return null;
        }
        ArrayList msEnumBeanList = Lists.newArrayList();
        cfgBusinessObjMetadataEntityList.forEach(cfgBusinessObjMetadataEntity -> {
            MsEnumBean msEnumBean = new MsEnumBean();
            msEnumBean.setText(cfgBusinessObjMetadataEntity.getFieldDisplayName());
            msEnumBean.setValue(cfgBusinessObjMetadataEntity.getFieldName());
            msEnumBeanList.add(msEnumBean);
        });
        return msEnumBeanList;
    }

    private String getDataFromCodeSet(String filedName) {
        CfgCodesetExample example = new CfgCodesetExample();
        example.createCriteria().andCodesetCodeEqualTo(filedName);
        CfgCodesetEntity cfgCodesetEntity = this.cfgCodesetDao.selectOneByExample(example);
        if (cfgCodesetEntity == null) {
            return null;
        }
        CfgCodesetItemExample cfgCodesetItemExample = new CfgCodesetItemExample();
        cfgCodesetItemExample.createCriteria().andCodesetIdEqualTo(cfgCodesetEntity.getCodesetId());
        List cfgCodesetItemEntities = this.cfgCodesetItemDao.selectByExample(cfgCodesetItemExample);
        ArrayList<HashMap> listMap = new ArrayList<HashMap>();
        for (CfgCodesetItemEntity tmp : cfgCodesetItemEntities) {
            HashMap map = Maps.newHashMap();
            map.put("value", tmp.getItemCode());
            map.put("text", tmp.getItemCname());
            map.put("code", filedName);
            listMap.add(map);
        }
        return JsonUtils.writeObjectToFastJson(listMap);
    }

    private List<CfgBusinessObjMetadataEntity> getMetaDataItem(Long objeId, List<String> itemNameList, String objCode, String objType) {
        if (objeId == null) {
            return this.getTempMateData(objCode, objType, itemNameList);
        }
        CfgBusinessObjMetadataExample example = new CfgBusinessObjMetadataExample();
        CfgBusinessObjMetadataExample.Criteria criteria = example.createCriteria();
        criteria.andBusinessObjIdEqualTo(objeId);
        if (!CollectionUtils.isEmpty(itemNameList)) {
            criteria.andFieldNameIn(itemNameList);
        }
        example.getOredCriteria().clear();
        example.getOredCriteria().add(criteria);
        List cfgBusinessObjMetadataEntities = this.cfgBusinessObjMetadataDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntities)) {
            return this.getTempMateData(objCode, objType, itemNameList);
        }
        ArrayList result = Lists.newArrayList();
        for (CfgBusinessObjMetadataEntity tmp : cfgBusinessObjMetadataEntities) {
            String enumList;
            String displayType = tmp.getDisplayType();
            if ((DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.PULL_DOWN || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.RADIO || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.CHECK_BOX) && StringUtils.isEmpty((CharSequence)(enumList = tmp.getFieldEnumValue()))) {
                tmp.setFieldEnumValue(this.getDataFromCodeSet(tmp.getFieldName()));
            }
            result.add(tmp);
        }
        return result;
    }

    private boolean updateExistConfigItem(List<MsBusinessObjMetadataBean> entities, Long id, String updateTime, MsCommonUserInfo userInfo) {
        MsMetadataItemQueryRequest request = new MsMetadataItemQueryRequest();
        request.setBusinessObjId(id);
        CfgBusinessObjMetadataExample example = new CfgBusinessObjMetadataExample();
        if (updateTime != null) {
            example.createCriteria().andBusinessObjIdEqualTo(id).andUpdateTimeGreaterThan(DateUtil.convertDate((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss"));
            Long count = this.cfgBusinessObjMetadataDao.countByExample(example);
            if (count > 0L) {
                throw new ConfigUpdateExpireException();
            }
        }
        example.clear();
        example.createCriteria().andBusinessObjIdEqualTo(id);
        List cfgBusinessObjMetadataEntities = this.cfgBusinessObjMetadataDao.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntities)) {
            for (CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity : cfgBusinessObjMetadataEntities) {
                this.cfgBusinessObjMetadataDao.deleteByPrimaryKey(cfgBusinessObjMetadataEntity.getBusinessObjMetadataId());
            }
        }
        for (MsBusinessObjMetadataBean msBusinessObjMetadataBean : entities) {
            CfgBusinessObjMetadataEntity entity = MetaDataTranslater.convertFromMsBusinessObjMetadataBean((MsBusinessObjMetadataBean)msBusinessObjMetadataBean);
            entity.setBusinessObjMetadataId(Long.valueOf(this.generator.nextId()));
            entity.setBusinessObjId(id);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(entity.getCreateTime());
            entity.setUpdateUser(userInfo.getUserId());
            entity.setCreateUser(userInfo.getUserId());
            entity.setFieldReadonly(Integer.valueOf(1));
            this.cfgBusinessObjMetadataDao.insertSelective(entity);
        }
        CfgConfigHistoryEntity cfgConfigHistoryEntity = new CfgConfigHistoryEntity();
        cfgConfigHistoryEntity.setConfigId(id);
        cfgConfigHistoryEntity.setCreateTime(new Date());
        cfgConfigHistoryEntity.setOriginalTime(CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntities) ? new Date() : ((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntities.get(0)).getUpdateTime());
        cfgConfigHistoryEntity.setConfigItem(JsonUtils.writeObjectToFastJson((Object)cfgBusinessObjMetadataEntities));
        this.cfgConfigHistoryDao.insertSelective(cfgConfigHistoryEntity);
        return Boolean.FALSE;
    }

    private Integer getOffset(MsMataDataQueryRequest msMataDataQueryRequest) {
        Integer pageNo = msMataDataQueryRequest.getPageNo();
        Integer pageSize = msMataDataQueryRequest.getPageSize();
        if (pageNo == null) {
            pageNo = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        return (pageNo - 1) * pageSize;
    }

    private boolean checkObjNameExist(String objCode, String objName, Long groupId) {
        CfgBusinessObjExample example = new CfgBusinessObjExample();
        example.createCriteria().andObjCodeEqualTo(objCode).andObjStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue())).andObjNameEqualTo(objName).andGroupIdEqualTo(groupId);
        long count = this.cfgBusinessObjDao.countByExample(example);
        return count <= 0L;
    }

    private void checkMetaItem(List<MsBusinessObjMetadataBean> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        HashSet fieldNameSet = new HashSet();
        HashSet fieldDisplayNameSet = new HashSet();
        StringBuffer outTips = new StringBuffer();
        for (MsBusinessObjMetadataBean msBusinessObjMetadataBean : entities) {
            boolean checkResult = this.checkFieldNameIsRepeat(fieldNameSet, msBusinessObjMetadataBean.getFieldName(), msBusinessObjMetadataBean.getFieldGroupIndex(), outTips);
            if (!checkResult) {
                throw new RuntimeException(outTips.toString());
            }
            checkResult = this.checkFieldNameIsRepeat(fieldDisplayNameSet, msBusinessObjMetadataBean.getFieldDisplayName(), msBusinessObjMetadataBean.getFieldGroupIndex(), outTips);
            if (!checkResult) {
                throw new RuntimeException(outTips.toString());
            }
            List msEnumBeanList = msBusinessObjMetadataBean.getFieldEnumValue();
            long countText = msEnumBeanList.stream().map(enumBean -> enumBean.getText()).distinct().count();
            long countValue = msEnumBeanList.stream().map(enumBean -> enumBean.getValue()).distinct().count();
            if (countText >= (long)msEnumBeanList.size() && countValue >= (long)msEnumBeanList.size()) continue;
            logger.info("checkMetaItem filedName msEnumBean=====>{}, countText:{}, countValue:{}, size:{}", new Object[]{JsonUtils.writeObjectToFastJson((Object)msEnumBeanList), countText, countValue, msEnumBeanList.size()});
            throw new ConfigMetaDataEnumRepeatException();
        }
    }

    private boolean checkFieldNameIsRepeat(Set<String> fieldNameSet, String fieldName, Integer groupIndex, StringBuffer outTips) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            logger.info("checkMetaItem filedName isEmpty =====>{}", (Object)fieldName);
            outTips.append(new ConfigMetaDataItemNullException().getMessage());
            return false;
        }
        String fileNameAndGroup = fieldName + groupIndex;
        if (fieldNameSet.contains(fileNameAndGroup)) {
            logger.info("checkMetaItem filedName contains=====>{}:fieldNameSet:{}", (Object)fileNameAndGroup, (Object)JsonUtils.writeObjectToFastJson(fieldNameSet));
            outTips.append(groupIndex == 0 ? "\u4e3b\u4fe1\u606f\u5b57\u6bb5:" : "\u660e\u7ec6\u5b57\u6bb5").append(fieldName).append(new ConfigMetaDataRepeatException().getMessage());
            return false;
        }
        fieldNameSet.add(fileNameAndGroup);
        return true;
    }

    private CfgBusinessObjMetadataEntity templateObjMetaDataConvert2BusOjbMetaData(CfgTemplateObjMetadataEntity cfgTemplateObjMetadataEntity) {
        String enumList;
        String displayType;
        CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity = ConfigTmpEntityTranslater.convertFromMsConfigBean((CfgTemplateObjMetadataEntity)cfgTemplateObjMetadataEntity);
        String associativeUrl = cfgTemplateObjMetadataEntity.getAssociativeUrl();
        if (!StringUtils.isEmpty((CharSequence)associativeUrl) && (DisplayTypeEnum.getDisplayTypeByCode((String)(displayType = cfgBusinessObjMetadataEntity.getDisplayType())) == DisplayTypeEnum.PULL_DOWN || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.RADIO || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.CHECK_BOX) && StringUtils.isEmpty((CharSequence)(enumList = cfgBusinessObjMetadataEntity.getFieldEnumValue()))) {
            List msEnumBeans = this.queryTemplateEnumValue(associativeUrl);
            logger.info("templateObjMetaDataConvert2BusOjbMetaData associativeUrl:{},msEnumBeans:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msEnumBeans));
            if (!CollectionUtils.isEmpty((Collection)msEnumBeans)) {
                cfgBusinessObjMetadataEntity.setFieldEnumValue(JsonUtils.writeObjectToFastJson((Object)msEnumBeans));
            }
        }
        return cfgBusinessObjMetadataEntity;
    }
}

