/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.terminal.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.bss.external.client.model.GetCompanyServiceInfoResponse;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.LicenseInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryResponseInfo;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusResponse;
import com.xforceplus.seller.config.client.DeviceApiClient;
import com.xforceplus.seller.config.client.UserApiClient;
import com.xforceplus.seller.config.client.model.MsAddTerminalResponse;
import com.xforceplus.seller.config.client.model.MsAddTerminalResult;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsCompanyModel;
import com.xforceplus.seller.config.client.model.MsConfigAddTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsConfigTemialAuthQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryMakeOutRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalStatusRequest;
import com.xforceplus.seller.config.client.model.MsQueryMakeOutTerminalResponse;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsTerminalQueryMakeOutResult;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResult;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.terminal.enums.SupperServiceType;
import com.xforceplus.seller.config.terminal.service.ConfigTerminalService;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.ucenter.client.model.MsGetUserDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetUserDetailResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigTerminalServiceImpl
extends BaseConfigService
implements ConfigTerminalService {
    @Autowired
    private DeviceApiClient deviceApiClient;
    @Autowired
    private UserApiClient userApiClient;
    private final String APPID = "phoenix-seller-config";

    public MsQueryTerminalResponse getTerminalList(MsConfigTemialQueryRequest request) {
        QueryTerminalRequest destinationRequest = new QueryTerminalRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        destinationRequest.setTerminalInfo(this.generateTerminalQueryInfo(destinationRequest.getTerminalInfo()));
        destinationRequest.setQueryServiceState(Boolean.valueOf(true));
        QueryTerminalResponse sourceResponse = this.deviceApiClient.deviceTerminalQueryPost(destinationRequest);
        this.logger.info("getTerminalList\u65b9\u6cd5\u83b7\u53d6\u5230\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sourceResponse));
        MsQueryTerminalResponse response = new MsQueryTerminalResponse();
        MsTerminalQueryResult destinationResponse = (MsTerminalQueryResult)JSON.parseObject((String)JSON.toJSONString((Object)sourceResponse), MsTerminalQueryResult.class);
        response.setResult(destinationResponse);
        response.setCode(sourceResponse.getHead().getCode());
        response.setMessage(sourceResponse.getHead().getMessage());
        this.logger.info("response = {}", (Object)JSON.toJSONString((Object)response));
        return response;
    }

    public MsResponse updateStatus(MsConfigUpdateTerminalStatusRequest request) {
        UpdateTerminalStatusRequest destinationRequest = new UpdateTerminalStatusRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        GetCompanyServiceInfoResponse serviceInfoResponse = null;
        if (null != request.getStatus() && request.getStatus() == 11) {
            if (null == request.getCompanyId()) {
                return new MsResponse().code(BaseResponse.Fail).message("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            serviceInfoResponse = this.getCompanyServiceInfo(request.getCompanyId().longValue());
            if (null == serviceInfoResponse || null == serviceInfoResponse.getCode() || serviceInfoResponse.getCode() == 0) {
                return new MsResponse().code(BaseResponse.Fail).message("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u5305");
            }
        }
        if (null != serviceInfoResponse) {
            destinationRequest.licenseInfo(new LicenseInfo().expireAt(this.formatExpireAt(serviceInfoResponse.getResult().getServiceEndTime())));
            this.logger.info("\u516c\u53f8id\u4e3a\uff1a{}\u7684\u670d\u52a1\u5305\u7ed3\u675f\u65f6\u95f4\u4e3a\uff1a{}", (Object)request.getCompanyId(), (Object)serviceInfoResponse.getResult().getServiceEndTime());
        }
        destinationRequest.setOperateInfo(this.getUpdateOperateInfo());
        UpdateTerminalStatusResponse sourceResponse = this.deviceApiClient.deviceTerminalUpdateStatusPost(destinationRequest);
        MsResponse response = new MsResponse();
        response.setCode(sourceResponse.getHead().getCode());
        response.setMessage(sourceResponse.getHead().getMessage());
        return response;
    }

    public MsResponse update(MsConfigUpdateTerminalRequest request) {
        UpdateTerminalRequest destinationRequest = new UpdateTerminalRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        destinationRequest.getTerminalInfo().setOperateInfo(this.getUpdateOperateInfo());
        UpdateTerminalResponse sourceResponse = this.deviceApiClient.deviceTerminalUpdatePost(destinationRequest);
        MsResponse response = new MsResponse();
        response.setCode(sourceResponse.getHead().getCode());
        response.setMessage(sourceResponse.getHead().getMessage());
        return response;
    }

    public MsAddTerminalResponse addTerminal(MsConfigAddTerminalRequest request) {
        List supportServices;
        AddTerminalRequest destinationRequest = new AddTerminalRequest();
        MsConfigDeviceGetCompanyListResponse msConfigDeviceGetCompanyListResponse = this.configDeviceGetCompanyList(new MsConfigDeviceGetCompanyListRequest());
        if (!msConfigDeviceGetCompanyListResponse.getCode().equals(BaseResponse.OK)) {
            return new MsAddTerminalResponse().code(msConfigDeviceGetCompanyListResponse.getCode()).message(msConfigDeviceGetCompanyListResponse.getMessage());
        }
        List companyModelList = msConfigDeviceGetCompanyListResponse.getResult();
        MsCompanyInfo msCompanyInfo = request.getTerminalInfo().getCompanyInfo();
        if (msCompanyInfo == null) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u6ca1\u6709\u586b\u5199\u516c\u53f8\u4fe1\u606f");
        }
        Optional<MsCompanyModel> optionalMsCompanyModel = companyModelList.stream().filter(msCompanyModel -> msCompanyModel.getCompanyId().equals(msCompanyInfo.getCompanyId())).findFirst();
        if (!optionalMsCompanyModel.isPresent()) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u4f60\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4fe1\u606f");
        }
        MsCompanyModel msCompanyModel2 = optionalMsCompanyModel.get();
        long companyId = msCompanyModel2.getCompanyId();
        OrgModel orgModel = this.getOrgModel(this.getCurrentUserInfo().getGroupId(), companyId);
        if (orgModel == null) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
        }
        GetCompanyServiceInfoResponse serviceInfoResponse = null;
        if (null != request.getTerminalInfo().getStatus() && request.getTerminalInfo().getStatus() == 11 && (null == (serviceInfoResponse = this.getCompanyServiceInfo(companyId)) || null == serviceInfoResponse.getCode() || serviceInfoResponse.getCode() == 0)) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u5305");
        }
        msCompanyInfo.setCompanyId(Long.valueOf(companyId));
        msCompanyInfo.setCompanyName(msCompanyModel2.getCompanyName());
        msCompanyInfo.setTaxNo(msCompanyModel2.getTaxNum());
        msCompanyInfo.setTenantId(Long.valueOf(this.getCurrentUserInfo().getGroupId()));
        msCompanyInfo.setTenantName(this.getCurrentUserInfo().getGroupName());
        msCompanyInfo.setOrganizationId(orgModel.getOrgStructId());
        msCompanyInfo.setOrganizationName(orgModel.getOrgName());
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        destinationRequest.getTerminalInfo().setOperateInfo(this.getAddOperateInfo());
        if (null != serviceInfoResponse) {
            destinationRequest.licenseInfo(new LicenseInfo().expireAt(this.formatExpireAt(serviceInfoResponse.getResult().getServiceEndTime())));
            this.logger.info("\u516c\u53f8id\u4e3a\uff1a{}\u7684\u670d\u52a1\u5305\u7ed3\u675f\u65f6\u95f4\u4e3a\uff1a{}", (Object)companyId, (Object)serviceInfoResponse.getResult().getServiceEndTime());
        }
        if (null != (supportServices = destinationRequest.getTerminalInfo().getSupportService()) && supportServices.size() == 1 && StringUtils.equals((CharSequence)((CharSequence)supportServices.get(0)), (CharSequence)"print")) {
            destinationRequest.getTerminalInfo().setTerminalType(Integer.valueOf(1));
        }
        AddTerminalResponse sourceResponse = this.deviceApiClient.deviceTerminalAddPost(destinationRequest);
        MsAddTerminalResponse response = new MsAddTerminalResponse();
        MsAddTerminalResult destinationResponse = new MsAddTerminalResult();
        BeanMapper.copy((Object)sourceResponse, (Object)destinationResponse);
        response.setResult(destinationResponse);
        response.setCode(sourceResponse.getHead().getCode());
        response.setMessage(sourceResponse.getHead().getMessage());
        return response;
    }

    public MsQueryMakeOutTerminalResponse getMakeOutTerminalList(MsConfigTemialQueryMakeOutRequest request) {
        MsQueryMakeOutTerminalResponse response = new MsQueryMakeOutTerminalResponse();
        List terminalList = this.getAuthTerminals();
        if (CollectionUtils.isEmpty((Collection)terminalList)) {
            response.setCode(Integer.valueOf(0));
            response.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230\u7ec8\u7aef\u5217\u8868");
            return response;
        }
        ArrayList makeOutTerminals = Lists.newArrayList();
        ArrayList printTerminals = Lists.newArrayList();
        for (MsTerminalQueryResponseInfo terminal : terminalList) {
            List supperServiceList = terminal.getSupportService();
            if (!CollectionUtils.isNotEmpty((Collection)supperServiceList)) continue;
            if (supperServiceList.contains(SupperServiceType.PRINT.getCode())) {
                printTerminals.add(terminal);
            }
            if (!supperServiceList.contains(SupperServiceType.MAKE.getCode())) continue;
            makeOutTerminals.add(terminal);
        }
        MsTerminalQueryMakeOutResult result = new MsTerminalQueryMakeOutResult();
        result.setMakeOutTerminals((List)makeOutTerminals);
        result.setPrintTerminals((List)printTerminals);
        response.setCode(Integer.valueOf(1));
        response.message("\u83b7\u53d6\u6210\u529f");
        response.setResult(result);
        return response;
    }

    public MsQueryTerminalResponse getAuthTerminalList(MsConfigTemialAuthQueryRequest request) {
        MsQueryTerminalResponse response = new MsQueryTerminalResponse();
        List terminalList = this.getAuthTerminals();
        if (CollectionUtils.isEmpty((Collection)terminalList)) {
            response.setCode(Integer.valueOf(0));
            response.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230\u7ec8\u7aef\u5217\u8868");
            return response;
        }
        List filterList = terminalList.stream().filter(e -> {
            boolean filterFlag = true;
            if (CollectionUtils.isNotEmpty((Collection)request.getInvoiceType())) {
                boolean bl = filterFlag = filterFlag && CollectionUtils.containsAny((Collection)e.getInvoiceType(), (Collection)request.getInvoiceType());
            }
            if (CollectionUtils.isNotEmpty((Collection)request.getSupportService())) {
                filterFlag = filterFlag && CollectionUtils.containsAny((Collection)e.getSupportService(), (Collection)request.getSupportService());
            }
            return filterFlag;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterList)) {
            response.setCode(Integer.valueOf(0));
            response.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230\u7ec8\u7aef\u5217\u8868");
            return response;
        }
        MsTerminalQueryResult result = new MsTerminalQueryResult();
        result.setTerminals(filterList);
        response.setCode(Integer.valueOf(1));
        response.message("\u83b7\u53d6\u6210\u529f");
        response.setResult(result);
        return response;
    }

    private List<MsTerminalQueryResponseInfo> getAuthTerminals() {
        ArrayList terminals = Lists.newArrayList();
        MsGetUserDetailRequest userRequest = new MsGetUserDetailRequest();
        Long userId = this.getCurrentUserInfo().getUserId();
        this.logger.info("\u83b7\u53d6\u7ec8\u7aef\u5217\u8868\u7684userId\u4e3a\uff1a{}\uff0cappid\u4e3a\uff1a{}", (Object)userId, (Object)"phoenix-seller-config");
        userRequest.setUserId(userId);
        userRequest.setAppid("phoenix-seller-config");
        userRequest.setRid("phoenix-seller-config");
        MsGetUserDetailResponse userResponse = this.userApiClient.getUserDetail(userRequest);
        if (null == userResponse.getCode() || userResponse.getCode() != 1) {
            this.logger.info("\u8fd0\u8425\u5e73\u53f0\u8fd4\u56de\u7684\u7ec8\u7aef\u5217\u8868\u7ed3\u679c\u4e3a\uff1a{}", JSON.toJSON((Object)userResponse));
            return terminals;
        }
        String terminalIds = userResponse.getResult().getTicketOpeningTerminal();
        String deviceIds = userResponse.getResult().getPrintingEquipment();
        this.logger.info("\u8fd0\u8425\u5e73\u53f0\u8fd4\u56de\u7684\u7ec8\u7aef\u5217\u8868\u7ed3\u679c\u4e3a\uff1aterminalIds\uff1a{}\uff0cdeviceIds\uff1a{}", (Object)terminalIds, (Object)deviceIds);
        if (StringUtils.isNotBlank((CharSequence)terminalIds)) {
            List terminalIdList = Arrays.asList(StringUtils.split((String)terminalIds, (String)",")).stream().map(e -> Long.parseLong(e)).collect(Collectors.toList());
            QueryTerminalRequest request = new QueryTerminalRequest();
            TerminalQueryInfo terminalInfo = new TerminalQueryInfo();
            terminalInfo.setTerminalIds(terminalIdList);
            request.setQueryServiceState(Boolean.valueOf(true));
            request.setTerminalInfo(terminalInfo);
            request.setPageInfo(this.getDefaultRequestPageInfo());
            QueryTerminalResponse sourceResponse = this.deviceApiClient.deviceTerminalQueryPost(request);
            this.logger.info("\u7a0e\u4ef6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sourceResponse));
            List<Object> deviceIdList = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)deviceIds)) {
                deviceIdList = Arrays.asList(StringUtils.split((String)deviceIds, (String)",")).stream().map(e -> Long.parseLong(e)).collect(Collectors.toList());
            }
            if (null != sourceResponse && null != sourceResponse.getHead() && null != sourceResponse.getHead().getCode() && sourceResponse.getHead().getCode() == 1) {
                List resourceTerminals = sourceResponse.getTerminals();
                for (TerminalQueryResponseInfo info : resourceTerminals) {
                    if (null != info.getDeviceId() && (!CollectionUtils.isNotEmpty((Collection)deviceIdList) || !deviceIdList.contains(info.getDeviceId()))) continue;
                    MsTerminalQueryResponseInfo msInfo = new MsTerminalQueryResponseInfo();
                    BeanMapper.copy((Object)info, (Object)msInfo);
                    msInfo.setDirectOnlineFlag(Integer.valueOf(null != info.DirectOnlineFlag() && info.DirectOnlineFlag() != false ? 1 : 0));
                    msInfo.setPrinterOnlineFlag(Integer.valueOf(null != info.PrinterOnlineFlag() && info.PrinterOnlineFlag() != false ? 1 : 0));
                    this.logger.info("\u6e32\u67d3\u540e\u7684\u7ec8\u7aef\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)msInfo));
                    terminals.add(msInfo);
                }
            }
        }
        this.logger.info("\u8fc7\u6ee4\u6743\u9650\u4e4b\u540e\u7684\u7ec8\u7aef\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)terminals));
        return terminals;
    }
}

