/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config;

import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.xforceplus.common.config.log.EnableWebLog;
import com.xforceplus.phoenix.oss.annotations.EnableOss;
import com.xforceplus.xplatframework.spring.annotations.EnableUserContext;
import java.nio.charset.Charset;
import java.util.List;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;

@EnableUserContext
@SpringBootApplication
@EnableDiscoveryClient
@EnableApolloConfig
@EnableTransactionManagement
@EnableFeignClients(value={"com.xforceplus.seller.config.client"})
@ComponentScan(value={"com.xforceplus"})
@MapperScan(value={"com.xforceplus.seller.config.repository.dao", "com.xforceplus.seller.config.repository.daoext"})
@EnableHystrix
@EnableOss
@EnableWebLog
public class SellerConfigApplication {
    public static void main(String[] args) {
        SpringApplication.run(SellerConfigApplication.class, (String[])args);
    }

    @Bean
    RestTemplate restTemplate(ClientHttpRequestFactory simpleClientHttpRequestFactory) {
        RestTemplate restTemplate = new RestTemplate(simpleClientHttpRequestFactory);
        List list = restTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("UTF8"));
            break;
        }
        return restTemplate;
    }

    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(5000);
        factory.setReadTimeout(5000);
        return factory;
    }
}

