/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.controller;

import com.xforceplus.seller.config.bizconfig.service.ConfigBizConfigService;
import com.xforceplus.seller.config.bizconfig.service.ConfigService;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.ConfigApi;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.ConfigCompanyNameRequest;
import com.xforceplus.seller.config.client.model.ConfigOperatorRequest;
import com.xforceplus.seller.config.client.model.ConfigTtitleRequest;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequstWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemResponse;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigResponse;
import com.xforceplus.seller.config.client.model.MsConfigSummaryDTO;
import com.xforceplus.seller.config.client.model.MsConfigSummaryResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.translater.MsConfigQueryRequestTranslater;
import com.xforceplus.seller.config.common.UserCheckUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@MSApiV1SellerConfig
public class MsConfigController
implements ConfigApi {
    private static final Logger logger = LoggerFactory.getLogger(MsConfigController.class);
    @Autowired
    private ConfigBizConfigService configBizConfigService;
    @Autowired
    private ConfigService configService;

    public MsResponse deleteConfig(@ApiParam(value="\u67e5\u8be2\u914d\u7f6e\u660e\u7ec6") @RequestBody MsConfigDeleteRequstWithUserInfo msConfigDeleteRequst) {
        MsCommonUserInfo userInfo = msConfigDeleteRequst.getUserInfo();
        MsResponse msResponse = this.isLogin(userInfo);
        if (null != msResponse) {
            return msResponse;
        }
        msResponse = new MsResponse();
        try {
            this.configBizConfigService.deleteCfgConfig(msConfigDeleteRequst.getConfigIdList(), userInfo.getUserId());
            msResponse.setCode(Response.OK);
        }
        catch (Exception e) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return msResponse;
    }

    public MsConfigItemResponse queryConfigDetailRule(@ApiParam(value="\u67e5\u8be2\u914d\u7f6e\u660e\u7ec6") @RequestBody MsConfigItemQueryRequest msConfigItemQueryRequest) {
        List result = this.configBizConfigService.queryConfigItemList(msConfigItemQueryRequest);
        MsConfigItemResponse msConfigItemResponse = new MsConfigItemResponse();
        msConfigItemResponse.setCode(Response.OK);
        msConfigItemResponse.setResult(result);
        return msConfigItemResponse;
    }

    public MsConfigItemResponse batchQueryConfigDetailRule(@RequestBody MsConfigItemBatchQueryRequest msConfigItemBatchQueryRequest) {
        List result = this.configBizConfigService.batchQueryConfigItemList(msConfigItemBatchQueryRequest);
        MsConfigItemResponse msConfigItemResponse = new MsConfigItemResponse();
        msConfigItemResponse.setCode(Response.OK);
        msConfigItemResponse.setResult(result);
        return msConfigItemResponse;
    }

    public MsConfigResponse queryConfigRule(@ApiParam(value="\u7528\u6237\u67e5\u8be2\u914d\u7f6e") @RequestBody MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo) {
        MsConfigResponse msConfigResponse = new MsConfigResponse();
        MsResponse response = this.isLogin(msConfigQueryRequestWithUserInfo.getUserInfo());
        if (null != response) {
            msConfigResponse.setCode(response.getCode());
            msConfigResponse.setMessage(response.getMessage());
            return msConfigResponse;
        }
        MsConfigQueryRequest msConfigQueryRequest = MsConfigQueryRequestTranslater.MsConfigQueryRequestWithUser2MsConfigQueryRequest((MsConfigQueryRequestWithUserInfo)msConfigQueryRequestWithUserInfo);
        MsConfigPageDTO msConfigPageDTO = this.configBizConfigService.queryConfigList(msConfigQueryRequest, msConfigQueryRequestWithUserInfo.getUserInfo().getGroupId());
        msConfigResponse.setCode(Response.OK);
        msConfigResponse.setResult(msConfigPageDTO);
        return msConfigResponse;
    }

    public MsConfigSummaryResponse queryConfigSummary(@ApiParam(value="\u7528\u6237\u67e5\u8be2\u914d\u7f6e") @RequestBody MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo) {
        MsConfigSummaryResponse msConfigSummaryResponse = new MsConfigSummaryResponse();
        logger.info("queryConfigSummary=======msConfigQueryRequestWithUserInfo:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequestWithUserInfo));
        MsResponse response = this.isLogin(msConfigQueryRequestWithUserInfo.getUserInfo());
        if (null != response) {
            msConfigSummaryResponse.setCode(response.getCode());
            msConfigSummaryResponse.setMessage(response.getMessage());
            return msConfigSummaryResponse;
        }
        MsConfigQueryRequest msConfigQueryRequest = MsConfigQueryRequestTranslater.MsConfigQueryRequestWithUser2MsConfigQueryRequest((MsConfigQueryRequestWithUserInfo)msConfigQueryRequestWithUserInfo);
        StatusEnum[] configStatusEnums = StatusEnum.values();
        ArrayList<MsConfigSummaryDTO> result = new ArrayList<MsConfigSummaryDTO>();
        for (StatusEnum configStatusEnum : configStatusEnums) {
            MsConfigQueryRequest request = new MsConfigQueryRequest();
            BeanUtils.copyProperties((Object)msConfigQueryRequest, (Object)request);
            request.setStatus(configStatusEnum.getStatus());
            int count = this.configBizConfigService.queryConfigCount(request, msConfigQueryRequestWithUserInfo.getUserInfo().getGroupId());
            logger.info("queryConfigSummary=======count:{}, configStatusEnum.getStatus():{}, request:{}", new Object[]{count, configStatusEnum.getStatus(), JsonUtils.writeObjectToFastJson((Object)request)});
            MsConfigSummaryDTO msConfigSummaryDTO = new MsConfigSummaryDTO();
            msConfigSummaryDTO.setCode(String.valueOf(configStatusEnum.getStatus()));
            msConfigSummaryDTO.setCount(Integer.valueOf(count));
            msConfigSummaryDTO.setName(configStatusEnum.getStatusDesc());
            result.add(msConfigSummaryDTO);
        }
        msConfigSummaryResponse.setCode(Response.OK);
        msConfigSummaryResponse.setResult(result);
        return msConfigSummaryResponse;
    }

    public MsResponse saveConfigDetailRule(@ApiParam(value="\u4fdd\u5b58\u914d\u7f6e\u660e\u7ec6") @RequestBody MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest) {
        MsResponse response = this.isLogin(msConfigItemAddRequest.getUserInfo());
        if (null != response) {
            return response;
        }
        response = new MsResponse();
        try {
            this.configBizConfigService.addCfgConfigItem(msConfigItemAddRequest, null);
            response.setCode(Response.OK);
        }
        catch (Exception e) {
            response.setCode(Response.Fail);
            response.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    public MsResponse saveConfigRule(@ApiParam(value="\u65b0\u589e\u8bf7\u6c42") @RequestBody MsConfigAddRequestWithUserInfo msConfigAddRequest) {
        MsResponse msResponse = this.isLogin(msConfigAddRequest.getUserInfo());
        if (null != msResponse) {
            return msResponse;
        }
        msResponse = new MsResponse();
        try {
            Response response = this.configBizConfigService.addCfgConfig(msConfigAddRequest);
            logger.info("saveConfigRule response====>{}", (Object)JsonUtils.writeObjectToFastJson((Object)response));
            msResponse.setCode(response.getCode());
            msResponse.setMessage(response.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            msResponse.setCode(Response.Fail);
            msResponse.setMessage(e.getMessage());
            logger.info("saveConfigRule  error {}", (Object)e.getMessage());
        }
        return msResponse;
    }

    private MsResponse isLogin(MsCommonUserInfo msCommonUserInfo) {
        MsResponse response = null;
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response = new MsResponse();
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response;
        }
        return response;
    }

    public Response updateConfigOperator(@ApiParam(value="\u7968\u9762\u4eba\u4fe1\u606f") @RequestBody ConfigOperatorRequest configOperatorRequest) {
        return this.configService.updateConfigOperator(configOperatorRequest);
    }

    public Response updateConfigTtitle(@ApiParam(value="\u7968\u9762\u62ac\u5934\u4fe1\u606f") @RequestBody ConfigTtitleRequest configTtitleRequest) {
        return this.configService.updateConfigTtitle(configTtitleRequest);
    }

    public Response updateConfigCompanyName(@ApiParam(value="\u516c\u53f8\u4fe1\u606f") @RequestBody ConfigCompanyNameRequest configCompanyNameRequest) {
        return this.configService.updateConfigCompanyName(configCompanyNameRequest);
    }
}

