/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.service.impl;

import com.google.common.collect.Lists;
import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.seller.config.bizconfig.service.ConfigBizConfigService;
import com.xforceplus.seller.config.bizconfig.service.impl.ImportFailConfigServiceImpl;
import com.xforceplus.seller.config.bizconfig.vo.CheckTerminalResponseVo;
import com.xforceplus.seller.config.cahe.LocalBssExternalCacheManager;
import com.xforceplus.seller.config.cahe.LocalCacheManager;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsAddTerminalResponse;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalRequest;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsPageInfo;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsTerminalInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import com.xforceplus.seller.config.client.model.MsUpdateTerminalInfo;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.constants.TerminalType;
import com.xforceplus.seller.config.device.service.business.ConfigDeviceService;
import com.xforceplus.seller.config.listeners.model.ConfigBase;
import com.xforceplus.seller.config.listeners.model.PersonConfig;
import com.xforceplus.seller.config.listeners.model.SplitConfig;
import com.xforceplus.seller.config.listeners.model.TerminalConfig;
import com.xforceplus.seller.config.listeners.model.TitleConfig;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigInterfaceDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjExample;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemExample;
import com.xforceplus.seller.config.terminal.service.ConfigTerminalService;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;

@Service
public class ImportConfigServiceImpl
extends BaseConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ImportConfigServiceImpl.class);
    private List billFields = Arrays.asList("invoiceRemarkFiledList");
    private List billItemFields = Arrays.asList("splitFiledList");
    @Autowired
    ConfigBizConfigService configBizConfigService;
    @Autowired
    CfgConfigInterfaceDao cfgConfigInterfaceDao;
    @Autowired
    CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao;
    @Autowired
    CfgConfigDao cfgConfigDao;
    @Autowired
    CfgConfigItemDao cfgConfigItemDao;
    @Autowired
    LocalCacheManager localCacheManager;
    @Autowired
    CfgBusinessObjDao cfgBusinessObjDao;
    @Autowired
    ConfigDeviceService configDeviceService;
    @Autowired
    LocalBssExternalCacheManager localBssExternalCacheManager;
    @Autowired
    private ConfigTerminalService configTerminalService;
    @Autowired
    private ImportFailConfigServiceImpl importFailConfigServiceImpl;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Value(value="${invoice.makeout.using.rest.api}")
    private boolean useingRestApi;

    public void importSplitConfig(List<SplitConfig> list, Map<String, Object> headers) {
        logger.info("=========\u5f00\u59cb\u5bfc\u5165\u62c6\u7968\u89c4\u5219============");
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        for (int i = 0; i < list.size(); ++i) {
            MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
            SplitConfig splitConfig = list.get(i);
            splitConfig.setBatchNo(importBatchNo);
            splitConfig.setConfigType((String)headers.get("configType"));
            ArrayList configList = Lists.newArrayList();
            MsConfigBean msConfigBean = new MsConfigBean();
            StringBuilder msg = new StringBuilder();
            this.checkSplitConfigData(splitConfig, msg);
            msConfigBean.businessBillType(splitConfig.getBusinessBillType());
            msConfigBean.setSellerName(splitConfig.getSellerName());
            msConfigBean.setSellerTaxNo(splitConfig.getSellerTaxNo());
            msConfigBean.setPurchaserName(splitConfig.getPurchaserName());
            msConfigBean.setPurchaserTaxNo(splitConfig.getPurchaserTaxNo());
            msConfigBean.setConfigType(Integer.valueOf(Integer.parseInt(String.valueOf(headers.get("configType")))));
            msConfigBean.setSalesbillType(splitConfig.getSalesbillType());
            msConfigBean.setConfigName(splitConfig.getConfigName());
            msConfigBean.setInvoiceType(splitConfig.getInvoiceType());
            String result = this.commonValid(msConfigBean, userInfo);
            msg.append(result);
            BeanMap beanMap = BeanMap.create((Object)splitConfig);
            Field[] declaredFields = splitConfig.getClass().getDeclaredFields();
            msConfigBean.setItemList(this.getBeanItemList(beanMap, declaredFields, splitConfig.getSalesbillType(), userInfo.getGroupId()));
            configList.add(msConfigBean);
            msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
            msConfigAddRequestWithUserInfo.setItemDTOList((List)configList);
            logger.info("\u8bf7\u6c42\u62c6\u7968\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
            Long configId = this.checkExist(msConfigBean);
            if (configId != null) {
                logger.info("\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
                msConfigBean.setConfigId(configId);
            }
            if (CommonTools.isEmpty((String)msg.toString())) {
                try {
                    Response response = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo);
                    logger.info("\u8bf7\u6c42\u62c6\u7968\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)response));
                    if (response.getCode() != 1) {
                        msg.append(response.getMessage());
                    }
                }
                catch (Exception e) {
                    msg.append(e.getMessage() == null ? "\u7cfb\u7edf\u9519\u8bef" : e.getMessage());
                }
            }
            this.insertInterFace((ConfigBase)splitConfig, msg.toString());
        }
    }

    private void checkSplitConfigData(SplitConfig splitConfig, StringBuilder msg) {
        List<String> invoiceTypes = Arrays.asList("c", "s", "ce", "ju", "v");
        List<String> amountSplitRules = Arrays.asList("1", "2", "3");
        List<String> saleListOptionsList = Arrays.asList("1", "2");
        List<String> taxDeviceTypes = Arrays.asList("1", "2", "3", "4", "0");
        List<String> itemSorts = Arrays.asList("0", "1");
        List<String> unitPriceAmountOpsList = Arrays.asList("0", "1");
        String invoiceType = splitConfig.getInvoiceType();
        if (CommonTools.isEmpty((String)invoiceType)) {
            msg.append("--\u53d1\u7968\u7c7b\u578b\u4e3a \u5fc5\u586b\u9879--");
        } else if (invoiceTypes.contains(invoiceType)) {
            splitConfig.setInvoiceType(invoiceType);
        } else {
            msg.append("---\u53d1\u7968\u7c7b\u578b\u5fc5\u987b\u662fc,s,ce,ju,v\u4e2d\u7684\u4e00\u9879 ---");
        }
        String amountSplitRule = splitConfig.getAmountSplitRule().trim();
        if (CommonTools.isEmpty((String)amountSplitRule)) {
            msg.append("--\u91d1\u989d\u62c6\u5206\u89c4\u5219 \u5fc5\u586b\u9879--");
        } else if (amountSplitRules.contains(amountSplitRule)) {
            splitConfig.setAmountSplitRule(amountSplitRule);
        } else {
            msg.append("--\u91d1\u989d\u62c6\u5206\u89c4\u5219 \u5fc5\u987b\u662f 1\u6309\u5355\u4ef7\uff0c 2\u6309\u6570\u91cf(\u53d6\u6574)\u62c6 3\u6309\u6570\u91cf(\u4e0d\u53d6\u6574)\u62c6--");
        }
        String itemSort = splitConfig.getItemSort().trim();
        if (CommonTools.isEmpty((String)itemSort)) {
            msg.append("---\u660e\u7ec6\u987a\u5e8f\u5fc5\u586b\u9879---");
        } else if (itemSorts.contains(itemSort)) {
            splitConfig.setItemSort(itemSort);
        } else {
            msg.append("---\u660e\u7ec6\u987a\u5e8f\u5fc5\u987b\u662f 0\u987a\u5e8f\u4f18\u5148\uff0c1\u5f20\u6570\u4f18\u5148---");
        }
        String saleListOption = splitConfig.getSaleListOption().trim();
        if (CommonTools.isEmpty((String)saleListOption)) {
            msg.append("---\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u5fc5\u586b\u9879---");
        } else if (saleListOptionsList.contains(saleListOption)) {
            splitConfig.setSaleListOption(saleListOption);
        } else {
            msg.append("---\u9500\u8d27\u6e05\u5355\u9009\u9879\u5fc5\u987b\u662f 1\u662f\uff0c2\u5426---");
        }
        String taxDeviceType = splitConfig.getTaxDeviceType().trim();
        if (CommonTools.isEmpty((String)splitConfig.getTaxDeviceType())) {
            msg.append("---\u7a0e\u63a7\u8bbe\u5907\uff0c\u5fc5\u586b\u9879---");
        } else if (taxDeviceTypes.contains(taxDeviceType)) {
            splitConfig.setTaxDeviceType(taxDeviceType);
        } else {
            msg.append("---\u7a0e\u63a7\u8bbe\u5907\u5fc5\u987b\u662f 1\u822a\u4fe1\u5355\u673a\uff0c2\u767e\u65fa\u5355\u76d8\uff0c3\u822a\u4fe1\u670d\u52a1\u5668\uff0c4\u767e\u65fa\u670d\u52a1\u5668\uff0c 0\u901a\u7528---");
        }
        String unitPriceAmountOps = splitConfig.getUnitPriceAmountOps().trim();
        if (CommonTools.isEmpty((String)unitPriceAmountOps)) {
            msg.append("---\u5355\u4ef7\u6570\u91cf\u9009\u9879\uff0c\u5fc5\u586b\u9879---");
        } else if (unitPriceAmountOpsList.contains(unitPriceAmountOps)) {
            splitConfig.setUnitPriceAmountOps(unitPriceAmountOps);
        } else {
            msg.append("---\u5355\u4ef7\u6570\u91cf\u9009\u9879\u5fc5\u987b\u662f 0\u6253\u5370\u5355\u4ef7\u6570\u91cf\uff0c1\u4e0d\u6253\u5370\u5355\u4ef7\u6570\u91cf---");
        }
    }

    public void importTitleConfig(List<TitleConfig> list, Map<String, Object> headers) {
        logger.info("=========\u5f00\u59cb\u5bfc\u5165\u62ac\u5934\u89c4\u5219============");
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        for (int i = 0; i < list.size(); ++i) {
            MsConfigItemBean valuesellerTel;
            ArrayList tel;
            MsConfigItemBean valuebankName;
            ArrayList bankName;
            MsConfigItemBean valuebankAccount;
            ArrayList bankAccount;
            MsConfigItemBean valueAddress;
            ArrayList address;
            MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
            TitleConfig titleConfig = list.get(i);
            titleConfig.setBatchNo(importBatchNo);
            titleConfig.setConfigType((String)headers.get("configType"));
            ArrayList configList = Lists.newArrayList();
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.businessBillType(titleConfig.getBusinessBillType());
            msConfigBean.setSellerName(titleConfig.getSellerName());
            msConfigBean.setSellerTaxNo(titleConfig.getSellerTaxNo());
            msConfigBean.setPurchaserName(titleConfig.getPurchaserName());
            msConfigBean.setPurchaserTaxNo(titleConfig.getPurchaserTaxNo());
            msConfigBean.setConfigType(Integer.valueOf(Integer.parseInt(titleConfig.getConfigType())));
            msConfigBean.setSalesbillType(titleConfig.getSalesbillType());
            msConfigBean.setConfigName(titleConfig.getConfigName());
            StringBuilder msg = new StringBuilder();
            String result = this.commonValid(msConfigBean, userInfo);
            msg.append(result);
            if (CommonTools.isEmpty((String)titleConfig.getSellerAddress())) {
                msg.append("--\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)titleConfig.getSellerBankAccount())) {
                msg.append("--\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)titleConfig.getSellerBankName())) {
                msg.append("--\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)titleConfig.getSellerTel())) {
                msg.append("--\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            ArrayList configItemList = Lists.newArrayList();
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                address = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerAddress()});
                valueAddress = new MsConfigItemBean("sellerAddress", (List)address);
                bankAccount = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankAccount()});
                valuebankAccount = new MsConfigItemBean("sellerBankAccount", (List)bankAccount);
                bankName = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankName()});
                valuebankName = new MsConfigItemBean("sellerBankName", (List)bankName);
                tel = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerTel()});
                valuesellerTel = new MsConfigItemBean("sellerTel", (List)tel);
                configItemList.add(valueAddress);
                configItemList.add(valuebankAccount);
                configItemList.add(valuebankName);
                configItemList.add(valuesellerTel);
            } else {
                address = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerAddress()});
                valueAddress = new MsConfigItemBean("purchaserAddress", (List)address);
                bankAccount = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankAccount()});
                valuebankAccount = new MsConfigItemBean("purchaserBankAccount", (List)bankAccount);
                bankName = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankName()});
                valuebankName = new MsConfigItemBean("purchaserBankName", (List)bankName);
                tel = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerTel()});
                valuesellerTel = new MsConfigItemBean("purchaserTel", (List)tel);
                configItemList.add(valueAddress);
                configItemList.add(valuebankAccount);
                configItemList.add(valuebankName);
                configItemList.add(valuesellerTel);
            }
            msConfigBean.setItemList((List)configItemList);
            configList.add(msConfigBean);
            msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
            msConfigAddRequestWithUserInfo.setItemDTOList((List)configList);
            logger.info("\u8bf7\u6c42\u62ac\u5934\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
            Long configId = this.checkExist(msConfigBean);
            if (configId != null) {
                logger.info("\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
                msConfigBean.setConfigId(configId);
            }
            if (CommonTools.isEmpty((String)msg.toString())) {
                try {
                    Response response = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo);
                    logger.info("\u8bf7\u6c42\u62ac\u5934\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)response));
                    if (response.getCode() != 1) {
                        msg.append(response.getMessage());
                    }
                }
                catch (Exception e) {
                    msg.append(e.getMessage() == null ? "\u7cfb\u7edf\u9519\u8bef" : e.getMessage());
                }
            }
            this.insertInterFace((ConfigBase)titleConfig, msg.toString());
        }
    }

    public void importPersonConfig(List<PersonConfig> list, Map<String, Object> headers) {
        logger.info("=========\u5f00\u59cb\u5bfc\u5165\u7968\u9762\u89c4\u5219============");
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        for (int i = 0; i < list.size(); ++i) {
            MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
            PersonConfig personConfig = list.get(i);
            personConfig.setBatchNo(importBatchNo);
            personConfig.setConfigType((String)headers.get("configType"));
            ArrayList configList = Lists.newArrayList();
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.businessBillType(personConfig.getBusinessBillType());
            msConfigBean.setSellerName(personConfig.getSellerName());
            msConfigBean.setSellerTaxNo(personConfig.getSellerTaxNo());
            msConfigBean.setPurchaserName(personConfig.getPurchaserName());
            msConfigBean.setPurchaserTaxNo(personConfig.getPurchaserTaxNo());
            msConfigBean.setConfigType(Integer.valueOf(Integer.parseInt(personConfig.getConfigType())));
            msConfigBean.setSalesbillType(personConfig.getSalesbillType());
            msConfigBean.setConfigName(personConfig.getConfigName());
            StringBuilder msg = new StringBuilder();
            String result = this.commonValid(msConfigBean, userInfo);
            msg.append(result);
            if (CommonTools.isEmpty((String)personConfig.getSellerName())) {
                msg.append("--\u9500\u65b9\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)personConfig.getSellerTaxNo())) {
                msg.append("--\u9500\u65b9\u7a0e\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)personConfig.getCashierName())) {
                msg.append("--\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)personConfig.getCheckerName())) {
                msg.append("--\u590d\u6838\u4eba\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)personConfig.getInvoicerName())) {
                msg.append("--\u5f00\u7968\u4eba\u4e0d\u80fd\u4e3a\u7a7a---");
            }
            BeanMap beanMap = BeanMap.create((Object)personConfig);
            Field[] declaredFields = personConfig.getClass().getDeclaredFields();
            msConfigBean.setItemList(this.getBeanItemList(beanMap, declaredFields, null, null));
            configList.add(msConfigBean);
            msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
            msConfigAddRequestWithUserInfo.setItemDTOList((List)configList);
            logger.info("\u8bf7\u6c42\u7968\u9762\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
            Long configId = this.checkExist(msConfigBean);
            if (configId != null) {
                logger.info("\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
                msConfigBean.setConfigId(configId);
            }
            if (CommonTools.isEmpty((String)msg.toString())) {
                try {
                    Response response = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo);
                    logger.info("\u8bf7\u6c42\u7968\u9762\u4eba\u5458\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)response));
                    if (response.getCode() != 1) {
                        msg.append(response.getMessage());
                    }
                }
                catch (Exception e) {
                    msg.append(e.getMessage() == null ? "\u7cfb\u7edf\u9519\u8bef" : e.getMessage());
                }
            }
            this.insertInterFace((ConfigBase)personConfig, msg.toString());
        }
    }

    private List<MsConfigItemBean> getBeanItemList(BeanMap beanMap, Field[] declaredFields, String salesBillType, Long groupId) {
        ArrayList configItemList = Lists.newArrayList();
        for (int j = 0; j < declaredFields.length; ++j) {
            String val;
            String fieldName = declaredFields[j].getName();
            if (fieldName.contains("$")) continue;
            ArrayList<String> value = new ArrayList<String>(1);
            if (this.billItemFields.contains(fieldName) && salesBillType != null) {
                val = String.valueOf(beanMap.get((Object)fieldName));
                value.addAll(this.getFieldEnName(salesBillType, groupId, val));
            } else if (this.billFields.contains(fieldName) && salesBillType != null) {
                val = String.valueOf(beanMap.get((Object)fieldName));
                value.addAll(this.getFieldEnNameForBill(salesBillType, groupId, val));
            } else {
                value.add(String.valueOf(beanMap.get((Object)fieldName)));
            }
            configItemList.add(new MsConfigItemBean(fieldName, value));
        }
        return configItemList;
    }

    private ArrayList<String> getFieldEnName(String salesBillType, Long groupId, String value) {
        Map map = this.localCacheManager.queryEffctiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        ArrayList dataValues = Lists.newArrayList();
        value = value.replace("\uff0c", ",");
        String[] splitfields = value.split(",");
        for (int i = 0; i < splitfields.length; ++i) {
            String disPlayName = splitfields[i];
            String key = disPlayName + "#1";
            MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key);
            if (msBusinessObjMetadataBean != null) {
                dataValues.add(msBusinessObjMetadataBean.getFieldName());
                continue;
            }
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u660e\u7ec6\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b{},\u96c6\u56e2id:{}", new Object[]{disPlayName, salesBillType, groupId});
        }
        return dataValues;
    }

    private ArrayList<String> getFieldEnNameForBill(String salesBillType, Long groupId, String value) {
        Map map = this.localCacheManager.queryEffctiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        ArrayList dataValues = Lists.newArrayList();
        String[] splitfields = value.split(",");
        for (int i = 0; i < splitfields.length; ++i) {
            String disPlayName = splitfields[i];
            String key = disPlayName + "#0";
            MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key);
            if (msBusinessObjMetadataBean != null) {
                dataValues.add(msBusinessObjMetadataBean.getFieldName());
                continue;
            }
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b{},\u96c6\u56e2id:{}", new Object[]{disPlayName, salesBillType, groupId});
        }
        return dataValues;
    }

    private MsCommonUserInfo getUserInfo(Map<String, Object> headers) {
        MsCommonUserInfo userInfo = new MsCommonUserInfo();
        userInfo.setUserId(Long.valueOf(Long.parseLong(String.valueOf(headers.get("userId")))));
        userInfo.setUserName(String.valueOf(headers.get("userName")));
        userInfo.setGroupId(Long.valueOf(Long.parseLong(String.valueOf(headers.get("groupId")))));
        userInfo.setGroupCode(String.valueOf(headers.get("groupCode")));
        userInfo.setGroupName(String.valueOf(headers.get("groupName")));
        this.setContextUserInfo(headers);
        return userInfo;
    }

    private void setContextUserInfo(Map<String, Object> headers) {
        UserInfo userInfo = new UserInfo();
        if (headers.get("groupId") != null) {
            userInfo.setGroupId(Long.parseLong(String.valueOf(headers.get("groupId"))));
        }
        this.userInfoHolder.put((Object)userInfo);
    }

    private String commonValid(MsConfigBean msConfigBean, MsCommonUserInfo userInfo) {
        StringBuilder msg = new StringBuilder();
        if (ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue()) {
            msConfigBean.setBusinessBillType(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
        } else {
            if (CommonTools.isEmpty((String)msConfigBean.getSalesbillType())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u5fc5\u987b\u586b\u5199").append("--");
            } else if (!BusinessSalesBillTypeEnum.checkIsExist((String)msConfigBean.getBusinessBillType())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u5fc5\u987b\u662fAR \u6216\u8005 AP").append("--");
            }
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType()) && CommonTools.isEmpty((String)msConfigBean.getSellerTaxNo())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u662fAR,\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("--");
            }
            if (BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType()) && CommonTools.isEmpty((String)msConfigBean.getPurchaserTaxNo())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u662fAP,\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("--");
            }
        }
        if (CommonTools.isEmpty((String)msConfigBean.getSellerTaxNo()) && !CommonTools.isEmpty((String)msConfigBean.getSellerName())) {
            msg.append("--").append("\u9500\u65b9\u7a0e\u53f7\u4e3a\u7a7a,\u9500\u65b9\u516c\u53f8\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        } else if (!CommonTools.isEmpty((String)msConfigBean.getSellerTaxNo()) && CommonTools.isEmpty((String)msConfigBean.getSellerName())) {
            msg.append("--").append("\u9500\u65b9\u516c\u53f8\u4e3a\u7a7a,\u9500\u65b9\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)msConfigBean.getPurchaserTaxNo()) && !CommonTools.isEmpty((String)msConfigBean.getPurchaserName())) {
            msg.append("--").append("\u8d2d\u65b9\u7a0e\u53f7\u4e3a\u7a7a,\u8d2d\u65b9\u516c\u53f8\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        } else if (CommonTools.isEmpty((String)msConfigBean.getPurchaserName()) && !CommonTools.isEmpty((String)msConfigBean.getPurchaserTaxNo())) {
            msg.append("--").append("\u8d2d\u65b9\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a,\u8d2d\u65b9\u7a0e\u53f7\u5fc5\u987b\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)msConfigBean.getSalesbillType())) {
            msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        } else {
            CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
            cfgBusinessObjExample.createCriteria().andGroupIdEqualTo(userInfo.getGroupId()).andObjNameEqualTo(msConfigBean.getSalesbillType().trim()).andObjStatusEqualTo(Byte.valueOf((byte)1));
            long l = this.cfgBusinessObjDao.countByExample(cfgBusinessObjExample);
            if (l == 0L) {
                msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u5728\u8be5\u96c6\u56e2\u4e0d\u5b58\u5728").append("--");
            }
        }
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue() && CommonTools.isEmpty((String)msConfigBean.getInvoiceType())) {
            msg.append("--").append("\u62c6\u7968\u89c4\u5219\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)msConfigBean.getConfigName())) {
            msg.append("--").append("\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        return msg.toString();
    }

    private void insertInterFace(ConfigBase config, String msg) {
        CfgConfigInterfaceEntity entity = new CfgConfigInterfaceEntity();
        entity.setBatchNo(config.getBatchNo());
        entity.setSalesbillType(config.getSalesbillType());
        entity.setBusinessBillType(config.getBusinessBillType() == null ? "" : config.getBusinessBillType());
        entity.setSellerName(config.getSellerName() == null ? "" : config.getSellerName());
        entity.setSellerTaxNo(config.getSellerTaxNo() == null ? "" : config.getSellerTaxNo());
        entity.setPurchaserName(config.getPurchaserName() == null ? "" : config.getPurchaserName());
        entity.setPurchaserTaxNo(config.getPurchaserTaxNo() == null ? "" : config.getPurchaserTaxNo());
        entity.setConfigType(Integer.valueOf(config.getConfigType()));
        entity.setInvoiceType(config.getInvoiceType() == null ? "" : config.getInvoiceType());
        entity.setConfigName(config.getConfigName() == null ? "" : config.getConfigName());
        String json = JsonUtils.writeObjectToFastJson((Object)config);
        entity.setOrigData(json);
        if (!CommonTools.isEmpty((String)msg)) {
            entity.setProcessFlag("F");
            entity.setProcessRemark(msg);
        } else {
            entity.setProcessFlag("S");
            entity.setProcessRemark("");
        }
        entity.setStatus(Integer.valueOf(1));
        entity.setCreateTime(new Date());
        this.cfgConfigInterfaceExtDao.insertWithDefaultValue(entity);
    }

    private Long checkExist(MsConfigBean msConfigBean) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        if (msConfigBean.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType())) {
            String invoiceType = msConfigBean.getInvoiceType();
            criteria.andInvoiceTypeEqualTo(invoiceType);
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        String salesbillType = StringUtils.isEmpty((CharSequence)msConfigBean.getSalesbillType()) ? "" : msConfigBean.getSalesbillType();
        criteria.andSalesbillTypeEqualTo(salesbillType);
        criteria.andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType());
        String sellerTaxNo = msConfigBean.getSellerTaxNo();
        criteria.andSellerTaxNoEqualTo(sellerTaxNo == null ? "" : sellerTaxNo);
        String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
        criteria.andPurchaserTaxNoEqualTo(purchaserTaxNo == null ? "" : purchaserTaxNo);
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (cfgConfigEntities.size() == 1) {
            return ((CfgConfigEntity)cfgConfigEntities.get(0)).getConfigId();
        }
        if (cfgConfigEntities.size() > 1) {
            logger.warn("==========\u914d\u7f6e\u8868\u5b58\u5728\u91cd\u590d\u6570\u636e==================================");
            return null;
        }
        return null;
    }

    private void updateConfigItem(MsConfigBean msConfigBean, Long configId) {
        msConfigBean.getItemList().forEach(item -> {
            List configItemValue = item.getConfigItemValue();
            if (!CollectionUtils.isEmpty((Collection)configItemValue) && !CommonTools.isEmpty((String)((String)configItemValue.get(0)))) {
                CfgConfigItemEntity cfgConfigItemEntity = new CfgConfigItemEntity();
                cfgConfigItemEntity.setConfigItemValue(JsonUtils.writeObjectToFastJson((Object)configItemValue));
                CfgConfigItemExample cfgConfigItemExample = new CfgConfigItemExample();
                cfgConfigItemExample.createCriteria().andConfigIdEqualTo(configId).andConfigItemNameEqualTo(item.getConfigItemName());
                this.cfgConfigItemDao.updateByExampleSelective(cfgConfigItemEntity, cfgConfigItemExample);
            } else {
                logger.info("\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u4e0d\u66f4\u8be5\u5b57\u6bb5:{}", (Object)item.getConfigItemName());
            }
        });
    }

    public void importTerminal(List<TerminalConfig> list, Map<String, Object> headers) {
        this.setContextUserInfo(headers);
        if (list == null || list.size() == 0) {
            logger.warn("\u65e0\u6570\u636e...");
            return;
        }
        ArrayList<TerminalConfig> errorList = new ArrayList<TerminalConfig>();
        int insertTotal = 0;
        int updateTotal = 0;
        long groupId = headers.get("groupId") == null ? -1L : Long.parseLong(headers.get("groupId").toString());
        String groupName = headers.get("groupName") == null ? "" : headers.get("groupName").toString();
        long userId = headers.get("userId") == null ? -1L : Long.parseLong(headers.get("userId").toString());
        List userCompanyTaxNos = null;
        if (this.useingRestApi) {
            userCompanyTaxNos = this.getCurrentUserCompanyTaxNos();
        }
        for (TerminalConfig terminalConfig : list) {
            StringBuilder sb = new StringBuilder();
            CheckTerminalResponseVo checkTerminalResponseVo = new CheckTerminalResponseVo();
            this.checkTerminal(terminalConfig, groupId, sb, checkTerminalResponseVo, userCompanyTaxNos);
            if (sb.length() > 0) {
                terminalConfig.setErrorMsg(sb.toString());
                errorList.add(terminalConfig);
                continue;
            }
            try {
                String terminalNo = terminalConfig.getTerminalNo();
                MsTerminalQueryResponseInfo msTerminalQueryResponseInfo = this.getTerminalList(terminalNo, groupId);
                if (msTerminalQueryResponseInfo != null) {
                    MsConfigUpdateTerminalRequest msConfigUpdateTerminalRequest = this.buildMsConfigUpdateTerminalRequest(msTerminalQueryResponseInfo.getId().longValue(), msTerminalQueryResponseInfo.getDeviceId(), msTerminalQueryResponseInfo.getDeviceUn(), terminalConfig, checkTerminalResponseVo);
                    MsResponse msResponse = this.configTerminalService.update(msConfigUpdateTerminalRequest, userId, groupId);
                    logger.info("terminal update params:{},response:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigUpdateTerminalRequest), (Object)JsonUtils.writeObjectToFastJson((Object)msResponse));
                    if (msResponse.getCode().equals(-1)) {
                        terminalConfig.setErrorMsg(msResponse.getMessage());
                        errorList.add(terminalConfig);
                        continue;
                    }
                    ++updateTotal;
                    continue;
                }
                MsConfigAddTerminalRequest msConfigAddTerminalRequest = this.buildMsConfigAddTerminalRequest(terminalConfig, checkTerminalResponseVo);
                MsAddTerminalResponse msAddTerminalResponse = this.configTerminalService.addTerminal(msConfigAddTerminalRequest, groupId, groupName, userId);
                logger.info("terminal insert params:{},response:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddTerminalRequest), (Object)JsonUtils.writeObjectToFastJson((Object)msAddTerminalResponse));
                if (msAddTerminalResponse.getCode().equals(Response.Fail) || msAddTerminalResponse.getCode().equals(-1)) {
                    terminalConfig.setErrorMsg(msAddTerminalResponse.getMessage());
                    errorList.add(terminalConfig);
                    continue;
                }
                ++insertTotal;
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u7ec8\u7aef\u5f02\u5e38.{}", (Throwable)e);
                terminalConfig.setErrorMsg(e.getMessage() == null ? "\u5904\u7406\u7ec8\u7aef\u5f02\u5e38" : e.getMessage().substring(0, 200));
            }
        }
        this.importFailConfigServiceImpl.dealFailTerminalImport(errorList, headers, insertTotal, updateTotal);
    }

    private void checkTerminal(TerminalConfig terminalConfig, long groupId, StringBuilder sb, CheckTerminalResponseVo checkTerminalResponseVo, List<String> userCompanyTaxNos) {
        String terminalNo = terminalConfig.getTerminalNo();
        String terminalName = terminalConfig.getTerminalName();
        String companyName = terminalConfig.getCompanyName();
        String companyTaxNo = terminalConfig.getCompanyTaxNo();
        String supportService = terminalConfig.getSupportService();
        String terminalType = terminalConfig.getTerminalType();
        String deviceNo = terminalConfig.getDeviceNo();
        String invoiceType = terminalConfig.getInvoiceType();
        if (StringUtils.isEmpty((CharSequence)terminalNo)) {
            sb.append("\u7ec8\u7aef\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isEmpty((CharSequence)terminalName)) {
            sb.append("\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isEmpty((CharSequence)companyName)) {
            sb.append("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isEmpty((CharSequence)companyTaxNo)) {
            sb.append("\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a;");
        } else {
            CompanyModel companyModel;
            if (this.useingRestApi && (userCompanyTaxNos == null || !userCompanyTaxNos.contains(companyTaxNo))) {
                sb.append("\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u8be5\u516c\u53f8;");
            }
            if ((companyModel = this.localBssExternalCacheManager.getCompanyMainInfoByTaxNo(companyTaxNo)) == null || !companyModel.getCompanyName().equals(companyName)) {
                sb.append("\u516c\u53f8\u540d\u79f0\u4e0d\u5408\u6cd5;");
            } else {
                checkTerminalResponseVo.setCompanyId(companyModel.getCompanyId().longValue());
            }
        }
        if (StringUtils.isEmpty((CharSequence)supportService)) {
            sb.append("\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
        } else {
            String[] supportServiceArr;
            ArrayList<String> supportServiceList = new ArrayList<String>();
            for (String str : supportServiceArr = supportService.split(",")) {
                if ("1".equals(str)) {
                    supportServiceList.add("make");
                    continue;
                }
                if ("2".equals(str)) {
                    supportServiceList.add("print");
                    continue;
                }
                if ("3".equals(str)) {
                    supportServiceList.add("originAccount");
                    continue;
                }
                if ("4".equals(str)) {
                    supportServiceList.add("assistant");
                    continue;
                }
                sb.append("\u670d\u52a1\u7c7b\u578b\u586b\u5199\u4e0d\u6b63\u786e;");
                break;
            }
            checkTerminalResponseVo.setSupportServiceList(supportServiceList);
        }
        if (StringUtils.isEmpty((CharSequence)terminalType)) {
            sb.append("\u7ec8\u7aef\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
        } else if (!TerminalType.getValues().contains(terminalType)) {
            sb.append("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7ec8\u7aef\u7c7b\u578b;");
        } else if (terminalType.equals(String.valueOf(TerminalType.SERVER.getValue()))) {
            if (StringUtils.isEmpty((CharSequence)deviceNo)) {
                sb.append("\u7a0e\u63a7\u8bbe\u5907\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                ArrayList taxDeviceTypes = Lists.newArrayList((Object[])new Integer[]{2, 4});
                MsQueryDeviceResponse msQueryDeviceResponse = this.configDeviceService.queryAllTaxDeviceByTaxDeviceTypes((List)taxDeviceTypes, groupId);
                if (msQueryDeviceResponse == null || msQueryDeviceResponse.getCode().equals(BaseResponse.Fail)) {
                    sb.append("\u7a0e\u63a7\u8bbe\u5907\u4e0d\u5b58\u5728;");
                } else {
                    boolean isLegal = false;
                    for (MsDeviceInfo msDeviceInfo : msQueryDeviceResponse.getResult().getDevices()) {
                        if (!deviceNo.equals(msDeviceInfo.getDeviceNo())) continue;
                        checkTerminalResponseVo.setDeviceId(msDeviceInfo.getId());
                        isLegal = true;
                        break;
                    }
                    if (!isLegal) {
                        sb.append("\u7a0e\u63a7\u8bbe\u5907\u4e0d\u5b58\u5728;");
                    }
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)invoiceType)) {
            sb.append("\u5f00\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }

    private MsConfigUpdateTerminalRequest buildMsConfigUpdateTerminalRequest(long id, Long deviceId, String deviceUn, TerminalConfig terminalConfig, CheckTerminalResponseVo checkTerminalResponseVo) {
        MsUpdateTerminalInfo updateTerminalInfo = new MsUpdateTerminalInfo();
        updateTerminalInfo.setId(Long.valueOf(id));
        updateTerminalInfo.setDeviceId(deviceId);
        updateTerminalInfo.setDeviceUn(deviceUn);
        updateTerminalInfo.setInvoiceType(Arrays.asList(terminalConfig.getInvoiceType().split(",")));
        updateTerminalInfo.setSupportService(checkTerminalResponseVo.getSupportServiceList());
        updateTerminalInfo.setTerminalName(terminalConfig.getTerminalName());
        updateTerminalInfo.setTerminalNo(terminalConfig.getTerminalNo());
        updateTerminalInfo.setTerminalType(Integer.valueOf(Integer.parseInt(terminalConfig.getTerminalType())));
        MsConfigUpdateTerminalRequest msConfigUpdateTerminalRequest = new MsConfigUpdateTerminalRequest();
        msConfigUpdateTerminalRequest.setTerminalInfo(updateTerminalInfo);
        return msConfigUpdateTerminalRequest;
    }

    private MsConfigAddTerminalRequest buildMsConfigAddTerminalRequest(TerminalConfig terminalConfig, CheckTerminalResponseVo checkTerminalResponseVo) {
        MsTerminalInfo insertTerminalInfo = new MsTerminalInfo();
        insertTerminalInfo.setInvoiceType(Arrays.asList(terminalConfig.getInvoiceType().split(",")));
        insertTerminalInfo.setDeviceId(checkTerminalResponseVo.getDeviceId());
        insertTerminalInfo.setSupportService(checkTerminalResponseVo.getSupportServiceList());
        insertTerminalInfo.setTerminalName(terminalConfig.getTerminalName());
        insertTerminalInfo.setTerminalNo(terminalConfig.getTerminalNo());
        insertTerminalInfo.setTerminalType(Integer.valueOf(Integer.parseInt(terminalConfig.getTerminalType())));
        insertTerminalInfo.setStatus(Integer.valueOf(11));
        MsCompanyInfo companyInfo = new MsCompanyInfo();
        companyInfo.setCompanyId(Long.valueOf(checkTerminalResponseVo.getCompanyId()));
        insertTerminalInfo.setCompanyInfo(companyInfo);
        MsConfigAddTerminalRequest msConfigAddTerminalRequest = new MsConfigAddTerminalRequest();
        msConfigAddTerminalRequest.setTerminalInfo(insertTerminalInfo);
        return msConfigAddTerminalRequest;
    }

    private MsTerminalQueryResponseInfo getTerminalList(String terminalNo, long groupId) {
        MsConfigTemialQueryRequest msConfigTemialQueryRequest = new MsConfigTemialQueryRequest();
        MsTerminalQueryInfo terminalInfo = new MsTerminalQueryInfo();
        terminalInfo.setTerminalNo(terminalNo);
        MsCompanyInfo msCompanyInfo = new MsCompanyInfo();
        msCompanyInfo.setTenantId(Long.valueOf(groupId));
        terminalInfo.setCompanyInfo(msCompanyInfo);
        msConfigTemialQueryRequest.setTerminalInfo(terminalInfo);
        MsPageInfo pageInfo = new MsPageInfo();
        pageInfo.setPageNo(Integer.valueOf(1));
        pageInfo.setPageSize(Integer.valueOf(50));
        msConfigTemialQueryRequest.setPageInfo(pageInfo);
        MsQueryTerminalResponse response = this.configTerminalService.getTerminalList(msConfigTemialQueryRequest);
        for (MsTerminalQueryResponseInfo msTerminalQueryResponseInfo : response.getResult().getTerminals()) {
            if (!terminalNo.equals(msTerminalQueryResponseInfo.getTerminalNo())) continue;
            return msTerminalQueryResponseInfo;
        }
        return null;
    }
}

