/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.cahe;

import com.google.common.collect.Maps;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.metadata.service.ConfigMetaDataService;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CACHE_NANME = "LOCAL_CONFIG_CACHE";
    @Autowired
    ConfigMetaDataService configMetaDataService;

    @Cacheable(cacheNames={"LOCAL_CONFIG_CACHE"})
    public Map<String, MsBusinessObjMetadataBean> queryEffctiveMetaData(Long groupId, String objCode, String objType) {
        MsMataDataQueryRequest request = new MsMataDataQueryRequest();
        request.setGroupId(groupId);
        request.setObjCode(objCode);
        request.setObjType(objType);
        this.logger.info("================queryEffctiveMetaData-{}==============================================", (Object)request);
        List result = this.configMetaDataService.queryEffectiveMetaDataList(request);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        result.forEach(m -> map.put(m.getFieldDisplayName() + "#" + m.getFieldGroupIndex(), m));
        this.logger.info("=================metadataItemResult-{}===========================================", (Object)JsonUtils.writeObjectToFastJson((Object)result));
        return map;
    }
}

