/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.xforceplus.seller.config.constants.CaffeineCacheEnum;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableCaching
@EnableScheduling
public class CaffeineCacheConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @Primary
    public CacheManager caffeineCacheManager() {
        this.logger.info("=======================building cacheManager==================================");
        Caffeine caffeine = Caffeine.newBuilder().initialCapacity(100).expireAfterWrite((long)CaffeineCacheEnum.BSS_EXTERNAL_LOCAL_CACHE.getTtl(), TimeUnit.SECONDS).maximumSize((long)CaffeineCacheEnum.BSS_EXTERNAL_LOCAL_CACHE.getMaxSize());
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.setAllowNullValues(true);
        cacheManager.setCaffeine(caffeine);
        cacheManager.setCacheNames((Collection)CaffeineCacheEnum.getNames());
        return cacheManager;
    }
}

