/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.device.service.business.impl;

import com.google.common.collect.Lists;
import com.xforceplus.micro.tax.device.contract.model.AddDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.CompanyQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.PageInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.TaxDeviceQueryRequestInfo;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsCompanyModel;
import com.xforceplus.seller.config.client.model.MsCompanyQueryInfo;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddResult;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateResponse;
import com.xforceplus.seller.config.client.model.MsConfigUpdateDeviceStatusRequest;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsDeviceQueryInfo;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryRequest;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryResponse;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryResult;
import com.xforceplus.seller.config.client.model.MsQueryAllTaxDeviceByTaxDeviceTypesRequest;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResult;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsResponsePageInfo;
import com.xforceplus.seller.config.client.model.MsUpdateDeviceInfo;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.device.service.business.ConfigDeviceService;
import com.xforceplus.seller.config.device.service.business.SubscribeDeviceService;
import com.xforceplus.seller.config.proxy.DeviceApiProxy;
import com.xforceplus.seller.config.proxy.model.device.RestAddDeviceRequest;
import com.xforceplus.seller.config.proxy.model.device.RestCompanyQueryInfo;
import com.xforceplus.seller.config.proxy.model.device.RestDeviceQueryInfo;
import com.xforceplus.seller.config.proxy.model.device.RestGetSubscribeDeviceStockResponse;
import com.xforceplus.seller.config.proxy.model.device.RestOperateInfo;
import com.xforceplus.seller.config.proxy.model.device.RestQueryDeviceRequest;
import com.xforceplus.seller.config.proxy.model.device.RestQueryDeviceResponse;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateDeviceInfo;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateDeviceRequest;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigDeviceServiceImpl
extends BaseConfigService
implements ConfigDeviceService {
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    DeviceApiProxy deviceApiProxy;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private SubscribeDeviceService subscribeDeviceService;
    @Value(value="${invoice.makeout.using.rest.api}")
    private boolean useingRestApi;

    private long getGroupId() {
        return ((UserInfo)this.userInfoHolder.get()).getGroupId();
    }

    public MsConfigDeviceUpdateResponse updateDevice(MsConfigDeviceUpdateRequest configDeviceUpdateRequest) {
        MsResponse msResponse;
        BiFunction<Integer, String, MsConfigDeviceUpdateResponse> quickReturn = (code, message) -> {
            MsConfigDeviceUpdateResponse response = new MsConfigDeviceUpdateResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        Function<ResponseHead, MsConfigDeviceUpdateResponse> quickProcessResult = responseHead -> (MsConfigDeviceUpdateResponse)quickReturn.apply(responseHead.getCode(), responseHead.getMessage());
        MsUpdateDeviceInfo msUpdateDeviceInfo = configDeviceUpdateRequest.getDeviceInfo();
        long deviceId = msUpdateDeviceInfo.getId();
        QueryDeviceResponse queryDeviceResponse = this.queryDeviceById(Collections.singletonList(deviceId));
        if (!queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            return quickProcessResult.apply(queryDeviceResponse.getHead());
        }
        List deviceInfoList = queryDeviceResponse.getDevices();
        if (deviceInfoList == null || deviceInfoList.size() != 1) {
            return quickReturn.apply(BaseResponse.Fail, "\u5bf9\u5e94\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        DeviceInfo deviceInfo = (DeviceInfo)deviceInfoList.get(0);
        if (!deviceInfo.getCompanyInfo().getTenantId().equals(this.getGroupId())) {
            return quickReturn.apply(BaseResponse.Fail, "\u60a8\u65e0\u6743\u9650\u66f4\u65b0\u6b64\u6570\u636e");
        }
        Integer taxDeviceType = msUpdateDeviceInfo.getTaxDeviceInfo().getTaxDeviceType();
        if (taxDeviceType == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((taxDeviceType.equals(Integer.parseInt("1")) || taxDeviceType.equals(Integer.parseInt("2"))) && msUpdateDeviceInfo.getDeviceNo() != null && !deviceInfo.getDeviceNo().equals(msUpdateDeviceInfo.getDeviceNo()) && !(msResponse = this.checkDeviceNo(msUpdateDeviceInfo.getDeviceNo())).getCode().equals(BaseResponse.OK)) {
            return quickReturn.apply(msResponse.getCode(), msResponse.getMessage());
        }
        MsUpdateDeviceInfo msDeviceInfo = configDeviceUpdateRequest.getDeviceInfo();
        if (!msDeviceInfo.getDeviceType().equals("taxDevice")) {
            return quickReturn.apply(BaseResponse.Fail, "\u6682\u4e0d\u652f\u6301\u7a0e\u63a7\u94a5\u5319");
        }
        RestUpdateDeviceRequest updateDeviceRequest = new RestUpdateDeviceRequest();
        BeanMapper.copy((Object)configDeviceUpdateRequest, (Object)updateDeviceRequest);
        RestOperateInfo operateInfo = new RestOperateInfo();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        operateInfo.setUpdatedBy(userInfo.getUserId() + "");
        updateDeviceRequest.getDeviceInfo().setOperateInfo(operateInfo);
        String serialNo = String.valueOf(this.idGenerator.nextId());
        this.logger.info("\u66f4\u65b0\u7a0e\u63a7\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        updateDeviceRequest.setSerialNo(serialNo);
        List service = updateDeviceRequest.getDeviceInfo().getService();
        boolean inventorySubscribe = false;
        if (!CollectionUtils.isEmpty((Collection)service) && service.contains("inventory")) {
            service.remove("inventory");
            inventorySubscribe = true;
            if (service.size() <= 0) {
                return quickReturn.apply(BaseResponse.Fail, "\u4e0d\u80fd\u53ea\u9009\u62e9\u5e93\u5b58\u670d\u52a1");
            }
        }
        this.logger.info("updateDeviceRequest:{}", (Object)updateDeviceRequest);
        UpdateDeviceResponse updateDeviceResponse = this.deviceApiProxy.deviceUpdatePost(updateDeviceRequest);
        MsConfigDeviceUpdateResponse msConfigDeviceUpdateResponse = new MsConfigDeviceUpdateResponse();
        msConfigDeviceUpdateResponse.setCode(updateDeviceResponse.getHead().getCode());
        msConfigDeviceUpdateResponse.setMessage(updateDeviceResponse.getHead().getMessage());
        this.logger.info("msConfigDeviceUpdateResponse:{}", (Object)msConfigDeviceUpdateResponse);
        if (!msConfigDeviceUpdateResponse.getCode().equals(BaseResponse.OK)) {
            return msConfigDeviceUpdateResponse;
        }
        UpdateDeviceStatusRequest updateStatusRequest = new UpdateDeviceStatusRequest();
        updateStatusRequest.setDeviceId(Collections.singletonList(deviceId));
        updateStatusRequest.setStatus(Integer.valueOf(0));
        updateStatusRequest.setOperateInfo(this.getUpdateOperateInfo());
        UpdateDeviceStatusResponse updateStatusResponse = this.deviceApiProxy.deviceUpdateStatusPost(updateStatusRequest);
        this.logger.debug("UpdateDeviceStatusResponse:{}", (Object)updateStatusResponse);
        if (!updateStatusResponse.getHead().getCode().equals(BaseResponse.OK)) {
            msConfigDeviceUpdateResponse.setCode(updateStatusResponse.getHead().getCode());
            msConfigDeviceUpdateResponse.setMessage(updateStatusResponse.getHead().getMessage());
            if (inventorySubscribe) {
                service.add("inventory");
            }
            String serviceMessage = this.updateDeviceService(deviceInfo, updateDeviceRequest.getDeviceInfo());
            if (StringUtils.isBlank((CharSequence)msConfigDeviceUpdateResponse.getMessage())) {
                msConfigDeviceUpdateResponse.setMessage(serviceMessage);
            } else {
                msConfigDeviceUpdateResponse.setMessage(msConfigDeviceUpdateResponse.getMessage() + "," + serviceMessage);
            }
        }
        return msConfigDeviceUpdateResponse;
    }

    private String updateDeviceService(DeviceInfo deviceInfo, RestUpdateDeviceInfo updateDeviceInfo) {
        String errorMessage;
        ArrayList<String> oldService = deviceInfo.getService();
        RestGetSubscribeDeviceStockResponse inventoryResponse = this.subscribeDeviceService.getInventorySubscribe(deviceInfo.getDeviceUn());
        if ("1".equals(inventoryResponse.getCode()) && inventoryResponse.getResult() != null && !CollectionUtils.isEmpty((Collection)inventoryResponse.getResult().getSubscribeDeviceStockList())) {
            if (oldService == null) {
                oldService = new ArrayList<String>();
            }
            oldService.add("inventory");
        }
        ArrayList<String> needCancelService = null;
        List needAddService = null;
        if (!CollectionUtils.isEmpty((Collection)updateDeviceInfo.getService()) && !CollectionUtils.isEmpty((Collection)oldService)) {
            ArrayList<String> serviceNotChange = new ArrayList<String>();
            for (String newService : updateDeviceInfo.getService()) {
                if (!oldService.contains(newService)) continue;
                serviceNotChange.add(newService);
            }
            oldService.removeAll(serviceNotChange);
            needCancelService = oldService;
            updateDeviceInfo.getService().removeAll(serviceNotChange);
            needAddService = updateDeviceInfo.getService();
        } else {
            if (CollectionUtils.isEmpty((Collection)updateDeviceInfo.getService())) {
                needCancelService = oldService;
            }
            if (CollectionUtils.isEmpty(oldService)) {
                needAddService = updateDeviceInfo.getService();
            }
        }
        String message = "";
        if (!CollectionUtils.isEmpty(needCancelService)) {
            message = errorMessage = this.cancelSubscriptionService(needCancelService, deviceInfo.getCompanyInfo().getTaxNo(), deviceInfo.getDeviceUn());
        }
        if (!CollectionUtils.isEmpty((Collection)needAddService) && StringUtils.isNotBlank((CharSequence)(errorMessage = this.subscriptionService(needAddService, deviceInfo.getCompanyInfo().getTaxNo(), deviceInfo.getDeviceUn())))) {
            message = StringUtils.isNotBlank((CharSequence)message) ? message + "," + errorMessage : errorMessage;
        }
        return message;
    }

    private QueryDeviceResponse queryDeviceById(List<Long> idList) {
        QueryDeviceRequest queryDeviceRequest = new QueryDeviceRequest();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        ArrayList typeList = Lists.newArrayList();
        typeList.add("taxDevice");
        typeList.add("taxVUKey");
        deviceQueryInfo.setDeviceType(null);
        deviceQueryInfo.setDeviceTypeList((List)typeList);
        deviceQueryInfo.setDeviceIds(idList);
        PageInfo pageInfo = this.getPageInfo(idList.size());
        queryDeviceRequest.setQueryInfo(deviceQueryInfo);
        queryDeviceRequest.setPageInfo(pageInfo);
        QueryDeviceResponse queryDeviceResponse = this.deviceApiProxy.deviceQueryPost(queryDeviceRequest);
        this.logger.debug("queryDeviceResponse:{}", (Object)queryDeviceResponse);
        return queryDeviceResponse;
    }

    private MsResponse checkDeviceNo(String deviceNo) {
        QueryDeviceRequest queryDeviceRequest = new QueryDeviceRequest();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        deviceQueryInfo.setDeviceType("taxDevice");
        deviceQueryInfo.setDeviceNo(deviceNo);
        PageInfo pageInfo = this.getPageInfo(1);
        queryDeviceRequest.setQueryInfo(deviceQueryInfo);
        queryDeviceRequest.setPageInfo(pageInfo);
        QueryDeviceResponse queryDeviceResponse = this.deviceApiProxy.deviceQueryPost(queryDeviceRequest);
        this.logger.debug("\u67e5\u8be2\u8bbe\u5907\u54cd\u5e94:{}", (Object)queryDeviceResponse);
        Function<ResponseHead, MsResponse> quickProcessResult = responseHead -> new MsResponse().code(responseHead.getCode()).message(responseHead.getMessage());
        if (!queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            return quickProcessResult.apply(queryDeviceResponse.getHead()).traceId(queryDeviceResponse.getHead().getTraceId());
        }
        if (queryDeviceResponse.getDevices() != null && !queryDeviceResponse.getDevices().isEmpty()) {
            return new MsResponse().code(BaseResponse.Fail).message("\u7a0e\u63a7\u8bbe\u5907\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u3002").traceId(queryDeviceResponse.getHead().getTraceId());
        }
        return new MsResponse().code(BaseResponse.OK);
    }

    public MsConfigDeviceAddResponse addDevice(MsConfigDeviceAddRequest msConfigDeviceAddRequest) {
        MsResponse msResponse;
        BiFunction<Integer, String, MsConfigDeviceAddResponse> quickReturn = (code, message) -> {
            MsConfigDeviceAddResponse response = new MsConfigDeviceAddResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        MsConfigDeviceGetCompanyListResponse msConfigDeviceGetCompanyListResponse = this.configDeviceGetCompanyList(new MsConfigDeviceGetCompanyListRequest());
        if (!msConfigDeviceGetCompanyListResponse.getCode().equals(BaseResponse.OK)) {
            return quickReturn.apply(msConfigDeviceGetCompanyListResponse.getCode(), msConfigDeviceGetCompanyListResponse.getMessage());
        }
        List companyModelList = msConfigDeviceGetCompanyListResponse.getResult();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsCompanyInfo msCompanyInfo = msConfigDeviceAddRequest.getDeviceInfo().getCompanyInfo();
        if (msCompanyInfo == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u6ca1\u6709\u586b\u5199\u516c\u53f8\u4fe1\u606f");
        }
        Optional<MsCompanyModel> optionalMsCompanyModel = companyModelList.stream().filter(msCompanyModel -> msCompanyModel.getCompanyId().equals(msCompanyInfo.getCompanyId())).findFirst();
        if (!optionalMsCompanyModel.isPresent()) {
            return quickReturn.apply(BaseResponse.Fail, "\u4f60\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4fe1\u606f");
        }
        MsCompanyModel msCompanyModel2 = optionalMsCompanyModel.get();
        long companyId = msCompanyModel2.getCompanyId();
        OrgModel orgModel = this.getOrgModel(userInfo.getGroupId(), companyId);
        if (orgModel == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
        }
        msCompanyInfo.setCompanyId(Long.valueOf(companyId));
        msCompanyInfo.setCompanyName(msCompanyModel2.getCompanyName());
        msCompanyInfo.setTaxNo(msCompanyModel2.getTaxNum());
        msCompanyInfo.setTenantId(Long.valueOf(userInfo.getGroupId()));
        msCompanyInfo.setTenantName(userInfo.getGroupName());
        msCompanyInfo.setOrganizationId(orgModel.getOrgStructId());
        msCompanyInfo.setOrganizationName(orgModel.getOrgName());
        Integer taxDeviceType = msConfigDeviceAddRequest.getDeviceInfo().getTaxDeviceInfo().getTaxDeviceType();
        if (taxDeviceType == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((taxDeviceType.equals(Integer.parseInt("1")) || taxDeviceType.equals(Integer.parseInt("2"))) && !(msResponse = this.checkDeviceNo(msConfigDeviceAddRequest.getDeviceInfo().getDeviceNo())).getCode().equals(BaseResponse.OK)) {
            return quickReturn.apply(msResponse.getCode(), msResponse.getMessage()).traceId(msResponse.getTraceId());
        }
        MsDeviceInfo msDeviceInfo = msConfigDeviceAddRequest.getDeviceInfo();
        msDeviceInfo.setHasLicenseFlag(null);
        msDeviceInfo.setStatus(Integer.valueOf(0));
        if (!msDeviceInfo.getDeviceType().equals("taxDevice")) {
            return quickReturn.apply(BaseResponse.Fail, "\u6682\u4e0d\u652f\u6301\u7a0e\u63a7\u94a5\u5319");
        }
        RestAddDeviceRequest addDeviceRequest = new RestAddDeviceRequest();
        BeanMapper.copy((Object)msConfigDeviceAddRequest, (Object)addDeviceRequest);
        RestOperateInfo operateInfo = new RestOperateInfo();
        operateInfo.setCreatedBy(userInfo.getUserId() + "");
        addDeviceRequest.getDeviceInfo().setOperateInfo(operateInfo);
        String serialNo = String.valueOf(this.idGenerator.nextId());
        this.logger.info("\u65b0\u589e\u7a0e\u63a7\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        addDeviceRequest.setSerialNo(serialNo);
        List service = addDeviceRequest.getDeviceInfo().getService();
        boolean inventorySubscribe = false;
        if (!CollectionUtils.isEmpty((Collection)service) && service.contains("inventory")) {
            service.remove("inventory");
            inventorySubscribe = true;
            if (service.size() <= 0) {
                return quickReturn.apply(BaseResponse.Fail, "\u4e0d\u80fd\u53ea\u9009\u62e9\u5e93\u5b58\u670d\u52a1");
            }
        }
        AddDeviceResponse addDeviceResponse = this.deviceApiProxy.deviceAddPost(addDeviceRequest);
        this.logger.debug("\u6dfb\u52a0\u7a0e\u63a7\u8bbe\u5907\u54cd\u5e94:{}", (Object)addDeviceResponse);
        MsConfigDeviceAddResponse msConfigDeviceAddResponse = new MsConfigDeviceAddResponse();
        msConfigDeviceAddResponse.setCode(addDeviceResponse.getHead().getCode());
        msConfigDeviceAddResponse.setMessage(addDeviceResponse.getHead().getMessage());
        MsConfigDeviceAddResult msConfigDeviceAddResult = new MsConfigDeviceAddResult();
        msConfigDeviceAddResult.setDeviceId(addDeviceResponse.getDeviceId());
        msConfigDeviceAddResult.setDeviceUn(addDeviceResponse.getDeviceUn());
        msConfigDeviceAddResponse.setResult(msConfigDeviceAddResult);
        msConfigDeviceAddResponse.traceId(addDeviceResponse.getHead().getTraceId());
        this.logger.debug("msConfigDeviceAddResponse:{}", (Object)msConfigDeviceAddResponse);
        if (StringUtils.isBlank((CharSequence)msConfigDeviceAddResponse.getMessage())) {
            msConfigDeviceAddResponse.setMessage("\u65b0\u589e\u8bbe\u5907\u6210\u529f");
        }
        if (msConfigDeviceAddResponse.getCode() == Response.OK) {
            String subscriptionMessage;
            if (inventorySubscribe) {
                service.add("inventory");
            }
            if (StringUtils.isNotBlank((CharSequence)(subscriptionMessage = this.subscriptionService(service, addDeviceRequest.getDeviceInfo().getCompanyInfo().getTaxNo(), msConfigDeviceAddResult.getDeviceUn())))) {
                this.logger.info("\u65b0\u589e\u8bbe\u5907\u8ba2\u9605\u7ed3\u679c:" + subscriptionMessage);
                msConfigDeviceAddResponse.setMessage(msConfigDeviceAddResponse.getMessage() + ", " + subscriptionMessage);
            }
        }
        return msConfigDeviceAddResponse;
    }

    public MsQueryDeviceResponse getDeviceList(MsConfigDeviceQueryRequest request) {
        if (request.getIsAppOrigin() != null && request.getIsAppOrigin().booleanValue()) {
            MsDeviceQueryInfo msDeviceQueryInfo = request.getQueryInfo();
            request.setQueryInfo(this.buildDeviceQueryInfo(msDeviceQueryInfo));
        }
        RestQueryDeviceRequest destinationRequest = new RestQueryDeviceRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        String serialNo = String.valueOf(this.idGenerator.nextId());
        this.logger.info("\u67e5\u8be2\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        destinationRequest.setSerialNo(serialNo);
        List userCompanyTaxNos = this.getCurrentUserCompanyTaxNos();
        if (userCompanyTaxNos != null && userCompanyTaxNos.size() > 0) {
            this.logger.info("\u5f53\u524d\u7528\u6237\u6240\u5728\u516c\u53f8\u7684\u7a0e\u53f7\uff1a" + userCompanyTaxNos.toString());
            if (destinationRequest.getQueryInfo() != null && destinationRequest.getQueryInfo().getCompanyInfo() != null && StringUtils.isNotBlank((CharSequence)destinationRequest.getQueryInfo().getCompanyInfo().getTaxNo()) && !userCompanyTaxNos.contains(destinationRequest.getQueryInfo().getCompanyInfo().getTaxNo())) {
                MsQueryDeviceResponse emptyResponse = new MsQueryDeviceResponse();
                MsQueryDeviceResult emptyResult = new MsQueryDeviceResult();
                MsResponsePageInfo pageInfo = new MsResponsePageInfo();
                pageInfo.setPageNo(request.getPageInfo().getPageNo());
                pageInfo.setTotal(Integer.valueOf(0));
                emptyResult.setPageInfo(pageInfo);
                emptyResponse.setResult(emptyResult);
                emptyResponse.setCode(Response.OK);
                emptyResponse.setMessage("\u67e5\u8be2\u6210\u529f");
                return emptyResponse;
            }
        } else {
            return new MsQueryDeviceResponse().code(Response.Fail).message("\u83b7\u53d6\u7528\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
        }
        if (destinationRequest.getQueryInfo() == null) {
            destinationRequest.setQueryInfo(new RestDeviceQueryInfo());
        }
        if (destinationRequest.getQueryInfo().getCompanyInfo() == null) {
            destinationRequest.getQueryInfo().setCompanyInfo(new RestCompanyQueryInfo());
        }
        destinationRequest.getQueryInfo().getCompanyInfo().setTaxNos(userCompanyTaxNos);
        ArrayList typeList = Lists.newArrayList();
        typeList.add("taxDevice");
        typeList.add("taxVUKey");
        destinationRequest.getQueryInfo().setDeviceType(null);
        destinationRequest.getQueryInfo().setDeviceTypeList((List)typeList);
        RestQueryDeviceResponse sourceResponse = this.deviceApiProxy.deviceQueryPost(destinationRequest);
        MsQueryDeviceResponse response = new MsQueryDeviceResponse();
        MsQueryDeviceResult destinationResponse = new MsQueryDeviceResult();
        response.setResult(destinationResponse);
        if ("1".equals(sourceResponse.getCode())) {
            BeanMapper.copy((Object)sourceResponse.getResult(), (Object)destinationResponse);
            response.setCode(BaseResponse.OK);
            response.setMessage("\u67e5\u8be2\u6210\u529f");
            if (!CollectionUtils.isEmpty((Collection)destinationResponse.getDevices())) {
                for (MsDeviceInfo deviceInfo : destinationResponse.getDevices()) {
                    RestGetSubscribeDeviceStockResponse inventoryResponse;
                    if (!StringUtils.isNotBlank((CharSequence)deviceInfo.getDeviceUn()) || !"1".equals((inventoryResponse = this.subscribeDeviceService.getInventorySubscribe(deviceInfo.getDeviceUn())).getCode()) || inventoryResponse.getResult() == null || CollectionUtils.isEmpty((Collection)inventoryResponse.getResult().getSubscribeDeviceStockList()) || inventoryResponse.getResult() == null || CollectionUtils.isEmpty((Collection)inventoryResponse.getResult().getSubscribeDeviceStockList())) continue;
                    if (deviceInfo.getService() == null) {
                        deviceInfo.setService(new ArrayList());
                    }
                    deviceInfo.getService().add("inventory");
                }
            }
        } else {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u67e5\u8be2\u5931\u8d25");
        }
        this.logger.debug("MsQueryDeviceResponse:{}", (Object)response);
        return response;
    }

    private PageInfo getPageInfo(int pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(Integer.valueOf(1));
        pageInfo.setPageSize(Integer.valueOf(pageSize));
        return pageInfo;
    }

    public MsResponse updateStatus(MsConfigUpdateDeviceStatusRequest request) {
        List deviceIdList = request.getDeviceId();
        int updateStatus = request.getStatus();
        BiFunction<Integer, String, MsResponse> quickReturn = (code, message) -> {
            MsResponse response = new MsResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        this.logger.debug("id list:{}", (Object)deviceIdList);
        QueryDeviceResponse queryDeviceResponse = this.queryDeviceById(deviceIdList);
        Function<ResponseHead, MsResponse> quickProcessResult = responseHead -> (MsResponse)quickReturn.apply(responseHead.getCode(), responseHead.getMessage());
        if (!queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            return quickProcessResult.apply(queryDeviceResponse.getHead());
        }
        List deviceInfoList = queryDeviceResponse.getDevices();
        if (deviceInfoList == null || deviceInfoList.size() != deviceIdList.size()) {
            return quickReturn.apply(BaseResponse.Fail, "\u5bf9\u5e94\u7684\u8bbe\u5907Id\u4e0d\u5b58\u5728");
        }
        long tenantId = this.getGroupId();
        for (DeviceInfo deviceInfo : deviceInfoList) {
            if (deviceInfo.getStatus() == null) {
                return quickReturn.apply(BaseResponse.Fail, "\u83b7\u53d6\u5f53\u524d\u8bbe\u5907\u72b6\u6001\u5931\u8d25");
            }
            if (updateStatus == 12 && deviceInfo.getStatus() == 12) {
                return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u5df2\u7ecf\u505c\u7528\uff0c\u4e0d\u9700\u8981\u518d\u505c\u7528");
            }
            if (updateStatus == 11 && deviceInfo.getStatus() == 11) {
                return quickReturn.apply(BaseResponse.Fail, "\u7a0e\u63a7\u8bbe\u5907\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u9700\u8981\u518d\u542f\u7528");
            }
            if (updateStatus == 22 && (deviceInfo.getStatus() == 11 || deviceInfo.getStatus() == 12)) {
                return quickReturn.apply(BaseResponse.Fail, "\u672a\u542f\u7528\u6216\u8005\u5df2\u542f\u7528\u7684\u7a0e\u63a7\u8bbe\u5907\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
            }
            if (deviceInfo.getCompanyInfo() == null || deviceInfo.getCompanyInfo().getTenantId() == null) {
                return quickReturn.apply(BaseResponse.Fail, "\u83b7\u53d6\u5f53\u524d\u8bbe\u5907\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
            }
            if (deviceInfo.getCompanyInfo().getTenantId().equals(tenantId)) continue;
            return quickReturn.apply(BaseResponse.Fail, "\u60a8\u65e0\u6743\u9650\u66f4\u65b0\u6b64\u6570\u636e");
        }
        UpdateDeviceStatusRequest destinationRequest = new UpdateDeviceStatusRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        destinationRequest.setOperateInfo(this.getUpdateOperateInfo());
        UpdateDeviceStatusResponse sourceResponse = this.deviceApiProxy.deviceUpdateStatusPost(destinationRequest);
        this.logger.debug("UpdateDeviceStatusResponse:{}", (Object)sourceResponse);
        if (sourceResponse.getHead().getCode() == Response.OK && updateStatus == 22) {
            this.deleteDeviceService(deviceInfoList);
        }
        return quickProcessResult.apply(sourceResponse.getHead());
    }

    private void deleteDeviceService(List<DeviceInfo> deviceInfoList) {
        if (!CollectionUtils.isEmpty(deviceInfoList)) {
            for (DeviceInfo deviceInfo : deviceInfoList) {
                this.cancelSubscriptionService(deviceInfo.getService(), deviceInfo.getCompanyInfo().getTaxNo(), deviceInfo.getDeviceUn());
            }
        }
    }

    public MsQueryDeviceResponse queryAllTaxDeviceByTaxDeviceTypes(MsQueryAllTaxDeviceByTaxDeviceTypesRequest queryAllTaxDeviceByTaxDeviceTypesRequest) {
        List taxDeviceTypes = queryAllTaxDeviceByTaxDeviceTypesRequest.getTaxDeviceTypes();
        return this.queryAllTaxDeviceByTaxDeviceTypes(taxDeviceTypes, this.getGroupId());
    }

    public MsQueryDeviceResponse queryAllTaxDeviceByTaxDeviceTypes(List<Integer> taxDeviceTypes, long groupId) {
        QueryDeviceRequest queryDeviceRequest = new QueryDeviceRequest();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        CompanyQueryInfo companyQueryInfo = new CompanyQueryInfo();
        List userCompanyTaxNos = this.getCurrentUserCompanyTaxNos();
        companyQueryInfo.setTenantId(Collections.singletonList(groupId));
        ArrayList typeList = Lists.newArrayList();
        typeList.add("taxDevice");
        typeList.add("taxVUKey");
        deviceQueryInfo.setDeviceType(null);
        deviceQueryInfo.setDeviceTypeList((List)typeList);
        deviceQueryInfo.setCompanyInfo(companyQueryInfo);
        deviceQueryInfo.setStatus(Collections.singletonList(11));
        PageInfo onePageInfo = this.getPageInfo(1);
        queryDeviceRequest.setQueryInfo(deviceQueryInfo);
        queryDeviceRequest.setPageInfo(onePageInfo);
        TaxDeviceQueryRequestInfo taxDeviceQueryRequestInfo = new TaxDeviceQueryRequestInfo();
        deviceQueryInfo.setTaxDeviceInfo(taxDeviceQueryRequestInfo);
        LinkedList deviceInfos = new LinkedList();
        PageInfo maxPageInfo = this.getPageInfo(1);
        for (int taxDeviceType : taxDeviceTypes) {
            taxDeviceQueryRequestInfo.setTaxDeviceType(Integer.valueOf(taxDeviceType));
            QueryDeviceResponse queryDeviceResponse = this.deviceApiProxy.deviceQueryPost(queryDeviceRequest, Long.valueOf(groupId), userCompanyTaxNos);
            if (queryDeviceResponse.getHead().getCode().equals(BaseResponse.Fail)) {
                this.logger.error("\u6279\u91cf\u83b7\u53d6\u51fa\u9519\u4e86:{}", (Object)queryDeviceResponse.getHead().getMessage());
                continue;
            }
            Integer total = queryDeviceResponse.getPageInfo() == null ? Integer.valueOf(0) : queryDeviceResponse.getPageInfo().getTotal();
            if (total == null || total == 0) continue;
            maxPageInfo.setPageSize(total);
            queryDeviceRequest.setPageInfo(maxPageInfo);
            queryDeviceResponse = this.deviceApiProxy.deviceQueryPost(queryDeviceRequest, Long.valueOf(groupId), userCompanyTaxNos);
            if (queryDeviceResponse.getHead().getCode().equals(BaseResponse.Fail)) {
                this.logger.error("\u6279\u91cf\u83b7\u53d6\u51fa\u9519\u4e86:{}", (Object)queryDeviceResponse.getHead().getMessage());
                continue;
            }
            deviceInfos.addAll(queryDeviceResponse.getDevices());
        }
        MsQueryDeviceResponse msQueryDeviceResponse = new MsQueryDeviceResponse();
        msQueryDeviceResponse.setCode(BaseResponse.OK);
        msQueryDeviceResponse.setMessage("");
        List msDeviceInfos = BeanMapper.mapList(deviceInfos, MsDeviceInfo.class);
        msQueryDeviceResponse.setResult(new MsQueryDeviceResult().devices(msDeviceInfos).pageInfo(new MsResponsePageInfo().pageNo(Integer.valueOf(1)).total(Integer.valueOf(msDeviceInfos.size()))));
        this.logger.debug("msQueryDeviceResponse:{}", (Object)msQueryDeviceResponse);
        return msQueryDeviceResponse;
    }

    private MsDeviceQueryInfo buildDeviceQueryInfo(MsDeviceQueryInfo msDeviceQueryInfo) {
        if (msDeviceQueryInfo == null) {
            msDeviceQueryInfo = new MsDeviceQueryInfo();
        }
        MsCompanyQueryInfo msCompanyQueryInfo = msDeviceQueryInfo.getCompanyInfo();
        List<Long> tenantIdList = Collections.singletonList(this.getGroupId());
        if (msCompanyQueryInfo == null) {
            msCompanyQueryInfo = new MsCompanyQueryInfo();
            msCompanyQueryInfo.setTenantId(tenantIdList);
            msDeviceQueryInfo.setCompanyInfo(msCompanyQueryInfo);
        } else {
            msCompanyQueryInfo.setTenantId(tenantIdList);
        }
        return msDeviceQueryInfo;
    }

    public MsDeviceSummaryQueryResponse deviceSummaryQuery(MsDeviceSummaryQueryRequest request) {
        RestQueryDeviceResponse sourceResponse;
        MsDeviceQueryInfo msDeviceQueryInfo = request.getQueryInfo();
        msDeviceQueryInfo = this.buildDeviceQueryInfo(msDeviceQueryInfo);
        MsDeviceSummaryQueryResponse response = new MsDeviceSummaryQueryResponse();
        ArrayList<MsDeviceSummaryQueryResult> deviceSummaryQueryResultList = new ArrayList<MsDeviceSummaryQueryResult>(2);
        MsDeviceSummaryQueryResult auditPassResult = new MsDeviceSummaryQueryResult();
        auditPassResult.setCode(Integer.valueOf(1));
        auditPassResult.setName("\u5ba1\u6838\u901a\u8fc7");
        MsDeviceSummaryQueryResult auditFailResult = new MsDeviceSummaryQueryResult();
        auditFailResult.setCode(Integer.valueOf(2));
        auditFailResult.setName("\u5ba1\u6838\u672a\u901a\u8fc7");
        MsDeviceSummaryQueryResult stayResult = new MsDeviceSummaryQueryResult();
        stayResult.setCode(Integer.valueOf(0));
        stayResult.setName("\u5f85\u5ba1\u6838");
        List userCompanyTaxNos = this.getCurrentUserCompanyTaxNos();
        if (userCompanyTaxNos != null && userCompanyTaxNos.size() > 0) {
            this.logger.info("\u5f53\u524d\u7528\u6237\u6240\u5728\u516c\u53f8\u7684\u7a0e\u53f7\uff1a" + userCompanyTaxNos.toString());
            if (msDeviceQueryInfo.getCompanyInfo() != null && StringUtils.isNotBlank((CharSequence)msDeviceQueryInfo.getCompanyInfo().getTaxNo()) && !userCompanyTaxNos.contains(msDeviceQueryInfo.getCompanyInfo().getTaxNo())) {
                auditPassResult.setCount(Long.valueOf(0L));
                auditFailResult.setCount(Long.valueOf(0L));
                stayResult.setCount(Long.valueOf(0L));
                deviceSummaryQueryResultList.add(auditPassResult);
                deviceSummaryQueryResultList.add(auditFailResult);
                deviceSummaryQueryResultList.add(stayResult);
                response.setResult(deviceSummaryQueryResultList);
                response.setCode(BaseResponse.OK);
                return response;
            }
        } else {
            response.setCode(Response.Fail);
            response.setMessage("\u83b7\u53d6\u7528\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            return response;
        }
        if (msDeviceQueryInfo.getStatus() != null && !msDeviceQueryInfo.getStatus().isEmpty() && !msDeviceQueryInfo.getStatus().stream().allMatch(status -> status.equals(11) || status.equals(12) || status.equals(21))) {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u8f93\u5165\u72b6\u6001\u9519\u8bef");
            return response;
        }
        RestDeviceQueryInfo deviceQueryInfo = new RestDeviceQueryInfo();
        BeanMapper.copy((Object)msDeviceQueryInfo, (Object)deviceQueryInfo);
        deviceQueryInfo.getCompanyInfo().setTaxNos(userCompanyTaxNos);
        ArrayList typeList = Lists.newArrayList();
        typeList.add("taxDevice");
        typeList.add("taxVUKey");
        deviceQueryInfo.setDeviceType(null);
        deviceQueryInfo.setDeviceTypeList((List)typeList);
        RestQueryDeviceRequest destinationRequest = new RestQueryDeviceRequest();
        destinationRequest.setPageInfo(this.getPageInfo(1));
        destinationRequest.setQueryInfo(deviceQueryInfo);
        ArrayList<Integer> auditPassStatusList = new ArrayList<Integer>(3);
        auditPassStatusList.add(11);
        auditPassStatusList.add(12);
        auditPassStatusList.add(21);
        if (deviceQueryInfo.getStatus() == null || deviceQueryInfo.getStatus().isEmpty()) {
            deviceQueryInfo.setStatus(auditPassStatusList);
        }
        if (!"1".equals((sourceResponse = this.deviceApiProxy.deviceQueryPost(destinationRequest)).getCode())) {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u67e5\u8be2\u5931\u8d25");
            this.logger.debug("deviceQueryPost result:{}", (Object)response);
            return response;
        }
        auditPassResult.setCount(Long.valueOf(sourceResponse.getResult().getPageInfo().getTotal().longValue()));
        deviceQueryInfo.setStatus(Collections.singletonList(2));
        sourceResponse = this.deviceApiProxy.deviceQueryPost(destinationRequest);
        if (!"1".equals(sourceResponse.getCode())) {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u67e5\u8be2\u5931\u8d25");
            this.logger.debug("deviceQueryPost result:{}", (Object)response);
            return response;
        }
        auditFailResult.setCount(Long.valueOf(sourceResponse.getResult().getPageInfo().getTotal().longValue()));
        deviceQueryInfo.setStatus(Collections.singletonList(0));
        sourceResponse = this.deviceApiProxy.deviceQueryPost(destinationRequest);
        if (!"1".equals(sourceResponse.getCode())) {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u67e5\u8be2\u5931\u8d25");
            this.logger.debug("deviceQueryPost result:{}", (Object)response);
            return response;
        }
        stayResult.setCount(Long.valueOf(sourceResponse.getResult().getPageInfo().getTotal() == null ? 0L : sourceResponse.getResult().getPageInfo().getTotal().longValue()));
        deviceSummaryQueryResultList.add(auditPassResult);
        deviceSummaryQueryResultList.add(auditFailResult);
        deviceSummaryQueryResultList.add(stayResult);
        response.setResult(deviceSummaryQueryResultList);
        response.setCode(BaseResponse.OK);
        this.logger.debug("result:{}", (Object)response);
        return response;
    }

    public MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest) {
        return super.configDeviceGetCompanyList(configDeviceGetCompanyListRequest);
    }

    private String subscriptionService(List<String> service, String taxNo, String deviceUn) {
        return this.subscribeDeviceService.batchAddSubscribe(service, taxNo, deviceUn);
    }

    private String cancelSubscriptionService(List<String> service, String taxNo, String deviceUn) {
        return this.subscribeDeviceService.batchCancelSubscribe(service, taxNo, deviceUn);
    }
}

