/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.bss.external.client.model.GetGroupInfoRequest;
import com.xforceplus.bss.external.client.model.GetGroupInfoResponse;
import com.xforceplus.bss.external.client.model.GroupModel;
import com.xforceplus.bss.external.client.model.SearchCompanyListRequest;
import com.xforceplus.bss.external.client.model.SearchCompanyListResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.bizconfig.service.ConfigBizConfigService;
import com.xforceplus.seller.config.bizconfig.service.ConfigMailRuleService;
import com.xforceplus.seller.config.client.CompanyApiClient;
import com.xforceplus.seller.config.client.GroupApiClient;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.SalesListPrintEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.matchparser.impl.ConfigMatchParserImpl;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequstWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemTempBean;
import com.xforceplus.seller.config.client.model.MsConfigMailRule;
import com.xforceplus.seller.config.client.model.MsConfigMailRuleResponse;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.seller.config.client.parse.bean.InvoiceSplitrRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.InvoiceSplitParser;
import com.xforceplus.seller.config.common.ConfigErrorEnum;
import com.xforceplus.seller.config.common.ConstantValue;
import com.xforceplus.seller.config.common.GenerateCronJobEnum;
import com.xforceplus.seller.config.common.xxlJobResponse.JobGroupPageListResult;
import com.xforceplus.seller.config.common.xxlJobResponse.XxlJobGroup;
import com.xforceplus.seller.config.constants.BusinessBillType;
import com.xforceplus.seller.config.exception.CompanyQueryException;
import com.xforceplus.seller.config.exception.ConfigCreateException;
import com.xforceplus.seller.config.exception.ConfigExsitException;
import com.xforceplus.seller.config.exception.ConfigItemRequiredException;
import com.xforceplus.seller.config.exception.ConfigNameRepeatException;
import com.xforceplus.seller.config.exception.InvoiceFaceConfigRepeatException;
import com.xforceplus.seller.config.exception.InvoiceSplitConfigException;
import com.xforceplus.seller.config.exception.ThridPartyInvokeException;
import com.xforceplus.seller.config.exception.TipsException;
import com.xforceplus.seller.config.metadata.service.ConfigMetaDataService;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemTempDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigJobDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigMailRuleDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigTempDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjMetadataDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigBillAttributeExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigExtDao;
import com.xforceplus.seller.config.repository.daoext.ConfigItemExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeExample;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempExample;
import com.xforceplus.seller.config.repository.model.CfgConfigJobEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigJobExample;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleExample;
import com.xforceplus.seller.config.repository.model.CfgConfigTempEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigTempExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataExample;
import com.xforceplus.seller.config.repository.model.modelext.CfgConfigExtExample;
import com.xforceplus.seller.config.system.enums.InvoiceType;
import com.xforceplus.seller.config.translater.ConfigEntityTranslater;
import com.xforceplus.seller.config.translater.ConfigItemEntityTranslator;
import com.xforceplus.seller.config.translater.ExamapleTranslater;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.ReflectUtil;
import com.xforceplus.seller.config.util.StringUtil;
import com.xforceplus.seller.config.util.XxlJobUtil;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigBizConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigBizConfigService.class);
    public static final String AUTO_MAKEOUT_SUFFIX = "-AutoMakeout";
    public static final String RED_FLUSH_SUFFIX = "-RedFlush";
    private CfgConfigDao cfgConfigDao;
    private CfgConfigItemDao cfgConfigItemDao;
    private CfgConfigTempDao cfgConfigTempDao;
    private CfgConfigItemTempDao cfgConfigItemTempDao;
    private IDGenerator generator;
    private CompanyApiClient companyApiClient;
    private GroupApiClient groupApiClient;
    private CfgTemplateObjDao cfgTemplateObjDao;
    private CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao;
    private ConfigItemExtDao configItemExtDao;
    private CfgConfigExtDao cfgConfigExtDao;
    private ConfigMetaDataService configMetaDataService;
    private ConfigMatchParserImpl configMatchParserImpl;
    private CfgConfigBillAttributeExtDao cfgConfigBillAttributeExtDao;
    private CfgConfigMailRuleDao cfgConfigMailRuleDao;
    private ConfigMailRuleService configMailRuleService;
    private CfgConfigJobDao cfgConfigJobDao;
    public static final int INVOICE_REMARK_MAX_LENGTH = 230;
    public static final int INVOICE_REMARK_CE_MAX_LENGTH = 250;
    public static final String AUTO_MAKEOUT_JOB = "virtualInvoiceAutoSplitAndMakeoutJob";
    public static final String AUTO_REDFLUSH_JOB = "virtualInvoiceAutoRedFlushJob";
    @Value(value="${xxl.job.admin.addresses:http\\://localhost:8080/xxl-job-admin}")
    private String adminAddresses;
    @Value(value="${xxl.job.admin.userName:admin}")
    private String xxlUserName;
    @Value(value="${xxl.job.admin.password:123456}")
    private String xxlPassword;

    @Autowired
    public ConfigBizConfigService(CfgConfigDao cfgConfigDao, CfgConfigItemDao cfgConfigItemDao, CfgConfigTempDao cfgConfigTempDao, CfgConfigItemTempDao cfgConfigItemTempDao, IDGenerator generator, CompanyApiClient companyApiClient, GroupApiClient groupApiClient, CfgTemplateObjDao cfgTemplateObjDao, CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao, ConfigItemExtDao configItemExtDao, CfgConfigExtDao cfgConfigExtDao, ConfigMetaDataService configMetaDataService, ConfigMatchParserImpl configMatchParserImpl, CfgConfigBillAttributeExtDao cfgConfigBillAttributeExtDao, CfgConfigMailRuleDao cfgConfigMailRuleDao, ConfigMailRuleService configMailRuleService, CfgConfigJobDao cfgConfigJobDao) {
        this.cfgConfigDao = cfgConfigDao;
        this.cfgConfigItemDao = cfgConfigItemDao;
        this.cfgConfigTempDao = cfgConfigTempDao;
        this.cfgConfigItemTempDao = cfgConfigItemTempDao;
        this.generator = generator;
        this.companyApiClient = companyApiClient;
        this.groupApiClient = groupApiClient;
        this.cfgTemplateObjDao = cfgTemplateObjDao;
        this.cfgTemplateObjMetadataDao = cfgTemplateObjMetadataDao;
        this.configItemExtDao = configItemExtDao;
        this.cfgConfigExtDao = cfgConfigExtDao;
        this.configMetaDataService = configMetaDataService;
        this.configMatchParserImpl = configMatchParserImpl;
        this.cfgConfigJobDao = cfgConfigJobDao;
        this.cfgConfigBillAttributeExtDao = cfgConfigBillAttributeExtDao;
        this.cfgConfigMailRuleDao = cfgConfigMailRuleDao;
        this.configMailRuleService = configMailRuleService;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteCfgConfig(MsConfigDeleteRequstWithUserInfo msConfigDeleteRequest, Long userId) {
        List configIdList = msConfigDeleteRequest.getConfigIdList();
        if (CollectionUtils.isEmpty((Collection)configIdList)) {
            return 1;
        }
        configIdList = configIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (msConfigDeleteRequest.getConfigType() == ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType()) {
            List entities = this.getConfigs(configIdList);
            List preCancelMailCfgs = this.getPreCancelMailCfgs(configIdList);
            this.configMailRuleService.cancelMailService(preCancelMailCfgs, userId);
        }
        CfgConfigExtExample cfgConfigExtExample = new CfgConfigExtExample();
        cfgConfigExtExample.setConfigIdList(configIdList);
        cfgConfigExtExample.setPreStatus(StatusEnum.NORMAL.getStatus());
        cfgConfigExtExample.setAfterStatus(StatusEnum.DELETE.getStatus());
        cfgConfigExtExample.setCreateUser(userId);
        cfgConfigExtExample.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        int affected = this.cfgConfigExtDao.deleteCfgConfigEntityByIds(cfgConfigExtExample);
        if (affected != configIdList.size()) {
            throw new RuntimeException("\u5220\u9664\u89c4\u5219\u5931\u8d25.");
        }
        return 1;
    }

    private List<CfgConfigMailRuleEntity> getPreCancelMailCfgs(List<Long> configIdList) {
        CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
        example.createCriteria().andConfigIdIn(configIdList).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        return this.cfgConfigMailRuleDao.selectByExample(example);
    }

    private List<CfgConfigEntity> getConfigs(List<Long> configIdList) {
        CfgConfigExample example = new CfgConfigExample();
        example.createCriteria().andConfigIdIn(configIdList).andStatusEqualTo(Byte.valueOf(ConstantValue.STATUS_ACTIVE.byteValue()));
        return this.cfgConfigDao.selectByExample(example);
    }

    @Transactional(rollbackFor={Exception.class})
    public Response addCfgConfig(MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo) {
        boolean ruleExists;
        logger.info("addCfgConfigAndItem msConfigAddRequestWithUserInfo===>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
        Response response = Response.failed((String)"");
        List msConfigBeanList = msConfigAddRequestWithUserInfo.getItemDTOList();
        if (CollectionUtils.isEmpty((Collection)msConfigBeanList)) {
            response.setMessage("\u89c4\u5219\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a.");
            return response;
        }
        MsConfigBean msConfigBean = (MsConfigBean)msConfigBeanList.get(0);
        if (ConfigTypeEnum.VIRTUAL_INVOICE_AUTO_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
            msConfigBean.setBusinessBillType(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
        }
        String businessBillType = msConfigBean.getBusinessBillType();
        if (!BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(businessBillType) && !BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(businessBillType)) {
            response.setMessage(ConfigErrorEnum.CONFIG_META_DATA_CHECK_ERROR.message());
            return response;
        }
        MsCommonUserInfo userInfo = msConfigAddRequestWithUserInfo.getUserInfo();
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
            msConfigBean.setSellerGroupId(userInfo.getGroupId());
        } else {
            msConfigBean.setPurchaserGroupId(userInfo.getGroupId());
        }
        this.fillCompanyInfo(msConfigBean, userInfo.getGroupId());
        logger.info("addCfgConfigAndItem msConfigBean2==========>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigBean));
        logger.info("msConfigBean.getConfigId()==========>{}", (Object)msConfigBean.getConfigId());
        if ((null == msConfigBean.getConfigId() || msConfigBean.getConfigId() == 0L) && (ruleExists = this.queryInvoiceConfigRuleExists(msConfigBean))) {
            response.setMessage("\u89c4\u5219\u5df2\u5b58\u5728.");
            return response;
        }
        this.checkBusinessConfig(msConfigBean);
        this.checkConfigItemRequired(msConfigBean);
        Long configId = this.addOrUpdateCfgConfig(msConfigBean, userInfo);
        List msConfigItemBeans = msConfigBean.getItemList();
        boolean isUpdateOperation = false;
        if (configId.equals(msConfigBean.getConfigId())) {
            isUpdateOperation = true;
        }
        int configType = msConfigBean.getConfigType();
        if (ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType() == configType) {
            ConfigBizConfigService proxy = (ConfigBizConfigService)AopContext.currentProxy();
            try {
                proxy.addOrUpdateMailRuleConfigAndRegisterTask(configId, msConfigBean, userInfo, isUpdateOperation);
            }
            catch (Exception e) {
                logger.error("@addCfgConfig.addMailRuleConfigAndRegisterTask error : ", (Throwable)e);
                response.setCode(Response.Fail);
                response.setMessage("\u4fdd\u5b58\u90ae\u4ef6\u89c4\u5219\u65f6\u51fa\u73b0\u5f02\u5e38.");
                return response;
            }
            response.setCode(Response.OK);
            response.setMessage("mail notice configuration saved.");
        }
        if (isUpdateOperation) {
            this.configItemExtDao.deleteConfigItemByConfigId(configId);
        }
        if (!CollectionUtils.isEmpty((Collection)msConfigItemBeans)) {
            MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest = new MsConfigItemAddRequestWithUserInfo();
            msConfigItemAddRequest.setItemDTOList(msConfigItemBeans);
            msConfigItemAddRequest.setConfigId(configId);
            msConfigItemAddRequest.setUserInfo(userInfo);
            this.addCfgConfigItem(msConfigItemAddRequest, msConfigBean);
        }
        try {
            response = this.handleVirtualInvoiceAutoConfig(msConfigBean, configId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Response.Fail.equals(response.getCode())) {
            throw new TipsException(response.getMessage());
        }
        response.setCode(Response.OK);
        response.setMessage("\u6dfb\u52a0\u6210\u529f.");
        List attributes = msConfigBean.getAttributes();
        if (!CollectionUtils.isEmpty((Collection)attributes)) {
            if (isUpdateOperation) {
                this.updateConfigBizBillAttributes(configId, msConfigBean);
            } else {
                this.addConfigBizBillAttributes(configId, msConfigBean);
            }
        }
        response.setCode(Response.OK);
        response.setMessage("\u6dfb\u52a0\u6210\u529f.");
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long addOrUpdateMailRuleConfigAndRegisterTask(Long configId, MsConfigBean msConfigBean, MsCommonUserInfo userInfo, boolean isUpdateOp) throws Exception {
        MsConfigMailRule mailRule = msConfigBean.getMailRule();
        CfgConfigMailRuleEntity entity = new CfgConfigMailRuleEntity();
        BeanMapper.copy((Object)mailRule, (Object)entity);
        entity.setCreateUser(userInfo.getUserId());
        entity.setCreateTime(new Date());
        entity.setConfigId(configId);
        entity.setPickUcAddress(Boolean.valueOf(mailRule.isPickUCAddress()));
        if (isUpdateOp) {
            CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
            example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
            List list = this.cfgConfigMailRuleDao.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new RuntimeException("\u66f4\u65b0\u65f6\u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u89c4\u5219.");
            }
            this.configMailRuleService.cancelMailService(list, userInfo.getUserId());
            CfgConfigMailRuleExample newCfgExample = new CfgConfigMailRuleExample();
            example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
            this.cfgConfigMailRuleDao.updateByExampleSelective(entity, newCfgExample);
            this.configMailRuleService.registerMailService(entity, userInfo.getUserId());
        } else {
            this.cfgConfigMailRuleDao.insertSelective(entity);
            this.configMailRuleService.registerMailService(entity, userInfo.getUserId());
            logger.info("@addMailRuleConfigAndRegisterTask \u4fdd\u5b58\u90ae\u4ef6\u63a8\u9001\u89c4\u5219 , entity", (Object)StringUtil.describeBean((Object)entity));
        }
        return entity.getId();
    }

    public void addConfigBizBillAttributes(Long configId, MsConfigBean msConfigBean) {
        ArrayList list = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)msConfigBean.getAttributes())) {
            String bizBillType = msConfigBean.getBusinessBillType();
            String salesBillType = msConfigBean.getSalesbillType();
            Long groupId = null;
            groupId = BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(bizBillType) ? msConfigBean.getSellerGroupId() : msConfigBean.getPurchaserGroupId();
            Long finalGroupId = groupId;
            msConfigBean.getAttributes().stream().forEach(attr -> {
                CfgConfigBillAttributeEntity entity = new CfgConfigBillAttributeEntity();
                entity.setConfigId(configId);
                entity.setGroupId(finalGroupId);
                entity.setBusinessBillType(bizBillType);
                entity.setSalesbillType(salesBillType);
                entity.setAttrName(attr.getAttrName());
                entity.setValue(attr.getValue());
                entity.setFieldName(attr.getFieldName());
                entity.setAttrDesc(StringUtil.fillEmpty((String)attr.getAttrDesc()));
                entity.setStatus(ConstantValue.STATUS_ACTIVE);
                entity.setCreateTime(new Date());
                list.add(entity);
            });
            this.cfgConfigBillAttributeExtDao.insertBatch(list);
            if (logger.isInfoEnabled()) {
                logger.info("@addConfigBizBillAttributes new config bill attributes added." + StringUtil.describeBean(list));
            }
        }
    }

    public void updateConfigBizBillAttributes(Long configId, MsConfigBean msConfigBean) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        CfgConfigBillAttributeEntity updateRecord = new CfgConfigBillAttributeEntity();
        updateRecord.setStatus(ConstantValue.STATUS_DEL);
        this.cfgConfigBillAttributeExtDao.updateByExampleSelective(updateRecord, example);
        this.addConfigBizBillAttributes(configId, msConfigBean);
    }

    private Response handleVirtualInvoiceAutoConfig(MsConfigBean msConfigBean, Long configId) throws IOException {
        if (!ConfigTypeEnum.VIRTUAL_INVOICE_AUTO_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
            return Response.ok((String)"\u975e\u865a\u62df\u53d1\u7968\u65e0\u9700\u4fdd\u5b58xxl-job\u8ba1\u5212");
        }
        Response saveResponse = null;
        List msConfigItemBeans = msConfigBean.getItemList();
        HashMap itemMap = Maps.newHashMap();
        msConfigItemBeans.forEach(a -> itemMap.put(a.getConfigItemName(), a.getConfigItemValue()));
        String billJobGroups = XxlJobUtil.getJobGroups((String)this.adminAddresses, (String)"bill-service", null);
        if (Strings.isEmpty((CharSequence)billJobGroups)) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230bill\u6267\u884c\u5668");
        }
        String invoiceJobGroups = XxlJobUtil.getJobGroups((String)this.adminAddresses, (String)"invoice-service", null);
        if (Strings.isEmpty((CharSequence)invoiceJobGroups)) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230invoice-service\u6267\u884c\u5668");
        }
        JobGroupPageListResult jobGroupPageListResult = (JobGroupPageListResult)JsonUtils.writeFastJsonToObject((String)billJobGroups, JobGroupPageListResult.class);
        if (CollectionUtils.isEmpty((Collection)jobGroupPageListResult.getData())) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230bill\u6267\u884c\u5668");
        }
        JobGroupPageListResult invoiceJobGroupPageListResult = (JobGroupPageListResult)JsonUtils.writeFastJsonToObject((String)invoiceJobGroups, JobGroupPageListResult.class);
        if (CollectionUtils.isEmpty((Collection)invoiceJobGroupPageListResult.getData())) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230invoice-service\u6267\u884c\u5668");
        }
        int billExecutorId = ((XxlJobGroup)jobGroupPageListResult.getData().get(0)).getId();
        int invoiceServiceExecutorId = ((XxlJobGroup)invoiceJobGroupPageListResult.getData().get(0)).getId();
        if (this.isChecked((List)itemMap.get("dailyAutoMakeoutFlag"))) {
            saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.DAILY_SCHEDULER.getType()), null, (List)itemMap.get("dailyAutoMakeoutTime"), msConfigBean, AUTO_MAKEOUT_JOB, configId, billExecutorId);
        } else if (this.isChecked((List)itemMap.get("monthlyAutoMakeoutFlag"))) {
            saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.MONTHLY_SCHEDULER.getType()), (List)itemMap.get("monthlyAutoMakeoutDate"), (List)itemMap.get("monthlyAutoMakeoutTime"), msConfigBean, AUTO_MAKEOUT_JOB, configId, billExecutorId);
        } else if (this.isChecked((List)itemMap.get("lastDayOfMonthAutoMakeoutFlag"))) {
            saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.LAST_DAY_OF_MONTH.getType()), null, (List)itemMap.get("lastDayOfMonthAutoMakeoutTime"), msConfigBean, AUTO_MAKEOUT_JOB, configId, billExecutorId);
        }
        if (Response.Fail.equals(saveResponse.getCode())) {
            return saveResponse;
        }
        this.maintainConfigJob(msConfigBean, configId, saveResponse, 1, AUTO_MAKEOUT_SUFFIX);
        if (this.isChecked((List)itemMap.get("isRedFlush"))) {
            if (this.isChecked((List)itemMap.get("dailyRedFlushoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.DAILY_SCHEDULER.getType()), null, (List)itemMap.get("dailyRedFlushoutTime"), msConfigBean, AUTO_REDFLUSH_JOB, configId, invoiceServiceExecutorId);
            } else if (this.isChecked((List)itemMap.get("monthlyRedFlushoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.MONTHLY_SCHEDULER.getType()), (List)itemMap.get("monthlyRedFlushoutDate"), (List)itemMap.get("monthlyRedFlushoutTime"), msConfigBean, AUTO_REDFLUSH_JOB, configId, invoiceServiceExecutorId);
            } else if (this.isChecked((List)itemMap.get("lastDayOfMonthRedFlushoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.LAST_DAY_OF_MONTH.getType()), null, (List)itemMap.get("lastDayOfMonthRedFlushoutTime"), msConfigBean, AUTO_REDFLUSH_JOB, configId, invoiceServiceExecutorId);
            }
            this.maintainConfigJob(msConfigBean, configId, saveResponse, 2, RED_FLUSH_SUFFIX);
        }
        return saveResponse;
    }

    private void maintainConfigJob(MsConfigBean msConfigBean, Long configId, Response saveResponse, int i, String s) {
        if (Response.OK.equals(saveResponse.getCode())) {
            Integer autoMakeId = Integer.parseInt(String.valueOf(saveResponse.getResult()));
            CfgConfigJobExample cfgConfigJobExample = new CfgConfigJobExample();
            CfgConfigJobExample.Criteria criteria = cfgConfigJobExample.createCriteria();
            criteria.andConfigIdEqualTo(configId);
            criteria.andJobTypeEqualTo(Integer.valueOf(i));
            criteria.andJobStatusEqualTo(StatusEnum.NORMAL.getStatus());
            CfgConfigJobEntity cfgConfigJobEntity = this.cfgConfigJobDao.selectOneByExample(cfgConfigJobExample);
            if (!Objects.nonNull(cfgConfigJobEntity)) {
                this.cfgConfigJobDao.insert(new CfgConfigJobEntity(autoMakeId, configId, Integer.valueOf(i), msConfigBean.getConfigName() + s, StatusEnum.NORMAL.getStatus()));
            }
        }
    }

    private String getCronExpr(Integer type, List<String> date, List<String> time) throws TipsException {
        StringBuilder cronExpr = new StringBuilder();
        cronExpr.append("0 ");
        String setTime = time.get(0);
        String[] hourAndMinute = setTime.split(":");
        cronExpr.append(hourAndMinute[1]).append(" ").append(hourAndMinute[0]).append(" ");
        switch (type) {
            case 1: {
                cronExpr.append("* * ?");
                break;
            }
            case 2: {
                if (CollectionUtils.isEmpty(date)) {
                    logger.error("virtual invoice, cannot create monthly xxljob if Date is empty");
                    throw new TipsException("xxl-job\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u6bcf\u6708\u5b9a\u65f6\u6267\u884c\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String setDay = date.get(0);
                String[] yearMonthDay = setDay.split("-");
                if (yearMonthDay.length < 3) {
                    throw new TipsException("xxl-job\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u6bcf\u6708\u5b9a\u65f6\u6267\u884c\uff0c\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
                }
                cronExpr.append(yearMonthDay[2]).append(" ").append("* ?");
                break;
            }
            case 3: {
                cronExpr.append("L * ?");
                break;
            }
        }
        logger.info("cronExpr:{}", (Object)cronExpr);
        return cronExpr.toString();
    }

    private Response generateAutoInvoiceXxlScheduler(Integer type, List<String> date, List<String> time, MsConfigBean msConfigBean, String javaBeanHandler, Long savedConfigId, int executorId) throws IOException {
        if (CollectionUtils.isEmpty(time)) {
            logger.error("virtual invoice, cannot create xxljob if time is empty");
            return Response.failed((String)"xxl-job\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cronExpr = this.getCronExpr(type, date, time);
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JSONObject requestInfo = this.getAutoJsonInfo(msConfigBean.getConfigName(), cronExpr, executorId, javaBeanHandler, savedConfigId);
        Long configId = msConfigBean.getConfigId();
        String jobId = "0";
        JSONObject saveResponse = null;
        if (Objects.nonNull(configId)) {
            CfgConfigJobExample cfgConfigJobExample = new CfgConfigJobExample();
            CfgConfigJobExample.Criteria criteria = cfgConfigJobExample.createCriteria();
            criteria.andConfigIdEqualTo(configId);
            if (AUTO_MAKEOUT_JOB.equals(javaBeanHandler)) {
                criteria.andJobTypeEqualTo(Integer.valueOf(1));
            } else if (AUTO_REDFLUSH_JOB.equals(javaBeanHandler)) {
                criteria.andJobTypeEqualTo(Integer.valueOf(2));
            }
            criteria.andJobStatusEqualTo(StatusEnum.NORMAL.getStatus());
            CfgConfigJobEntity cfgConfigJobEntity = this.cfgConfigJobDao.selectOneByExample(cfgConfigJobExample);
            requestInfo.put("id", (Object)String.valueOf(cfgConfigJobEntity.getJobId()));
            jobId = String.valueOf(cfgConfigJobEntity.getJobId());
            saveResponse = XxlJobUtil.updateJob((String)this.adminAddresses, (JSONObject)requestInfo);
        } else {
            saveResponse = XxlJobUtil.addJob((String)this.adminAddresses, (JSONObject)requestInfo);
        }
        if (null == saveResponse) {
            return Response.failed((String)"\u8c03\u7528xxl-job api\u63a5\u53e3\u5931\u8d25\uff01");
        }
        if (saveResponse.containsKey((Object)"code") && 200 == saveResponse.getInteger("code")) {
            logger.info("\u6dfb\u52a0/\u66f4\u65b0\u6210\u529f\uff0crequestInfo\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)requestInfo));
            if ("0".equals(jobId) && !Strings.isNullOrEmpty((String)saveResponse.getString("content"))) {
                jobId = saveResponse.getString("content");
            }
        } else {
            return Response.failed((String)"\u6dfb\u52a0/\u66f4\u65b0\u5931\u8d25\uff0c\u8c03\u7528xxl-job api\u63a5\u53e3\u5931\u8d25\uff01");
        }
        JSONObject startResponse = XxlJobUtil.startJob((String)this.adminAddresses, (int)Integer.parseInt(jobId));
        if (startResponse.containsKey((Object)"code") && 200 == startResponse.getInteger("code")) {
            logger.info("\u542f\u52a8\u6210\u529f\uff0crequestInfo\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)startResponse));
            return Response.ok((String)"\u4fdd\u5b58\u5e76\u542f\u52a8\u6210\u529f", (Object)jobId);
        }
        return Response.failed((String)"\u542f\u52a8\u5931\u8d25\uff0c\u8c03\u7528api\u63a5\u53e3\u5931\u8d25\uff01");
    }

    private JSONObject getAutoJsonInfo(String configName, String cronExpr, int executorId, String javaBeanHandler, Long savedConfigId) {
        JSONObject requestInfo = new JSONObject();
        requestInfo.put("jobGroup", (Object)executorId);
        configName = AUTO_MAKEOUT_JOB.equals(javaBeanHandler) ? configName + AUTO_MAKEOUT_SUFFIX : configName + RED_FLUSH_SUFFIX;
        requestInfo.put("jobDesc", (Object)configName);
        requestInfo.put("executorRouteStrategy", (Object)"FIRST");
        requestInfo.put("jobCron", (Object)cronExpr);
        requestInfo.put("glueType", (Object)"BEAN");
        requestInfo.put("executorHandler", (Object)javaBeanHandler);
        requestInfo.put("executorBlockStrategy", (Object)"SERIAL_EXECUTION");
        requestInfo.put("executorTimeout", (Object)0);
        requestInfo.put("executorFailRetryCount", (Object)1);
        requestInfo.put("author", (Object)"Admin");
        requestInfo.put("executorParam", (Object)String.valueOf(savedConfigId));
        return requestInfo;
    }

    private boolean isChecked(List<String> toCheckEntry) {
        boolean isCheck = false;
        if (!CollectionUtils.isEmpty(toCheckEntry)) {
            String s;
            switch (s = toCheckEntry.get(0)) {
                case "true": 
                case "True": {
                    isCheck = true;
                    break;
                }
                case "false": 
                case "False": {
                    isCheck = false;
                    break;
                }
            }
        }
        return isCheck;
    }

    private Long addOrUpdateCfgConfig(MsConfigBean msConfigBean, MsCommonUserInfo userInfo) {
        Long configId = msConfigBean.getConfigId();
        CfgConfigEntity entity = ConfigEntityTranslater.convertFromMsConfigBean((MsConfigBean)msConfigBean);
        entity.setUpdateTime(new Date());
        if (configId == null || configId == 0L) {
            int result;
            this.checkConfigName(msConfigBean, userInfo.getGroupId());
            configId = this.generator.nextId();
            entity.setConfigId(configId);
            entity.setStatus(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            entity.setCreateTime(entity.getUpdateTime());
            entity.setCreateUser(userInfo.getUserId());
            try {
                result = this.cfgConfigDao.insertSelective(entity);
            }
            catch (DuplicateKeyException exception) {
                throw new ConfigExsitException();
            }
            if (result < 1) {
                throw new ConfigCreateException();
            }
            return configId;
        }
        try {
            this.cfgConfigDao.updateByPrimaryKeySelective(entity);
        }
        catch (DuplicateKeyException exception) {
            throw new ConfigExsitException();
        }
        return entity.getConfigId();
    }

    @Transactional(rollbackFor={Exception.class})
    public int addCfgConfigItem(MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest, MsConfigBean temp) {
        List msConfigItemBeans = msConfigItemAddRequest.getItemDTOList();
        if (ConfigTypeEnum.BILL_MERGE_TYPE.getConfigType().intValue() == temp.getConfigType().intValue()) {
            CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
            cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo(ConfigTypeEnum.BILL_MERGE_TYPE.getObjCode());
            CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
            if (cfgTemplateObjEntity != null) {
                CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
                ArrayList<String> fieldNames = new ArrayList<String>(2);
                fieldNames.add("defaultAssociationCondition");
                fieldNames.add("defaultMergerCondition");
                cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId()).andFieldNameIn(fieldNames);
                List list = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
                list.forEach(m -> {
                    MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
                    msConfigItemBean.setConfigItemName(m.getFieldName());
                    msConfigItemBean.setConfigItemDisplayName(m.getFieldDisplayName());
                    String fieldEnumValue = m.getFieldEnumValue();
                    ArrayList defaultValues = new ArrayList();
                    List msEnumBeans = JsonUtils.writeJsonToListObject((String)fieldEnumValue, MsEnumBean.class);
                    msEnumBeans.forEach(item -> defaultValues.add(item.getValue()));
                    msConfigItemBean.setConfigItemValue(defaultValues);
                    msConfigItemBeans.add(msConfigItemBean);
                });
            }
        }
        Long configId = msConfigItemAddRequest.getConfigId();
        MsCommonUserInfo userInfo = msConfigItemAddRequest.getUserInfo();
        for (MsConfigItemBean configItemBean : msConfigItemBeans) {
            int result;
            String value;
            List list;
            Long id = configItemBean.getConfigItemId();
            if (configId == null || configId == 0L) {
                return 0;
            }
            if ("invoiceLimit".equals(configItemBean.getConfigItemName()) && temp != null && !CollectionUtils.isEmpty((Collection)(list = configItemBean.getConfigItemValue())) && !CommonTools.isEmpty((String)(value = (String)list.get(0)))) {
                this.checkLimitAmt(temp, value);
            }
            CfgConfigItemEntity cfgConfigItemEntity = ConfigItemEntityTranslator.convertFromMsConfigItemBean((MsConfigItemBean)configItemBean);
            cfgConfigItemEntity.setUpdateUser(userInfo.getUserId());
            cfgConfigItemEntity.setUpdateTime(new Date());
            if (id == null || id == 0L) {
                id = this.generator.nextId();
                cfgConfigItemEntity.setConfigItemId(id);
                cfgConfigItemEntity.setConfigId(configId);
                cfgConfigItemEntity.setCreateTime(cfgConfigItemEntity.getUpdateTime());
                cfgConfigItemEntity.setCreateUser(cfgConfigItemEntity.getUpdateUser());
                result = this.cfgConfigItemDao.insertSelective(cfgConfigItemEntity);
            } else {
                result = this.cfgConfigItemDao.updateByPrimaryKeySelective(cfgConfigItemEntity);
            }
            if (result >= 1) continue;
            throw new ConfigCreateException();
        }
        return 1;
    }

    public MsConfigPageDTO queryEffectiveConfig(MsConfigQueryRequest msConfigQueryRequest) {
        return null;
    }

    public Response getOptimalMatchConfig(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        logger.info("getOptimalMatchConfig---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItemList2ConfigBean(defaultMsConfigBean);
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(item -> ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)item)).collect(Collectors.toList());
        MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
        logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBean));
        if (null == bestMsConfigBean) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---match--failed--defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItemList2ConfigBean(defaultMsConfigBean);
        }
        return this.fillConfigItemList2ConfigBean(bestMsConfigBean);
    }

    public Response getOriginalCfgs(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItemList2ConfigBean(defaultMsConfigBean);
        }
        Response response = new Response();
        response.setCode(Response.OK);
        ArrayList<MsConfigBean> configs = new ArrayList<MsConfigBean>();
        for (CfgConfigEntity entity : settingCfgConfigEntityList) {
            MsConfigBean config = this.getConfigBean(entity, msConfigQueryRequest);
            configs.add(config);
        }
        if (!CollectionUtils.isEmpty(configs)) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean config = this.getConfigBean(defaultCfgConfigEntity, msConfigQueryRequest);
            response.setResult((Object)config);
        }
        return response;
    }

    private MsConfigBean getConfigBean(CfgConfigEntity entity, MsConfigQueryRequest msConfigQueryRequest) {
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        msConfigBean.setItemList(this.queryConfigItems(msConfigBean));
        List attributes = this.queryAttributeList(entity.getConfigId());
        if (!CollectionUtils.isEmpty((Collection)attributes)) {
            msConfigBean.setHasAttrClassCfg(true);
            msConfigBean.setAttributes(attributes);
        }
        return msConfigBean;
    }

    private List<MsConfigBizBillAttribute> queryAttributeList(Long configId) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        List attrs = this.cfgConfigBillAttributeExtDao.selectByExample(example);
        return BeanMapper.mapList((Collection)attrs, MsConfigBizBillAttribute.class);
    }

    public Response getOptimalMatchConfigWithAttr(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        logger.info("getOptimalMatchConfig---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItems(defaultMsConfigBean);
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(item -> this.getMsConfigBean(item)).collect(Collectors.toList());
        MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
        logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBean));
        if (null == bestMsConfigBean) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---match--failed--defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItems(defaultMsConfigBean);
        }
        return this.fillConfigItems(bestMsConfigBean);
    }

    public MsConfigBean getMsConfigBean(CfgConfigEntity entity) {
        ArrayList attributes = new ArrayList();
        List attrs = this.selectCfgBillAttribute(entity);
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)entity);
        if (!CollectionUtils.isEmpty((Collection)attrs)) {
            msConfigBean.setHasAttrClassCfg(true);
            attrs.stream().forEach(attr -> {
                MsConfigBizBillAttribute attribute = new MsConfigBizBillAttribute();
                attribute.setFieldName(attr.getFieldName());
                attribute.setAttrName(attr.getAttrName());
                attribute.setAttrDesc(attr.getAttrDesc());
                attribute.setValue(attr.getValue());
                attributes.add(attribute);
            });
        }
        msConfigBean.setAttributes(attributes);
        return msConfigBean;
    }

    private List<CfgConfigEntity> filtCfgByBillBizAttribute(List<CfgConfigEntity> settingCfgConfigEntityList, MsConfigQueryRequest msConfigQueryRequest) throws Exception {
        if (CollectionUtils.isEmpty(settingCfgConfigEntityList)) {
            return null;
        }
        ArrayList<CfgConfigEntity> filtedList = new ArrayList<CfgConfigEntity>();
        for (CfgConfigEntity config : settingCfgConfigEntityList) {
            List attrs = this.selectCfgBillAttribute(config);
            if (!CollectionUtils.isEmpty((Collection)attrs)) {
                boolean match = true;
                Map bean = ReflectUtil.bean2map((Object)msConfigQueryRequest);
                for (CfgConfigBillAttributeEntity attr : attrs) {
                    String value = (String)bean.get(attr.getFieldName());
                    if (value != null && value == attr.getValue()) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                filtedList.add(config);
                continue;
            }
            filtedList.add(config);
        }
        return filtedList;
    }

    private List<CfgConfigBillAttributeEntity> selectCfgBillAttribute(CfgConfigEntity config) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        CfgConfigBillAttributeExample.Criteria criteria = example.createCriteria();
        criteria.andConfigIdEqualTo(config.getConfigId()).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        if (StringUtils.isNotEmpty((CharSequence)config.getBusinessBillType())) {
            criteria.andBusinessBillTypeEqualTo(config.getBusinessBillType());
        }
        if (StringUtils.isNotEmpty((CharSequence)config.getSalesbillType())) {
            criteria.andSalesbillTypeEqualTo(config.getSalesbillType());
        }
        return this.cfgConfigBillAttributeExtDao.selectByExample(example);
    }

    private List<MsConfigItemBean> queryConfigItems(MsConfigBean msConfigBean) {
        MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
        request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
        return this.queryConfigItemList(request);
    }

    private Response fillConfigItems(MsConfigBean msConfigBean) {
        Response response = new Response();
        if (null != msConfigBean) {
            MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
            request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
            List configItemList = this.queryConfigItemList(request);
            if (logger.isInfoEnabled()) {
                logger.info("getOptimalMatchConfig--itemList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
            }
            msConfigBean.setItemList(configItemList);
            response.setCode(Response.OK);
            response.setResult((Object)msConfigBean);
        } else {
            response.setCode(Response.Fail);
        }
        return response;
    }

    private Response fillConfigItemList2ConfigBean(MsConfigBean msConfigBean) {
        Response response = new Response();
        if (null != msConfigBean) {
            MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
            request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
            List configItemList = this.queryConfigItemList(request);
            if (logger.isInfoEnabled()) {
                logger.info("getOptimalMatchConfig--itemList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
            }
            response.setCode(Response.OK);
            response.setResult((Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
        } else {
            response.setCode(Response.Fail);
        }
        return response;
    }

    private List<CfgConfigEntity> querySettingConfigList(MsConfigQueryRequest msConfigQueryRequest) {
        List cfgConfigEntityList;
        logger.debug("querySettingConfigList----msConfigQueryRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[ConfigTypeEnum.of((Integer)msConfigQueryRequest.getConfigType()).ordinal()]) {
            case 1: 
            case 2: {
                cfgConfigEntityList = this.querySettingSplitConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 3: {
                cfgConfigEntityList = this.querySettingGroupMergeConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 4: {
                cfgConfigEntityList = this.querySettingGroupMergeConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 5: 
            case 6: {
                cfgConfigEntityList = this.querySettingInvoiceConfig(msConfigQueryRequest);
                break;
            }
            case 7: {
                cfgConfigEntityList = this.querySettingSysConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            default: {
                cfgConfigEntityList = this.querySettingConfig(msConfigQueryRequest);
            }
        }
        return cfgConfigEntityList;
    }

    private CfgConfigEntity queryDefaultConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigEntity cfgConfigEntity;
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[ConfigTypeEnum.of((Integer)msConfigQueryRequest.getConfigType()).ordinal()]) {
            case 1: {
                cfgConfigEntity = this.queryDefaultSplitConfig((String)msConfigQueryRequest.getInvoiceType().get(0));
                break;
            }
            case 2: {
                cfgConfigEntity = this.queryDefaultInvoiceMatchBillConfig((String)msConfigQueryRequest.getInvoiceType().get(0));
                break;
            }
            case 5: 
            case 6: {
                cfgConfigEntity = this.queryDefaultInvoiceConfig(msConfigQueryRequest.getBusinessBillType());
                break;
            }
            default: {
                cfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest.getConfigType());
            }
        }
        return cfgConfigEntity;
    }

    private CfgConfigEntity queryDefaultConfig(Integer configType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(configType.byteValue()));
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultSplitConfig(String invoiceType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andInvoiceTypeEqualTo(invoiceType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultInvoiceMatchBillConfig(String invoiceType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.BILL_INVOICE_MATCH_TYPE.getConfigType().byteValue()));
        criteria.andInvoiceTypeEqualTo(invoiceType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultInvoiceConfig(String businessBillType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andBusinessBillTypeEqualTo(businessBillType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingSplitConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u5339\u914d\u89c4\u5219>>>");
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            CfgConfigExample.Criteria criteriaAR = cfgConfigExample.createCriteria();
            criteriaAR.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
            criteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            criteriaAR.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            criteriaAR.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
            criteriaAR.andInvoiceTypeEqualTo((String)msConfigQueryRequest.getInvoiceType().get(0));
        }
        CfgConfigExample.Criteria criteriaAP = cfgConfigExample.createCriteria();
        if (msConfigQueryRequest.getPurchaserGroupId() != null) {
            criteriaAP.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
            criteriaAP.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            criteriaAP.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            criteriaAP.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
            criteriaAP.andInvoiceTypeEqualTo((String)msConfigQueryRequest.getInvoiceType().get(0));
            if (msConfigQueryRequest.getSellerGroupId() != null) {
                cfgConfigExample.or(criteriaAP);
            }
        }
        return this.cfgConfigDao.selectByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingGroupMergeConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample groupMergeExample = new CfgConfigExample();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            CfgConfigExample.Criteria groupCriteriaAR = groupMergeExample.createCriteria();
            groupCriteriaAR.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
            groupCriteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            groupCriteriaAR.andStatusEqualTo(Byte.valueOf(msConfigQueryRequest.getStatus().byteValue()));
        }
        if (msConfigQueryRequest.getPurchaserGroupId() != null) {
            CfgConfigExample.Criteria groupCriteriaAP = groupMergeExample.createCriteria();
            groupCriteriaAP.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
            groupCriteriaAP.andStatusEqualTo(Byte.valueOf(msConfigQueryRequest.getStatus().byteValue()));
            groupCriteriaAP.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            if (msConfigQueryRequest.getSellerGroupId() != null) {
                groupMergeExample.or(groupCriteriaAP);
            }
        }
        return this.cfgConfigDao.selectByExample(groupMergeExample);
    }

    private List<CfgConfigEntity> querySettingSysConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample configExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = configExample.createCriteria();
        if (msConfigQueryRequest.getBusinessBillType() != null) {
            if (BusinessBillType.AR.value().equals(msConfigQueryRequest.getBusinessBillType())) {
                criteria.andSellerGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
            } else {
                criteria.andPurchaserGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getPurchaserGroupId() == null ? 0L : msConfigQueryRequest.getPurchaserGroupId()));
            }
            criteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        } else {
            criteria.andSellerGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
            criteria.andPurchaserGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getPurchaserGroupId() == null ? 0L : msConfigQueryRequest.getPurchaserGroupId()));
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        criteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        return this.cfgConfigDao.selectByExample(configExample);
    }

    private List<CfgConfigEntity> querySettingInvoiceConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria invoiceCriteria = cfgConfigExample.createCriteria();
        invoiceCriteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId() != null ? msConfigQueryRequest.getSellerGroupId() : Long.valueOf(0L));
        invoiceCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        invoiceCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        invoiceCriteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        return this.cfgConfigDao.selectByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample settingConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria settingCriteria = settingConfigExample.createCriteria();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            settingCriteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
        }
        if (msConfigQueryRequest.getPurchaserGroupId() != null && BusinessBillType.AP.value().equals(msConfigQueryRequest.getBusinessBillType())) {
            settingCriteria.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
        }
        if (msConfigQueryRequest.getSellerGroupId() == null || msConfigQueryRequest.getPurchaserGroupId() == null) {
            return new ArrayList<CfgConfigEntity>();
        }
        settingCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        settingCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        settingCriteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        return this.cfgConfigDao.selectByExample(settingConfigExample);
    }

    public MsConfigPageDTO queryConfigList(MsConfigQueryRequest msConfigBean, Long groupId) {
        MsConfigPageDTO msConfigPageDTO = new MsConfigPageDTO();
        CfgConfigExample example = ExamapleTranslater.createConfigExampleByRequest((MsConfigQueryRequest)msConfigBean, (Long)groupId);
        example.setLimit(Integer.valueOf(msConfigBean.getPageSize() == null || msConfigBean.getPageSize() == 0 ? 10 : msConfigBean.getPageSize()));
        example.setOffset(this.getOffset(msConfigBean));
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(example);
        Long count = this.cfgConfigDao.countByExample(example);
        msConfigPageDTO.setPageNo(msConfigBean.getPageNo());
        msConfigPageDTO.setTotal(Integer.valueOf(count.intValue()));
        ArrayList<MsConfigBean> result = new ArrayList<MsConfigBean>();
        for (CfgConfigEntity tmp : cfgConfigEntities) {
            MsConfigBean msConfigBeanTmp = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)tmp);
            List attributes = this.getConfigBizBillAttributes(msConfigBeanTmp);
            msConfigBeanTmp.setAttributes(attributes);
            result.add(msConfigBeanTmp);
        }
        msConfigPageDTO.setItemDTOList(result);
        return msConfigPageDTO;
    }

    private List<MsConfigBizBillAttribute> getConfigBizBillAttributes(MsConfigBean msConfigBeanTmp) {
        ArrayList<MsConfigBizBillAttribute> attributes = new ArrayList<MsConfigBizBillAttribute>();
        Long configId = msConfigBeanTmp.getConfigId();
        String bizBillType = msConfigBeanTmp.getBusinessBillType();
        String salesBillType = msConfigBeanTmp.getSalesbillType();
        Long groupId = null;
        groupId = BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(bizBillType) ? msConfigBeanTmp.getSellerGroupId() : msConfigBeanTmp.getPurchaserGroupId();
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdEqualTo(configId).andSalesbillTypeEqualTo(salesBillType).andGroupIdEqualTo(groupId).andBusinessBillTypeEqualTo(bizBillType).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        List attributeEntities = this.cfgConfigBillAttributeExtDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)attributeEntities)) {
            return attributes;
        }
        attributeEntities.stream().forEach(attr -> {
            MsConfigBizBillAttribute attribute = new MsConfigBizBillAttribute();
            attribute.setFieldName(attr.getFieldName());
            attribute.setAttrName(attr.getAttrName());
            attribute.setAttrDesc(attr.getAttrDesc());
            attribute.setValue(attr.getValue());
            attributes.add(attribute);
        });
        return attributes;
    }

    public Integer queryConfigCount(MsConfigQueryRequest msConfigBean, Long groupId) {
        CfgConfigExample example = ExamapleTranslater.createConfigExampleByRequest((MsConfigQueryRequest)msConfigBean, (Long)groupId);
        Long count = this.cfgConfigDao.countByExample(example);
        return count.intValue();
    }

    public List<MsConfigItemBean> queryConfigItemList(MsConfigItemQueryRequest cfgConfigItemRequest) {
        ArrayList<MsConfigItemBean> result;
        block3: {
            block2: {
                logger.info("queryConfigItemList===========cfgConfigItemRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgConfigItemRequest));
                CfgConfigItemExample cfgConfigItemExample = new CfgConfigItemExample();
                cfgConfigItemExample.createCriteria().andConfigIdEqualTo(Long.valueOf(cfgConfigItemRequest.getConfigId()));
                List cfgConfigItemEntityList = this.cfgConfigItemDao.selectByExample(cfgConfigItemExample);
                result = new ArrayList<MsConfigItemBean>();
                if (CollectionUtils.isEmpty((Collection)cfgConfigItemEntityList)) break block2;
                for (CfgConfigItemEntity cfgConfigItemEntity : cfgConfigItemEntityList) {
                    MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemEntity((CfgConfigItemEntity)cfgConfigItemEntity);
                    result.add(msConfigItemBean);
                }
                break block3;
            }
            CfgConfigItemTempExample cfgConfigTempExample = new CfgConfigItemTempExample();
            cfgConfigTempExample.createCriteria().andConfigIdEqualTo(Long.valueOf(cfgConfigItemRequest.getConfigId()));
            List cfgConfigItemTempEntities = this.cfgConfigItemTempDao.selectByExample(cfgConfigTempExample);
            if (CollectionUtils.isEmpty((Collection)cfgConfigItemTempEntities)) break block3;
            for (CfgConfigItemTempEntity cfgConfigItemEntity : cfgConfigItemTempEntities) {
                MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemTempEntity((CfgConfigItemTempEntity)cfgConfigItemEntity);
                result.add(msConfigItemBean);
            }
        }
        return result;
    }

    public List<MsConfigItemBean> batchQueryConfigItemList(MsConfigItemBatchQueryRequest cfgConfigItemRequest) {
        logger.info("queryConfigItemList===========cfgConfigItemRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgConfigItemRequest));
        CfgConfigItemExample cfgConfigItemExample = new CfgConfigItemExample();
        ArrayList<MsConfigItemBean> result = new ArrayList<MsConfigItemBean>();
        List allIds = cfgConfigItemRequest.getConfigIds();
        if (CollectionUtils.isEmpty((Collection)allIds)) {
            return result;
        }
        cfgConfigItemExample.createCriteria().andConfigIdIn(allIds);
        List cfgConfigItemEntityList = this.cfgConfigItemDao.selectByExample(cfgConfigItemExample);
        ArrayList<Long> configIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)cfgConfigItemEntityList)) {
            for (Object cfgConfigItemEntity : cfgConfigItemEntityList) {
                MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemEntity((CfgConfigItemEntity)cfgConfigItemEntity);
                result.add(msConfigItemBean);
                configIds.add(cfgConfigItemEntity.getConfigId());
            }
        }
        List<Long> tempConfigIds = new ArrayList();
        if (configIds.size() > 0) {
            for (Long id : allIds) {
                if (configIds.contains(id)) continue;
                tempConfigIds.add(id);
            }
        } else {
            tempConfigIds = allIds;
        }
        if (!CollectionUtils.isEmpty(tempConfigIds)) {
            CfgConfigItemTempExample cfgConfigTempExample = new CfgConfigItemTempExample();
            cfgConfigTempExample.createCriteria().andConfigIdIn(tempConfigIds);
            List cfgConfigItemTempEntities = this.cfgConfigItemTempDao.selectByExample(cfgConfigTempExample);
            if (!CollectionUtils.isEmpty((Collection)cfgConfigItemTempEntities)) {
                for (CfgConfigItemTempEntity cfgConfigItemEntity : cfgConfigItemTempEntities) {
                    MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemTempEntity((CfgConfigItemTempEntity)cfgConfigItemEntity);
                    result.add(msConfigItemBean);
                }
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long queryTempConfigItemList(MsTmpConfigAddRequest msTmpConfigQueryRequest) {
        List list = msTmpConfigQueryRequest.getEntityList();
        logger.info("cfg_config_temp md5 lists====={}", (Object)JsonUtils.writeObjectToFastJson((Object)list));
        String md5 = this.getMD5TempConfigItem(list);
        logger.info("cfg_config_temp md5======{}", (Object)md5);
        CfgConfigTempExample example = new CfgConfigTempExample();
        example.createCriteria().andMd5EqualTo(md5);
        List configTempEntityList = this.cfgConfigTempDao.selectByExample(example);
        logger.info("cfgConfigTempDao selectByExample ======{}", (Object)JsonUtils.writeObjectToFastJson((Object)configTempEntityList));
        if (CollectionUtils.isEmpty((Collection)configTempEntityList)) {
            this.checkTmpInvoiceInfo(list, msTmpConfigQueryRequest.getInvoiceType(), msTmpConfigQueryRequest.getSellerTaxNo(), msTmpConfigQueryRequest.getConfigType());
            CfgConfigTempEntity cfgConfigTempEntity = new CfgConfigTempEntity();
            Long id = this.generator.nextId();
            cfgConfigTempEntity.setConfigId(id);
            cfgConfigTempEntity.setMd5(md5);
            cfgConfigTempEntity.setUserId(msTmpConfigQueryRequest.getUserId());
            cfgConfigTempEntity.setCreateTime(new Date());
            cfgConfigTempEntity.setConfigName(UUID.randomUUID().toString());
            cfgConfigTempEntity.setUpdateTime(cfgConfigTempEntity.getCreateTime());
            this.cfgConfigTempDao.insert(cfgConfigTempEntity);
            for (MsConfigItemTempBean bean : list) {
                CfgConfigItemTempEntity cfgConfigItemTempEntity = ExamapleTranslater.tempBeanConvert2ItemTempEntity((MsConfigItemTempBean)bean, (Long)id);
                cfgConfigItemTempEntity.setCreateUser(msTmpConfigQueryRequest.getUserId());
                cfgConfigItemTempEntity.setCreateTime(new Date());
                cfgConfigItemTempEntity.setUpdateTime(cfgConfigItemTempEntity.getCreateTime());
                cfgConfigItemTempEntity.setUpdateUser(msTmpConfigQueryRequest.getUserId());
                cfgConfigItemTempEntity.setConfigItemId(Long.valueOf(this.generator.nextId()));
                this.cfgConfigItemTempDao.insert(cfgConfigItemTempEntity);
            }
            return id;
        }
        return ((CfgConfigTempEntity)configTempEntityList.get(0)).getConfigId();
    }

    private String getMD5TempConfigItem(List<MsConfigItemTempBean> msConfigItemTempBeanList) {
        HashMap configItemTempBeanMap = Maps.newHashMap();
        msConfigItemTempBeanList.forEach(tempBean -> configItemTempBeanMap.put(tempBean.getConfigItemName(), tempBean));
        StringBuffer buffer = new StringBuffer();
        configItemTempBeanMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(orderedBean -> buffer.append((String)orderedBean.getKey()).append(((MsConfigItemTempBean)orderedBean.getValue()).getConfigItemValue()));
        return DigestUtils.md5Hex((String)buffer.toString());
    }

    private boolean queryInvoiceConfigRuleExists(MsConfigBean msConfigBean) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        if (msConfigBean.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType()) || msConfigBean.getConfigType().equals(ConfigTypeEnum.BILL_INVOICE_MATCH_TYPE.getConfigType())) {
            String invoiceType = msConfigBean.getInvoiceType();
            criteria.andInvoiceTypeEqualTo(invoiceType);
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        String salesbillType = StringUtils.isEmpty((CharSequence)msConfigBean.getSalesbillType()) ? "" : msConfigBean.getSalesbillType();
        criteria.andSalesbillTypeEqualTo(salesbillType);
        criteria.andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType());
        Long groupId = null;
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
            Long sellerGroupId = msConfigBean.getSellerGroupId();
            criteria.andSellerGroupIdEqualTo(sellerGroupId);
            String sellerTaxNo = msConfigBean.getSellerTaxNo();
            criteria.andSellerTaxNoEqualTo(sellerTaxNo == null ? "" : sellerTaxNo);
            Long purchaserGroupId = msConfigBean.getPurchaserGroupId();
            criteria.andPurchaserGroupIdEqualTo(Long.valueOf(purchaserGroupId == null ? 0L : purchaserGroupId));
            if (null != purchaserGroupId && purchaserGroupId > 0L) {
                String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
                criteria.andPurchaserTaxNoEqualTo(purchaserTaxNo == null ? "" : purchaserTaxNo);
            }
            groupId = sellerGroupId;
        } else {
            Long purchaserGroupId = msConfigBean.getPurchaserGroupId();
            criteria.andPurchaserGroupIdEqualTo(purchaserGroupId);
            String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
            criteria.andPurchaserTaxNoEqualTo(purchaserTaxNo == null ? "" : purchaserTaxNo);
            Long sellerGroupId = msConfigBean.getSellerGroupId();
            criteria.andSellerGroupIdEqualTo(Long.valueOf(sellerGroupId == null ? 0L : sellerGroupId));
            if (null != sellerGroupId && sellerGroupId > 0L) {
                String sellerTaxNo = msConfigBean.getSellerTaxNo();
                criteria.andSellerTaxNoEqualTo(sellerTaxNo == null ? "" : sellerTaxNo);
            }
            groupId = purchaserGroupId;
        }
        List cfgs = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (cfgs.size() == 0) {
            return false;
        }
        String bizBillType = msConfigBean.getBusinessBillType();
        String salesBillType = msConfigBean.getSalesbillType();
        List attributes = msConfigBean.getAttributes();
        if (CollectionUtils.isEmpty((Collection)attributes)) {
            return true;
        }
        for (MsConfigBizBillAttribute attribute : attributes) {
            String value;
            String attr;
            String field = attribute.getFieldName();
            List billAttributeEntities = this.selectCfgBillAttribute(groupId, bizBillType, salesBillType, field, attr = attribute.getAttrName(), value = attribute.getValue());
            if (!CollectionUtils.isEmpty((Collection)billAttributeEntities)) continue;
            return false;
        }
        return true;
    }

    private List<CfgConfigBillAttributeEntity> selectCfgBillAttribute(Long groupId, String bizBillType, String salesBillType, String field, String attr, String value) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andGroupIdEqualTo(groupId).andSalesbillTypeEqualTo(salesBillType).andFieldNameEqualTo(field).andAttrNameEqualTo(attr).andBusinessBillTypeEqualTo(bizBillType).andValueEqualTo(value).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        return this.cfgConfigBillAttributeExtDao.selectByExample(example);
    }

    private Integer getOffset(MsConfigQueryRequest msConfigBean) {
        Integer pageNo = msConfigBean.getPageNo();
        Integer pageSize = msConfigBean.getPageSize();
        if (pageNo == null || pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        return (pageNo - 1) * pageSize;
    }

    private MsConfigBean fillCompanyInfo(MsConfigBean msConfigBean, Long groupId) {
        GroupModel groupModel;
        String sellerTaxNo = msConfigBean.getSellerTaxNo();
        String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
        if (!StringUtils.isEmpty((CharSequence)sellerTaxNo)) {
            CompanyModel sellerCompany = this.companyInfoQuery(sellerTaxNo);
            msConfigBean.setSellerNo(String.valueOf(sellerCompany.getCompanyId()));
            msConfigBean.setSellerName(sellerCompany.getCompanyName());
            groupModel = this.groupInfoQueryById(sellerCompany.getCompanyId());
            if (BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                msConfigBean.setSellerGroupId(Long.valueOf(groupModel == null ? 0L : groupModel.getGroupId()));
            } else if (groupModel != null && groupModel.getGroupId().longValue() != groupId.longValue()) {
                logger.error("\u67e5\u8be2\u516c\u53f8,\u7a0e\u53f7:{}\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010{}\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u7684\u96c6\u56e2\u3010{}\u3011\u4e0d\u4e00\u81f4", new Object[]{sellerTaxNo, groupModel.getGroupId(), groupId});
                throw new ThridPartyInvokeException("\u521b\u5efa\u65b9\u662fAR\u65f6,\u7a0e\u53f7:" + sellerTaxNo + "\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010" + groupModel.getGroupId() + "\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u4eba\u7684\u96c6\u56e2\u3010" + groupId + "\u3011\u4e0d\u4e00\u81f4");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)purchaserTaxNo)) {
            CompanyModel purchaserCompany = this.companyInfoQuery(purchaserTaxNo);
            msConfigBean.setPurchaserNo(String.valueOf(purchaserCompany.getCompanyId()));
            msConfigBean.setPurchaserName(purchaserCompany.getCompanyName());
            groupModel = this.groupInfoQueryById(purchaserCompany.getCompanyId());
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                msConfigBean.setPurchaserGroupId(Long.valueOf(groupModel == null ? 0L : groupModel.getGroupId()));
            } else if (groupModel != null && groupModel.getGroupId().longValue() != groupId.longValue()) {
                logger.error("\u521b\u5efa\u65b9\u662fAP\u65f6,\u67e5\u8be2\u516c\u53f8,\u7a0e\u53f7:{}\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010{}\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u7684\u96c6\u56e2\u3010{}\u3011\u4e0d\u4e00\u81f4", new Object[]{sellerTaxNo, groupModel.getGroupId(), groupId});
                throw new ThridPartyInvokeException("\u521b\u5efa\u65b9\u662fAP\u65f6,\u7a0e\u53f7:" + sellerTaxNo + "\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010" + groupModel.getGroupId() + "\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u4eba\u7684\u96c6\u56e2\u3010" + groupId + "\u3011\u4e0d\u4e00\u81f4");
            }
        }
        return msConfigBean;
    }

    private CompanyModel companyInfoQuery(String taxNo) {
        SearchCompanyListRequest searchCompanyListRequest = new SearchCompanyListRequest();
        searchCompanyListRequest.setDataType(SearchCompanyListRequest.DataTypeEnum.TAXNUM);
        searchCompanyListRequest.setDataValue(taxNo);
        searchCompanyListRequest.setRid(UUID.randomUUID().toString());
        searchCompanyListRequest.setAppid("config-service");
        SearchCompanyListResponse searchCompanyListResponse = null;
        try {
            searchCompanyListResponse = this.companyApiClient.searchCompanyList(searchCompanyListRequest);
        }
        catch (Exception exception) {
            logger.error("\u67e5\u8be2\u516c\u53f8\u51fa\u73b0\u5f02\u5e38,\u7a0e\u53f7:{}", (Throwable)exception);
            throw new ThridPartyInvokeException("\u67e5\u8be2\u516c\u53f8\u51fa\u73b0\u5f02\u5e38");
        }
        if (searchCompanyListResponse == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchCompanyListResponse.getResult())) {
            String msg = "\u5f53\u524d\u7a0e\u53f7:\u3010" + taxNo + "\u3011\u6ca1\u6709\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f";
            logger.error(msg);
            throw new CompanyQueryException(msg);
        }
        return (CompanyModel)searchCompanyListResponse.getResult().get(0);
    }

    private GroupModel groupInfoQueryById(Long companyId) {
        GetGroupInfoRequest getGroupInfoRequest = new GetGroupInfoRequest();
        getGroupInfoRequest.setDataType(GetGroupInfoRequest.DataTypeEnum.COMPANYID);
        getGroupInfoRequest.setDataValue(String.valueOf(companyId));
        getGroupInfoRequest.setRid(UUID.randomUUID().toString());
        getGroupInfoRequest.setAppid("config-service");
        GetGroupInfoResponse getGroupInfoResponse = null;
        try {
            getGroupInfoResponse = this.groupApiClient.getGroupInfo(getGroupInfoRequest);
            if (getGroupInfoResponse == null || getGroupInfoResponse.getResult() == null) {
                throw new CompanyQueryException(String.valueOf(companyId));
            }
        }
        catch (Exception exception) {
            throw new ThridPartyInvokeException("\u67e5\u8be2\u8fd0\u8425\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38");
        }
        return getGroupInfoResponse.getResult();
    }

    private boolean checkTmpInvoiceInfo(List<MsConfigItemTempBean> list, String invoiceType, String sellerTaxNo, Integer configType) {
        List msConfigItemBeans = list.stream().filter(Objects::nonNull).map(entry -> ConfigItemEntityTranslator.convertFromMsConfigItemTempBean((MsConfigItemTempBean)entry)).collect(Collectors.toList());
        return this.checkConfigItem(msConfigItemBeans, invoiceType, sellerTaxNo, configType);
    }

    private boolean checkConfigItem(List<MsConfigItemBean> msConfigItemBeans, String invoiceTypeStr, String sellerTaxNo, Integer configType) {
        logger.debug("checkConfigItem msConfigItemBeans ======{},invoiceTypeStr:{},sellerTaxNo:{}", new Object[]{JsonUtils.writeObjectToFastJson(msConfigItemBeans), invoiceTypeStr, sellerTaxNo});
        InvoiceSplitrRuleDTO invoiceSplitrRuleDTO = new InvoiceSplitParser().parse(msConfigItemBeans);
        MsConfigBean msConfigBean = new MsConfigBean();
        msConfigBean.setConfigType(configType);
        msConfigBean.setInvoiceType(invoiceTypeStr);
        msConfigBean.setSellerTaxNo(sellerTaxNo);
        this.checkLimitAmt(msConfigBean, invoiceSplitrRuleDTO.getInvoiceLimit().toString());
        Integer invoiceMaxRow = invoiceSplitrRuleDTO.getInvoiceItemMaxRow();
        Integer salesListMaxRow = invoiceSplitrRuleDTO.getSalesListMaxRow();
        String saleListOpt = invoiceSplitrRuleDTO.getSaleListOption();
        String taxDeviceType = invoiceSplitrRuleDTO.getTaxDeviceType();
        Integer customRemarkSize = invoiceSplitrRuleDTO.getCustomRemarkSize();
        if (customRemarkSize != null && customRemarkSize <= 0) {
            throw new InvoiceSplitConfigException("\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
        }
        InvoiceType invoiceType = InvoiceType.fromValue((String)invoiceTypeStr);
        logger.debug("checkConfigItem invoiceType:{}, saleListOpt:{}, invoiceMaxRow:{}, salesListMaxRow:{}", new Object[]{invoiceType.value(), saleListOpt, invoiceMaxRow, salesListMaxRow});
        if (invoiceType == InvoiceType.ELECTRONIC || invoiceType == InvoiceType.SPECIAL_ELECTRONIC) {
            if (SalesListPrintEnum.NOT_PRINT_SALES_LIST.getSalesListOpt().equals(saleListOpt)) {
                if (invoiceMaxRow != 5 && invoiceMaxRow != 0) {
                    throw new InvoiceSplitConfigException("\u7535\u5b50\u53d1\u7968\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u5141\u8bb8\u586b\u5199 0\u62165");
                }
            } else {
                if (invoiceMaxRow != 0 && invoiceMaxRow != 5) {
                    throw new InvoiceSplitConfigException("\u7535\u7968\u62c6\u7968\u89c4\u5219\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 0\u62165 ");
                }
                if (salesListMaxRow <= 0 || salesListMaxRow > 100) {
                    throw new InvoiceSplitConfigException("\u7535\u7968\u62c6\u7968\u89c4\u5219\uff0c\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1\u81f3100\u884c");
                }
            }
            if (customRemarkSize != null && customRemarkSize > 250) {
                throw new InvoiceSplitConfigException("\u7535\u7968\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7250\u4e2a\u5b57\u8282");
            }
        } else if (invoiceType == InvoiceType.NORMAL || invoiceType == InvoiceType.SPECIAL) {
            if (SalesListPrintEnum.NOT_PRINT_SALES_LIST.getSalesListOpt().equals(saleListOpt)) {
                if (invoiceMaxRow < 1 || invoiceMaxRow > 8) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u4e0d\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1 \u81f38");
                }
            } else {
                if (invoiceMaxRow < 0 || invoiceMaxRow > 8) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 0\u81f38");
                }
                if (salesListMaxRow < 0 || salesListMaxRow > 2000) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 0 \u81f3 2000.");
                }
            }
            if (customRemarkSize != null && customRemarkSize > 230) {
                throw new InvoiceSplitConfigException("\u7eb8\u7968\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7230\u4e2a\u5b57\u8282");
            }
        }
        return true;
    }

    private boolean checkBusinessConfig(MsConfigBean msConfigBean) {
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.of((Integer)msConfigBean.getConfigType());
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[configTypeEnum.ordinal()]) {
            case 1: {
                return this.checkInvoiceSplitConfig(msConfigBean);
            }
            case 6: {
                return this.checkInvoiceUserConfig(msConfigBean);
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean checkInvoiceSplitConfig(MsConfigBean msConfigBean) {
        Integer configType = msConfigBean.getConfigType();
        String invoiceTypeStr = msConfigBean.getInvoiceType();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)configType);
        List msConfigItemBeans = msConfigBean.getItemList();
        if (configTypeEnum == ConfigTypeEnum.SPLIT_CONFIG_TYPE) {
            return this.checkConfigItem(msConfigItemBeans, invoiceTypeStr, msConfigBean.getSellerTaxNo(), msConfigBean.getConfigType());
        }
        return true;
    }

    private boolean checkInvoiceUserConfig(MsConfigBean msConfigBean) {
        List msConfigItemBeanList = msConfigBean.getItemList();
        logger.info("checkInvoiceUserConfig---msConfigItemBeanList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigItemBeanList));
        if (CollectionUtils.isEmpty((Collection)msConfigItemBeanList)) {
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        MsMataDataQueryRequest msMataDataQueryRequest = new MsMataDataQueryRequest();
        msMataDataQueryRequest.setObjCode("invoiceMemberInfoConfig");
        msMataDataQueryRequest.setObjType(msConfigBean.getSalesbillType());
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryTemplateMetaDataList(msMataDataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeanList)) {
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u6821\u9a8c\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25.");
        }
        HashMap validateFieldLengthMap = Maps.newHashMap();
        msBusinessObjMetadataBeanList.forEach(item -> validateFieldLengthMap.put(item.getFieldName(), item.getFieldLength()));
        logger.info("checkInvoiceUserConfig---validateFieldLengthMap:{}", (Object)JsonUtils.writeObjectToFastJson((Object)validateFieldLengthMap));
        for (MsConfigItemBean msConfigItemBean : msConfigItemBeanList) {
            Integer fieldLength = (Integer)validateFieldLengthMap.get(msConfigItemBean.getConfigItemName());
            fieldLength = fieldLength == null ? 0 : fieldLength;
            if (CollectionUtils.isEmpty((Collection)msConfigItemBean.getConfigItemValue())) {
                throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            String fieldValue = (String)msConfigItemBean.getConfigItemValue().get(0);
            logger.info("checkInvoiceUserConfig---fieldName:{},fieldValue:{}, length:{}, validateLength:{}", new Object[]{msConfigItemBean.getConfigItemName(), fieldValue.length(), fieldValue, fieldLength});
            if (!StringUtils.isEmpty((CharSequence)fieldValue) && fieldValue.length() <= fieldLength) continue;
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u3010" + fieldValue + "\u3011\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + fieldLength);
        }
        return true;
    }

    private boolean checkConfigItemRequired(MsConfigBean msConfigBean) {
        List unRequiredFiledList = this.unRequiredFiledList();
        List msConfigItemBeanList = msConfigBean.getItemList();
        for (MsConfigItemBean msConfigItemBean : msConfigItemBeanList) {
            String fieldName = msConfigItemBean.getConfigItemName();
            List itemValue = msConfigItemBean.getConfigItemValue();
            if (unRequiredFiledList.contains(fieldName) || !CollectionUtils.isEmpty((Collection)itemValue)) continue;
            String configItemDisplayName = msConfigItemBean.getConfigItemDisplayName();
            if (StringUtils.isEmpty((CharSequence)configItemDisplayName)) {
                if ("splitFiledList".equals(fieldName)) {
                    configItemDisplayName = "\u62c6\u5206\u5b57\u6bb5";
                } else if ("invoiceRemarkFiledList".equals(fieldName)) {
                    configItemDisplayName = "\u5907\u6ce8\u5b57\u6bb5";
                }
            }
            if (StringUtils.isEmpty((CharSequence)configItemDisplayName)) {
                configItemDisplayName = "\u914d\u7f6e\u9879 \u4e0d\u80fd\u4e3a\u7a7a.";
            }
            ConfigItemRequiredException configItemRequiredException = new ConfigItemRequiredException();
            String message = String.format(configItemRequiredException.getMessage(), configItemDisplayName);
            throw new ConfigItemRequiredException(message);
        }
        return true;
    }

    private List<String> unRequiredFiledList() {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo("unRequiredFiledsList");
        List cfgTemplateObjEntities = this.cfgTemplateObjDao.selectByExample(cfgTemplateObjExample);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjEntities)) {
            return Lists.newArrayList();
        }
        CfgTemplateObjEntity cfgTemplateObjEntity = (CfgTemplateObjEntity)cfgTemplateObjEntities.get(0);
        Long busObjId = cfgTemplateObjEntity.getTemplateObjId();
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(busObjId);
        List cfgTemplateObjMetadataEntities = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjMetadataEntities)) {
            return Lists.newArrayList();
        }
        return cfgTemplateObjMetadataEntities.stream().filter(Objects::nonNull).map(entry -> entry.getFieldName()).collect(Collectors.toList());
    }

    private boolean checkConfigName(MsConfigBean msConfigBean, Long groupId) {
        String configName = msConfigBean.getConfigName();
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        cfgConfigExample.createCriteria().andConfigNameEqualTo(configName).andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue())).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue())).andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType()).andPurchaserGroupIdEqualTo(groupId);
        CfgConfigExample cfgConfigExampleAR = new CfgConfigExample();
        CfgConfigExample.Criteria criteriaAR = cfgConfigExampleAR.createCriteria();
        criteriaAR.andConfigNameEqualTo(configName);
        criteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        criteriaAR.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteriaAR.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
        criteriaAR.andSellerGroupIdEqualTo(groupId);
        cfgConfigExample.or(criteriaAR);
        long count = this.cfgConfigDao.countByExample(cfgConfigExample);
        if (count > 0L) {
            throw new ConfigNameRepeatException();
        }
        if (ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue() || ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue()) {
            CfgConfigExample example = new CfgConfigExample();
            example.createCriteria().andSalesbillTypeEqualTo(msConfigBean.getSalesbillType()).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue())).andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue())).andSellerTaxNoEqualTo(msConfigBean.getSellerTaxNo()).andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType()).andPurchaserTaxNoEqualTo(msConfigBean.getPurchaserTaxNo());
            long countConfig = this.cfgConfigDao.countByExample(example);
            if (countConfig > 0L) {
                throw new InvoiceFaceConfigRepeatException();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkLimitAmt(MsConfigBean tmp, String value) {
        logger.info("checkLimitAmt--tmp:{} value:{}", (Object)tmp, (Object)value);
        if (!CommonTools.isEmpty((String)tmp.getSellerTaxNo()) && ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().intValue() == tmp.getConfigType().intValue()) {
            CompanyModel companyModel = this.companyInfoQuery(tmp.getSellerTaxNo());
            BigDecimal limit = BigDecimal.ZERO;
            if (InvoiceType.NORMAL.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getCquota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u666e\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u666e\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getCquota());
            } else if (InvoiceType.SPECIAL.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getSquota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u4e13\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u4e13\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getSquota());
            } else if (InvoiceType.ELECTRONIC.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getCeQuota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u7535\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u7535\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getCeQuota());
            } else if (InvoiceType.NORMAL_ROLL.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getJuQuota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u5377\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u5377\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getJuQuota());
            } else if (InvoiceType.VEHICLE.value().equals(tmp.getInvoiceType())) {
                logger.info("\u4e00\u671f\u6ca1\u6709");
            }
            if (InvoiceType.NORMAL.value().equals(tmp.getInvoiceType()) || InvoiceType.SPECIAL.value().equals(tmp.getInvoiceType()) || InvoiceType.ELECTRONIC.value().equals(tmp.getInvoiceType()) || InvoiceType.NORMAL_ROLL.value().equals(tmp.getInvoiceType())) {
                BigDecimal decimalValue = new BigDecimal(value);
                if (decimalValue.compareTo(BigDecimal.ZERO) != 1) {
                    logger.info("\u5f00\u7968\u9650\u989d\u53ea\u80fd\u5927\u4e8e0");
                    throw new RuntimeException("\u5f00\u7968\u9650\u989d\u53ea\u80fd\u5927\u4e8e0");
                }
                if (decimalValue.compareTo(limit) == 1) {
                    logger.info("\u5f00\u7968\u9650\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9500\u65b9\u516c\u53f8\u7684\u5f00\u7968\u9650\u989d\uff0c\u9650\u989d\u4e3a\u3010" + limit.toPlainString() + "\u3011\u5b9e\u9645\u4f20\u5165\u503c\u3010" + decimalValue.toPlainString() + "\u3011");
                    throw new RuntimeException("\u5f00\u7968\u9650\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9500\u65b9\u516c\u53f8\u7684\u5f00\u7968\u9650\u989d\uff0c\u9650\u989d\u4e3a\u3010" + limit.toPlainString() + "\u3011\u5b9e\u9645\u4f20\u5165\u503c\u3010" + decimalValue.toPlainString() + "\u3011");
                }
            }
        }
    }

    public MsConfigMailRuleResponse pullMailRuleConfig(Long configId) {
        MsConfigMailRuleResponse response = MsConfigMailRuleResponse.builder().build();
        response.setCode(BaseResponse.OK);
        List entities = this.queryMailRuleConfig(configId);
        if (entities.size() == 0) {
            response.setResult(null);
            return response;
        }
        if (entities.size() > 1) {
            logger.warn("@pullMailRuleConfig multiple mail rules found, expect 1, found " + entities.size());
        }
        CfgConfigMailRuleEntity entity = (CfgConfigMailRuleEntity)entities.get(0);
        MsConfigMailRule rule = new MsConfigMailRule();
        BeanMapper.copy((Object)entity, (Object)rule);
        rule.setConfigMailRuleId(entity.getId());
        rule.setPickUCAddress(entity.getPickUcAddress().booleanValue());
        response.setResult(rule);
        return response;
    }

    private List<CfgConfigMailRuleEntity> queryMailRuleConfig(Long configId) {
        CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
        example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        return this.cfgConfigMailRuleDao.selectByExample(example);
    }
}

