/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.notice.client.model.MsDoBase;
import com.xforceplus.notice.client.model.MsOperateMessageRequest;
import com.xforceplus.notice.client.model.MsOperateMessageResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.seller.config.client.MessageClient;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.repository.dao.CfgConfigInterfaceDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceExample;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.apimodel.file.ImportResponse;
import com.xforceplus.xplatframework.apimodel.file.ImportResult;
import com.xforceplus.xplatframework.model.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ImportReasonTools {
    @Autowired
    CfgConfigInterfaceDao cfgConfigInterfaceDao;
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    IDGenerator iDGenerator;
    @Autowired
    MessageClient messageClient;
    @Autowired
    CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao;
    private static final Logger logger = LoggerFactory.getLogger(ImportReasonTools.class);
    public static final List<String> splitTemplateList = Lists.newArrayList((Object[])new String[]{"\u521b\u5efa\u65b9", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u89c4\u5219\u540d\u79f0", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u53d1\u7968\u7c7b\u578b", "\u91d1\u989d\u62c6\u5206\u89c4\u5219", "\u7968\u9762\u6700\u5927\u884c\u6570", "\u5f00\u7968\u9650\u989d", "\u660e\u7ec6\u987a\u5e8f", "\u9500\u8d27\u6e05\u5355\u9009\u9879", "\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570", "\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b", "\u5355\u4ef7\u6570\u91cf\u9009\u9879", "\u62c6\u5206\u5b57\u6bb5", "\u5907\u6ce8\u5b57\u6bb5"});
    public static final List<String> titleTemplateList = Lists.newArrayList((Object[])new String[]{"\u521b\u5efa\u65b9", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u9500\u65b9\u7a0e\u53f7", "\u89c4\u5219\u540d\u79f0", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u9500\u65b9\u5730\u5740", "\u9500\u65b9\u94f6\u884c\u8d26\u53f7", "\u9500\u65b9\u5f00\u6237\u884c", "\u9500\u65b9\u7535\u8bdd"});
    public static final List<String> personTemplateList = Lists.newArrayList((Object[])new String[]{"\u521b\u5efa\u65b9", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u9500\u65b9\u7a0e\u53f7", "\u89c4\u5219\u540d\u79f0", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u5f00\u7968\u4eba", "\u590d\u6838\u4eba", "\u6536\u6b3e\u4eba"});
    public static Map<String, String> templateMap = Maps.newHashMap();

    public Response handleUploadMsg(Map<String, Object> headers) {
        if (headers.get("importBatchNo") != null) {
            Long importBatchNo = (Long)headers.get("importBatchNo");
            String fileOriginName = (String)headers.get("fileOriginName");
            int configType = (Integer)headers.get("configType");
            UserInfo userInfo = (UserInfo)JsonUtils.writeFastJsonToObject((String)((String)headers.get("userInfo")), UserInfo.class);
            logger.info("importBatchNo:{}", (Object)importBatchNo);
            logger.info("fileOriginName:{}", (Object)fileOriginName);
            try {
                CfgConfigInterfaceExample example = new CfgConfigInterfaceExample();
                example.createCriteria().andBatchNoEqualTo(importBatchNo).andProcessFlagEqualTo("F");
                List cfgConfigInterfaceEntities = this.cfgConfigInterfaceDao.selectByExample(example);
                if (CollectionUtils.isEmpty((Collection)cfgConfigInterfaceEntities)) {
                    return Response.failed((String)"\u751f\u6210\u5931\u8d25");
                }
                HashMap descMap = Maps.newHashMap();
                ArrayList headList = Lists.newArrayList();
                ArrayList headDescList = Lists.newArrayList();
                headDescList.add("\u5931\u8d25\u539f\u56e0");
                descMap.put("\u5931\u8d25\u539f\u56e0", "mainReason");
                descMap.putAll(templateMap);
                if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType() == configType) {
                    headDescList.addAll(splitTemplateList);
                } else if (ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType() == configType) {
                    headDescList.addAll(titleTemplateList);
                } else if (ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType() == configType) {
                    headDescList.addAll(personTemplateList);
                } else {
                    throw new RuntimeException("\u751f\u6210\u5bfc\u5165\u5931\u8d25\u539f\u56e0EXCl\u5931\u8d25");
                }
                headList.addAll(headDescList.stream().map(descMap::get).collect(Collectors.toList()));
                ArrayList dataList = Lists.newArrayList();
                for (CfgConfigInterfaceEntity entity : cfgConfigInterfaceEntities) {
                    String origData = entity.getOrigData();
                    Map data = JsonUtils.writeFastJsonToMap((String)origData);
                    data.put("mainReason", entity.getProcessRemark());
                    dataList.add(data);
                }
                logger.info("dataList size:{}", (Object)dataList.size());
                HSSFWorkbook workbook = new HSSFWorkbook();
                Sheet sheet = workbook.createSheet("\u914d\u7f6e\u89c4\u5219\u5bfc\u5165\u5931\u8d25\u539f\u56e0");
                sheet.setDefaultColumnWidth(15);
                sheet.setForceFormulaRecalculation(true);
                ImportReasonTools.buildHeader((Sheet)sheet, (List)headList, (List)headDescList);
                ImportReasonTools.buildBody((Sheet)sheet, (List)headList, (List)dataList);
                String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + importBatchNo + ".xls";
                String key = this.putFile((Workbook)workbook, filepath);
                logger.info("\u4e0a\u4f20\u5355\u636e\u5931\u8d25\u6587\u4ef6\u6210\u529foss key:{}", (Object)key);
                MsOperateMessageRequest request = new MsOperateMessageRequest();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                request.setMessageTitle(sdf.format(new Date()) + ",\u4e1a\u52a1\u5355excel\u6587\u4ef6\u3010" + fileOriginName + "\u3011\u5bfc\u5165");
                request.setMessageUrl(this.ossUtil.fileKeyToDownloadUrlViaPlatform(key));
                logger.info("download url is : {}", (Object)request.getMessageUrl());
                request.setGroupId(Long.valueOf(userInfo.getGroupId()));
                request.setMessageContent("\u5bfc\u5165\u5931\u8d25" + cfgConfigInterfaceEntities.size() + "\u6761\uff0c\u8be6\u89c1\u4e0b\u8f7d\u6587\u4ef6");
                request.setMessageId(Long.valueOf(this.iDGenerator.nextId()));
                request.setMessageType(Integer.valueOf(1));
                request.setMessageValue(Long.valueOf(1L));
                request.setUserId(Long.valueOf(userInfo.getUserId()));
                request.setAppid("config-service");
                request.setDoType(MsDoBase.DoTypeEnum.I);
                request.setOperater(userInfo.getUserName());
                request.setOperaterid(String.valueOf(userInfo.getUserId()));
                request.setRid(String.valueOf(this.iDGenerator.nextId()));
                MsOperateMessageResponse reponse = this.messageClient.operateMessage(request);
                logger.info("reponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)reponse));
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u5355\u636e\u5bfc\u5165\u5931\u8d25\u539f\u56e0\u5f02\u5e38:{}", (Throwable)e);
            }
        }
        return Response.ok((String)"\u751f\u6210\u6210\u529f");
    }

    private static void buildHeader(Sheet sheet, List<String> headList, List<String> headDescList) {
        Row row = sheet.createRow(0);
        CellStyle cellStyle = ImportReasonTools.getCellStyle((Workbook)row.getSheet().getWorkbook());
        for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
            Cell cell = row.createCell(columnIndex);
            String val = headDescList.get(columnIndex);
            cell.setCellValue(val == null ? "" : val.toString());
            cell.setCellStyle(cellStyle);
        }
    }

    private static void buildBody(Sheet sheet, List<String> headList, List<Map<String, Object>> dataList) {
        CellStyle cellStyle = ImportReasonTools.getBodyCellStyle((Workbook)sheet.getWorkbook());
        for (int rowNum = 1; rowNum <= dataList.size(); ++rowNum) {
            Map<String, Object> map = dataList.get(rowNum - 1);
            Row row = sheet.createRow(rowNum);
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                Cell cell = row.createCell(columnIndex);
                Object val = map.get(headList.get(columnIndex));
                cell.setCellValue(val == null ? "" : val.toString());
                cell.setCellStyle(cellStyle);
            }
        }
    }

    public static String captureName(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(Workbook workbook, String filePath) throws IOException {
        OutputStream out = null;
        File localFile = null;
        try {
            String key;
            localFile = new File(filePath);
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            out = new FileOutputStream(localFile);
            workbook.write(out);
            String string = key = this.ossUtil.uploadFileInternal(filePath, Module.SELLER, true);
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230oss\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (localFile != null) {
                localFile.delete();
            }
        }
    }

    public static CellStyle getCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle getBodyCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)400);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public ImportResponse queryResult(Long importBatchNo) {
        ImportResponse importResponse = new ImportResponse();
        ImportResult importResult = new ImportResult();
        List list = this.cfgConfigInterfaceExtDao.queryGroupByProcessFlagAndBatchNo(importBatchNo);
        list.forEach(item -> {
            if ("F".equals(item.get("processFlag"))) {
                importResult.setFail(Integer.valueOf(Integer.parseInt(String.valueOf(item.get("total")))));
            } else if ("S".equals(item.get("processFlag"))) {
                importResult.setSuccess(Integer.valueOf(Integer.parseInt(String.valueOf(item.get("total")))));
            }
        });
        importResponse.setResult(importResult);
        importResponse.setCode(Response.OK);
        return importResponse;
    }

    static {
        templateMap.put("\u521b\u5efa\u65b9", "businessBillType");
        templateMap.put("\u9500\u65b9\u540d\u79f0", "sellerName");
        templateMap.put("\u9500\u65b9\u7a0e\u53f7", "sellerTaxNo");
        templateMap.put("\u8d2d\u65b9\u540d\u79f0", "purchaserName");
        templateMap.put("\u8d2d\u65b9\u7a0e\u53f7", "purchaserTaxNo");
        templateMap.put("\u89c4\u5219\u540d\u79f0", "configName");
        templateMap.put("\u4e1a\u52a1\u5355\u7c7b\u578b", "salesbillType");
        templateMap.put("\u53d1\u7968\u7c7b\u578b", "invoiceType");
        templateMap.put("\u91d1\u989d\u62c6\u5206\u89c4\u5219", "amountSplitRule");
        templateMap.put("\u7968\u9762\u6700\u5927\u884c\u6570", "invoiceItemMaxRow");
        templateMap.put("\u5f00\u7968\u9650\u989d", "invoiceLimit");
        templateMap.put("\u660e\u7ec6\u987a\u5e8f", "itemSort");
        templateMap.put("\u9500\u8d27\u6e05\u5355\u9009\u9879", "saleListOption");
        templateMap.put("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570", "salesListMaxRow");
        templateMap.put("\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b", "taxDeviceType");
        templateMap.put("\u5355\u4ef7\u6570\u91cf\u9009\u9879", "unitPriceAmountOps");
        templateMap.put("\u62c6\u5206\u5b57\u6bb5", "splitFiledList");
        templateMap.put("\u5907\u6ce8\u5b57\u6bb5", "invoiceRemarkFiledList");
        templateMap.put("\u9500\u65b9\u5730\u5740", "sellerAddress");
        templateMap.put("\u9500\u65b9\u94f6\u884c\u8d26\u53f7", "sellerBankAccount");
        templateMap.put("\u9500\u65b9\u5f00\u6237\u884c", "sellerBankName");
        templateMap.put("\u9500\u65b9\u7535\u8bdd", "sellerTel");
        templateMap.put("\u5f00\u7968\u4eba", "invoicerName");
        templateMap.put("\u590d\u6838\u4eba", "checkerName");
        templateMap.put("\u6536\u6b3e\u4eba", "cashierName");
    }
}

