/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.service.impl;

import com.xforceplus.seller.config.bizconfig.service.ConfigService;
import com.xforceplus.seller.config.client.model.ConfigCompanyNameRequest;
import com.xforceplus.seller.config.client.model.ConfigOperatorInfo;
import com.xforceplus.seller.config.client.model.ConfigOperatorRequest;
import com.xforceplus.seller.config.client.model.ConfigTtitleInfo;
import com.xforceplus.seller.config.client.model.ConfigTtitleRequest;
import com.xforceplus.seller.config.constants.BusinessBillType;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemExample;
import com.xforceplus.seller.config.repository.model.modelext.ConfigOperatorAndTtitleAndCompanyNameExtExample;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigServiceImpl
implements ConfigService {
    @Autowired
    private CfgConfigDao cfgConfigDao;
    @Autowired
    private CfgConfigExtDao cfgConfigExtDao;
    @Autowired
    private CfgConfigItemDao cfgConfigItemDao;
    private static final Logger logger = LoggerFactory.getLogger(ConfigServiceImpl.class);

    public Response updateConfigOperator(ConfigOperatorRequest configOperatorRequest) {
        int configType;
        String billType;
        String businessBillType;
        String otherSideTaxNo;
        String selfTaxNo = configOperatorRequest.getSelfTaxNo();
        List configIds = this.queryConfigForOperatorAndTtitle(selfTaxNo, otherSideTaxNo = configOperatorRequest.getOtherSideTaxNo(), businessBillType = configOperatorRequest.getBusinessBillType(), billType = configOperatorRequest.getBillType(), configType = 4);
        if (configIds == null || configIds.size() == 0) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList updateConfigItems = new ArrayList();
        ArrayList<Long> resultsConfigIds = new ArrayList<Long>();
        ConfigOperatorInfo newOperatorInfo = configOperatorRequest.getNewOperatorInfo();
        List cfgConfigItemEntityList = this.queryConfigItemByConfigIds(configIds);
        Map<Long, List<CfgConfigItemEntity>> groupBy = cfgConfigItemEntityList.stream().collect(Collectors.groupingBy(CfgConfigItemEntity::getConfigId));
        for (Map.Entry<Long, List<CfgConfigItemEntity>> entry : groupBy.entrySet()) {
            List<CfgConfigItemEntity> list = entry.getValue();
            if (list == null || list.size() != 3) continue;
            resultsConfigIds.add(entry.getKey());
            for (CfgConfigItemEntity cfgConfigItemEntity : list) {
                CfgConfigItemEntity updateCfgConfigItemEntity = new CfgConfigItemEntity();
                updateCfgConfigItemEntity.setConfigItemId(cfgConfigItemEntity.getConfigItemId());
                if ("cashierName".equals(cfgConfigItemEntity.getConfigItemName())) {
                    updateCfgConfigItemEntity.setConfigItemValue("[\"" + newOperatorInfo.getCashierName() + "\"]");
                } else if ("checkerName".equals(cfgConfigItemEntity.getConfigItemName())) {
                    updateCfgConfigItemEntity.setConfigItemValue("[\"" + newOperatorInfo.getCheckerName() + "\"]");
                } else if ("invoicerName".equals(cfgConfigItemEntity.getConfigItemName())) {
                    updateCfgConfigItemEntity.setConfigItemValue("[\"" + newOperatorInfo.getInvoicerName() + "\"]");
                }
                this.cfgConfigItemDao.updateByPrimaryKeySelective(updateCfgConfigItemEntity);
            }
        }
        if (updateConfigItems.size() > 0) {
            // empty if block
        }
        if (resultsConfigIds.size() > 0) {
            return Response.from((Integer)Response.OK, null, resultsConfigIds);
        }
        return Response.failed((String)"\u65e0\u6570\u636e");
    }

    public Response updateConfigTtitle(ConfigTtitleRequest configTtitleRequest) {
        int configType;
        String billType;
        String businessBillType;
        String otherSideTaxNo;
        String selfTaxNo = configTtitleRequest.getSelfTaxNo();
        List configIds = this.queryConfigForOperatorAndTtitle(selfTaxNo, otherSideTaxNo = configTtitleRequest.getOtherSideTaxNo(), businessBillType = configTtitleRequest.getBusinessBillType(), billType = configTtitleRequest.getBillType(), configType = 3);
        if (configIds == null || configIds.size() == 0) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList updateConfigItems = new ArrayList();
        ArrayList<Long> resultsConfigIds = new ArrayList<Long>();
        ConfigTtitleInfo newTtitleInfo = configTtitleRequest.getNewTtitleInfo();
        List cfgConfigItemEntityList = this.queryConfigItemByConfigIds(configIds);
        Map<Long, List<CfgConfigItemEntity>> groupBy = cfgConfigItemEntityList.stream().collect(Collectors.groupingBy(CfgConfigItemEntity::getConfigId));
        for (Map.Entry<Long, List<CfgConfigItemEntity>> entry : groupBy.entrySet()) {
            List<CfgConfigItemEntity> list = entry.getValue();
            if (list == null || list.size() != 4) continue;
            resultsConfigIds.add(entry.getKey());
            for (CfgConfigItemEntity cfgConfigItemEntity : list) {
                CfgConfigItemEntity updateCfgConfigItemEntity = new CfgConfigItemEntity();
                updateCfgConfigItemEntity.setConfigItemId(cfgConfigItemEntity.getConfigItemId());
                if (cfgConfigItemEntity.getConfigItemName().endsWith("Address")) {
                    updateCfgConfigItemEntity.setConfigItemValue("[\"" + newTtitleInfo.getAddress() + "\"]");
                } else if (cfgConfigItemEntity.getConfigItemName().endsWith("BankAccount")) {
                    updateCfgConfigItemEntity.setConfigItemValue("[\"" + newTtitleInfo.getBankAccount() + "\"]");
                } else if (cfgConfigItemEntity.getConfigItemName().endsWith("BankName")) {
                    updateCfgConfigItemEntity.setConfigItemValue("[\"" + newTtitleInfo.getBankName() + "\"]");
                } else if (cfgConfigItemEntity.getConfigItemName().endsWith("Tel")) {
                    updateCfgConfigItemEntity.setConfigItemValue("[\"" + newTtitleInfo.getTel() + "\"]");
                }
                this.cfgConfigItemDao.updateByPrimaryKeySelective(updateCfgConfigItemEntity);
            }
        }
        if (updateConfigItems.size() > 0) {
            // empty if block
        }
        if (resultsConfigIds.size() > 0) {
            return Response.from((Integer)Response.OK, null, resultsConfigIds);
        }
        return Response.failed((String)"\u65e0\u6570\u636e");
    }

    public Response updateConfigCompanyName(ConfigCompanyNameRequest configCompanyNameRequest) {
        String businessBillType;
        String companyTaxNo = configCompanyNameRequest.getCompanyTaxNo();
        List configIds = this.queryConfigForCompanyName(companyTaxNo, businessBillType = configCompanyNameRequest.getBusinessBillType());
        if (configIds == null || configIds.size() == 0) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList configEntityList = new ArrayList();
        String newCompanyName = configCompanyNameRequest.getNewCompanyName();
        CfgConfigExample example = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = example.createCriteria();
        criteria.andConfigIdIn(configIds);
        List list = this.cfgConfigDao.selectByExample(example);
        for (CfgConfigEntity cfgConfigEntity : list) {
            CfgConfigEntity updateCfgConfigEntity = new CfgConfigEntity();
            updateCfgConfigEntity.setConfigId(cfgConfigEntity.getConfigId());
            if (cfgConfigEntity.getBusinessBillType().equals(BusinessBillType.AP.value())) {
                updateCfgConfigEntity.setPurchaserName(newCompanyName);
            } else {
                if (!cfgConfigEntity.getBusinessBillType().equals(BusinessBillType.AR.value())) continue;
                updateCfgConfigEntity.setSellerName(newCompanyName);
            }
            this.cfgConfigDao.updateByPrimaryKeySelective(updateCfgConfigEntity);
        }
        if (configEntityList.size() > 0) {
            // empty if block
        }
        return Response.ok((String)"");
    }

    public List<Long> queryConfigForOperatorAndTtitle(String selfTaxNo, String otherSideTaxNo, String businessBillType, String billType, int configType) {
        ConfigOperatorAndTtitleAndCompanyNameExtExample companyNameExtExample = new ConfigOperatorAndTtitleAndCompanyNameExtExample();
        companyNameExtExample.setSelfTaxNo(selfTaxNo);
        companyNameExtExample.setOtherSideTaxNo(otherSideTaxNo);
        companyNameExtExample.setBillType(billType);
        companyNameExtExample.setBusinessBillType(businessBillType);
        companyNameExtExample.setConfigType(configType);
        if (StringUtils.isEmpty((CharSequence)businessBillType)) {
            companyNameExtExample.setSellerPurchaserTaxNo(3);
        } else if (businessBillType.equals(BusinessBillType.AP.value())) {
            companyNameExtExample.setSellerPurchaserTaxNo(2);
        } else if (businessBillType.equals(BusinessBillType.AR.value())) {
            companyNameExtExample.setSellerPurchaserTaxNo(1);
        } else {
            return new ArrayList<Long>();
        }
        return this.cfgConfigExtDao.queryOperatorAndTtitleAndCompanyConfig(companyNameExtExample);
    }

    public List<Long> queryConfigForCompanyName(String companyTaxNo, String businessBillType) {
        ConfigOperatorAndTtitleAndCompanyNameExtExample companyNameExtExample = new ConfigOperatorAndTtitleAndCompanyNameExtExample();
        companyNameExtExample.setCompanyTaxNo(companyTaxNo);
        if (StringUtils.isEmpty((CharSequence)businessBillType)) {
            companyNameExtExample.setSellerPurchaserTaxNo(6);
        } else if (businessBillType.equals(BusinessBillType.AP.value())) {
            companyNameExtExample.setSellerPurchaserTaxNo(5);
        } else if (businessBillType.equals(BusinessBillType.AR.value())) {
            companyNameExtExample.setSellerPurchaserTaxNo(4);
        } else {
            return new ArrayList<Long>();
        }
        return this.cfgConfigExtDao.queryOperatorAndTtitleAndCompanyConfig(companyNameExtExample);
    }

    public List<CfgConfigItemEntity> queryConfigItemByConfigIds(List<Long> configIds) {
        if (configIds == null || configIds.size() == 0) {
            return new ArrayList<CfgConfigItemEntity>();
        }
        CfgConfigItemExample example = new CfgConfigItemExample();
        CfgConfigItemExample.Criteria criteria = example.createCriteria();
        criteria.andConfigIdIn(configIds);
        return this.cfgConfigItemDao.selectByExample(example);
    }
}

