/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.cahe;

import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.bss.external.client.model.GetCompanyInfoRequest;
import com.xforceplus.bss.external.client.model.GetCompanyInfoResponse;
import com.xforceplus.seller.config.client.BssExternalCompanyClient;
import com.xforceplus.seller.config.client.UserApiClient;
import com.xforceplus.ucenter.external.client.model.GetUserInfoRequest;
import com.xforceplus.ucenter.external.client.model.GetUserInfoResponse;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalBssExternalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String cacheName = "BSS_EXTERNAL_LOCAL_CACHE";
    private BssExternalCompanyClient bssExternalCompanyClient;
    private UserApiClient userApiClient;

    @Autowired
    public LocalBssExternalCacheManager(BssExternalCompanyClient bssExternalCompanyClient, UserApiClient userApiClient) {
        this.bssExternalCompanyClient = bssExternalCompanyClient;
        this.userApiClient = userApiClient;
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"})
    public CompanyModel getCompanyMainInfoByTaxNo(String companyTaxNo) {
        GetCompanyInfoRequest request = new GetCompanyInfoRequest();
        request.setDataType(GetCompanyInfoRequest.DataTypeEnum.TAXNUM);
        request.setDataValue(companyTaxNo);
        request.setAppid("phoenix-seller-config");
        request.setRid(UUID.randomUUID().toString());
        this.logger.debug("======================getCompanyMainInfoByTaxNo-request-{}============================", (Object)request);
        GetCompanyInfoResponse companyInfo = this.bssExternalCompanyClient.getCompanyInfo(request);
        this.logger.debug("=================CompanyModeByTaxNo-{}============================", (Object)companyInfo.getResult());
        return companyInfo.getResult();
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    public GetUserInfoResponse getUserExtPermission(Long userId, Long groupId) {
        try {
            GetUserInfoRequest getUserInfoRequest = new GetUserInfoRequest();
            getUserInfoRequest.setUserID(userId);
            getUserInfoRequest.setGroupID(groupId);
            getUserInfoRequest.setAppid("phoenix-seller-config");
            getUserInfoRequest.setRid(UUID.randomUUID().toString());
            this.logger.info("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027,userId:{},groupId:{}", (Object)userId, (Object)groupId);
            GetUserInfoResponse userInfo = this.userApiClient.getUserInfo(getUserInfoRequest);
            this.logger.info("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027\u8fd4\u56de\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)userInfo));
            return userInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

