/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.company;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.model.AddCompanyRequest;
import com.xforceplus.seller.config.client.model.ConfigCompanyModel;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryRequest;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryResponse;
import com.xforceplus.seller.config.repository.dao.CfgCompanyDao;
import com.xforceplus.seller.config.repository.model.CfgCompanyEntity;
import com.xforceplus.seller.config.repository.model.CfgCompanyExample;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigCompanyService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigCompanyService.class);
    @Autowired
    IDGenerator idGenerator;
    @Autowired
    CfgCompanyDao cfgCompanyDao;

    public Response addCompany(AddCompanyRequest request) {
        CfgCompanyExample cfgCompanyExample = new CfgCompanyExample();
        cfgCompanyExample.createCriteria().andCompanyTaxNoEqualTo(request.getCompanyTaxNo());
        List cfgCompanyEntities = this.cfgCompanyDao.selectByExample(cfgCompanyExample);
        if (CollectionUtils.isEmpty((Collection)cfgCompanyEntities)) {
            CfgCompanyEntity cfgCompanyEntity = new CfgCompanyEntity();
            cfgCompanyEntity.setCompanyId(Long.valueOf(this.idGenerator.nextId()));
            cfgCompanyEntity.setCompanyName(request.getCompanyName());
            cfgCompanyEntity.setCompanyNo(CommonTools.isEmpty((String)request.getCompanyNo()) ? "" : request.getCompanyNo());
            cfgCompanyEntity.setCompanyTaxNo(request.getCompanyTaxNo());
            cfgCompanyEntity.setUserId(request.getUserId());
            cfgCompanyEntity.setGroupId(request.getGroupId());
            cfgCompanyEntity.setStatus(Byte.valueOf((byte)1));
            cfgCompanyEntity.setDeleteToken("");
            cfgCompanyEntity.setCreateTime(new Date());
            this.cfgCompanyDao.insert(cfgCompanyEntity);
        } else {
            logger.info("\u7a0e\u53f7\u5df2\u7ecf\u7ef4\u62a4:{}", (Object)request.getCompanyTaxNo());
        }
        return Response.ok((String)"\u65b0\u589e\u6210\u529f");
    }

    public ConfigCompanyQueryResponse queryConfigCompany(ConfigCompanyQueryRequest request) {
        Long groupId = request.getGroupId();
        String keyword = request.getKeyword();
        CfgCompanyExample cfgCompanyExample = new CfgCompanyExample();
        CfgCompanyExample.Criteria criteria = cfgCompanyExample.createCriteria();
        if (groupId != 0L) {
            criteria.andGroupIdEqualTo(groupId);
        }
        if (!CommonTools.isEmpty((String)keyword)) {
            criteria.andCompanyNameLike("%" + keyword + "%");
        }
        List cfgCompanyEntities = this.cfgCompanyDao.selectByExample(cfgCompanyExample);
        ArrayList listModel = Lists.newArrayList();
        cfgCompanyEntities.stream().forEach(item -> {
            ConfigCompanyModel configCompanyModel = new ConfigCompanyModel();
            BeanUtils.copyProperties((Object)item, (Object)configCompanyModel);
            listModel.add(configCompanyModel);
        });
        ConfigCompanyQueryResponse configCompanyQueryResponse = new ConfigCompanyQueryResponse();
        configCompanyQueryResponse.setCode(1);
        configCompanyQueryResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        configCompanyQueryResponse.setList((List)listModel);
        return configCompanyQueryResponse;
    }
}

