/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.config;

import java.util.Properties;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
public class TxConfigBeanName {
    @Autowired
    private DataSourceTransactionManager transactionManager;

    @Bean(name={"transactionInterceptor"})
    public TransactionInterceptor transactionInterceptor() {
        Properties transactionAttributes = new Properties();
        transactionAttributes.setProperty("add*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("save*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("batchSave*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("delete*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("batchDelete*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("update*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("batchUpdate*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("select*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        transactionAttributes.setProperty("get*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        transactionAttributes.setProperty("query*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        TransactionInterceptor tsi = new TransactionInterceptor((PlatformTransactionManager)this.transactionManager, transactionAttributes);
        return tsi;
    }

    @Bean
    public BeanNameAutoProxyCreator transactionAutoProxy() {
        BeanNameAutoProxyCreator creator = new BeanNameAutoProxyCreator();
        creator.setInterceptorNames(new String[]{"transactionInterceptor"});
        creator.setBeanNames(new String[]{"*Service", "*ServiceImpl"});
        creator.setProxyTargetClass(true);
        return creator;
    }
}

