/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.config.interceptor;

import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.Interceptor.AppApiSecurityInterceptor;
import com.xforceplus.xplatsecurity.JsonHelp;
import com.xforceplus.xplatsecurity.annotation.SkipAuth;
import com.xforceplus.xplatsecurity.api.TokenService;
import com.xforceplus.xplatsecurity.api.TokenValidateException;
import com.xforceplus.xplatsecurity.api.domain.TokenBody;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AppUserInfoInterceptor
extends HandlerInterceptorAdapter {
    public static final Logger logger = LoggerFactory.getLogger(AppApiSecurityInterceptor.class);
    @Autowired
    TokenService tokenService;
    @Autowired
    ContextHolder contextHolder;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.addHeader("X-TId", TraceContext.traceId());
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            Annotation[] annotations = method.getAnnotations();
            if (Arrays.stream(annotations).anyMatch(a -> a.annotationType().equals(SkipAuth.class))) {
                return true;
            }
            String accessToken = request.getHeader("X-Access-Token");
            if (StringUtils.isEmpty((Object)accessToken)) {
                throw new TokenValidateException("token\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                TokenBody tokenRes = this.tokenService.validateToken(accessToken);
                if (null == tokenRes) {
                    throw new TokenValidateException("token\u89e3\u6790\u5931\u8d25");
                }
                UserContext userContext = new UserContext();
                userContext.setAccessToken(accessToken);
                String userStr = (String)tokenRes.getAdditionalProperties().get("userInfo");
                if (StringUtils.isEmpty((Object)accessToken)) {
                    throw new TokenValidateException("token\u6ca1\u6709\u7528\u6237\u4fe1\u606f");
                }
                UserSessionInfo userSessionInfo = (UserSessionInfo)JsonHelp.toObj((String)userStr, UserSessionInfo.class);
                this.convertToUserInfo(request, userSessionInfo);
                return true;
            }
            catch (Exception var12) {
                logger.error("token\u89e3\u6790\u5931\u8d25\uff0ctoken = " + accessToken, (Throwable)var12);
                throw new TokenValidateException("token\u89e3\u6790\u5931\u8d25");
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.contextHolder.clearContext();
    }

    private void convertToUserInfo(HttpServletRequest request, UserSessionInfo sessionInfo) {
        UserInfo userInfo = new UserInfo();
        if (sessionInfo != null) {
            if (sessionInfo != null) {
                userInfo.setGroupId(sessionInfo.getGroupId());
                userInfo.setGroupName(sessionInfo.getGroupName());
                userInfo.setGroupCode(sessionInfo.getGroupCode());
                userInfo.setMobile(sessionInfo.getMobile());
                userInfo.setUserName(sessionInfo.getSysUserName());
                userInfo.setUserId(sessionInfo.getSysUserId());
            }
        } else {
            userInfo.setGroupId(0L);
            userInfo.setGroupName("test");
            userInfo.setGroupCode("test");
            userInfo.setMobile("13800000000");
            userInfo.setUserName("java");
            userInfo.setUserId(1L);
        }
        this.userInfoHolder.put((Object)userInfo);
    }
}

