/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.device.controller;

import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.ConfigDeviceApi;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateResponse;
import com.xforceplus.seller.config.client.model.MsConfigUpdateDeviceStatusRequest;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryRequest;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryResponse;
import com.xforceplus.seller.config.client.model.MsQueryAllTaxDeviceByTaxDeviceTypesRequest;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsUpdateDeviceInfo;
import com.xforceplus.seller.config.device.service.business.ConfigDeviceService;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatsecurity.base.BaseMicroController;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MSApiV1SellerConfig
public class MsConfigDeviceController
extends BaseMicroController
implements ConfigDeviceApi {
    @Autowired
    private ConfigDeviceService configDeviceService;

    public MsConfigDeviceAddResponse addDevice(@RequestBody MsConfigDeviceAddRequest configDeviceAddRequest) {
        BiFunction<Integer, String, MsConfigDeviceAddResponse> quickReturn = (code, message) -> {
            MsConfigDeviceAddResponse response = new MsConfigDeviceAddResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        MsDeviceInfo msDeviceInfo = configDeviceAddRequest.getDeviceInfo();
        if (msDeviceInfo == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u8bbe\u5907\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.configDeviceService.addDevice(configDeviceAddRequest);
    }

    public MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(@RequestBody MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest) {
        return this.configDeviceService.configDeviceGetCompanyList(configDeviceGetCompanyListRequest);
    }

    public MsDeviceSummaryQueryResponse deviceSummaryQuery(@RequestBody MsDeviceSummaryQueryRequest deviceSummaryQueryRequest) {
        return this.configDeviceService.deviceSummaryQuery(deviceSummaryQueryRequest);
    }

    public MsQueryDeviceResponse getDeviceList(@RequestBody MsConfigDeviceQueryRequest request) {
        return this.configDeviceService.getDeviceList(request);
    }

    public MsQueryDeviceResponse queryAllTaxDeviceByTaxDeviceTypes(@RequestBody MsQueryAllTaxDeviceByTaxDeviceTypesRequest queryAllTaxDeviceByTaxDeviceTypesRequest) {
        if (queryAllTaxDeviceByTaxDeviceTypesRequest.getTaxDeviceTypes() == null || queryAllTaxDeviceByTaxDeviceTypesRequest.getTaxDeviceTypes().isEmpty()) {
            return new MsQueryDeviceResponse().code(BaseResponse.Fail).message("\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a");
        }
        return this.configDeviceService.queryAllTaxDeviceByTaxDeviceTypes(queryAllTaxDeviceByTaxDeviceTypesRequest);
    }

    public MsConfigDeviceUpdateResponse updateDevice(@RequestBody MsConfigDeviceUpdateRequest configDeviceUpdateRequest) {
        BiFunction<Integer, String, MsConfigDeviceUpdateResponse> quickReturn = (code, message) -> {
            MsConfigDeviceUpdateResponse response = new MsConfigDeviceUpdateResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        MsUpdateDeviceInfo msUpdateDeviceInfo = configDeviceUpdateRequest.getDeviceInfo();
        Long deviceId = msUpdateDeviceInfo.getId();
        if (deviceId == null || deviceId < 1L) {
            return quickReturn.apply(BaseResponse.Fail, "\u4e0d\u80fd\u4f20\u5165\u7a7a\u8bbe\u5907Id");
        }
        return this.configDeviceService.updateDevice(configDeviceUpdateRequest);
    }

    public MsResponse updateStatus(@RequestBody MsConfigUpdateDeviceStatusRequest request) {
        BiFunction<Integer, String, MsResponse> quickReturn = (code, message) -> {
            MsResponse response = new MsResponse();
            response.setCode(code);
            response.setMessage(message);
            return response;
        };
        List deviceIdList = request.getDeviceId();
        if (deviceIdList == null || deviceIdList.isEmpty()) {
            return quickReturn.apply(BaseResponse.Fail, "\u66f4\u65b0\u7684ip\u5217\u8868\u4e3a\u7a7a");
        }
        Integer updateStatus = request.getStatus();
        if (updateStatus == null || !updateStatus.equals(12) && !updateStatus.equals(11) && !updateStatus.equals(21) && !updateStatus.equals(22)) {
            return quickReturn.apply(BaseResponse.Fail, "\u8f93\u5165\u72b6\u6001\u4e0d\u6b63\u786e!");
        }
        return this.configDeviceService.updateStatus(request);
    }
}

