/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.job;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xforceplus.seller.config.client.InvoiceApiClient;
import com.xforceplus.seller.config.common.ConstantValue;
import com.xforceplus.seller.config.job.CfgResult;
import com.xforceplus.seller.config.job.SendInvoiceMailService;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigMailRuleDao;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleExample;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.mail.MsAttachment;
import com.xforceplus.seller.config.util.mail.MsEmailRequest;
import com.xforceplus.seller.config.util.mail.MsMailResponse;
import com.xforceplus.seller.config.util.mail.SmsEmailClient;
import com.xforceplus.seller.invoice.client.model.JobSellerInvoiceModel;
import com.xforceplus.seller.invoice.client.model.JobSellerInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SendInvoiceMailService {
    private static final Logger log = LoggerFactory.getLogger(SendInvoiceMailService.class);
    @Autowired
    SmsEmailClient smsEmailClient;
    @Autowired
    CfgConfigDao cfgConfigDao;
    @Autowired
    CfgConfigMailRuleDao cfgConfigMailRuleDao;
    @Autowired
    InvoiceApiClient invoiceApiClient;
    @Value(value="${config.mail.daily.templateNo:AUTO_INVOICE_MAIL}")
    private String templateNo;

    public void dailyJob(String configId) {
        try {
            this.coreProcess(configId, true);
        }
        catch (Exception e) {
            log.error("@dailyJob exception: ", (Throwable)e);
        }
    }

    public void monthlyJob(String configId) {
        try {
            this.coreProcess(configId, false);
        }
        catch (Exception e) {
            log.error("@dailyJob exception: ", (Throwable)e);
        }
    }

    private void coreProcess(String configId, boolean isDaily) {
        CfgResult config = this.getCfgInfo(configId, isDaily);
        if (null == config) {
            return;
        }
        JobSellerInvoiceModel result = this.getSellerInvoice(config);
        Map keyByDatas = this.keyByInvoice(config, result);
        ArrayList outerReceivers = new ArrayList();
        if (config.getUseCustomAddress().booleanValue()) {
            config.getCustomMailList();
            if (!StringUtils.isEmpty((CharSequence)config.getCustomMailList())) {
                outerReceivers.addAll(Lists.newArrayList((Object[])config.getCustomMailList().split(";")));
            }
        }
        if (config.getPickUcAddress().booleanValue()) {
            // empty if block
        }
        for (Map.Entry entry : keyByDatas.entrySet()) {
            MsEmailRequest request = new MsEmailRequest();
            HashSet receiverSet = Sets.newHashSet();
            request.setTemplateCode(this.templateNo);
            ArrayList<MsAttachment> attaches = new ArrayList<MsAttachment>();
            log.info("@dailyJob print keyByGroup : " + (String)entry.getKey());
            Collection invoices = (Collection)entry.getValue();
            BigDecimal totalAmount = BigDecimal.ZERO;
            String seller = null;
            for (SellerInvoiceInfo invoice : invoices) {
                if (StringUtils.isEmpty(seller)) {
                    seller = invoice.getSellerName();
                }
                MsAttachment attachment = new MsAttachment();
                attachment.setDisplayName(invoice.getInvoiceCode());
                attachment.setFileUrl(invoice.getInvoiceUrl());
                attaches.add(attachment);
                if (config.getPickBizBillAddress().booleanValue()) {
                    receiverSet.add(invoice.getReceiveUserEmail());
                }
                totalAmount.add(invoice.getAmountWithTax());
            }
            ArrayList receivers = Lists.newArrayList((Iterable)receiverSet);
            receivers.addAll(outerReceivers);
            request.setReceivers((List)receivers);
            request.setAttachments(attaches);
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("sellerName", seller);
            prop.put("invoiceCount", invoices.size());
            prop.put("totalAmount", totalAmount.doubleValue());
            prop.put("startTime", DateUtil.dateToString((Date)config.getStartTime()));
            prop.put("endTime", DateUtil.dateToString((Date)config.getEndTime()));
            request.setProps(prop);
            this.sendMail(request);
        }
    }

    private Map<String, Collection<SellerInvoiceInfo>> keyByInvoice(CfgResult config, JobSellerInvoiceModel result) {
        List list = result.getList();
        1 keyByFunc = new /* Unavailable Anonymous Inner Class!! */;
        List vs = list;
        ImmutableListMultimap keyByMap = Multimaps.index((Iterable)list, (Function)keyByFunc);
        return keyByMap.asMap();
    }

    private JobSellerInvoiceModel getSellerInvoice(CfgResult config) {
        JobSellerInvoiceRequest request = new JobSellerInvoiceRequest();
        try {
            BeanUtils.copyProperties((Object)request, (Object)config);
        }
        catch (Exception e) {
            log.error("@dailyJob copyProp error: ", (Throwable)e);
        }
        return this.invoiceApiClient.querySellerInvoice(request);
    }

    private CfgResult getCfgInfo(String configId, boolean isDaily) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        cfgConfigExample.createCriteria().andConfigIdEqualTo(Long.valueOf(Long.parseLong(configId))).andStatusEqualTo(Byte.valueOf(ConstantValue.STATUS_ACTIVE.byteValue()));
        List configs = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return null;
        }
        CfgConfigEntity config = (CfgConfigEntity)configs.get(0);
        CfgConfigMailRuleExample mailExample = new CfgConfigMailRuleExample();
        mailExample.createCriteria().andConfigIdEqualTo(config.getConfigId()).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        List mailRule = this.cfgConfigMailRuleDao.selectByExample(mailExample);
        if (CollectionUtils.isEmpty((Collection)mailRule)) {
            return null;
        }
        CfgConfigMailRuleEntity mailRuleEntity = (CfgConfigMailRuleEntity)mailRule.get(0);
        String purTaxNo = config.getPurchaserTaxNo();
        String sellerTaxNo = config.getSellerTaxNo();
        String invoiceType = config.getInvoiceType();
        String billType = config.getSalesbillType();
        Long sellGroupId = config.getSellerGroupId();
        Long purchaserGroupId = config.getPurchaserGroupId();
        Date startTime = null;
        Date endTime = null;
        if (isDaily) {
            startTime = DateTools.getDate((String)mailRuleEntity.getSendTime(), (int)-1);
            endTime = DateTools.getDate((String)mailRuleEntity.getSendTime(), (int)0);
        } else {
            startTime = DateUtil.getFirstdayOfMonth((Date)DateUtil.addDays((Date)new Date(), (int)-3));
            endTime = DateUtil.getLastdayOfMonth((Date)DateUtil.addDays((Date)new Date(), (int)-3));
        }
        CfgResult cfgInfo = new CfgResult();
        cfgInfo.setPurTaxNo(purTaxNo);
        cfgInfo.setSellerTaxNo(sellerTaxNo);
        cfgInfo.setBillType(billType);
        cfgInfo.setInvoiceType(invoiceType);
        cfgInfo.setStartTime(startTime);
        cfgInfo.setEndTime(endTime);
        cfgInfo.setCombineType(mailRuleEntity.getCombineType());
        cfgInfo.setPickBizBillAddress(mailRuleEntity.getPickBizBillAddress());
        cfgInfo.setCustomMailList(mailRuleEntity.getCustomMailList());
        cfgInfo.setPickUcAddress(mailRuleEntity.getPickUcAddress());
        cfgInfo.setUseCustomAddress(mailRuleEntity.getUseCustomAddress());
        cfgInfo.setMailTemplateNo(mailRuleEntity.getMailTemplateNo());
        cfgInfo.setSellGroupId(sellGroupId);
        cfgInfo.setPurchaserGroupId(purchaserGroupId);
        return cfgInfo;
    }

    private boolean sendMail(MsEmailRequest request) {
        block4: {
            request.setAppId(Long.valueOf(20L));
            request.setSenderName("\u7968\u6613\u901a\u884c\u4e1a\u6807\u51c6\u5316\u5e73\u53f0");
            request.setSubject("\u7968\u6613\u901a\u6bcf\u65e5\u53d1\u7968\u6c47\u603b");
            request.setTenantId(Long.valueOf(0L));
            MsMailResponse response = null;
            try {
                response = this.smsEmailClient.sendEmail(Long.valueOf(0L), request);
                if (1 == response.getCode()) {
                    if (log.isInfoEnabled()) {
                        log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f, bean: {}", (Object)request);
                    }
                    return true;
                }
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25, bean: {}, response: {}", (Object)request, (Object)response);
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block4;
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25, bean: {}", (Object)request);
                log.error("\u5f02\u5e38\u8be6\u60c5: ", (Throwable)e);
            }
        }
        return false;
    }

    public JobSellerInvoiceModel getRes() {
        String str = "{\n    \"list\": [\n        {\n            \"id\": \"579638857558159360\",\n            \"preInvoiceId\": \"579638829850476546\",\n            \"batchNo\": \"579638825803116548\",\n            \"outBatchNo\": \"579638825803116548\",\n            \"salesbillId\": \"579638498118922242\",\n            \"salesbillNo\": \"AR-20200518195626-05\",\n            \"sellerTenantId\": \"0\",\n            \"sellerGroupId\": \"1203939049971830784\",\n            \"sellerNo\": \"\",\n            \"sellerId\": \"1235121917271887872\",\n            \"sellerCode\": \"\",\n            \"sellerName\": \"\u63a5\u53e3\u6d4b\u8bd5\u4e13\u7528\u9500\u9879\u516c\u53f8\",\n            \"sellerTaxNo\": \"915000007471504SSA\",\n            \"sellerTel\": \"0760-88812019\",\n            \"sellerAddress\": \"\u4e2d\u5c71\u5e02\u677f\u8299\u9547\u6cb3\u897f\u65b0\u533a\",\n            \"sellerBankName\": \"\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u4e2d\u5c71\u5e02\u5206\u884c\",\n            \"sellerBankAccount\": \"2011002509245126026\",\n            \"purchaserName\": \"\u63a5\u53e3\u6d4b\u8bd5\u4e13\u7528\u8fdb\u9879\u516c\u53f8\",\n            \"purchaserTenantId\": \"0\",\n            \"purchaserGroupId\": \"1203939049971830784\",\n            \"purchaserId\": \"1235124506734514176\",\n            \"purchaserNo\": \"\",\n            \"purchaserTaxNo\": \"915000007471504SSC\",\n            \"purchaserTel\": \"0755-25536074\",\n            \"purchaserAddress\": \"\u6df1\u5733\u5e02\u7f57\u6e56\u533a\u9ec4\u8d1d\u8857\u9053\u9ec4\u8d1d\u8def\u56fd\u5bb6\u52a8\u6f2b\u753b\u4ea7\u4e1a\u57fa\u5730\u52a8\u6f2b\u5927\u53a618\u5c42\",\n            \"purchaserBankName\": \"\u519c\u884c\u7f57\u6e56\u652f\u884c\",\n            \"purchaserBankAccount\": \"41-001200040001203\",\n            \"purchaserEPayId\": \"\",\n            \"invoiceType\": \"s\",\n            \"invoiceColor\": \"1\",\n            \"invoiceCode\": \"282223050351\",\n            \"invoiceNo\": \"20032896\",\n            \"machineCode\": \"20200307\",\n            \"terminalType\": 1,\n            \"paperDrawDate\": 1589731200000,\n            \"checkCode\": \"\",\n            \"cashierName\": \"\",\n            \"checkerName\": \"\",\n            \"invoicerName\": \"sell\",\n            \"remark\": \"\",\n            \"electronicSignature\": \"\",\n            \"invoiceOrigin\": \"0\",\n            \"systemOrig\": \"Test\",\n            \"specialInvoiceFlag\": \"0\",\n            \"billType\": \"\u6d4b\u8bd5\u4e1a\u52a1\u5355\u7c7b\u578b-GK\",\n            \"businessBillType\": \"AR\",\n            \"amountWithTax\": 105,\n            \"amountWithoutTax\": 100,\n            \"taxAmount\": 5,\n            \"taxRate\": \"0.05\",\n            \"originInvoiceNo\": \"\",\n            \"originInvoiceCode\": \"\",\n            \"cipherText\": \"4->6+896/+63/70/*911771125>278117*472><-7+093718-7/<<1-7+-8+40<<92/-63979/</58<53524<087517*472><-7+093771-3\",\n            \"cipherTextTwoCode\": \"\",\n            \"virtualFlag\": \"\",\n            \"abandonFlag\": \"0\",\n            \"redTime\": 1589803073038,\n            \"redFlag\": \"0\",\n            \"redNotificationNo\": \"\",\n            \"status\": 1,\n            \"matchedStatus\": 0,\n            \"saleListFileFlag\": 0,\n            \"printContentFlag\": 0,\n            \"displayPriceQality\": 0,\n            \"pdfPath\": \"\",\n            \"receiveUserEmail\": \"guojia@xforceplus.com\",\n            \"makeOutUnitName\": \"\",\n            \"handleStatus\": \"\",\n            \"handleRemark\": \"\",\n            \"outCheckStatus\": \"\",\n            \"lockFlag\": 0,\n            \"identifyStatus\": \"\",\n            \"printStatus\": \"0\",\n            \"retreatStatus\": \"\",\n            \"paymentStatus\": \"\",\n            \"makeOutUnitCode\": \"\",\n            \"createUserName\": \"sellerautotest\",\n            \"createTime\": 1589803072811,\n            \"createUserId\": \"0\",\n            \"updateTime\": 1589803073038,\n            \"updateUserId\": \"0\",\n            \"updateUserName\": \"\",\n            \"deposeUserName\": \"\",\n            \"deposeTime\": 1589731200000,\n            \"deposeUserId\": \"0\",\n            \"sysOrgId\": \"1235121917385072640\",\n            \"customerNo\": \"\",\n            \"invoiceUrl\": \"\",\n            \"ext1\": \"\",\n            \"ext2\": \"\",\n            \"ext3\": \"\",\n            \"ext4\": \"\",\n            \"ext5\": \"\",\n            \"ext6\": \"\",\n            \"ext7\": \"\",\n            \"ext8\": \"\",\n            \"ext9\": \"\",\n            \"ext10\": \"\",\n            \"ext11\": \"\",\n            \"ext12\": \"\",\n            \"ext13\": \"\",\n            \"ext14\": \"\",\n            \"ext15\": \"\",\n            \"ext16\": \"\",\n            \"ext17\": \"\",\n            \"ext18\": \"\",\n            \"ext19\": \"\",\n            \"ext20\": \"\",\n            \"ext21\": \"\",\n            \"ext22\": \"\",\n            \"ext23\": \"\",\n            \"ext24\": \"18001\",\n            \"ext25\": \"V03936\",\n            \"addressee\": \"\",\n            \"addresseeTel\": \"\",\n            \"addresseeProvince\": \"\",\n            \"addresseeCity\": \"\",\n            \"addresseeCounty\": \"\",\n            \"direction\": \"\",\n            \"logisticRemark\": \"\",\n            \"addresseeComp\": \"\",\n            \"addresseePost\": \"\",\n            \"auditType\": 0\n        },\n        {\n            \"id\": \"579638857751097344\",\n            \"preInvoiceId\": \"579638829074530304\",\n            \"batchNo\": \"579638825803116547\",\n            \"outBatchNo\": \"579638825803116547\",\n            \"salesbillId\": \"579638498156670978\",\n            \"salesbillNo\": \"AR-20200518195626-06\",\n            \"sellerTenantId\": \"0\",\n            \"sellerGroupId\": \"1203939049971830784\",\n            \"sellerNo\": \"\",\n            \"sellerId\": \"1235121917271887872\",\n            \"sellerCode\": \"\",\n            \"sellerName\": \"\u63a5\u53e3\u6d4b\u8bd5\u4e13\u7528\u9500\u9879\u516c\u53f8\",\n            \"sellerTaxNo\": \"915000007471504SSA\",\n            \"sellerTel\": \"0760-88812019\",\n            \"sellerAddress\": \"\u4e2d\u5c71\u5e02\u677f\u8299\u9547\u6cb3\u897f\u65b0\u533a\",\n            \"sellerBankName\": \"\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u4e2d\u5c71\u5e02\u5206\u884c\",\n            \"sellerBankAccount\": \"2011002509245126026\",\n            \"purchaserName\": \"\u63a5\u53e3\u6d4b\u8bd5\u4e13\u7528\u8fdb\u9879\u516c\u53f8\",\n            \"purchaserTenantId\": \"0\",\n            \"purchaserGroupId\": \"1203939049971830784\",\n            \"purchaserId\": \"1235124506734514176\",\n            \"purchaserNo\": \"\",\n            \"purchaserTaxNo\": \"915000007471504SSC\",\n            \"purchaserTel\": \"0755-25536074\",\n            \"purchaserAddress\": \"\u6df1\u5733\u5e02\u7f57\u6e56\u533a\u9ec4\u8d1d\u8857\u9053\u9ec4\u8d1d\u8def\u56fd\u5bb6\u52a8\u6f2b\u753b\u4ea7\u4e1a\u57fa\u5730\u52a8\u6f2b\u5927\u53a618\u5c42\",\n            \"purchaserBankName\": \"\u519c\u884c\u7f57\u6e56\u652f\u884c\",\n            \"purchaserBankAccount\": \"41-001200040001203\",\n            \"purchaserEPayId\": \"\",\n            \"invoiceType\": \"s\",\n            \"invoiceColor\": \"1\",\n            \"invoiceCode\": \"282223050351\",\n            \"invoiceNo\": \"20032897\",\n            \"machineCode\": \"20200307\",\n            \"terminalType\": 1,\n            \"paperDrawDate\": 1589731200000,\n            \"checkCode\": \"\",\n            \"cashierName\": \"\",\n            \"checkerName\": \"\",\n            \"invoicerName\": \"sell\",\n            \"remark\": \"\",\n            \"electronicSignature\": \"\",\n            \"invoiceOrigin\": \"0\",\n            \"systemOrig\": \"Test\",\n            \"specialInvoiceFlag\": \"0\",\n            \"billType\": \"\u6d4b\u8bd5\u4e1a\u52a1\u5355\u7c7b\u578b-GK\",\n            \"businessBillType\": \"AR\",\n            \"amountWithTax\": 105,\n            \"amountWithoutTax\": 100,\n            \"taxAmount\": 5,\n            \"taxRate\": \"0.05\",\n            \"originInvoiceNo\": \"\",\n            \"originInvoiceCode\": \"\",\n            \"cipherText\": \"4->6+896/+63/70/*911771125>278117*472><-7+093718-7/<<1-7+-8+40<<92/-63979/</58<53524<087517*472><-7+093771-3\",\n            \"cipherTextTwoCode\": \"\",\n            \"virtualFlag\": \"\",\n            \"abandonFlag\": \"0\",\n            \"redTime\": 1589803466705,\n            \"redFlag\": \"3\",\n            \"redNotificationNo\": \"1234123412341234\",\n            \"status\": 1,\n            \"matchedStatus\": 0,\n            \"saleListFileFlag\": 0,\n            \"printContentFlag\": 0,\n            \"displayPriceQality\": 0,\n            \"pdfPath\": \"\",\n            \"receiveUserEmail\": \"zhaominmin@xforceplus.com\",\n            \"makeOutUnitName\": \"\",\n            \"handleStatus\": \"1\",\n            \"handleRemark\": \"\",\n            \"outCheckStatus\": \"\",\n            \"lockFlag\": 0,\n            \"identifyStatus\": \"\",\n            \"printStatus\": \"0\",\n            \"retreatStatus\": \"\",\n            \"paymentStatus\": \"\",\n            \"makeOutUnitCode\": \"\",\n            \"createUserName\": \"sellerautotest\",\n            \"createTime\": 1589803072857,\n            \"createUserId\": \"0\",\n            \"updateTime\": 1589803466705,\n            \"updateUserId\": \"0\",\n            \"updateUserName\": \"\",\n            \"deposeUserName\": \"\",\n            \"deposeTime\": 1589803073039,\n            \"deposeUserId\": \"0\",\n            \"sysOrgId\": \"1235121917385072640\",\n            \"customerNo\": \"\",\n            \"invoiceUrl\": \"\",\n            \"ext1\": \"\",\n            \"ext2\": \"\",\n            \"ext3\": \"\",\n            \"ext4\": \"\",\n            \"ext5\": \"\",\n            \"ext6\": \"\",\n            \"ext7\": \"\",\n            \"ext8\": \"\",\n            \"ext9\": \"\",\n            \"ext10\": \"\",\n            \"ext11\": \"\",\n            \"ext12\": \"\",\n            \"ext13\": \"\",\n            \"ext14\": \"\",\n            \"ext15\": \"\",\n            \"ext16\": \"\",\n            \"ext17\": \"\",\n            \"ext18\": \"\",\n            \"ext19\": \"\",\n            \"ext20\": \"\",\n            \"ext21\": \"\",\n            \"ext22\": \"\",\n            \"ext23\": \"\",\n            \"ext24\": \"18001\",\n            \"ext25\": \"V03936\",\n            \"addressee\": \"\",\n            \"addresseeTel\": \"\",\n            \"addresseeProvince\": \"\",\n            \"addresseeCity\": \"\",\n            \"addresseeCounty\": \"\",\n            \"direction\": \"\",\n            \"logisticRemark\": \"\",\n            \"addresseeComp\": \"\",\n            \"addresseePost\": \"\",\n            \"auditType\": 0\n        }\n    ]\n}";
        JobSellerInvoiceModel model = (JobSellerInvoiceModel)JSON.parseObject((String)str, JobSellerInvoiceModel.class);
        return model;
    }
}

