/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.license.service.business.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.micro.tax.device.contract.model.AcquireLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.AcquireLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseResponse;
import com.xforceplus.seller.config.client.DeviceApiClient;
import com.xforceplus.seller.config.client.model.MsAcquireLicenseResponse;
import com.xforceplus.seller.config.client.model.MsAcquireLicenseResult;
import com.xforceplus.seller.config.client.model.MsConfigAcquireLicenseRequest;
import com.xforceplus.seller.config.client.model.MsConfigSendLicenseRequest;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.license.service.business.ConfigLicenseService;
import com.xforceplus.seller.config.proxy.DeviceApiProxy;
import com.xforceplus.seller.config.proxy.model.device.RestGetActiveResponse;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.xplatframework.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigLicenseServiceImpl
extends BaseConfigService
implements ConfigLicenseService {
    Logger logger = LoggerFactory.getLogger(ConfigLicenseServiceImpl.class);
    @Autowired
    private DeviceApiClient deviceApiClient;
    @Autowired
    DeviceApiProxy deviceApiProxy;

    public MsAcquireLicenseResponse acquireLicense(MsConfigAcquireLicenseRequest request) {
        this.logger.info("acquireLicense request:{}", (Object)JsonUtils.writeObjectToJson((Object)request));
        AcquireLicenseRequest destinationRequest = new AcquireLicenseRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        AcquireLicenseResponse sourceResponse = this.deviceApiClient.deviceLicenseAcquirePost(destinationRequest);
        this.logger.info("acquireLicense destinationRequest:{},sourceResponse:{}", (Object)JsonUtils.writeObjectToJson((Object)destinationRequest), (Object)JsonUtils.writeObjectToJson((Object)sourceResponse));
        if (!sourceResponse.getLicenseUrl().startsWith("https")) {
            sourceResponse.setLicenseUrl(sourceResponse.getLicenseUrl().replaceFirst("http", "https"));
        }
        this.logger.info("license download url is : {}", (Object)sourceResponse.getLicenseUrl());
        MsAcquireLicenseResponse response = new MsAcquireLicenseResponse();
        MsAcquireLicenseResult destinationResponse = new MsAcquireLicenseResult();
        BeanMapper.copy((Object)sourceResponse, (Object)destinationResponse);
        response.setResult(destinationResponse);
        response.setCode(sourceResponse.getHead().getCode());
        response.setMessage(sourceResponse.getHead().getMessage());
        return response;
    }

    public MsResponse sendLicense(MsConfigSendLicenseRequest request) {
        SendLicenseRequest destinationRequest = new SendLicenseRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        destinationRequest.setOperateInfo(this.getAddOperateInfo());
        this.logger.info("\u53d1\u9001\u6388\u6743\u6587\u4ef6\u7684\u8bf7\u6c42\u4e3a\uff1a{}", JSON.toJSON((Object)destinationRequest));
        SendLicenseResponse sourceResponse = this.deviceApiProxy.deviceLicenseSendPost(destinationRequest);
        this.logger.info("\u53d1\u9001\u6388\u6743\u6587\u4ef6\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{}", JSON.toJSON((Object)sourceResponse));
        MsResponse response = new MsResponse();
        response.setCode(sourceResponse.getHead().getCode());
        response.setMessage(sourceResponse.getHead().getMessage());
        return response;
    }

    public RestGetActiveResponse getActiveCode(String uns) {
        return this.deviceApiProxy.getActiveCode(uns);
    }
}

