/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.bizconfig.service.impl.ImportConfigServiceImpl;
import com.xforceplus.seller.config.listeners.model.PersonConfig;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(PersonConfigImportListener.class);
    @Autowired
    ImportConfigServiceImpl importConfigServiceImpl;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.person.config.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("configType", "4");
            logger.info("\u7968\u9762\u4eba\u89c4\u5219\u5bfc\u5165:{},,,header:{}", (Object)body, (Object)headers);
            List list = JsonUtils.writeFastJsonToListObject((String)body, PersonConfig.class);
            this.importConfigServiceImpl.importPersonConfig(list, headers);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7968\u9762\u4eba\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

