/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.bizconfig.service.impl.ImportConfigServiceImpl;
import com.xforceplus.seller.config.listeners.model.TitleConfig;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TitleConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(TitleConfigImportListener.class);
    @Autowired
    ImportConfigServiceImpl importConfigServiceImpl;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.title.config.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            logger.info("\u62ac\u5934\u89c4\u5219\u5bfc\u5165:{},,,header:{}", (Object)body, (Object)headers);
            headers.put("configType", "3");
            List list = JsonUtils.writeFastJsonToListObject((String)body, TitleConfig.class);
            this.importConfigServiceImpl.importTitleConfig(list, headers);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5f00\u7968\u62ac\u5934\u89c4\u5219\u5931\u8d25", (Throwable)e);
        }
    }
}

