/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.metadata.controller;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.cahe.LocalBssExternalCacheManager;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.MetaApi;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeMetaDataResponse;
import com.xforceplus.seller.config.client.model.MsGroupTypeResponse;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataDeleteRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataItemDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetaDataPageDTO;
import com.xforceplus.seller.config.client.model.MsMetaDataResponse;
import com.xforceplus.seller.config.client.model.MsMetaDataSummaryResponse;
import com.xforceplus.seller.config.client.model.MsMetadataItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMetadataItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetadataItemResponse;
import com.xforceplus.seller.config.client.model.MsQueryHighlightFieldListResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.common.UserCheckUtils;
import com.xforceplus.seller.config.metadata.service.ConfigMetaDataService;
import com.xforceplus.seller.config.metadata.service.vo.BusinessExtensionAttribute;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.translater.MetaDataObjTranslater;
import com.xforceplus.ucenter.external.client.model.GetUserInfoResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.base.BaseMicroController;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@MSApiV1SellerConfig
@RestController
public class MsConfigMetaDataController
extends BaseMicroController
implements MetaApi {
    @Autowired
    private ConfigMetaDataService configMetaDataService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private LocalBssExternalCacheManager localBssExternalCacheManager;

    public MsMetadataItemResponse batchQueryWithObjCodeFiledName(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataBatchQueryRequest mataDataBatchQueryRequest) {
        List msBusinessObjMetadataBeanList = this.configMetaDataService.batchQueryWithObjCodeFiledName(mataDataBatchQueryRequest);
        MsMetadataItemResponse response = new MsMetadataItemResponse();
        response.setCode(Response.OK);
        response.setResult(msBusinessObjMetadataBeanList);
        return response;
    }

    public MsResponse metaDataDelete(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u5220\u9664", required=true) @RequestBody MsMataDataDeleteRequestWithUserInfo mataDataDeleteRequest) {
        MsResponse response = new MsResponse();
        MsCommonUserInfo msCommonUserInfo = mataDataDeleteRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response;
        }
        try {
            this.configMetaDataService.deleteMetaData(mataDataDeleteRequest.getItems(), msCommonUserInfo);
            response.setCode(Response.OK);
            return response;
        }
        catch (RuntimeException e) {
            response.setCode(Response.Fail);
            response.setMessage(e.getMessage());
            return response;
        }
    }

    public MsMetaDataSummaryResponse metaDataSummary(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List msMetaDataSummaryDTOs = this.configMetaDataService.metaDataSummary(msMataDataQueryRequest);
        MsMetaDataSummaryResponse response = new MsMetaDataSummaryResponse();
        response.setCode(Response.OK);
        response.setResult(msMetaDataSummaryDTOs);
        return response;
    }

    public MsMetadataItemResponse queryEffctiveMetaData(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryEffectiveMetaDataList(mataDataQueryRequest);
        MsMetadataItemResponse response = new MsMetadataItemResponse();
        response.setCode(Response.OK);
        response.setResult(msBusinessObjMetadataBeanList);
        return response;
    }

    public MsMetadataItemResponse queryTemplateMetaData(@ApiParam(value="\u6a21\u677f\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryTemplateMetaDataList(mataDataQueryRequest);
        MsMetadataItemResponse response = new MsMetadataItemResponse();
        response.setCode(Response.OK);
        response.setResult(msBusinessObjMetadataBeanList);
        return response;
    }

    public MsGroupTypeMetaDataResponse queryGroupMetaDataWithObjType(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest groupId) {
        List result = this.configMetaDataService.queryMetaDataByObjType(groupId);
        MsGroupTypeMetaDataResponse msGroupTypeMetaDataResponse = new MsGroupTypeMetaDataResponse();
        msGroupTypeMetaDataResponse.setCode(Response.OK);
        msGroupTypeMetaDataResponse.setResult(result);
        return msGroupTypeMetaDataResponse;
    }

    public MsGroupTypeResponse queryAuthorizationBillTypeList(@ApiParam(value="\u67e5\u8be2\u5df2\u6388\u6743\u4e1a\u52a1\u5355\u7c7b\u578b\u5217\u8868\u4fe1\u606f", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List result = this.configMetaDataService.queryGroupObjType(msMataDataQueryRequest);
        MsGroupTypeResponse msGroupTypeResponse = new MsGroupTypeResponse();
        msGroupTypeResponse.setCode(Response.OK);
        this.logger.info("queryAuthorizationBillTypeList-result:{}", (Object)JsonUtils.writeObjectToFastJson((Object)result));
        if (CollectionUtils.isEmpty((Collection)result)) {
            msGroupTypeResponse.setResult(result);
            return msGroupTypeResponse;
        }
        this.logger.info("queryGroupObjType userInfoHolder {}", (Object)JsonUtils.writeObjectToFastJson((Object)this.userInfoHolder));
        if (Objects.isNull(this.userInfoHolder) || Objects.isNull(this.userInfoHolder.get())) {
            msGroupTypeResponse.setResult(result);
            return msGroupTypeResponse;
        }
        Set ownObjTypeSet = null;
        try {
            long userId = ((UserInfo)this.userInfoHolder.get()).getUserId();
            long groupId = msMataDataQueryRequest.getGroupId();
            GetUserInfoResponse userInfoResponse = this.localBssExternalCacheManager.getUserExtPermission(Long.valueOf(userId), Long.valueOf(groupId));
            if (userInfoResponse != null && Response.OK.equals(userInfoResponse.getCode())) {
                String businessExtensionAttribute = userInfoResponse.getResult().getBusinessExtensionAttribute();
                this.logger.info("queryGroupObjType businessExtensionAttribute {}", (Object)businessExtensionAttribute);
                if (Objects.nonNull(businessExtensionAttribute)) {
                    List myBusinessExtensionAttributeList = JsonUtils.writeJsonToListObject((String)businessExtensionAttribute, BusinessExtensionAttribute.class);
                    ownObjTypeSet = myBusinessExtensionAttributeList.stream().filter(Objects::nonNull).map(item -> item.getObjType()).collect(Collectors.toSet());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
        ArrayList filterResult = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(ownObjTypeSet) && !CollectionUtils.isEmpty((Collection)result)) {
            for (MsGroupTypeBean msGroupTypeBean : result) {
                if (!ownObjTypeSet.contains(msGroupTypeBean.getObjType())) continue;
                filterResult.add(msGroupTypeBean);
            }
        }
        msGroupTypeResponse.setResult((List)filterResult);
        return msGroupTypeResponse;
    }

    public MsGroupTypeResponse queryGroupObjType(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List result = this.configMetaDataService.queryGroupObjType(msMataDataQueryRequest);
        MsGroupTypeResponse msGroupTypeResponse = new MsGroupTypeResponse();
        msGroupTypeResponse.setCode(Response.OK);
        msGroupTypeResponse.setResult(result);
        return msGroupTypeResponse;
    }

    public MsMetaDataResponse queryMetaData(@ApiParam(value="\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        ArrayList<MsBusinessObjBean> msBusinessObjBeans = new ArrayList<MsBusinessObjBean>();
        for (CfgBusinessObjEntity tmp : cfgBusinessObjEntities) {
            MsBusinessObjBean msBusinessObjBean = MetaDataObjTranslater.convertFromConfigEntity((CfgBusinessObjEntity)tmp);
            msBusinessObjBeans.add(msBusinessObjBean);
        }
        MsMetaDataPageDTO msMetaDataPageDTO = new MsMetaDataPageDTO();
        msMetaDataPageDTO.setResult(msBusinessObjBeans);
        Long count = this.configMetaDataService.queryMetaDataCount(mataDataQueryRequest);
        msMetaDataPageDTO.setTotal(Integer.valueOf(count.intValue()));
        msMetaDataPageDTO.setPageNo(mataDataQueryRequest.getPageNo());
        MsMetaDataResponse response = new MsMetaDataResponse();
        response.setResult(msMetaDataPageDTO);
        response.setCode(Response.OK);
        return response;
    }

    public MsMetadataItemResponse queryMetaDataItem(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMetadataItemQueryRequest metadataItemQueryRequest) {
        this.logger.info("queryMetaDataItem metadataItemQueryRequest==========={}", (Object)JsonUtils.writeObjectToFastJson((Object)metadataItemQueryRequest));
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryMetaDataItemListByObjId(metadataItemQueryRequest);
        this.logger.debug("queryMetaDataItem msBusinessObjMetadataBeanList==========={}", (Object)JsonUtils.writeObjectToFastJson((Object)msBusinessObjMetadataBeanList));
        MsMetadataItemResponse msMetadataItemResponse = new MsMetadataItemResponse();
        msMetadataItemResponse.setCode(Response.OK);
        msMetadataItemResponse.setResult(msBusinessObjMetadataBeanList);
        return msMetadataItemResponse;
    }

    public MsResponse saveMetaData(@ApiParam(value="\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58", required=true) @RequestBody MsMataDataAddRequestWithUserInfo mataDataAddRequest) {
        MsResponse response = new MsResponse();
        MsCommonUserInfo msCommonUserInfo = mataDataAddRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55.");
            return response;
        }
        try {
            int isOk = this.configMetaDataService.addMetaObjData(mataDataAddRequest);
            if (isOk == Response.OK) {
                response.setCode(Response.OK);
            } else {
                response.setCode(Response.Fail);
                response.setMessage("\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58\u5931\u8d25.");
            }
        }
        catch (Exception e) {
            response.setCode(Response.Fail);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    public MsResponse saveMetaDataItem(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMetadataItemAddRequestWithUserInfo metadataItemAddRequest) {
        MsResponse msResponse = new MsResponse();
        MsCommonUserInfo userInfo = metadataItemAddRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)userInfo)) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return msResponse;
        }
        this.configMetaDataService.addMetaDataItem(metadataItemAddRequest);
        msResponse.setCode(Response.OK);
        return msResponse;
    }

    public MsQueryHighlightFieldListResponse queryHighlightFieldList(@NotNull @ApiParam(value="\u6a21\u677f\u7f16\u7801", required=true) @RequestParam(value="objCode", required=true) String objCode, @NotNull @ApiParam(value="\u5355\u636e\u5bf9\u8c61\u7c7b\u578b", required=true) @RequestParam(value="objType", required=true) String objType, @ApiParam(value="\u96c6\u56e2id") @RequestParam(value="groupId", required=false) Long groupId) {
        if (Objects.isNull(groupId) || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        }
        List msHighlightFieldDTOList = this.configMetaDataService.queryHighlightFieldList(objCode, objType, groupId);
        MsQueryHighlightFieldListResponse msQueryHighlightFieldListResponse = new MsQueryHighlightFieldListResponse();
        msQueryHighlightFieldListResponse.setCode(Response.OK);
        msQueryHighlightFieldListResponse.setMessage("ok");
        msQueryHighlightFieldListResponse.setResult(msHighlightFieldDTOList);
        return msQueryHighlightFieldListResponse;
    }

    public Response queryMetaObjMetadata(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataItemDataQueryRequest msMataItemDataQueryRequest) {
        Long groupId = msMataItemDataQueryRequest.getGroupId();
        if (groupId == null) {
            msMataItemDataQueryRequest.setGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        }
        return this.configMetaDataService.queryMetaObjMetadata(msMataItemDataQueryRequest);
    }

    public Response addOrUpdateMetaObjData(@ApiParam(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u5143\u6570\u636e\u5bf9\u8c61", required=true) @RequestBody MsBusinessObjBean msBusinessObjBean) {
        Long groupId = msBusinessObjBean.getGroupId();
        Long userId = null;
        if (groupId == null) {
            msBusinessObjBean.setGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
            userId = ((UserInfo)this.userInfoHolder.get()).getUserId();
        }
        return this.configMetaDataService.addOrUpdateMetaObjData(msBusinessObjBean, userId);
    }

    public MsGroupTypeResponse queryGroupObjType4local(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest groupId) {
        List result = this.configMetaDataService.queryGroupObjType(groupId);
        MsGroupTypeResponse msGroupTypeResponse = new MsGroupTypeResponse();
        msGroupTypeResponse.setCode(Response.OK);
        msGroupTypeResponse.setResult(result);
        return msGroupTypeResponse;
    }
}

