/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.metadata.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.BillConfigRequest;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.BillConfigClient;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.DisplayTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.FieldGroup;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeMetaDataDTO;
import com.xforceplus.seller.config.client.model.MsHighlightBean;
import com.xforceplus.seller.config.client.model.MsHighlightFieldDTO;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataItemDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetaDataSummaryDTO;
import com.xforceplus.seller.config.client.model.MsMetadataItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMetadataItemQueryRequest;
import com.xforceplus.seller.config.common.ObjCodeExtEnum;
import com.xforceplus.seller.config.exception.ConfigMetaDataEnumRepeatException;
import com.xforceplus.seller.config.exception.ConfigMetaDataItemNullException;
import com.xforceplus.seller.config.exception.ConfigMetaDataRepeatException;
import com.xforceplus.seller.config.exception.ConfigMetaExistException;
import com.xforceplus.seller.config.exception.ConfigUpdateExpireException;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjMetadataDao;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjMetadataExtDao;
import com.xforceplus.seller.config.repository.dao.CfgCodesetDao;
import com.xforceplus.seller.config.repository.dao.CfgCodesetItemDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigHistoryDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjMetadataDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjExample;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExample;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExtEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExtExample;
import com.xforceplus.seller.config.repository.model.CfgCodesetEntity;
import com.xforceplus.seller.config.repository.model.CfgCodesetExample;
import com.xforceplus.seller.config.repository.model.CfgCodesetItemEntity;
import com.xforceplus.seller.config.repository.model.CfgCodesetItemExample;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigHistoryEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataExample;
import com.xforceplus.seller.config.translater.ConfigTmpEntityTranslater;
import com.xforceplus.seller.config.translater.MetaDataExampleTranslater;
import com.xforceplus.seller.config.translater.MetaDataObjTranslater;
import com.xforceplus.seller.config.translater.MetaDataTranslater;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigMetaDataService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMetaDataService.class);
    private final String[] needExtFields = new String[]{"mergerCondition", "associationCondition", "splitFiledList", "invoiceLimit"};
    private final String[] remarkeedExtFields = new String[]{"invoiceRemarkFiledList", "invoiceItemRemarkFiledList"};
    private final String[] filterExtObjCode = new String[]{"billFilter", "invoiceFilter", "preInvoiceFilter"};
    private CfgBusinessObjDao cfgBusinessObjDao;
    private CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao;
    private CfgTemplateObjDao cfgTemplateObjDao;
    private CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao;
    private CfgConfigHistoryDao cfgConfigHistoryDao;
    private CfgCodesetDao cfgCodesetDao;
    private CfgCodesetItemDao cfgCodesetItemDao;
    private CfgConfigDao cfgConfigDao;
    private BillConfigClient billConfigClient;
    private IDGenerator generator;
    private CfgBusinessObjMetadataExtDao cfgBusinessObjMetadataExtDao;

    @Autowired
    public ConfigMetaDataService(CfgBusinessObjDao cfgBusinessObjDao, CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao, CfgTemplateObjDao cfgTemplateObjDao, CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao, CfgConfigHistoryDao cfgConfigHistoryDao, CfgCodesetDao cfgCodesetDao, CfgCodesetItemDao cfgCodesetItemDao, CfgConfigDao cfgConfigDao, BillConfigClient billConfigClient, IDGenerator generator, CfgBusinessObjMetadataExtDao cfgBusinessObjMetadataExtDao) {
        this.cfgBusinessObjDao = cfgBusinessObjDao;
        this.cfgBusinessObjMetadataDao = cfgBusinessObjMetadataDao;
        this.cfgTemplateObjDao = cfgTemplateObjDao;
        this.cfgTemplateObjMetadataDao = cfgTemplateObjMetadataDao;
        this.cfgConfigHistoryDao = cfgConfigHistoryDao;
        this.cfgCodesetDao = cfgCodesetDao;
        this.cfgCodesetItemDao = cfgCodesetItemDao;
        this.cfgConfigDao = cfgConfigDao;
        this.billConfigClient = billConfigClient;
        this.generator = generator;
        this.cfgBusinessObjMetadataExtDao = cfgBusinessObjMetadataExtDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public int addMetaObjData(MsMataDataAddRequestWithUserInfo msMataDataAddRequestWithUserInfo) {
        List businessObjBeans = msMataDataAddRequestWithUserInfo.getItemDTOList();
        logger.info("businessObjBeans---->:{}", (Object)JsonUtils.writeObjectToFastJson((Object)businessObjBeans));
        MsCommonUserInfo userInfo = msMataDataAddRequestWithUserInfo.getUserInfo();
        if (CollectionUtils.isEmpty((Collection)businessObjBeans)) {
            return 0;
        }
        for (MsBusinessObjBean businessObjBean : businessObjBeans) {
            int operationRet;
            CfgBusinessObjEntity entity = MetaDataObjTranslater.convertFromMsBusinessObjBean((MsBusinessObjBean)businessObjBean, (MsCommonUserInfo)userInfo);
            Long id = entity.getBusinessObjId();
            if (id == null || id == 0L) {
                boolean isExist = this.checkObjNameExist(businessObjBean.getObjCode(), businessObjBean.getObjName(), userInfo.getGroupId());
                if (!isExist) {
                    throw new ConfigMetaExistException();
                }
                id = this.generator.nextId();
                entity.setBusinessObjId(id);
                entity.setObjStatus(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
                entity.setCreateTime(entity.getUpdateTime());
                entity.setCreateUser(userInfo.getUserId());
                operationRet = this.cfgBusinessObjDao.insertSelective(entity);
            } else {
                operationRet = this.cfgBusinessObjDao.updateByPrimaryKeySelective(entity);
            }
            if (operationRet <= 0) {
                throw new ConfigMetaExistException();
            }
            List msBusinessObjMetadataBeans = businessObjBean.getItems();
            logger.info("msBusinessObjMetadataBeans---->:{}", (Object)JsonUtils.writeObjectToFastJson((Object)businessObjBeans));
            this.checkMetaItem(msBusinessObjMetadataBeans);
            if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeans)) continue;
            MsMetadataItemAddRequestWithUserInfo msMetadataItemAddRequest = new MsMetadataItemAddRequestWithUserInfo();
            msMetadataItemAddRequest.setItemDTOList(msBusinessObjMetadataBeans);
            msMetadataItemAddRequest.setObjId(id);
            msMetadataItemAddRequest.setUserInfo(userInfo);
            int addRet = this.addMetaDataItem(msMetadataItemAddRequest);
            logger.info("addMetaDataItem----->:{}", (Object)addRet);
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public Response addOrUpdateMetaObjData(MsBusinessObjBean msBusinessObjBean, Long userId) {
        List msBusinessObjMetadataBeanList;
        Long businessObjId = msBusinessObjBean.getBusinessObjId();
        if (businessObjId == null) {
            CfgBusinessObjEntity entity = new CfgBusinessObjEntity();
            businessObjId = this.generator.nextId();
            entity.setBusinessObjId(businessObjId);
            entity.setObjCode(msBusinessObjBean.getObjCode());
            entity.setObjName(msBusinessObjBean.getObjName());
            entity.setObjType(msBusinessObjBean.getObjType());
            entity.setObjDesc(msBusinessObjBean.getObjDesc());
            entity.setObjStatus(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            entity.setCreateTime(entity.getUpdateTime());
            entity.setCreateUser(userId);
            this.cfgBusinessObjDao.insertSelective(entity);
        }
        if ((msBusinessObjMetadataBeanList = msBusinessObjBean.getItems()) == null) {
            return Response.ok((String)"");
        }
        for (MsBusinessObjMetadataBean msBusinessObjMetadataBean : msBusinessObjMetadataBeanList) {
            Long businessObjMetadataId = msBusinessObjMetadataBean.getBusinessObjMetadataId();
            if (businessObjMetadataId == null) {
                CfgBusinessObjMetadataEntity insert = new CfgBusinessObjMetadataEntity();
                BeanUtils.copyProperties((Object)msBusinessObjMetadataBean, (Object)insert);
                insert.setBusinessObjMetadataId(Long.valueOf(this.generator.nextId()));
                insert.setBusinessObjId(businessObjId);
                insert.setFieldType(insert.getFieldType() == null ? "s" : insert.getFieldType());
                insert.setFieldQueryType(insert.getFieldQueryType() == null ? "eq" : insert.getFieldQueryType());
                this.cfgBusinessObjMetadataDao.insertSelective(insert);
                continue;
            }
            CfgBusinessObjMetadataEntity update = new CfgBusinessObjMetadataEntity();
            update.setBusinessObjMetadataId(businessObjMetadataId);
            update.setFieldSort(msBusinessObjMetadataBean.getFieldSort());
            update.setFieldVisible(msBusinessObjMetadataBean.getFieldVisible());
            this.cfgBusinessObjMetadataDao.updateByPrimaryKeySelective(update);
        }
        return Response.ok((String)"");
    }

    public List<CfgBusinessObjEntity> queryMetaDataList(MsMataDataQueryRequest cfgBusinessObjRequest) {
        CfgBusinessObjExample cfgBusinessObjExample = MetaDataExampleTranslater.createExampleByRequest((MsMataDataQueryRequest)cfgBusinessObjRequest);
        cfgBusinessObjExample.setLimit(cfgBusinessObjRequest.getPageSize());
        cfgBusinessObjExample.setOffset(this.getOffset(cfgBusinessObjRequest));
        return this.cfgBusinessObjDao.selectByExample(cfgBusinessObjExample);
    }

    public Long queryMetaDataCount(MsMataDataQueryRequest cfgBusinessObjRequest) {
        CfgBusinessObjExample cfgBusinessObjExample = MetaDataExampleTranslater.createExampleByRequest((MsMataDataQueryRequest)cfgBusinessObjRequest);
        return this.cfgBusinessObjDao.countByExample(cfgBusinessObjExample);
    }

    public List<MsBusinessObjMetadataBean> queryEffectiveMetaDataList(MsMataDataQueryRequest cfgBusinessObjRequest) {
        List<MsBusinessObjMetadataBean> msBusinessObjMetadataBeanList;
        block24: {
            Long groupId;
            String objCode;
            block23: {
                String objType = cfgBusinessObjRequest.getObjType();
                objCode = cfgBusinessObjRequest.getObjCode();
                groupId = cfgBusinessObjRequest.getGroupId();
                String ext1 = cfgBusinessObjRequest.getExt1();
                String ext2 = cfgBusinessObjRequest.getExt2();
                logger.info("queryEffectiveMetadataList======groupId:{},objCode:{},ext1:{},objType:{}", new Object[]{groupId, objCode, ext1, objType});
                if (StringUtils.isEmpty((CharSequence)objCode)) {
                    return Lists.newArrayList();
                }
                String objCodeExt = objCode;
                if (!StringUtils.isEmpty((CharSequence)ext1)) {
                    ObjCodeExtEnum objCodeExtEnum = ObjCodeExtEnum.getValueByObjCode((String)objCode, (String)ext1);
                    if (null == objCodeExtEnum) {
                        return Lists.newArrayList();
                    }
                    objCodeExt = objCodeExtEnum.getObjCodeExt();
                }
                msBusinessObjMetadataBeanList = Lists.newArrayList();
                if ((CommonTools.isEmpty((String)ext2) || "1".equals(ext2)) && !CollectionUtils.isEmpty((Collection)(msBusinessObjMetadataBeanList = this.queryCustomCfgBusinessObjMetadataList(groupId, objCodeExt, objType, true, (List)Lists.newArrayList())))) {
                    return msBusinessObjMetadataBeanList;
                }
                msBusinessObjMetadataBeanList = this.queryTemplateObjMetadataListByCodeAndType(objCodeExt, objType);
                if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeanList)) {
                    return Lists.newArrayList();
                }
                if (StringUtils.isEmpty((CharSequence)objType)) break block23;
                List custObjMetaEntities = this.queryCustomCfgBusinessObjMetadataByGroupIdAndObjType(groupId, objType);
                List customMsEnumBeanList = "mergeRule".equals(objCode) ? this.convertCfgBusinessObjMetadata2MsEnumBean(custObjMetaEntities, false) : this.convertCfgBusinessObjMetadata2MsEnumBean(custObjMetaEntities, true);
                if (!CollectionUtils.isEmpty((Collection)customMsEnumBeanList)) {
                    msBusinessObjMetadataBeanList.forEach(msBusinessObjMetadataBean -> this.fillMsBusinessObjMetadataBean(msBusinessObjMetadataBean, customMsEnumBeanList));
                    MsBusinessObjMetadataBean invoiceRemarkBean = null;
                    MsBusinessObjMetadataBean invoiceItemRemarkBean = null;
                    MsBusinessObjMetadataBean goodsServicesNameMainBean = null;
                    MsBusinessObjMetadataBean goodsServicesNameBean = null;
                    MsBusinessObjMetadataBean itemSpecMainBean = null;
                    MsBusinessObjMetadataBean itemSpecBean = null;
                    for (MsBusinessObjMetadataBean msBusinessObjMetadataBean2 : msBusinessObjMetadataBeanList) {
                        if ("invoiceRemarkFiledList".equals(msBusinessObjMetadataBean2.getFieldName())) {
                            invoiceRemarkBean = msBusinessObjMetadataBean2;
                        }
                        if ("invoiceItemRemarkFiledList".equals(msBusinessObjMetadataBean2.getFieldName())) {
                            invoiceItemRemarkBean = msBusinessObjMetadataBean2;
                        }
                        if ("goodsServicesNameFieldsList".equals(msBusinessObjMetadataBean2.getFieldName())) {
                            goodsServicesNameBean = msBusinessObjMetadataBean2;
                        }
                        if ("goodsServicesNameMainFieldsList".equals(msBusinessObjMetadataBean2.getFieldName())) {
                            goodsServicesNameMainBean = msBusinessObjMetadataBean2;
                        }
                        if ("itemSpecFieldsList".equals(msBusinessObjMetadataBean2.getFieldName())) {
                            itemSpecBean = msBusinessObjMetadataBean2;
                        }
                        if (!"itemSpecMainFieldsList".equals(msBusinessObjMetadataBean2.getFieldName())) continue;
                        itemSpecMainBean = msBusinessObjMetadataBean2;
                    }
                    if (invoiceRemarkBean != null) {
                        if (goodsServicesNameMainBean != null) {
                            goodsServicesNameMainBean.setFieldEnumValue(invoiceRemarkBean.getFieldEnumValue());
                        }
                        if (itemSpecMainBean != null) {
                            itemSpecMainBean.setFieldEnumValue(invoiceRemarkBean.getFieldEnumValue());
                        }
                    }
                    if (invoiceItemRemarkBean != null) {
                        if (goodsServicesNameBean != null) {
                            goodsServicesNameBean.setFieldEnumValue(invoiceItemRemarkBean.getFieldEnumValue());
                        }
                        if (itemSpecBean != null) {
                            itemSpecBean.setFieldEnumValue(invoiceItemRemarkBean.getFieldEnumValue());
                        }
                    }
                }
                if (!Arrays.asList(this.filterExtObjCode).contains(objCode) || custObjMetaEntities == null) break block24;
                for (int i = 0; i < custObjMetaEntities.size(); ++i) {
                    MsBusinessObjMetadataBean entity = (MsBusinessObjMetadataBean)custObjMetaEntities.get(i);
                    if (entity.getFieldGroupIndex() == 0) {
                        msBusinessObjMetadataBeanList.add(entity);
                        continue;
                    }
                    entity.setFieldName(entity.getFieldName() + ",");
                    msBusinessObjMetadataBeanList.add(entity);
                }
                break block24;
            }
            if (Arrays.asList(this.filterExtObjCode).contains(objCode)) {
                CfgBusinessObjExample objExample = new CfgBusinessObjExample();
                objExample.createCriteria().andGroupIdEqualTo(groupId).andObjStatusEqualTo(Byte.valueOf((byte)1));
                List cfgBusinessObjEntities = this.cfgBusinessObjDao.selectByExample(objExample);
                for (int i = 0; i < cfgBusinessObjEntities.size(); ++i) {
                    CfgBusinessObjEntity businessObjEntity = (CfgBusinessObjEntity)cfgBusinessObjEntities.get(i);
                    CfgBusinessObjMetadataExample example = new CfgBusinessObjMetadataExample();
                    example.createCriteria().andBusinessObjIdEqualTo(businessObjEntity.getBusinessObjId()).andFixedEqualTo(Integer.valueOf(0)).andFieldGroupIndexEqualTo(Integer.valueOf(0));
                    List cfgBusinessObjMetadataEntities = this.cfgBusinessObjMetadataDao.selectByExample(example);
                    ArrayList objMetadataBeanList = Lists.newArrayList();
                    Map cfgBusinessObjMetadataExtEntityMap = this.queryMetaDataItemExtListByBusinessObjId(businessObjEntity.getBusinessObjId());
                    for (CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity : cfgBusinessObjMetadataEntities) {
                        MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntity, (CfgBusinessObjMetadataExtEntity)((CfgBusinessObjMetadataExtEntity)cfgBusinessObjMetadataExtEntityMap.get(cfgBusinessObjMetadataEntity.getBusinessObjMetadataId())));
                        this.fillFieldEnumValue(msBusinessObjBean, businessObjEntity.getBusinessObjId());
                        objMetadataBeanList.add(msBusinessObjBean);
                    }
                    objMetadataBeanList.forEach(item -> {
                        item.setFieldName(businessObjEntity.getObjName() + "-" + item.getFieldName());
                        item.setFieldDisplayName(businessObjEntity.getObjName() + "-" + item.getFieldDisplayName());
                    });
                    msBusinessObjMetadataBeanList.addAll(objMetadataBeanList);
                }
            }
        }
        return msBusinessObjMetadataBeanList;
    }

    public List<MsBusinessObjMetadataBean> queryTemplateMetaDataList(MsMataDataQueryRequest cfgBusinessObjRequest) {
        String objCode = cfgBusinessObjRequest.getObjCode();
        String objType = cfgBusinessObjRequest.getObjType();
        Long groupId = cfgBusinessObjRequest.getGroupId();
        logger.info("queryTemplateMetaDataList objCode:{},objType:{}, groupId:{}", new Object[]{objCode, objType, groupId});
        List msBusinessObjMetadataBeanList = this.queryTemplateObjMetadataListByCodeAndType(objCode, objType);
        if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeanList)) {
            return Lists.newArrayList();
        }
        return msBusinessObjMetadataBeanList;
    }

    public List<MsBusinessObjMetadataBean> queryCustomCfgBusinessObjMetadataList(Long groupId, String objCode, String objType, boolean isFixed, List<Integer> fieldGroupIndexs) {
        logger.info("queryCustomCfgBusinessObjMetadataList groupId-objCode-objType-isFixed:{}, {},{}, {}", new Object[]{groupId, objCode, objType, isFixed});
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        CfgBusinessObjExample.Criteria criteria = cfgBusinessObjExample.createCriteria();
        criteria.andGroupIdEqualTo(groupId);
        if (!CommonTools.isEmpty((String)objCode)) {
            criteria.andObjCodeEqualTo(objCode);
        }
        if (!StringUtils.isEmpty((CharSequence)objType)) {
            criteria.andObjTypeEqualTo(objType);
        }
        criteria.andObjStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
        ArrayList msBusinessObjBeanList = Lists.newArrayList();
        if (null != cfgBusinessObjEntity) {
            CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
            CfgBusinessObjMetadataExample.Criteria metadataCriteria = cfgBusinessObjMetadataExample.createCriteria();
            metadataCriteria.andBusinessObjIdEqualTo(cfgBusinessObjEntity.getBusinessObjId());
            if (fieldGroupIndexs != null && !fieldGroupIndexs.isEmpty()) {
                metadataCriteria.andFieldGroupIndexIn(fieldGroupIndexs);
            }
            if (!isFixed) {
                metadataCriteria.andFixedEqualTo(Integer.valueOf(0));
            }
            List cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
            Map cfgBusinessObjMetadataExtEntityMap = this.queryMetaDataItemExtListByBusinessObjId(cfgBusinessObjEntity.getBusinessObjId());
            for (CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity : cfgBusinessObjMetadataEntityList) {
                MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntity, (CfgBusinessObjMetadataExtEntity)((CfgBusinessObjMetadataExtEntity)cfgBusinessObjMetadataExtEntityMap.get(cfgBusinessObjMetadataEntity.getBusinessObjMetadataId())));
                this.fillFieldEnumValue(msBusinessObjBean, cfgBusinessObjEntity.getBusinessObjId());
                msBusinessObjBeanList.add(msBusinessObjBean);
            }
        }
        return msBusinessObjBeanList;
    }

    public int addMetaDataItem(MsMetadataItemAddRequestWithUserInfo msMetadataItemAddRequest) {
        List entities = msMetadataItemAddRequest.getItemDTOList();
        Long id = msMetadataItemAddRequest.getObjId();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return 0;
        }
        if (!this.updateExistConfigItem(entities, id, msMetadataItemAddRequest.getUpdateTime(), msMetadataItemAddRequest.getUserInfo())) {
            return 1;
        }
        return 1;
    }

    public List<MsGroupTypeMetaDataDTO> queryMetaDataByObjType(MsMataDataQueryRequest msMataDataQueryRequest) {
        logger.info("msMataDataQueryRequest--------:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msMataDataQueryRequest));
        List objTypeList = this.queryGroupObjType(msMataDataQueryRequest);
        ArrayList<MsGroupTypeMetaDataDTO> result = new ArrayList<MsGroupTypeMetaDataDTO>();
        for (MsGroupTypeBean objType : objTypeList) {
            MsGroupTypeMetaDataDTO groupTypeMetaDataDTO = new MsGroupTypeMetaDataDTO();
            String objCodeExt = msMataDataQueryRequest.getObjCode();
            if (!StringUtils.isEmpty((CharSequence)msMataDataQueryRequest.getExt1())) {
                ObjCodeExtEnum objCodeExtEnum = ObjCodeExtEnum.getValueByObjCode((String)msMataDataQueryRequest.getObjCode(), (String)msMataDataQueryRequest.getExt1());
                if (null == objCodeExtEnum) {
                    return Lists.newArrayList();
                }
                objCodeExt = objCodeExtEnum.getObjCodeExt();
            }
            List msBusinessObjMetadataBeanList = this.queryCustomCfgBusinessObjMetadataList(msMataDataQueryRequest.getGroupId(), objCodeExt, objType.getObjType(), false, (List)Lists.newArrayList());
            groupTypeMetaDataDTO.setObjType(objType.getObjType());
            groupTypeMetaDataDTO.setMetaList(msBusinessObjMetadataBeanList);
            result.add(groupTypeMetaDataDTO);
        }
        logger.info("msMataDataQueryRequest-result:{}", (Object)JsonUtils.writeObjectToFastJson(result));
        return result;
    }

    public List<MsGroupTypeBean> queryGroupObjType(MsMataDataQueryRequest msMataDataQueryRequest) {
        msMataDataQueryRequest.setObjStatus(StatusEnum.NORMAL.getStatus());
        List cfgBusinessObjEntities = this.queryMetaDataList(msMataDataQueryRequest);
        logger.debug("objTypeRequest is {},objTypeResult:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msMataDataQueryRequest), (Object)JsonUtils.writeObjectToFastJson((Object)cfgBusinessObjEntities));
        return cfgBusinessObjEntities.stream().filter(Objects::nonNull).map(entry -> {
            MsGroupTypeBean msGroupTypeBean = new MsGroupTypeBean();
            msGroupTypeBean.setObjId(String.valueOf(entry.getBusinessObjId()));
            msGroupTypeBean.setObjType(entry.getObjName());
            return msGroupTypeBean;
        }).collect(Collectors.toList());
    }

    public List<MsBusinessObjMetadataBean> queryMetaDataItemListByObjId(MsMetadataItemQueryRequest cfgBusinessObjMetadataRequest) {
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectByPrimaryKey(cfgBusinessObjMetadataRequest.getBusinessObjId());
        if (cfgBusinessObjEntity == null) {
            return Lists.newArrayList();
        }
        List cfgBusinessObjMetadataEntityList = this.queryMetaDataItemListByBusinessObjId(cfgBusinessObjEntity.getBusinessObjId());
        logger.info("queryMetaDataItemListByObjId cfgBusinessObjMetadataEntityList==========={}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgBusinessObjMetadataEntityList));
        Map cfgBusinessObjMetadataExtEntityMap = this.queryMetaDataItemExtListByBusinessObjId(cfgBusinessObjEntity.getBusinessObjId());
        logger.debug("queryMetaDataItemListByObjId cfgBusinessObjMetadataExtEntityMap==========={}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgBusinessObjMetadataExtEntityMap));
        ArrayList msBusinessObjBeanList = Lists.newArrayList();
        for (CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity : cfgBusinessObjMetadataEntityList) {
            MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntity, (CfgBusinessObjMetadataExtEntity)((CfgBusinessObjMetadataExtEntity)cfgBusinessObjMetadataExtEntityMap.get(cfgBusinessObjMetadataEntity.getBusinessObjMetadataId())));
            this.fillFieldEnumValue(msBusinessObjBean, cfgBusinessObjEntity.getBusinessObjId());
            msBusinessObjBeanList.add(msBusinessObjBean);
        }
        return msBusinessObjBeanList;
    }

    private List<CfgBusinessObjMetadataEntity> queryMetaDataItemListByBusinessObjId(Long businessObjId) {
        CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
        CfgBusinessObjMetadataExample.Criteria criteria = cfgBusinessObjMetadataExample.createCriteria();
        criteria.andBusinessObjIdEqualTo(businessObjId);
        List cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
        return cfgBusinessObjMetadataEntityList;
    }

    private Map<Long, CfgBusinessObjMetadataExtEntity> queryMetaDataItemExtListByBusinessObjId(Long businessObjId) {
        CfgBusinessObjMetadataExtExample cfgBusinessObjMetadataExtExample = new CfgBusinessObjMetadataExtExample();
        CfgBusinessObjMetadataExtExample.Criteria criteria = cfgBusinessObjMetadataExtExample.createCriteria();
        criteria.andBusinessObjIdEqualTo(businessObjId);
        List cfgBusinessObjMetadataExtEntityList = this.cfgBusinessObjMetadataExtDao.selectByExample(cfgBusinessObjMetadataExtExample);
        Map<Long, CfgBusinessObjMetadataExtEntity> cfgBusinessObjMetadataExtEntityMap = cfgBusinessObjMetadataExtEntityList.stream().collect(Collectors.toMap(CfgBusinessObjMetadataExtEntity::getBusinessObjMetadataId, entity -> entity));
        return cfgBusinessObjMetadataExtEntityMap;
    }

    private List<MsBusinessObjMetadataBean> queryTemplateObjMetadataListByCodeAndType(String templateObjCode, String templateObjType) {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        CfgTemplateObjExample.Criteria cfgTemplateObjCriteria = cfgTemplateObjExample.createCriteria();
        cfgTemplateObjCriteria.andTemplateObjCodeEqualTo(templateObjCode);
        CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
        logger.info("queryMetaDataItemListByBusinessObjId cfgTemplateObjEntity========={}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgTemplateObjEntity));
        if (null == cfgTemplateObjEntity) {
            return Lists.newArrayList();
        }
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        CfgTemplateObjMetadataExample.Criteria cfgTemplateObjMetadataCriteria = cfgTemplateObjMetadataExample.createCriteria();
        cfgTemplateObjMetadataCriteria.andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId());
        List cfgTemplateObjMetadataEntityList = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
        List msBusinessObjMetadataBeanList = this.convertAndTemplateFillFieldEnumValue(cfgTemplateObjMetadataEntityList);
        return msBusinessObjMetadataBeanList;
    }

    public List<MsBusinessObjMetadataBean> batchQueryWithObjCodeFiledName(MsMataDataBatchQueryRequest msMataDataBatchQueryRequest) {
        logger.debug("query objCode with params:{}", (Object)msMataDataBatchQueryRequest);
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        String objType = msMataDataBatchQueryRequest.getObjType();
        CfgBusinessObjExample.Criteria criteria = cfgBusinessObjExample.createCriteria();
        if (StringUtils.isEmpty((CharSequence)msMataDataBatchQueryRequest.getObjCode())) {
            return new ArrayList<MsBusinessObjMetadataBean>();
        }
        criteria.andObjCodeEqualTo(msMataDataBatchQueryRequest.getObjCode());
        if (msMataDataBatchQueryRequest.getGroupId() != null && msMataDataBatchQueryRequest.getGroupId() > 0L) {
            criteria.andGroupIdEqualTo(msMataDataBatchQueryRequest.getGroupId());
        }
        if (!StringUtils.isEmpty((CharSequence)objType)) {
            criteria.andObjTypeEqualTo(msMataDataBatchQueryRequest.getObjType());
        }
        cfgBusinessObjExample.clear();
        cfgBusinessObjExample.getOredCriteria().add(criteria);
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
        List msBusinessObjMetadataBeanList = cfgBusinessObjEntity == null ? this.getMetaDataItem(null, msMataDataBatchQueryRequest.getFiledNameList(), msMataDataBatchQueryRequest.getObjCode(), msMataDataBatchQueryRequest.getObjType()) : this.getMetaDataItem(cfgBusinessObjEntity.getBusinessObjId(), msMataDataBatchQueryRequest.getFiledNameList(), msMataDataBatchQueryRequest.getObjCode(), msMataDataBatchQueryRequest.getObjType());
        return msBusinessObjMetadataBeanList;
    }

    private void fillFieldEnumValue(MsBusinessObjMetadataBean msBusinessObjBean, Long businessObjId) {
        List msEnumBeanList;
        String displayType = msBusinessObjBean.getDisplayType();
        if ((DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.PULL_DOWN || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.RADIO || DisplayTypeEnum.getDisplayTypeByCode((String)displayType) == DisplayTypeEnum.CHECK_BOX) && CollectionUtils.isEmpty((Collection)(msEnumBeanList = msBusinessObjBean.getFieldEnumValue()))) {
            if (Objects.nonNull(businessObjId)) {
                msBusinessObjBean.setFieldEnumValue(this.getDataFromCodeSet(msBusinessObjBean.getFieldName()));
            } else if (!StringUtils.isEmpty((CharSequence)msBusinessObjBean.getAssociativeUrl())) {
                List msEnumBeans = this.queryTemplateEnumValue(msBusinessObjBean.getAssociativeUrl());
                logger.info("templateObjMetaDataConvert2BusOjbMetaData associativeUrl:{},msEnumBeans:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msEnumBeans));
                if (!CollectionUtils.isEmpty((Collection)msEnumBeans)) {
                    msBusinessObjBean.setFieldEnumValue(msEnumBeans);
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteMetaData(List<Long> metaDataIdList, MsCommonUserInfo msCommonUserInfo) {
        if (CollectionUtils.isEmpty(metaDataIdList)) {
            return 1;
        }
        for (Long metaDataId : metaDataIdList) {
            CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectByPrimaryKey(metaDataId);
            CfgConfigExample cfgConfigExample = new CfgConfigExample();
            CfgConfigExample.Criteria purchaserCriteria = cfgConfigExample.createCriteria();
            CfgConfigExample.Criteria sellerCriteria = cfgConfigExample.createCriteria();
            purchaserCriteria.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType());
            purchaserCriteria.andPurchaserGroupIdEqualTo(msCommonUserInfo.getGroupId());
            purchaserCriteria.andSalesbillTypeEqualTo(cfgBusinessObjEntity.getObjType());
            purchaserCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            sellerCriteria.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
            sellerCriteria.andSellerGroupIdEqualTo(msCommonUserInfo.getGroupId());
            sellerCriteria.andSalesbillTypeEqualTo(cfgBusinessObjEntity.getObjType());
            sellerCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            cfgConfigExample.getOredCriteria().add(purchaserCriteria);
            cfgConfigExample.or(sellerCriteria);
            long count = this.cfgConfigDao.countByExample(cfgConfigExample);
            if (count > 0L) {
                throw new RuntimeException("\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25,\u4e1a\u52a1\u5206\u7c7b" + cfgBusinessObjEntity.getObjType() + "\u5df2\u914d\u7f6e\u62c6\u7968\u89c4\u5219");
            }
            BillConfigRequest billConfigRequest = new BillConfigRequest();
            billConfigRequest.setGroupId(msCommonUserInfo.getGroupId());
            billConfigRequest.setSalesBillType(cfgBusinessObjEntity.getObjType());
            Response response = this.billConfigClient.getBillCountByBillType(billConfigRequest);
            if (null != response && Response.OK.equals(response.getCode())) {
                long count2 = Long.valueOf((String)response.getResult());
                if (count2 > 0L) {
                    throw new RuntimeException("\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25,\u5df2\u5b58\u5728\u4e1a\u52a1\u5206\u7c7b[" + cfgBusinessObjEntity.getObjType() + "]\u7684\u5355\u636e");
                }
            } else {
                throw new RuntimeException("billConfigClient-\u5355\u636e\u67e5\u8be2\u5931\u8d25");
            }
            CfgBusinessObjEntity entity = new CfgBusinessObjEntity();
            entity.setBusinessObjId(metaDataId);
            entity.setObjStatus(Byte.valueOf(StatusEnum.DELETE.getStatus().byteValue()));
            int updateRet = this.cfgBusinessObjDao.updateByPrimaryKeySelective(entity);
            if (updateRet > 0) continue;
            throw new RuntimeException("\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25,\u4e1a\u52a1Id" + metaDataId);
        }
        return 1;
    }

    public List<MsMetaDataSummaryDTO> metaDataSummary(MsMataDataQueryRequest msMataDataQueryRequest) {
        StatusEnum[] statusEnums = StatusEnum.values();
        ArrayList result = Lists.newArrayList();
        for (StatusEnum statusEnum : statusEnums) {
            msMataDataQueryRequest.setObjStatus(statusEnum.getStatus());
            MsMetaDataSummaryDTO msMetaDataSummaryDTO = new MsMetaDataSummaryDTO();
            Long count = this.queryMetaDataCount(msMataDataQueryRequest);
            msMetaDataSummaryDTO.setCode(String.valueOf(statusEnum.getStatus()));
            msMetaDataSummaryDTO.setCount(Integer.valueOf(count.intValue()));
            msMetaDataSummaryDTO.setName(statusEnum.getStatusDesc());
            result.add(msMetaDataSummaryDTO);
        }
        return result;
    }

    private List<MsBusinessObjMetadataBean> getTempMateData(String objCode, String objType, List<String> fieldNameList) {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        CfgTemplateObjExample.Criteria criteria = cfgTemplateObjExample.createCriteria();
        criteria.andTemplateObjCodeEqualTo(objCode);
        if (!StringUtils.isEmpty((CharSequence)objType)) {
            CfgTemplateObjExample cfgTemplateObjExampleExt = new CfgTemplateObjExample();
            CfgTemplateObjExample.Criteria criteriaExt = cfgTemplateObjExample.createCriteria();
            criteriaExt.andTemplateObjTypeEqualTo(objType);
            criteriaExt.getCriteria().addAll(criteria.getAllCriteria());
            cfgTemplateObjExampleExt.getOredCriteria().add(criteriaExt);
            Long count = this.cfgTemplateObjDao.countByExample(cfgTemplateObjExampleExt);
            if (count > 0L) {
                criteria.andTemplateObjTypeEqualTo(objType);
            }
        }
        cfgTemplateObjExample.clear();
        cfgTemplateObjExample.getOredCriteria().add(criteria);
        CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
        CfgTemplateObjMetadataExample example = new CfgTemplateObjMetadataExample();
        CfgTemplateObjMetadataExample.Criteria tmpCriteria = example.createCriteria();
        tmpCriteria.andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId());
        if (!CollectionUtils.isEmpty(fieldNameList)) {
            tmpCriteria.andFieldNameIn(fieldNameList);
        }
        example.clear();
        example.getOredCriteria().add(tmpCriteria);
        List cfgTemplateObjMetadataEntityList = this.cfgTemplateObjMetadataDao.selectByExample(example);
        List msBusinessObjMetadataBeanList = this.convertAndTemplateFillFieldEnumValue(cfgTemplateObjMetadataEntityList);
        return msBusinessObjMetadataBeanList;
    }

    private List<MsBusinessObjMetadataBean> convertAndTemplateFillFieldEnumValue(List<CfgTemplateObjMetadataEntity> cfgTemplateObjMetadataEntityList) {
        List<MsBusinessObjMetadataBean> msBusinessObjMetadataBeanList = cfgTemplateObjMetadataEntityList.stream().filter(Objects::nonNull).map(ConfigTmpEntityTranslater::convertFromMsConfigBean).collect(Collectors.toList());
        for (MsBusinessObjMetadataBean msBusinessObjMetadataBean : msBusinessObjMetadataBeanList) {
            this.fillFieldEnumValue(msBusinessObjMetadataBean, null);
        }
        return msBusinessObjMetadataBeanList;
    }

    private MsBusinessObjMetadataBean fillMsBusinessObjMetadataBean(MsBusinessObjMetadataBean msBusinessObjMetadataBean, List<MsEnumBean> customMsEnumBeanList) {
        String displayType;
        if (CollectionUtils.isEmpty(customMsEnumBeanList)) {
            return msBusinessObjMetadataBean;
        }
        String associativeUrl = msBusinessObjMetadataBean.getAssociativeUrl();
        if (!(StringUtils.isEmpty((CharSequence)associativeUrl) && !Arrays.asList(this.needExtFields).contains(msBusinessObjMetadataBean.getFieldName()) || DisplayTypeEnum.getDisplayTypeByCode((String)(displayType = msBusinessObjMetadataBean.getDisplayType())) != DisplayTypeEnum.PULL_DOWN && DisplayTypeEnum.getDisplayTypeByCode((String)displayType) != DisplayTypeEnum.RADIO && DisplayTypeEnum.getDisplayTypeByCode((String)displayType) != DisplayTypeEnum.CHECK_BOX)) {
            List msEnumBeanList = msBusinessObjMetadataBean.getFieldEnumValue();
            if (CollectionUtils.isEmpty((Collection)msEnumBeanList)) {
                msEnumBeanList = Lists.newArrayList();
            }
            if (Arrays.asList(this.remarkeedExtFields).contains(msBusinessObjMetadataBean.getFieldName())) {
                for (MsEnumBean item : customMsEnumBeanList) {
                    if ("invoiceRemarkFiledList".equals(msBusinessObjMetadataBean.getFieldName()) && "0".equals(item.getFieldGroupIndex())) {
                        msEnumBeanList.add(item);
                        continue;
                    }
                    if (!"invoiceItemRemarkFiledList".equals(msBusinessObjMetadataBean.getFieldName()) || !"1".equals(item.getFieldGroupIndex())) continue;
                    msEnumBeanList.add(item);
                }
            }
            msBusinessObjMetadataBean.setFieldEnumValue(msEnumBeanList);
        }
        return msBusinessObjMetadataBean;
    }

    private List<MsEnumBean> queryTemplateEnumValue(String templateCode) {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo(templateCode);
        CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
        if (cfgTemplateObjEntity == null) {
            return null;
        }
        Long templateObjId = cfgTemplateObjEntity.getTemplateObjId();
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(templateObjId);
        List cfgTemplateObjMetadataEntities = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
        return this.convertCfgTemplateObjMetadata2MsEnumBean(cfgTemplateObjMetadataEntities);
    }

    private List<MsEnumBean> convertCfgTemplateObjMetadata2MsEnumBean(List<CfgTemplateObjMetadataEntity> cfgTemplateObjMetadataEntities) {
        ArrayList list = Lists.newArrayList();
        for (CfgTemplateObjMetadataEntity cfgTemplateObjMetadataEntity : cfgTemplateObjMetadataEntities) {
            MsEnumBean msEnumBean = new MsEnumBean();
            msEnumBean.setText(cfgTemplateObjMetadataEntity.getFieldDisplayName());
            msEnumBean.setValue(cfgTemplateObjMetadataEntity.getFieldName());
            list.add(msEnumBean);
        }
        return list;
    }

    private List<MsBusinessObjMetadataBean> queryCustomCfgBusinessObjMetadataByGroupIdAndObjType(Long groupId, String objType) {
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        cfgBusinessObjExample.createCriteria().andGroupIdEqualTo(groupId).andObjTypeEqualTo(objType).andObjStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        List cfgBusinessObjEntityList = this.cfgBusinessObjDao.selectByExample(cfgBusinessObjExample);
        if (!CollectionUtils.isEmpty((Collection)cfgBusinessObjEntityList)) {
            CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
            cfgBusinessObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(((CfgBusinessObjEntity)cfgBusinessObjEntityList.get(0)).getBusinessObjId()).andFixedEqualTo(Integer.valueOf(0));
            List cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
            ArrayList msBusinessObjMetadataBeanList = Lists.newArrayList();
            Map cfgBusinessObjMetadataExtEntityMap = this.queryMetaDataItemExtListByBusinessObjId(((CfgBusinessObjEntity)cfgBusinessObjEntityList.get(0)).getBusinessObjId());
            for (CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity : cfgBusinessObjMetadataEntityList) {
                MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntity, (CfgBusinessObjMetadataExtEntity)((CfgBusinessObjMetadataExtEntity)cfgBusinessObjMetadataExtEntityMap.get(cfgBusinessObjMetadataEntity.getBusinessObjMetadataId())));
                this.fillFieldEnumValue(msBusinessObjBean, ((CfgBusinessObjEntity)cfgBusinessObjEntityList.get(0)).getBusinessObjId());
                msBusinessObjMetadataBeanList.add(msBusinessObjBean);
            }
            return msBusinessObjMetadataBeanList;
        }
        return null;
    }

    private List<MsEnumBean> convertCfgBusinessObjMetadata2MsEnumBean(List<MsBusinessObjMetadataBean> msBusinessObjMetadataBeanList, boolean isSimpleFormat) {
        if (CollectionUtils.isEmpty(msBusinessObjMetadataBeanList)) {
            return null;
        }
        ArrayList msEnumBeanList = Lists.newArrayList();
        msBusinessObjMetadataBeanList.forEach(cfgBusinessObjMetadataEntity -> {
            MsEnumBean msEnumBean = new MsEnumBean();
            if (isSimpleFormat) {
                msEnumBean.setText(cfgBusinessObjMetadataEntity.getFieldDisplayName());
                msEnumBean.setValue(cfgBusinessObjMetadataEntity.getFieldName());
                msEnumBean.setFieldGroupIndex(String.valueOf(cfgBusinessObjMetadataEntity.getFieldGroupIndex()));
            } else {
                msEnumBean.setCode(cfgBusinessObjMetadataEntity.getFieldName());
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setField(cfgBusinessObjMetadataEntity.getFieldName());
                fieldGroup.setFieldGroupIndex(cfgBusinessObjMetadataEntity.getFieldGroupIndex().toString());
                msEnumBean.setValue(JsonUtils.writeObjectToFastJson((Object)fieldGroup));
                msEnumBean.setText(cfgBusinessObjMetadataEntity.getFieldDisplayName());
                msEnumBean.setFieldGroupIndex(cfgBusinessObjMetadataEntity.getFieldGroupIndex().toString());
            }
            msEnumBeanList.add(msEnumBean);
        });
        logger.info("convertCfgBusinessObjMetadata2MsEnumBean msEnumBeanList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msEnumBeanList));
        return msEnumBeanList;
    }

    private List<MsEnumBean> getDataFromCodeSet(String filedName) {
        CfgCodesetExample example = new CfgCodesetExample();
        example.createCriteria().andCodesetCodeEqualTo(filedName);
        CfgCodesetEntity cfgCodesetEntity = this.cfgCodesetDao.selectOneByExample(example);
        if (cfgCodesetEntity == null) {
            return null;
        }
        CfgCodesetItemExample cfgCodesetItemExample = new CfgCodesetItemExample();
        cfgCodesetItemExample.createCriteria().andCodesetIdEqualTo(cfgCodesetEntity.getCodesetId());
        List cfgCodesetItemEntities = this.cfgCodesetItemDao.selectByExample(cfgCodesetItemExample);
        ArrayList listMap = new ArrayList();
        ArrayList msEnumBeanList = Lists.newArrayList();
        for (CfgCodesetItemEntity tmp : cfgCodesetItemEntities) {
            MsEnumBean msEnumBean = new MsEnumBean();
            msEnumBean.setCode(filedName);
            msEnumBean.setText(tmp.getItemCname());
            msEnumBean.setValue(tmp.getItemCode());
            msEnumBeanList.add(msEnumBean);
        }
        return msEnumBeanList;
    }

    private List<MsBusinessObjMetadataBean> getMetaDataItem(Long objId, List<String> itemNameList, String objCode, String objType) {
        logger.debug("getMetaDataItem with params:{}, {}, {}, {}", new Object[]{objId, itemNameList, objCode, objType});
        if (objId == null) {
            return this.getTempMateData(objCode, objType, itemNameList);
        }
        CfgBusinessObjMetadataExample example = new CfgBusinessObjMetadataExample();
        CfgBusinessObjMetadataExample.Criteria criteria = example.createCriteria();
        criteria.andBusinessObjIdEqualTo(objId);
        if (!CollectionUtils.isEmpty(itemNameList)) {
            criteria.andFieldNameIn(itemNameList);
        }
        example.getOredCriteria().clear();
        example.getOredCriteria().add(criteria);
        List cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntityList)) {
            return this.getTempMateData(objCode, objType, itemNameList);
        }
        ArrayList msBusinessObjMetadataBeanList = Lists.newArrayList();
        Map cfgBusinessObjMetadataExtEntityMap = this.queryMetaDataItemExtListByBusinessObjId(objId);
        for (CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity : cfgBusinessObjMetadataEntityList) {
            MsBusinessObjMetadataBean msBusinessObjBean = MetaDataTranslater.convertFromConfigEntity((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntity, (CfgBusinessObjMetadataExtEntity)((CfgBusinessObjMetadataExtEntity)cfgBusinessObjMetadataExtEntityMap.get(cfgBusinessObjMetadataEntity.getBusinessObjMetadataId())));
            this.fillFieldEnumValue(msBusinessObjBean, objId);
            msBusinessObjMetadataBeanList.add(msBusinessObjBean);
        }
        logger.debug("getMetaDataItem result:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msBusinessObjMetadataBeanList));
        return msBusinessObjMetadataBeanList;
    }

    private boolean updateExistConfigItem(List<MsBusinessObjMetadataBean> msBusinessObjMetadataBeanList, Long id, String updateTime, MsCommonUserInfo userInfo) {
        MsMetadataItemQueryRequest request = new MsMetadataItemQueryRequest();
        request.setBusinessObjId(id);
        CfgBusinessObjMetadataExample example = new CfgBusinessObjMetadataExample();
        if (updateTime != null) {
            example.createCriteria().andBusinessObjIdEqualTo(id).andUpdateTimeGreaterThan(DateUtil.convertDate((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss"));
            Long count = this.cfgBusinessObjMetadataDao.countByExample(example);
            if (count > 0L) {
                throw new ConfigUpdateExpireException();
            }
        }
        example.clear();
        example.createCriteria().andBusinessObjIdEqualTo(id);
        List cfgBusinessObjMetadataEntities = this.cfgBusinessObjMetadataDao.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntities)) {
            for (CfgBusinessObjMetadataEntity tmp : cfgBusinessObjMetadataEntities) {
                this.cfgBusinessObjMetadataDao.deleteByPrimaryKey(tmp.getBusinessObjMetadataId());
                this.cfgBusinessObjMetadataExtDao.deleteByPrimaryKey(tmp.getBusinessObjMetadataId());
            }
        }
        for (MsBusinessObjMetadataBean metadataBean : msBusinessObjMetadataBeanList) {
            long businessObjMetadataId = this.generator.nextId();
            logger.info("--web metadataBean:{},businessObjMetadataId:{},id:{}", new Object[]{JsonUtils.writeObjectToFastJson((Object)metadataBean), businessObjMetadataId, id});
            CfgBusinessObjMetadataEntity entity = MetaDataTranslater.convertMsBusinessObjMetadataBean2MetadataEntity((MsBusinessObjMetadataBean)metadataBean, (Long)businessObjMetadataId, (Long)id, (Long)userInfo.getUserId());
            logger.info("insert entity:{},businessObjMetadataId:{},id:{}", new Object[]{JsonUtils.writeObjectToFastJson((Object)entity), businessObjMetadataId, id});
            this.cfgBusinessObjMetadataDao.insertSelective(entity);
            CfgBusinessObjMetadataExtEntity cfgBusinessObjMetadataExtEntity = MetaDataTranslater.convertMsBusinessObjMetadataBean2MetadataExtEntity((MsBusinessObjMetadataBean)metadataBean, (Long)businessObjMetadataId, (Long)id);
            logger.info("insert cfgBusinessObjMetadataExtEntity:{},businessObjMetadataId:{},id:{}", new Object[]{JsonUtils.writeObjectToFastJson((Object)cfgBusinessObjMetadataExtEntity), businessObjMetadataId, id});
            if (!Objects.nonNull(cfgBusinessObjMetadataExtEntity)) continue;
            this.cfgBusinessObjMetadataExtDao.insertSelective(cfgBusinessObjMetadataExtEntity);
        }
        CfgConfigHistoryEntity cfgConfigHistoryEntity = new CfgConfigHistoryEntity();
        cfgConfigHistoryEntity.setConfigId(id);
        cfgConfigHistoryEntity.setCreateTime(new Date());
        cfgConfigHistoryEntity.setOriginalTime(CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntities) ? new Date() : ((CfgBusinessObjMetadataEntity)cfgBusinessObjMetadataEntities.get(0)).getUpdateTime());
        if (cfgBusinessObjMetadataEntities.size() < 90) {
            cfgConfigHistoryEntity.setConfigItem(JsonUtils.writeObjectToFastJson((Object)cfgBusinessObjMetadataEntities));
            this.cfgConfigHistoryDao.insertSelective(cfgConfigHistoryEntity);
        }
        return Boolean.FALSE;
    }

    private Integer getOffset(MsMataDataQueryRequest msMataDataQueryRequest) {
        Integer pageNo = msMataDataQueryRequest.getPageNo();
        Integer pageSize = msMataDataQueryRequest.getPageSize();
        if (pageNo == null) {
            pageNo = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        return (pageNo - 1) * pageSize;
    }

    private boolean checkObjNameExist(String objCode, String objName, Long groupId) {
        CfgBusinessObjExample example = new CfgBusinessObjExample();
        example.createCriteria().andObjCodeEqualTo(objCode).andObjStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue())).andObjNameEqualTo(objName).andGroupIdEqualTo(groupId);
        long count = this.cfgBusinessObjDao.countByExample(example);
        return count <= 0L;
    }

    private void checkMetaItem(List<MsBusinessObjMetadataBean> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        HashSet fieldNameSet = new HashSet();
        HashSet fieldDisplayNameSet = new HashSet();
        StringBuffer outTips = new StringBuffer();
        for (MsBusinessObjMetadataBean msBusinessObjMetadataBean : entities) {
            boolean checkResult = this.checkFieldNameIsRepeat(fieldNameSet, msBusinessObjMetadataBean.getFieldName(), msBusinessObjMetadataBean.getFieldGroupIndex(), outTips);
            if (!checkResult) {
                throw new RuntimeException(outTips.toString());
            }
            checkResult = this.checkFieldNameIsRepeat(fieldDisplayNameSet, msBusinessObjMetadataBean.getFieldDisplayName(), msBusinessObjMetadataBean.getFieldGroupIndex(), outTips);
            if (!checkResult) {
                throw new RuntimeException(outTips.toString());
            }
            List msEnumBeanList = msBusinessObjMetadataBean.getFieldEnumValue();
            long countText = msEnumBeanList.stream().map(enumBean -> enumBean.getText()).distinct().count();
            long countValue = msEnumBeanList.stream().map(enumBean -> enumBean.getValue()).distinct().count();
            if (countText >= (long)msEnumBeanList.size() && countValue >= (long)msEnumBeanList.size()) continue;
            logger.info("checkMetaItem filedName msEnumBean=====>{}, countText:{}, countValue:{}, size:{}", new Object[]{JsonUtils.writeObjectToFastJson((Object)msEnumBeanList), countText, countValue, msEnumBeanList.size()});
            throw new ConfigMetaDataEnumRepeatException();
        }
    }

    private boolean checkFieldNameIsRepeat(Set<String> fieldNameSet, String fieldName, Integer groupIndex, StringBuffer outTips) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            logger.info("checkMetaItem filedName isEmpty =====>{}", (Object)fieldName);
            outTips.append(new ConfigMetaDataItemNullException().getMessage());
            return false;
        }
        String fileNameAndGroup = fieldName + groupIndex;
        if (fieldNameSet.contains(fileNameAndGroup)) {
            logger.info("checkMetaItem filedName contains=====>{}:fieldNameSet:{}", (Object)fileNameAndGroup, (Object)JsonUtils.writeObjectToFastJson(fieldNameSet));
            outTips.append(groupIndex == 0 ? "\u4e3b\u4fe1\u606f\u5b57\u6bb5:" : "\u660e\u7ec6\u5b57\u6bb5").append(fieldName).append(new ConfigMetaDataRepeatException().getMessage());
            return false;
        }
        fieldNameSet.add(fileNameAndGroup);
        return true;
    }

    public List<MsHighlightFieldDTO> queryHighlightFieldList(String objCode, String objType, Long groupId) {
        ArrayList msHighlightFieldDTOList = Lists.newArrayList();
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        CfgBusinessObjExample.Criteria cfgBusinessObjCriteria = cfgBusinessObjExample.createCriteria();
        cfgBusinessObjCriteria.andObjCodeEqualTo(objCode).andObjTypeEqualTo(objType).andGroupIdEqualTo(groupId);
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
        if (Objects.isNull(cfgBusinessObjEntity)) {
            return msHighlightFieldDTOList;
        }
        CfgBusinessObjMetadataExtExample cfgBusinessObjMetadataExtExample = new CfgBusinessObjMetadataExtExample();
        CfgBusinessObjMetadataExtExample.Criteria objMetadataExtCriteria = cfgBusinessObjMetadataExtExample.createCriteria();
        objMetadataExtCriteria.andBusinessObjIdEqualTo(cfgBusinessObjEntity.getBusinessObjId());
        List cfgBusinessObjMetadataExtEntityList = this.cfgBusinessObjMetadataExtDao.selectByExample(cfgBusinessObjMetadataExtExample);
        cfgBusinessObjMetadataExtEntityList.forEach(extEntity -> {
            List deserialMsHighlightFieldDTOList = null;
            if (!CommonTools.isEmpty((String)extEntity.getFieldHighlightValue()) && !"[]".equals(extEntity.getFieldHighlightValue())) {
                if (!CommonTools.isEmpty((String)extEntity.getFieldEnumValue()) && !"[]".equals(extEntity.getFieldEnumValue())) {
                    List enumBeans = JSON.parseArray((String)extEntity.getFieldEnumValue(), MsEnumBean.class);
                    List highlightBeans = JSON.parseArray((String)extEntity.getFieldHighlightValue(), MsHighlightBean.class);
                    highlightBeans.forEach(bean -> {
                        if (!CommonTools.isEmpty((String)bean.getFieldName()) && bean.getFieldName().startsWith("ext") && "eq".equals(bean.getRelation())) {
                            String t = bean.getText();
                            enumBeans.forEach(enumBean -> {
                                if (!CommonTools.isEmpty((String)enumBean.getValue()) && enumBean.getValue().equals(t)) {
                                    bean.setText(enumBean.getText());
                                }
                            });
                        }
                    });
                    deserialMsHighlightFieldDTOList = JsonUtils.writeJsonToListObject((String)String.valueOf(JSON.toJSON((Object)highlightBeans)), MsHighlightFieldDTO.class);
                } else {
                    deserialMsHighlightFieldDTOList = JsonUtils.writeJsonToListObject((String)extEntity.getFieldHighlightValue(), MsHighlightFieldDTO.class);
                }
                if (!CollectionUtils.isEmpty((Collection)deserialMsHighlightFieldDTOList)) {
                    msHighlightFieldDTOList.addAll(deserialMsHighlightFieldDTOList);
                }
            }
        });
        return msHighlightFieldDTOList;
    }

    public Response queryMetaObjMetadata(MsMataItemDataQueryRequest msMataDataQueryRequest) {
        Long groupId = msMataDataQueryRequest.getGroupId();
        String objCode = msMataDataQueryRequest.getObjCode();
        String objType = msMataDataQueryRequest.getObjType();
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        CfgBusinessObjExample.Criteria criteria = cfgBusinessObjExample.createCriteria();
        criteria.andGroupIdEqualTo(groupId);
        if (!CommonTools.isEmpty((String)objCode)) {
            criteria.andObjCodeEqualTo(objCode);
        }
        if (!StringUtils.isEmpty((CharSequence)objType)) {
            criteria.andObjTypeEqualTo(objType);
        }
        criteria.andObjStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
        if (cfgBusinessObjEntity == null) {
            return Response.ok((String)"", new ArrayList());
        }
        CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
        cfgBusinessObjMetadataExample.setOrderByClause("field_sort");
        CfgBusinessObjMetadataExample.Criteria metadataCriteria = cfgBusinessObjMetadataExample.createCriteria();
        metadataCriteria.andBusinessObjIdEqualTo(cfgBusinessObjEntity.getBusinessObjId());
        Integer fieldGroupIndex = msMataDataQueryRequest.getFieldGroupIndex();
        if (fieldGroupIndex != null) {
            metadataCriteria.andFieldGroupIndexEqualTo(fieldGroupIndex);
        }
        List cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
        return Response.ok((String)"", (Object)cfgBusinessObjMetadataEntityList);
    }

    public List<CfgBusinessObjEntity> queryBusinessObjByExample(CfgBusinessObjExample example) {
        return this.cfgBusinessObjDao.selectByExample(example);
    }
}

