/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.proxy;

import com.xforceplus.seller.config.proxy.model.LoginRequest;
import com.xforceplus.seller.config.proxy.model.LoginResponse;
import com.xforceplus.seller.config.proxy.model.device.CommonResponse;
import com.xforceplus.seller.config.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateTools {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateTools.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${invoice.makeout.client.clientId}")
    private String clientId;
    @Value(value="${invoice.makeout.client.secret}")
    private String secret;
    @Value(value="${invoice.makeout.login.url}")
    private String loginUrl;
    @Value(value="${invoice.makeout.base.url}")
    private String baseUrl;

    public <T extends CommonResponse> T postEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = subUrl;
        if (!subUrl.startsWith("http")) {
            req_url = this.baseUrl + groupId + subUrl;
        }
        logger.info("post\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        String reqStr = JsonUtils.writeObjectToFastJson((Object)req);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)reqStr, (MultiValueMap)this.getHeader());
            logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)requestEntity));
            ResponseEntity tResponseEntity = this.restTemplate.postForEntity(req_url, (Object)requestEntity, tClass, new Object[0]);
            if (null == tResponseEntity || null == tResponseEntity.getBody()) {
                logger.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 url {}, req {},header {}", new Object[]{req_url, JsonUtils.writeObjectToFastJson((Object)req), JsonUtils.writeObjectToFastJson((Object)this.getHeader())});
                throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
            }
            CommonResponse body = (CommonResponse)tResponseEntity.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T putEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.baseUrl + groupId + subUrl;
        logger.info("put\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)req));
        HttpEntity requestEntity = new HttpEntity(req, (MultiValueMap)this.getHeader());
        try {
            ResponseEntity exchange = this.restTemplate.exchange(req_url, HttpMethod.PUT, requestEntity, tClass, new Object[0]);
            CommonResponse body = (CommonResponse)exchange.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T patchEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.baseUrl + groupId + subUrl;
        logger.info("patch\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        HttpEntity requestEntity = new HttpEntity(req, (MultiValueMap)this.getHeader());
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)requestEntity));
        try {
            ResponseEntity exchange = this.restTemplate.exchange(req_url, HttpMethod.PATCH, requestEntity, tClass, new Object[0]);
            if (null == exchange || null == exchange.getBody()) {
                logger.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 req {},header {}", (Object)JsonUtils.writeObjectToFastJson((Object)req), (Object)JsonUtils.writeObjectToFastJson((Object)this.getHeader()));
                throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
            }
            CommonResponse body = (CommonResponse)exchange.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T getEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = subUrl;
        if (!subUrl.startsWith("http")) {
            req_url = this.baseUrl + groupId + subUrl;
        }
        logger.info("get\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        HttpEntity requestEntity = new HttpEntity(req, (MultiValueMap)this.getHeader());
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)requestEntity));
        try {
            ResponseEntity exchange = this.restTemplate.exchange(req_url, HttpMethod.GET, requestEntity, tClass, new Object[0]);
            if (null == exchange || null == exchange.getBody()) {
                logger.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 req {},header {}", (Object)JsonUtils.writeObjectToFastJson((Object)req), (Object)JsonUtils.writeObjectToFastJson((Object)this.getHeader()));
                throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
            }
            CommonResponse body = (CommonResponse)exchange.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T deleteEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = subUrl;
        if (!subUrl.startsWith("http")) {
            req_url = this.baseUrl + groupId + subUrl;
        }
        logger.info("delete\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        HttpEntity requestEntity = new HttpEntity(req, (MultiValueMap)this.getHeader());
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)requestEntity));
        try {
            ResponseEntity exchange = this.restTemplate.exchange(req_url, HttpMethod.DELETE, requestEntity, tClass, new Object[0]);
            if (null == exchange || null == exchange.getBody()) {
                logger.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 req {},header {}", (Object)JsonUtils.writeObjectToFastJson((Object)req), (Object)JsonUtils.writeObjectToFastJson((Object)this.getHeader()));
                throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
            }
            CommonResponse body = (CommonResponse)exchange.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T getFailResponse(Class<T> tClass, Exception e, String req_url) {
        try {
            CommonResponse t = (CommonResponse)tClass.newInstance();
            if (e instanceof HttpStatusCodeException) {
                String data = ((HttpStatusCodeException)e).getResponseBodyAsString();
                CommonResponse commonResponse = (CommonResponse)JsonUtils.writeFastJsonToObject((String)data, CommonResponse.class);
                t.setCode(commonResponse.getCode());
                t.setMessage(commonResponse.getMessage());
                t.setTraceId(commonResponse.getTraceId());
                logger.info("\u8bf7\u6c42\u7a0e\u4ef6url:{},\u5931\u8d25\u539f\u56e0:{}", (Object)req_url, (Object)commonResponse.toString());
            } else {
                logger.error("\u8bf7\u6c42\u7a0e\u4ef6url\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                t.setCode("-1");
                t.setMessage(e.getMessage());
            }
            return (T)t;
        }
        catch (InstantiationException e1) {
            logger.error("\u8f6c\u6362\u5931\u8d25\u6d88\u606f\u5f02\u5e38InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e1) {
            logger.error("\u8f6c\u6362\u5931\u8d25\u6d88\u606f\u5f02\u5e38IllegalAccessException", (Throwable)e);
        }
        return null;
    }

    public String getAcessToken() {
        LoginRequest loginRequest = new LoginRequest(this.clientId, this.secret);
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)loginRequest, (MultiValueMap)requestHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(this.loginUrl, (Object)requestEntity, LoginResponse.class, new Object[0]);
        LoginResponse body = (LoginResponse)response.getBody();
        if (body.getCode() == 1) {
            return body.getData();
        }
        throw new RuntimeException("\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38");
    }

    public HttpHeaders getHeader() {
        String token = this.getAcessToken();
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        requestHeaders.add("x-app-token", token);
        return requestHeaders;
    }
}

