/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.util;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.runtime.Settings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslJsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(DslJsonUtil.class);
    private static DslJson<Object> dslJson = new DslJson(Settings.withRuntime().allowArrayFormat(true).includeServiceLoader());

    public static <T> T deserialize(Class<T> clazz, String json) throws Exception {
        byte[] bytes = json.getBytes("utf-8");
        return (T)dslJson.deserialize(clazz, bytes, bytes.length);
    }

    public static <T> List<T> deserializeList(Class<T> clazz, String json) throws Exception {
        byte[] bytes = json.getBytes("utf-8");
        return dslJson.deserializeList(clazz, bytes, bytes.length);
    }

    public static <T> List<List<T>> deserializeLists(Class<T> clazz, String json) throws Exception {
        byte[] bytes = json.getBytes("utf-8");
        return dslJson.deserializeList(clazz, bytes, bytes.length);
    }

    public static String serialize(Object value) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            dslJson.serialize(value, (OutputStream)os);
            return os.toString("utf-8");
        }
        catch (Exception e) {
            logger.error("\u5e8f\u5217\u5316\u5931\u8d25:{}", value, (Object)e);
            return "";
        }
    }
}

