/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.app.controller;

import com.xforceplus.seller.config.app.annotation.APIV1Config;
import com.xforceplus.seller.config.app.api.ConfigApi;
import com.xforceplus.seller.config.bizconfig.controller.MsConfigController;
import com.xforceplus.seller.config.bizconfig.controller.MsConfigTempController;
import com.xforceplus.seller.config.bizconfig.service.ConfigBizConfigService;
import com.xforceplus.seller.config.client.ItemAssemble;
import com.xforceplus.seller.config.client.model.ConfigItemDTO;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequst;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequstWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigMailRuleResponse;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigResponse;
import com.xforceplus.seller.config.client.model.MsConfigSummaryResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.seller.config.client.model.MsTmpConfigResponse;
import com.xforceplus.seller.config.client.translater.MsConfigQueryRequestTranslater;
import com.xforceplus.seller.config.job.SendInvoiceMailService;
import com.xforceplus.seller.config.util.UserTranslater;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@APIV1Config
public class ConfigController
extends BaseAppController
implements ConfigApi {
    @Autowired
    private ConfigBizConfigService configBizConfigService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    MsConfigController msConfigController;
    @Autowired
    MsConfigTempController msConfigTempController;
    @Autowired
    private ItemAssemble itemAssemble;
    @Autowired
    SendInvoiceMailService sendInvoiceMailService;

    public MsConfigResponse queryConfig(@ApiParam(value="\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e", required=true) @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsConfigResponse response = new MsConfigResponse();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response;
        }
        MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo = MsConfigQueryRequestTranslater.msConfigQueryRequest2MsConfigQueryRequestWithUser((MsConfigQueryRequest)msConfigQueryRequest);
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigQueryRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        MsConfigQueryRequest request = MsConfigQueryRequestTranslater.MsConfigQueryRequestWithUser2MsConfigQueryRequest((MsConfigQueryRequestWithUserInfo)msConfigQueryRequestWithUserInfo);
        MsConfigPageDTO msConfigPageDTO = this.configBizConfigService.queryConfigList(request, msCommonUserInfo.getGroupId());
        response.setResult(msConfigPageDTO);
        response.setCode(Response.OK);
        response.setMessage("\u67e5\u8be2\u6210\u529f");
        return response;
    }

    public MsResponse saveConfig(@ApiParam(value="\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e", required=true) @RequestBody MsConfigAddRequest msConfigAddRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsResponse response = new MsResponse();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response;
        }
        MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
        msConfigAddRequestWithUserInfo.setItemDTOList(msConfigAddRequest.getItemDTOList());
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigAddRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigController.saveConfigRule(msConfigAddRequestWithUserInfo);
    }

    public MsTmpConfigResponse queryTempConfig(@ApiParam(value="\u67e5\u8be2\u7528\u6237\u4e0b\u4e34\u65f6\u7684\u914d\u7f6e", required=true) @RequestBody ConfigItemDTO TempConfigQureyRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsTmpConfigAddRequest msTmpConfigQueryRequest = this.itemAssemble.convert2TmpConfigItemRequest(TempConfigQureyRequest);
        msTmpConfigQueryRequest.setUserId(Long.valueOf(userInfo.getUserId()));
        return this.msConfigTempController.saveTmpConfigRule(msTmpConfigQueryRequest);
    }

    public MsConfigSummaryResponse queryConfigSummary(@ApiParam(value="\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u6458\u8981\u6807\u7b7e", required=true) @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo = MsConfigQueryRequestTranslater.msConfigQueryRequest2MsConfigQueryRequestWithUser((MsConfigQueryRequest)msConfigQueryRequest);
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigQueryRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigController.queryConfigSummary(msConfigQueryRequestWithUserInfo);
    }

    public MsResponse deleteConfig(@ApiParam(value="\u914d\u7f6e\u5220\u9664", required=true) @RequestBody MsConfigDeleteRequst msConfigDeleteRequst) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsConfigDeleteRequstWithUserInfo msConfigDeleteRequstWithUserInfo = new MsConfigDeleteRequstWithUserInfo();
        msConfigDeleteRequstWithUserInfo.setConfigIdList(msConfigDeleteRequst.getConfigIdList());
        msConfigDeleteRequstWithUserInfo.setConfigType(msConfigDeleteRequst.getConfigType());
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigDeleteRequstWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigController.deleteConfig(msConfigDeleteRequstWithUserInfo);
    }

    public MsConfigMailRuleResponse queryConfigMailRule(@ApiParam(value="\u67e5\u8be2\u5f00\u7968\u63a8\u9001\u89c4\u5219", required=true) @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        return this.msConfigController.queryConfigMailRule(msCommonUserInfo, msConfigQueryRequest);
    }

    @RequestMapping(path={"/job/daily"})
    public String startDailyJob(String configId) {
        this.sendInvoiceMailService.dailyJob(configId);
        return "ok";
    }

    @RequestMapping(path={"/job/monthly"})
    public String startMonthlyJob(String configId) {
        this.sendInvoiceMailService.monthlyJob(configId);
        return "ok";
    }
}

