/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.controller;

import com.xforceplus.seller.config.bizconfig.service.ConfigBizConfigService;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.InvoiceSplitConfigApi;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@MSApiV1SellerConfig
public class SplitConfigController
implements InvoiceSplitConfigApi {
    private static final Logger logger = LoggerFactory.getLogger(SplitConfigController.class);
    @Autowired
    private ConfigBizConfigService configBizConfigService;

    public MsConfigResponse queryEffectiveSplitRule(@ApiParam(value="\u67e5\u8be2\u62c6\u7968\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        msConfigQueryRequest.setConfigType(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType());
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        logger.info("\u62c6\u7968\u89c4\u5219\u8bf7\u6c42 msConfigQueryRequest========={}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        MsConfigPageDTO msConfigPageDTO = this.configBizConfigService.queryEffectiveConfig(msConfigQueryRequest);
        logger.info("\u62c6\u7968\u89c4\u5219\u54cd\u5e94 msConfigPageDTO========={}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigPageDTO));
        MsConfigResponse msConfigResponse = new MsConfigResponse();
        msConfigResponse.setCode(Response.OK);
        msConfigResponse.setResult(msConfigPageDTO);
        return msConfigResponse;
    }

    public MsResponse getOptimalMatchConfig(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u6700\u4f18\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        if (logger.isInfoEnabled()) {
            logger.info("@getOptimalMatchConfig invoiceTypeList====>{}", (Object)msConfigQueryRequest.getInvoiceType().toString());
        }
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Integer apiVersion = msConfigQueryRequest.getApiVersion();
        Response response = null;
        apiVersion = 1;
        switch (apiVersion) {
            case 1: {
                response = this.configBizConfigService.getOptimalMatchConfig(msConfigQueryRequest);
                break;
            }
            case 2: {
                response = this.configBizConfigService.getOriginalCfgs(msConfigQueryRequest);
                break;
            }
            case 3: {
                response = this.configBizConfigService.getOptimalMatchConfigWithAttr(msConfigQueryRequest);
                break;
            }
            default: {
                response = this.configBizConfigService.getOptimalMatchConfig(msConfigQueryRequest);
            }
        }
        msResponse.setCode(response.getCode());
        msResponse.setResult(response.getResult());
        return msResponse;
    }
}

