/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.seller.config.bizconfig.service.ConfigMailRuleService;
import com.xforceplus.seller.config.client.model.job.JobParameter;
import com.xforceplus.seller.config.common.ConstantValue;
import com.xforceplus.seller.config.job.SendInvoiceMailService;
import com.xforceplus.seller.config.repository.dao.CfgConfigMailRuleDao;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleExample;
import com.xforceplus.seller.config.util.XxlJobUtil;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
public class ConfigMailRuleServiceImpl
implements ConfigMailRuleService {
    private static final Logger log = LoggerFactory.getLogger(ConfigMailRuleServiceImpl.class);
    @Autowired
    CfgConfigMailRuleDao cfgConfigMailRuleDao;
    @Autowired
    SendInvoiceMailService sendInvoiceMailService;
    @Value(value="${xxl.job.admin.addresses:'http://xxl-job2.phoenix-t.xforceplus.com/xxl-job-admin'}")
    String xxlJobUrl;
    @Value(value="${xxl.job.admin.userName:admin}")
    private String xxlUserName;
    @Value(value="${xxl.job.admin.password:123456}")
    private String xxlPassword;
    @Value(value="${config.mail.monthly.cron:0 0 0 0 1/1 ? }")
    private String monthlyCron;
    private static final String APP_NAME = "seller-config-service";

    public void cancelMailService(List<CfgConfigMailRuleEntity> entities, Long userId) {
        if (!CollectionUtils.isEmpty(entities)) {
            entities.stream().forEach(config -> this.deactiveScheduler(config, userId));
        }
    }

    public void registerMailService(CfgConfigMailRuleEntity entity, Long userId) throws Exception {
        if (entity.getSendDaily().booleanValue()) {
            this.register(entity, true);
        }
        if (entity.getSendMonthly().booleanValue()) {
            this.register(entity, false);
        }
    }

    private void register(CfgConfigMailRuleEntity entity, boolean sendDaily) throws Exception {
        block6: {
            String group = XxlJobUtil.getJobGroupsWithGet((String)this.xxlJobUrl, (String)APP_NAME, null);
            int groupId = XxlJobUtil.getExecutorId((String)group);
            JSONObject param = this.buildJobParam(entity, sendDaily, groupId);
            JSONObject response = null;
            response = XxlJobUtil.addJob((String)this.xxlJobUrl, (JSONObject)param);
            if (response.containsKey((Object)"code") && 200 == response.getInteger("code")) {
                log.info("@register \u6ce8\u518c\u52a8\u6001\u90ae\u4ef6\u4efb\u52a1\u6210\u529f : " + entity.getConfigId());
                if (!Strings.isNullOrEmpty((String)response.getString("content"))) {
                    int jobId = Integer.valueOf(response.getString("content"));
                    XxlJobUtil.startJob((String)this.xxlJobUrl, (int)jobId);
                    CfgConfigMailRuleEntity update = new CfgConfigMailRuleEntity();
                    CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
                    example.createCriteria().andConfigIdEqualTo(entity.getConfigId()).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
                    if (sendDaily) {
                        update.setDailyTaskId(new Long(jobId));
                    } else {
                        update.setMonthlyTaskId(new Long(jobId));
                    }
                    this.cfgConfigMailRuleDao.updateByExampleSelective(update, example);
                }
                break block6;
            }
            log.info("@register \u6ce8\u518c\u52a8\u6001\u90ae\u4ef6\u4efb\u52a1\u5931\u8d25 : " + entity.getConfigId());
            throw new RuntimeException("@register \u6ce8\u518c\u52a8\u6001\u90ae\u4ef6\u4efb\u52a1\u5931\u8d25 : " + entity.getConfigId());
        }
    }

    private void deactiveScheduler(CfgConfigMailRuleEntity config, Long userId) {
        if (null != config.getDailyTaskId()) {
            try {
                XxlJobUtil.login((String)this.xxlJobUrl, (String)this.xxlUserName, (String)this.xxlPassword);
                XxlJobUtil.deleteJob((String)this.xxlJobUrl, (int)config.getDailyTaskId().intValue());
            }
            catch (Exception e) {
                log.error("@deactiveScheduler stop daily task, ", (Throwable)e);
            }
        }
        if (null != config.getMonthlyTaskId()) {
            try {
                XxlJobUtil.login((String)this.xxlJobUrl, (String)this.xxlUserName, (String)this.xxlPassword);
                XxlJobUtil.deleteJob((String)this.xxlJobUrl, (int)config.getMonthlyTaskId().intValue());
            }
            catch (Exception e) {
                log.error("@deactiveScheduler stop monthly task, ", (Throwable)e);
            }
        }
        CfgConfigMailRuleEntity update = new CfgConfigMailRuleEntity();
        update.setStatus(ConstantValue.STATUS_DEL);
        update.setCreateUser(userId);
        CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
        example.createCriteria().andConfigIdEqualTo(config.getConfigId()).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        this.cfgConfigMailRuleDao.updateByExampleSelective(update, example);
    }

    private JSONObject buildJobParam(CfgConfigMailRuleEntity entity, boolean sendDaily, int groupId) {
        JobParameter parameter = JobParameter.builder().build();
        parameter.setJobGroup(groupId);
        parameter.setAlarmEmail("guojia@xforceplus.com");
        if (sendDaily) {
            parameter.setJobCron(this.genDailyCron(entity));
            parameter.setExecutorHandler("mailDailyJob");
        } else {
            parameter.setJobCron(this.monthlyCron);
            parameter.setExecutorHandler("mailMonthlyJob");
        }
        parameter.setJobCron("0 */1 * * * ?");
        parameter.setAuthor("Admin");
        parameter.setExecutorBlockStrategy("SERIAL_EXECUTION");
        parameter.setExecutorFailRetryCount(1);
        parameter.setExecutorParam(entity.getConfigId().toString());
        parameter.setExecutorTimeout(0);
        parameter.setExecutorRouteStrategy("FIRST");
        parameter.setGlueType("BEAN");
        parameter.setJobDesc("\u90ae\u4ef6\u4efb\u52a1\u52a8\u6001job" + entity.getConfigId());
        JSONObject object = JSONObject.parseObject((String)JSON.toJSONString((Object)parameter));
        return object;
    }

    private String genDailyCron(CfgConfigMailRuleEntity entity) {
        String time = entity.getSendTime();
        String[] str = time.split(":");
        String hour = str[0];
        String minute = str[1];
        StringBuilder sb = new StringBuilder();
        sb.append(0).append(" ");
        sb.append(Integer.valueOf(minute)).append(" ");
        sb.append(Integer.valueOf(hour)).append(" ");
        sb.append("* * ? *");
        return sb.toString();
    }

    private JSONObject getAutoJsonInfo(String configName, String cronExpr, int executorId, String javaBeanHandler, Long savedConfigId) {
        JSONObject requestInfo = new JSONObject();
        requestInfo.put("jobDesc", (Object)configName);
        requestInfo.put("executorRouteStrategy", (Object)"ROUND");
        requestInfo.put("jobCron", (Object)cronExpr);
        requestInfo.put("glueType", (Object)"BEAN");
        requestInfo.put("executorHandler", (Object)javaBeanHandler);
        requestInfo.put("executorBlockStrategy", (Object)"SERIAL_EXECUTION");
        requestInfo.put("executorTimeout", (Object)0);
        requestInfo.put("executorFailRetryCount", (Object)1);
        requestInfo.put("author", (Object)"Admin");
        requestInfo.put("executorParam", (Object)String.valueOf(savedConfigId));
        return requestInfo;
    }
}

