/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xforceplus.seller.config.client.CasmClient;
import com.xforceplus.seller.config.client.InvoiceApiClient;
import com.xforceplus.seller.config.common.ConstantValue;
import com.xforceplus.seller.config.job.CfgResult;
import com.xforceplus.seller.config.job.SendInvoiceMailService;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigMailRuleDao;
import com.xforceplus.seller.config.repository.daoext.LogNoticeEventExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleExample;
import com.xforceplus.seller.config.repository.model.LogNoticeEventEntity;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.StringUtil;
import com.xforceplus.seller.config.util.mail.MsAttachment;
import com.xforceplus.seller.config.util.mail.MsEmailRequest;
import com.xforceplus.seller.config.util.mail.MsMailResponse;
import com.xforceplus.seller.config.util.mail.Receiver;
import com.xforceplus.seller.config.util.mail.SmsEmailClient;
import com.xforceplus.seller.invoice.client.model.JobSellerInvoiceModel;
import com.xforceplus.seller.invoice.client.model.JobSellerInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
public class SendInvoiceMailService {
    private static final Logger log = LoggerFactory.getLogger(SendInvoiceMailService.class);
    @Autowired
    SmsEmailClient smsEmailClient;
    @Autowired
    CfgConfigDao cfgConfigDao;
    @Autowired
    LogNoticeEventExtDao logNoticeEventExtDao;
    @Autowired
    CfgConfigMailRuleDao cfgConfigMailRuleDao;
    @Autowired
    InvoiceApiClient invoiceApiClient;
    @Autowired
    CasmClient casmClient;
    @Value(value="${config.mail.daily.templateNo:AUTO_INVOICE_MAIL}")
    private String templateNo;
    @Value(value="${config.mail.receiver.default:close}")
    private String defaultReceiverSwitch;

    @RequestMapping(path={"/job/test/invoice"})
    public JobSellerInvoiceModel queryInvoice(String str) {
        JSONObject jsonObject = JSON.parseObject((String)str);
        JobSellerInvoiceRequest request = new JobSellerInvoiceRequest();
        request.setBillType((String)jsonObject.get((Object)"billType"));
        request.setEndTime(DateTools.getDate((String)((String)jsonObject.get((Object)"endTime"))));
        request.setStartTime(DateTools.getDate((String)((String)jsonObject.get((Object)"startTime"))));
        request.setInvoiceType((String)jsonObject.get((Object)"invoiceType"));
        request.setPurTaxNo((String)jsonObject.get((Object)"purTaxNo"));
        request.setSellerTaxNo((String)jsonObject.get((Object)"sellerTaxNo"));
        return this.invoiceApiClient.querySellerInvoice(request);
    }

    public void dailyJob(String configId) {
        try {
            log.info("\u5f00\u59cb\u6267\u884c\u6bcf\u65e5\u4efb\u52a1 configId: " + configId);
            this.coreProcess(configId, true);
            log.info("\u6bcf\u65e5\u4efb\u52a1\u6267\u884c\u7ed3\u675f configId: " + configId);
        }
        catch (Exception e) {
            log.error("@dailyJob exception: ", (Throwable)e);
            throw e;
        }
    }

    public void monthlyJob(String configId) {
        try {
            log.info("\u5f00\u59cb\u6267\u884c\u6bcf\u6708\u4efb\u52a1 configId: " + configId);
            this.coreProcess(configId, false);
            log.info("\u6bcf\u6708\u4efb\u52a1\u6267\u884c\u7ed3\u675f configId: " + configId);
        }
        catch (Exception e) {
            log.error("@dailyJob exception: ", (Throwable)e);
            throw e;
        }
    }

    public void coreProcess(String configId, boolean isDaily) {
        CfgResult config = this.getCfgInfo(configId, isDaily);
        if (null == config) {
            log.info("@coreProcess \u6ca1\u6709\u67e5\u8be2\u5230\u89c4\u5219 configId: " + configId);
            return;
        }
        JobSellerInvoiceModel result = this.getSellerInvoice(config);
        Map keyByDatas = this.keyByInvoice(config, result);
        HashSet receiverSet = Sets.newHashSet();
        if (config.getUseCustomAddress().booleanValue()) {
            config.getCustomMailList();
            if (!StringUtils.isEmpty((CharSequence)config.getCustomMailList())) {
                receiverSet.addAll(Lists.newArrayList((Object[])config.getCustomMailList().split(";")));
            }
        }
        if (config.getPickUcAddress().booleanValue()) {
            // empty if block
        }
        for (Map.Entry entry : keyByDatas.entrySet()) {
            MsEmailRequest request = new MsEmailRequest();
            request.setTemplateCode(this.templateNo);
            ArrayList<MsAttachment> attaches = new ArrayList<MsAttachment>();
            log.info("@dailyJob print keyByGroup : " + (String)entry.getKey());
            Collection invoices = (Collection)entry.getValue();
            BigDecimal totalAmount = BigDecimal.ZERO;
            String seller = null;
            for (SellerInvoiceInfo invoice : invoices) {
                if (StringUtils.isEmpty(seller)) {
                    seller = invoice.getSellerName();
                }
                if (!StringUtils.isEmpty((CharSequence)invoice.getInvoiceUrl())) {
                    MsAttachment attachment = new MsAttachment();
                    attachment.setDisplayName(invoice.getInvoiceCode());
                    attachment.setFileUrl(invoice.getInvoiceUrl());
                    attaches.add(attachment);
                }
                if (config.getPickBizBillAddress().booleanValue() && StringUtils.isNotEmpty((CharSequence)invoice.getReceiveUserEmail())) {
                    receiverSet.add(invoice.getReceiveUserEmail());
                }
                totalAmount.add(invoice.getAmountWithTax());
                request.appendBatchNo(invoice.getBatchNo().toString());
            }
            ArrayList receivers = Lists.newArrayList((Iterable)receiverSet);
            if ("open".equals(this.defaultReceiverSwitch)) {
                ArrayList<String> defaultReceiver = new ArrayList<String>();
                defaultReceiver.add("guojia@xforceplus.com");
                request.setReceivers(defaultReceiver);
            } else {
                request.setReceivers((List)receivers);
            }
            request.setAttachments(attaches);
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("sellerName", seller);
            prop.put("invoiceCount", invoices.size());
            prop.put("totalAmount", totalAmount.doubleValue());
            prop.put("startTime", DateUtil.dateToString((Date)config.getStartTime()));
            prop.put("endTime", DateUtil.dateToString((Date)config.getEndTime()));
            request.setProps(prop);
            this.sendMail(request);
        }
    }

    private Map<String, Collection<SellerInvoiceInfo>> keyByInvoice(CfgResult config, JobSellerInvoiceModel result) {
        List list = result.getList();
        1 keyByFunc = new /* Unavailable Anonymous Inner Class!! */;
        ImmutableListMultimap keyByMap = Multimaps.index((Iterable)list, (Function)keyByFunc);
        return keyByMap.asMap();
    }

    private JobSellerInvoiceModel getSellerInvoice(CfgResult config) {
        JobSellerInvoiceRequest request = new JobSellerInvoiceRequest();
        try {
            request.setSellerTaxNo(config.getSellerTaxNo());
            request.setPurTaxNo(config.getPurTaxNo());
            request.setInvoiceType(config.getInvoiceType());
            request.setStartTime(config.getStartTime());
            request.setEndTime(config.getEndTime());
            request.setBillType(config.getBillType());
            log.info("@getSellerInvoice request: " + StringUtil.describeBean((Object)request));
        }
        catch (Exception e) {
            log.error("@dailyJob copyProp error: ", (Throwable)e);
        }
        return this.invoiceApiClient.querySellerInvoice(request);
    }

    private CfgResult getCfgInfo(String configId, boolean isDaily) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        cfgConfigExample.createCriteria().andConfigIdEqualTo(Long.valueOf(Long.parseLong(configId))).andStatusEqualTo(Byte.valueOf(ConstantValue.STATUS_ACTIVE.byteValue()));
        List configs = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return null;
        }
        CfgConfigEntity config = (CfgConfigEntity)configs.get(0);
        CfgConfigMailRuleExample mailExample = new CfgConfigMailRuleExample();
        mailExample.createCriteria().andConfigIdEqualTo(config.getConfigId()).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        List mailRule = this.cfgConfigMailRuleDao.selectByExample(mailExample);
        if (CollectionUtils.isEmpty((Collection)mailRule)) {
            return null;
        }
        CfgConfigMailRuleEntity mailRuleEntity = (CfgConfigMailRuleEntity)mailRule.get(0);
        String purTaxNo = config.getPurchaserTaxNo();
        String sellerTaxNo = config.getSellerTaxNo();
        String invoiceType = config.getInvoiceType();
        String billType = config.getSalesbillType();
        Long sellGroupId = config.getSellerGroupId();
        Long purchaserGroupId = config.getPurchaserGroupId();
        Date startTime = null;
        Date endTime = null;
        if (isDaily) {
            startTime = DateTools.getDate((String)mailRuleEntity.getSendTime(), (int)-1);
            endTime = DateTools.getDate((String)mailRuleEntity.getSendTime(), (int)0);
        } else {
            startTime = DateUtil.getFirstdayOfMonth((Date)DateUtil.addDays((Date)new Date(), (int)-3));
            endTime = DateUtil.getLastdayOfMonth((Date)DateUtil.addDays((Date)new Date(), (int)-3));
        }
        CfgResult cfgInfo = new CfgResult();
        cfgInfo.setPurTaxNo(purTaxNo);
        cfgInfo.setSellerTaxNo(sellerTaxNo);
        cfgInfo.setBillType(billType);
        cfgInfo.setInvoiceType(invoiceType);
        cfgInfo.setStartTime(startTime);
        cfgInfo.setEndTime(endTime);
        cfgInfo.setCombineType(mailRuleEntity.getCombineType());
        cfgInfo.setPickBizBillAddress(mailRuleEntity.getPickBizBillAddress());
        cfgInfo.setCustomMailList(mailRuleEntity.getCustomMailList());
        cfgInfo.setPickUcAddress(mailRuleEntity.getPickUcAddress());
        cfgInfo.setUseCustomAddress(mailRuleEntity.getUseCustomAddress());
        cfgInfo.setMailTemplateNo(mailRuleEntity.getMailTemplateNo());
        cfgInfo.setSellGroupId(sellGroupId);
        cfgInfo.setPurchaserGroupId(purchaserGroupId);
        return cfgInfo;
    }

    private boolean sendMail(MsEmailRequest request) {
        block5: {
            log.info("@sendMail start sendMail request: " + StringUtil.describeBean((Object)request));
            request.setAppId(Long.valueOf(20L));
            request.setSenderName("\u7968\u6613\u901a\u884c\u4e1a\u6807\u51c6\u5316\u5e73\u53f0");
            request.setSubject("\u7968\u6613\u901a\u6bcf\u65e5\u53d1\u7968\u6c47\u603b");
            request.setTenantId(Long.valueOf(0L));
            MsMailResponse response = null;
            try {
                response = this.smsEmailClient.sendEmail(Long.valueOf(0L), request);
                if (1 == response.getCode()) {
                    if (log.isInfoEnabled()) {
                        log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f, bean: {}", (Object)request);
                        ArrayList<LogNoticeEventEntity> eventEntities = new ArrayList<LogNoticeEventEntity>();
                        for (Receiver receiver : request.getReceiverList()) {
                            LogNoticeEventEntity entity = new LogNoticeEventEntity();
                            entity.setBatchNo(request.getBatchNo());
                            entity.setChannel("mail");
                            entity.setCreateTime(new Date());
                            entity.setReceiver(receiver.getReceiver());
                            eventEntities.add(entity);
                        }
                        this.logNoticeEventExtDao.insertBatch(eventEntities);
                    }
                    return true;
                }
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25, bean: {}, response: {}", (Object)request, (Object)response);
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block5;
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25, bean: {}", (Object)request);
                log.error("\u5f02\u5e38\u8be6\u60c5: ", (Throwable)e);
            }
        }
        return false;
    }
}

