/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.bizconfig.service.impl.ImportConfigServiceImpl;
import com.xforceplus.seller.config.listeners.model.SplitConfig;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplitConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(SplitConfigImportListener.class);
    @Autowired
    ImportConfigServiceImpl importConfigServiceImpl;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.split.config.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            String body = new String(message.getBody());
            logger.info("\u62c6\u7968\u89c4\u5219\u5bfc\u5165:{}", (Object)body);
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("configType", "1");
            List list = JsonUtils.writeFastJsonToListObject((String)body, SplitConfig.class);
            this.importConfigServiceImpl.importSplitConfig(list, headers);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f00\u7968\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }
}

