/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.bizconfig.service.impl.ImportConfigServiceImpl;
import com.xforceplus.seller.config.listeners.model.TerminalConfig;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(TerminalConfigImportListener.class);
    @Autowired
    private ImportConfigServiceImpl importConfigServiceImpl;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.terminal.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            logger.info("\u7ec8\u7aef\u5bfc\u5165:{},headers:{}", (Object)body, (Object)JsonUtils.writeObjectToJson((Object)headers));
            List list = JsonUtils.writeJsonToListObject((String)body, TerminalConfig.class);
            this.importConfigServiceImpl.importTerminal(list, headers);
        }
        catch (Exception e) {
            logger.error("\u7ec8\u7aef\u5bfc\u5165\u5f02\u5e38:{}", (Throwable)e);
        }
    }
}

