/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.proxy;

import com.google.common.collect.Lists;
import com.xforceplus.micro.tax.device.contract.model.AddDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryResponseInfo;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.DeviceApiClient;
import com.xforceplus.seller.config.proxy.RestTemplateTools;
import com.xforceplus.seller.config.proxy.model.NewCompanyInfo;
import com.xforceplus.seller.config.proxy.model.NewGetTerminalRequest;
import com.xforceplus.seller.config.proxy.model.NewTerminalQueryInfo;
import com.xforceplus.seller.config.proxy.model.RestGetTerminalRequest;
import com.xforceplus.seller.config.proxy.model.RestGetTerminalResponse;
import com.xforceplus.seller.config.proxy.model.RestTerminalQueryInfo;
import com.xforceplus.seller.config.proxy.model.device.RestActiveCodeRequest;
import com.xforceplus.seller.config.proxy.model.device.RestActiveCodeResponse;
import com.xforceplus.seller.config.proxy.model.device.RestAddDeviceRequest;
import com.xforceplus.seller.config.proxy.model.device.RestAddDeviceResponse;
import com.xforceplus.seller.config.proxy.model.device.RestAddTerminalRequest;
import com.xforceplus.seller.config.proxy.model.device.RestAddTerminalResponse;
import com.xforceplus.seller.config.proxy.model.device.RestCancelDeviceStockRequest;
import com.xforceplus.seller.config.proxy.model.device.RestCancelDeviceStockResponse;
import com.xforceplus.seller.config.proxy.model.device.RestCancelExtractRequest;
import com.xforceplus.seller.config.proxy.model.device.RestCancelExtractResponse;
import com.xforceplus.seller.config.proxy.model.device.RestDeviceQueryInfo;
import com.xforceplus.seller.config.proxy.model.device.RestGetActiveResponse;
import com.xforceplus.seller.config.proxy.model.device.RestGetSubscribeDeviceStockResponse;
import com.xforceplus.seller.config.proxy.model.device.RestGetSubscribeResponse;
import com.xforceplus.seller.config.proxy.model.device.RestQueryDeviceRequest;
import com.xforceplus.seller.config.proxy.model.device.RestQueryDeviceResponse;
import com.xforceplus.seller.config.proxy.model.device.RestSendLicenseRequest;
import com.xforceplus.seller.config.proxy.model.device.RestSendLicenseResponse;
import com.xforceplus.seller.config.proxy.model.device.RestSubscribeDeviceStockRequest;
import com.xforceplus.seller.config.proxy.model.device.RestSubscribeDeviceStockResponse;
import com.xforceplus.seller.config.proxy.model.device.RestSubscribeExtractRequest;
import com.xforceplus.seller.config.proxy.model.device.RestSubscribeExtractResponse;
import com.xforceplus.seller.config.proxy.model.device.RestTerminalQueryResponseInfo;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateDeviceRequest;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateDeviceResponse;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateDeviceStatusRequest;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateDeviceStatusResponse;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateTerminalRequest;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateTerminalResponse;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateTerminalStatusRequest;
import com.xforceplus.seller.config.proxy.model.device.RestUpdateTerminalStatusResponse;
import com.xforceplus.seller.config.proxy.model.device.SendEmailItem;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeviceApiProxy {
    private static final Logger logger = LoggerFactory.getLogger(DeviceApiProxy.class);
    public static final String SUCESS = "1";
    @Value(value="${invoice.makeout.using.rest.api}")
    private boolean useingRestApi;
    @Value(value="${invoice.makeout.global.url:https://paas-t.xforceplus.com/}")
    private String globalPath;
    @Autowired
    private DeviceApiClient deviceApiClient;
    @Autowired
    RestTemplateTools restTemplateTools;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private IDGenerator idGenerator;

    public UserInfo getUserInfo() {
        UserInfo userInfo = new UserInfo();
        userInfo.setGroupId(2L);
        return userInfo;
    }

    public AddDeviceResponse deviceAddPost(RestAddDeviceRequest addDeviceRequest) {
        AddDeviceResponse addDeviceResponse = null;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/devices";
        addDeviceResponse = new AddDeviceResponse();
        RestAddDeviceResponse restAddDeviceResponse = (RestAddDeviceResponse)this.restTemplateTools.postEntity((Object)addDeviceRequest, groupId, subUrl, RestAddDeviceResponse.class);
        this.convertAddDeviceResponse(restAddDeviceResponse, addDeviceResponse);
        return addDeviceResponse;
    }

    public UpdateDeviceResponse deviceUpdatePost(RestUpdateDeviceRequest updateDeviceRequest) {
        UpdateDeviceResponse updateDeviceResponse = null;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/devices";
        RestUpdateDeviceResponse restUpdateDeviceResponse = (RestUpdateDeviceResponse)this.restTemplateTools.putEntity((Object)updateDeviceRequest, groupId, subUrl, RestUpdateDeviceResponse.class);
        updateDeviceResponse = new UpdateDeviceResponse();
        this.convertUpdateDeviceResponse(restUpdateDeviceResponse, updateDeviceResponse);
        return updateDeviceResponse;
    }

    public UpdateDeviceStatusResponse deviceUpdateStatusPost(UpdateDeviceStatusRequest updateStatusRequest) {
        UpdateDeviceStatusResponse updateStatusResponse = null;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/devices";
        RestUpdateDeviceStatusRequest restUpdateDeviceStatusRequest = new RestUpdateDeviceStatusRequest();
        this.convertUpdateDeviceStatusRequest(updateStatusRequest, restUpdateDeviceStatusRequest);
        RestUpdateDeviceStatusResponse restUpdateDeviceStatusResponse = (RestUpdateDeviceStatusResponse)this.restTemplateTools.patchEntity((Object)restUpdateDeviceStatusRequest, groupId, subUrl, RestUpdateDeviceStatusResponse.class);
        updateStatusResponse = new UpdateDeviceStatusResponse();
        this.convertUpdateDeviceStatusResponse(restUpdateDeviceStatusResponse, updateStatusResponse);
        return updateStatusResponse;
    }

    public QueryDeviceResponse deviceQueryPost(QueryDeviceRequest destinationRequest) {
        QueryDeviceResponse queryDeviceResponse = null;
        if (this.useingRestApi) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            Long groupId = 0L;
            if (userInfo != null) {
                groupId = userInfo.getGroupId();
            }
            String subUrl = "/taxware/v1/hardware/devices/query";
            RestQueryDeviceRequest restQueryDeviceRequest = new RestQueryDeviceRequest();
            this.convertQueryDeviceToReuest(destinationRequest, restQueryDeviceRequest);
            RestQueryDeviceResponse restQueryDeviceResponse = (RestQueryDeviceResponse)this.restTemplateTools.postEntity((Object)restQueryDeviceRequest, groupId, subUrl, RestQueryDeviceResponse.class);
            queryDeviceResponse = new QueryDeviceResponse();
            this.convertQueryDeviceToResponse(restQueryDeviceResponse, queryDeviceResponse);
        } else {
            queryDeviceResponse = this.deviceApiClient.deviceQueryPost(destinationRequest);
        }
        return queryDeviceResponse;
    }

    public QueryDeviceResponse deviceQueryPost(QueryDeviceRequest destinationRequest, Long groupId, List<String> taxNos) {
        QueryDeviceResponse queryDeviceResponse = null;
        if (this.useingRestApi) {
            if (groupId == null) {
                UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
                groupId = userInfo.getGroupId();
            }
            String subUrl = "/taxware/v1/hardware/devices/query";
            RestQueryDeviceRequest restQueryDeviceRequest = new RestQueryDeviceRequest();
            this.convertQueryDeviceToReuest(destinationRequest, restQueryDeviceRequest);
            if (taxNos != null && restQueryDeviceRequest.getQueryInfo().getCompanyInfo() != null) {
                restQueryDeviceRequest.getQueryInfo().getCompanyInfo().setTaxNos(taxNos);
            }
            RestQueryDeviceResponse restQueryDeviceResponse = (RestQueryDeviceResponse)this.restTemplateTools.postEntity((Object)restQueryDeviceRequest, groupId, subUrl, RestQueryDeviceResponse.class);
            queryDeviceResponse = new QueryDeviceResponse();
            this.convertQueryDeviceToResponse(restQueryDeviceResponse, queryDeviceResponse);
        } else {
            queryDeviceResponse = this.deviceApiClient.deviceQueryPost(destinationRequest);
        }
        return queryDeviceResponse;
    }

    public RestQueryDeviceResponse deviceQueryPost(RestQueryDeviceRequest destinationRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = 0L;
        if (userInfo != null) {
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/devices/query";
        RestQueryDeviceResponse restQueryDeviceResponse = (RestQueryDeviceResponse)this.restTemplateTools.postEntity((Object)destinationRequest, groupId, subUrl, RestQueryDeviceResponse.class);
        return restQueryDeviceResponse;
    }

    public AddTerminalResponse deviceTerminalAddPost(AddTerminalRequest destinationRequest, Long groupId) {
        AddTerminalResponse addTerminalResponse = null;
        if (this.useingRestApi) {
            if (groupId == null) {
                UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
                groupId = userInfo.getGroupId();
            }
            String subUrl = "/taxware/v1/hardware/terminals";
            RestAddTerminalRequest restAddTerminalRequest = new RestAddTerminalRequest();
            this.convertAddTerminalRequest(destinationRequest, restAddTerminalRequest);
            RestAddTerminalResponse restAddTerminalResponse = (RestAddTerminalResponse)this.restTemplateTools.postEntity((Object)restAddTerminalRequest, groupId, subUrl, RestAddTerminalResponse.class);
            addTerminalResponse = new AddTerminalResponse();
            this.convertAddTerminalResponse(restAddTerminalResponse, addTerminalResponse);
        } else {
            addTerminalResponse = this.deviceApiClient.deviceTerminalAddPost(destinationRequest);
        }
        return addTerminalResponse;
    }

    public UpdateTerminalStatusResponse deviceTerminalUpdateStatusPost(UpdateTerminalStatusRequest destinationRequest) {
        UpdateTerminalStatusResponse sourceResponse = null;
        if (this.useingRestApi) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            Long groupId = userInfo.getGroupId();
            String subUrl = "/taxware/v1/hardware/terminals";
            RestUpdateTerminalStatusRequest restUpdateTerminalStatusRequest = new RestUpdateTerminalStatusRequest();
            this.convertUpdateTerminalStatusRequest(destinationRequest, restUpdateTerminalStatusRequest);
            RestUpdateTerminalStatusResponse restUpdateTerminalStatusResponse = (RestUpdateTerminalStatusResponse)this.restTemplateTools.patchEntity((Object)restUpdateTerminalStatusRequest, groupId, subUrl, RestUpdateTerminalStatusResponse.class);
            sourceResponse = new UpdateTerminalStatusResponse();
            this.convertUpdateTerminalStatusResponse(restUpdateTerminalStatusResponse, sourceResponse);
        } else {
            sourceResponse = this.deviceApiClient.deviceTerminalUpdateStatusPost(destinationRequest);
        }
        return sourceResponse;
    }

    public UpdateTerminalResponse deviceTerminalUpdatePost(UpdateTerminalRequest destinationRequest, Long groupId) {
        UpdateTerminalResponse sourceResponse = null;
        if (this.useingRestApi) {
            if (groupId == null) {
                UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
                groupId = userInfo.getGroupId();
            }
            String subUrl = "/taxware/v1/hardware/terminals";
            RestUpdateTerminalRequest restUpdateTerminalRequest = new RestUpdateTerminalRequest();
            this.convertUpdateTerminalRequest(destinationRequest, restUpdateTerminalRequest);
            RestUpdateTerminalResponse restUpdateTerminalResponse = (RestUpdateTerminalResponse)this.restTemplateTools.putEntity((Object)restUpdateTerminalRequest, groupId, subUrl, RestUpdateTerminalResponse.class);
            sourceResponse = new UpdateTerminalResponse();
            this.convertUpdateTerminalResponse(restUpdateTerminalResponse, sourceResponse);
        } else {
            sourceResponse = this.deviceApiClient.deviceTerminalUpdatePost(destinationRequest);
        }
        return sourceResponse;
    }

    public QueryTerminalResponse deviceTerminalQueryPost(QueryTerminalRequest request, Long groupId) {
        QueryTerminalResponse sourceResponse = null;
        if (this.useingRestApi) {
            if (groupId == null) {
                UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
                groupId = userInfo.getGroupId();
            }
            String subUrl = "/taxware/v1/hardware/terminals/query";
            RestGetTerminalRequest restGetTerminalRequest = new RestGetTerminalRequest();
            this.convertGetTerminalToRestRequest(request, restGetTerminalRequest);
            RestGetTerminalResponse restGetTerminalResponse = (RestGetTerminalResponse)this.restTemplateTools.postEntity((Object)restGetTerminalRequest, groupId, subUrl, RestGetTerminalResponse.class);
            QueryTerminalResponse queryTerminalResponse = new QueryTerminalResponse();
            this.convertGetTerminalToRestResponse(restGetTerminalResponse, queryTerminalResponse);
            sourceResponse = queryTerminalResponse;
        } else {
            sourceResponse = this.deviceApiClient.deviceTerminalQueryPost(request);
        }
        return sourceResponse;
    }

    public QueryTerminalResponse deviceTerminalQueryPost(QueryTerminalRequest request, Long groupId, List<String> userCompanyTaxNos) {
        QueryTerminalResponse sourceResponse = null;
        if (this.useingRestApi) {
            if (groupId == null) {
                UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
                groupId = userInfo.getGroupId();
            }
            String subUrl = "/taxware/v1/hardware/terminals/query";
            NewGetTerminalRequest restGetTerminalRequest = this.generateGetTerminalRequest(request, userCompanyTaxNos);
            RestGetTerminalResponse restGetTerminalResponse = (RestGetTerminalResponse)this.restTemplateTools.postEntity((Object)restGetTerminalRequest, groupId, subUrl, RestGetTerminalResponse.class);
            QueryTerminalResponse queryTerminalResponse = new QueryTerminalResponse();
            this.convertGetTerminalToRestResponse(restGetTerminalResponse, queryTerminalResponse);
            sourceResponse = queryTerminalResponse;
        } else {
            sourceResponse = this.deviceApiClient.deviceTerminalQueryPost(request);
        }
        return sourceResponse;
    }

    public SendLicenseResponse deviceLicenseSendPost(SendLicenseRequest destinationRequest) {
        SendLicenseResponse sourceResponse = null;
        if (this.useingRestApi) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            Long groupId = 0L;
            if (userInfo != null) {
                groupId = userInfo.getGroupId();
            }
            String subUrl = "/taxware/v1/hardware/terminal/license-key/send";
            String adaptpath = "api/device/global";
            String path = this.globalPath + adaptpath + subUrl;
            RestActiveCodeRequest restSendActiveCodeRequest = new RestActiveCodeRequest();
            this.convertSendActiveCodeToRestRequest(destinationRequest, restSendActiveCodeRequest);
            RestActiveCodeResponse restActvieCodeResponse = (RestActiveCodeResponse)this.restTemplateTools.postEntity((Object)restSendActiveCodeRequest, groupId, path, RestActiveCodeResponse.class);
            sourceResponse = new SendLicenseResponse();
            this.convertActiveCodeToRestResponse(restActvieCodeResponse, sourceResponse);
        } else {
            sourceResponse = this.deviceApiClient.deviceLicenseSendPost(destinationRequest);
        }
        return sourceResponse;
    }

    private void convertActiveCodeToRestResponse(RestActiveCodeResponse restActvieCodeResponse, SendLicenseResponse sourceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restActvieCodeResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setTraceId(restActvieCodeResponse.getTraceId());
            sourceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restActvieCodeResponse.getMessage());
            responseHead.setTraceId(restActvieCodeResponse.getTraceId());
            sourceResponse.setHead(responseHead);
        }
    }

    private void convertSendActiveCodeToRestRequest(SendLicenseRequest destinationRequest, RestActiveCodeRequest restSendActiveCodeRequest) {
        ArrayList sendList = Lists.newArrayList();
        String receiverEmail = destinationRequest.getReceiverEmail();
        String[] split = receiverEmail.split(",");
        for (int i = 0; i < split.length; ++i) {
            String email = split[i];
            SendEmailItem emailItem = new SendEmailItem();
            emailItem.setReceiverEmail(email);
            emailItem.setTerminalUn(destinationRequest.getUn());
            sendList.add(emailItem);
        }
        restSendActiveCodeRequest.setSendLicenseList((List)sendList);
    }

    private void convertSendLicenseToRestResponse(RestSendLicenseResponse restSendLicenseResponse, SendLicenseResponse sendLicenseResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restSendLicenseResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setTraceId(restSendLicenseResponse.getResult().getTraceId());
            sendLicenseResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restSendLicenseResponse.getMessage());
            responseHead.setTraceId(restSendLicenseResponse.getTraceId());
            sendLicenseResponse.setHead(responseHead);
        }
    }

    private void convertSendLicenseToRestRequest(SendLicenseRequest destinationRequest, RestSendLicenseRequest restSendLicenseRequest) {
        restSendLicenseRequest.setLicenseType(destinationRequest.getLicenseType());
        restSendLicenseRequest.setOperateInfo(destinationRequest.getOperateInfo());
        restSendLicenseRequest.setReceiverEmail(destinationRequest.getReceiverEmail());
        restSendLicenseRequest.setUn(destinationRequest.getUn());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u53d1\u9001\u6388\u6743\u6587\u4ef6\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restSendLicenseRequest.setSerialNo(serialNo);
    }

    private void convertGetTerminalToRestResponse(RestGetTerminalResponse restGetTerminalResponse, QueryTerminalResponse queryTerminalResponse) {
        if (SUCESS.equals(restGetTerminalResponse.getCode())) {
            ResponseHead responseHead = new ResponseHead();
            responseHead.setCode(Integer.valueOf(1));
            queryTerminalResponse.setHead(responseHead);
            RestTerminalQueryResponseInfo restTerminalQueryResponseInfo = new RestTerminalQueryResponseInfo();
            ArrayList<TerminalQueryResponseInfo> terminals = new ArrayList<TerminalQueryResponseInfo>();
            if (restGetTerminalResponse.getResult() != null) {
                List list = restGetTerminalResponse.getResult().getTerminals();
                for (RestTerminalQueryResponseInfo info : list) {
                    TerminalQueryResponseInfo terminalQueryResponseInfo = new TerminalQueryResponseInfo();
                    BeanUtils.copyProperties((Object)info, (Object)terminalQueryResponseInfo);
                    ArrayList onlineDevices = Lists.newArrayList();
                    if (info.getOnlineDevice() != null) {
                        DeviceInfo deviceInfo = new DeviceInfo();
                        deviceInfo.setDeviceUn(info.getOnlineDevice().getDeviceUn());
                        deviceInfo.setId(Long.valueOf(0L));
                        onlineDevices.add(deviceInfo);
                        terminalQueryResponseInfo.setOnlineDevices((List)onlineDevices);
                    }
                    terminals.add(terminalQueryResponseInfo);
                }
            }
            queryTerminalResponse.setTerminals(terminals);
            queryTerminalResponse.setPageInfo(restGetTerminalResponse.getResult().getPageInfo());
        } else {
            ResponseHead responseHead = new ResponseHead();
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restGetTerminalResponse == null ? "\u67e5\u8be2\u9519\u8bef" : restGetTerminalResponse.getMessage());
            queryTerminalResponse.setHead(responseHead);
        }
    }

    private void convertGetTerminalToRestRequest(QueryTerminalRequest request, RestGetTerminalRequest restGetTerminalRequest) {
        restGetTerminalRequest.setPageInfo(request.getPageInfo());
        restGetTerminalRequest.setQueryServiceState(request.QueryServiceState());
        restGetTerminalRequest.setSerialNo(String.valueOf(this.idGenerator.nextId()));
        RestTerminalQueryInfo restTerminalQueryInfo = new RestTerminalQueryInfo();
        @Valid TerminalQueryInfo terminalInfo = request.getTerminalInfo();
        BeanUtils.copyProperties((Object)terminalInfo, (Object)restTerminalQueryInfo);
        restTerminalQueryInfo.setTerminalUns(request.getTerminalInfo().getTerminalUns());
        restGetTerminalRequest.setTerminalInfo(restTerminalQueryInfo);
    }

    private NewGetTerminalRequest generateGetTerminalRequest(QueryTerminalRequest request, List<String> userCompanyTaxNos) {
        NewTerminalQueryInfo terminalQueryInfo;
        NewGetTerminalRequest getTerminalRequest = new NewGetTerminalRequest();
        BeanMapper.copy((Object)request, (Object)getTerminalRequest);
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u67e5\u8be2\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        getTerminalRequest.setSerialNo(serialNo);
        if (getTerminalRequest.getTerminalInfo() == null) {
            getTerminalRequest.setTerminalInfo(new NewTerminalQueryInfo());
        }
        if ((terminalQueryInfo = getTerminalRequest.getTerminalInfo()).getCompanyInfo() == null) {
            terminalQueryInfo.setCompanyInfo(new NewCompanyInfo());
        }
        NewCompanyInfo companyInfo = terminalQueryInfo.getCompanyInfo();
        companyInfo.setTaxNos(userCompanyTaxNos);
        return getTerminalRequest;
    }

    private void convertAddDeviceResponse(RestAddDeviceResponse restAddDeviceResponse, AddDeviceResponse addDeviceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restAddDeviceResponse.getCode())) {
            addDeviceResponse.setDeviceUn(restAddDeviceResponse.getResult().getDeviceUn());
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setTraceId(restAddDeviceResponse.getResult().getTraceId());
            addDeviceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restAddDeviceResponse == null ? "\u65b0\u589e\u8bbe\u5907\u51fa\u9519\uff01" : restAddDeviceResponse.getMessage());
            addDeviceResponse.setHead(responseHead);
        }
    }

    private void convertUpdateDeviceResponse(RestUpdateDeviceResponse restUpdateDeviceResponse, UpdateDeviceResponse updateDeviceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateDeviceResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u4fee\u6539\u6210\u529f");
            responseHead.setTraceId(restUpdateDeviceResponse.getResult().getTraceId());
            updateDeviceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateDeviceResponse != null ? restUpdateDeviceResponse.getMessage() : "\u4fee\u6539\u51fa\u9519");
            responseHead.setTraceId(restUpdateDeviceResponse.getTraceId());
            updateDeviceResponse.setHead(responseHead);
        }
    }

    private void convertQueryDeviceToResponse(RestQueryDeviceResponse restQueryDeviceResponse, QueryDeviceResponse queryDeviceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restQueryDeviceResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u67e5\u8be2\u6210\u529f");
            responseHead.setTraceId(restQueryDeviceResponse.getResult().getTraceId());
            List restDeviceInfos = restQueryDeviceResponse.getResult().getDevices();
            if (restDeviceInfos != null && restDeviceInfos.size() > 0) {
                ArrayList devices = new ArrayList();
                restDeviceInfos.stream().forEach(restDeviceInfo -> {
                    DeviceInfo deviceInfo = new DeviceInfo();
                    BeanMapper.copy((Object)restDeviceInfo, (Object)deviceInfo);
                    devices.add(deviceInfo);
                });
                queryDeviceResponse.setDevices(devices);
            }
            queryDeviceResponse.setOnlineDeviceUns(restQueryDeviceResponse.getResult().getOnlineDeviceUns());
            queryDeviceResponse.setOriginAccountOnlineDeviceUns(restQueryDeviceResponse.getResult().getOriginAccountOnlineDeviceUns());
            queryDeviceResponse.setPageInfo(restQueryDeviceResponse.getResult().getPageInfo());
            queryDeviceResponse.setOnlineDeviceIds((List)Lists.newArrayList());
            queryDeviceResponse.setOriginAccountOnlineDeviceUns((List)Lists.newArrayList());
            queryDeviceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage("\u67e5\u8be2\u5931\u8d25");
            queryDeviceResponse.setHead(responseHead);
        }
    }

    private void convertQueryDeviceToReuest(QueryDeviceRequest destinationRequest, RestQueryDeviceRequest restQueryDeviceRequest) {
        restQueryDeviceRequest.setPageInfo(destinationRequest.getPageInfo());
        RestDeviceQueryInfo restDeviceQueryInfo = new RestDeviceQueryInfo();
        BeanUtils.copyProperties((Object)destinationRequest.getQueryInfo(), (Object)restDeviceQueryInfo);
        restQueryDeviceRequest.setQueryInfo(restDeviceQueryInfo);
        restQueryDeviceRequest.setQueryServiceState(destinationRequest.QueryServiceState());
        restQueryDeviceRequest.setQueryOriginAccountServiceState(destinationRequest.QueryOriginAccountServiceState());
        restQueryDeviceRequest.setSortInfo(destinationRequest.getSortInfo());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u67e5\u8be2\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restQueryDeviceRequest.setSerialNo(serialNo);
    }

    private void convertAddTerminalResponse(RestAddTerminalResponse restAddTerminalResponse, AddTerminalResponse addTerminalResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restAddTerminalResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("");
            addTerminalResponse.setHead(responseHead);
            addTerminalResponse.setTerminalUn(restAddTerminalResponse.getResult().getTerminalUn());
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restAddTerminalResponse.getMessage());
            responseHead.setTraceId(restAddTerminalResponse.getTraceId());
            addTerminalResponse.setHead(responseHead);
        }
    }

    private void convertAddTerminalRequest(AddTerminalRequest destinationRequest, RestAddTerminalRequest restAddTerminalRequest) {
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u65b0\u589e\u7ec8\u7aef\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restAddTerminalRequest.setSerialNo(serialNo);
        restAddTerminalRequest.setLicenseInfo(destinationRequest.getLicenseInfo());
        restAddTerminalRequest.setTerminalInfo(destinationRequest.getTerminalInfo());
    }

    private void convertUpdateTerminalResponse(RestUpdateTerminalResponse restUpdateTerminalResponse, UpdateTerminalResponse updateTerminalResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateTerminalResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u4fee\u6539\u6210\u529f\uff01");
            updateTerminalResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateTerminalResponse.getMessage());
            updateTerminalResponse.setHead(responseHead);
        }
    }

    private void convertUpdateTerminalRequest(UpdateTerminalRequest destinationRequest, RestUpdateTerminalRequest restUpdateTerminalRequest) {
        restUpdateTerminalRequest.setTerminalInfo(destinationRequest.getTerminalInfo());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u4fee\u6539\u7ec8\u7aef\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restUpdateTerminalRequest.setSerialNo(serialNo);
    }

    private void convertUpdateDeviceStatusResponse(RestUpdateDeviceStatusResponse restUpdateDeviceStatusResponse, UpdateDeviceStatusResponse updateStatusResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateDeviceStatusResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u66f4\u65b0\u6210\u529f\uff01");
            updateStatusResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateDeviceStatusResponse.getMessage());
            updateStatusResponse.setHead(responseHead);
        }
    }

    private void convertUpdateDeviceStatusRequest(UpdateDeviceStatusRequest updateStatusRequest, RestUpdateDeviceStatusRequest restUpdateDeviceStatusRequest) {
        restUpdateDeviceStatusRequest.setDeviceUns(updateStatusRequest.getDeviceUns());
        restUpdateDeviceStatusRequest.setDeviceId(updateStatusRequest.getDeviceId());
        restUpdateDeviceStatusRequest.setFromSystem(updateStatusRequest.getFromSystem());
        restUpdateDeviceStatusRequest.setLicenseInfo(updateStatusRequest.getLicenseInfo());
        restUpdateDeviceStatusRequest.setOperateInfo(updateStatusRequest.getOperateInfo());
        restUpdateDeviceStatusRequest.setRemark(updateStatusRequest.getRemark());
        restUpdateDeviceStatusRequest.setStatus(updateStatusRequest.getStatus());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u66f4\u65b0\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restUpdateDeviceStatusRequest.setSerialNo(serialNo);
    }

    private void convertUpdateTerminalStatusResponse(RestUpdateTerminalStatusResponse restUpdateTerminalStatusResponse, UpdateTerminalStatusResponse sourceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateTerminalStatusResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u4fee\u6539\u72b6\u6001\u6210\u529f");
            sourceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateTerminalStatusResponse.getMessage());
            sourceResponse.setHead(responseHead);
        }
    }

    private void convertUpdateTerminalStatusRequest(UpdateTerminalStatusRequest destinationRequest, RestUpdateTerminalStatusRequest restUpdateTerminalStatusRequest) {
        restUpdateTerminalStatusRequest.setFromSystem(destinationRequest.getFromSystem());
        restUpdateTerminalStatusRequest.setLicenseInfo(destinationRequest.getLicenseInfo());
        restUpdateTerminalStatusRequest.setOperateInfo(destinationRequest.getOperateInfo());
        restUpdateTerminalStatusRequest.setStatus(destinationRequest.getStatus());
        restUpdateTerminalStatusRequest.setTerminalUns(destinationRequest.getTerminalUns());
        restUpdateTerminalStatusRequest.setTerminalId(destinationRequest.getTerminalId());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u4fee\u6539\u7ec8\u7aef\u72b6\u6001\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restUpdateTerminalStatusRequest.setSerialNo(serialNo);
    }

    public RestGetActiveResponse getActiveCode(String uns) {
        long groupId = 0L;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (userInfo != null) {
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/terminal/license-key/query?terminalUns=";
        String[] split = uns.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (i != split.length - 1) {
                stringBuilder.append(s).append(",");
                continue;
            }
            stringBuilder.append(s);
        }
        subUrl = subUrl + stringBuilder.toString();
        String adaptpath = "api/device/global";
        String path = this.globalPath + adaptpath + subUrl;
        RestGetActiveResponse restGetActiveResponse = (RestGetActiveResponse)this.restTemplateTools.getEntity(null, Long.valueOf(groupId), path, RestGetActiveResponse.class);
        return restGetActiveResponse;
    }

    public RestSubscribeExtractResponse extractSubscribe(RestSubscribeExtractRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device/extract-subscribe";
        RestSubscribeExtractResponse response = (RestSubscribeExtractResponse)this.restTemplateTools.postEntity((Object)request, groupId, subUrl, RestSubscribeExtractResponse.class);
        return response;
    }

    public RestGetSubscribeResponse getGetSubscribeInfo(int extractType, String extractValue) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device/extract-subscribe?extractType=" + extractType + "&extractValue=" + extractValue;
        RestGetSubscribeResponse response = (RestGetSubscribeResponse)this.restTemplateTools.getEntity(null, groupId, subUrl, RestGetSubscribeResponse.class);
        return response;
    }

    public RestCancelExtractResponse cancelExtractSubscribe(RestCancelExtractRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device/extract-subscribe";
        RestCancelExtractResponse response = (RestCancelExtractResponse)this.restTemplateTools.putEntity((Object)request, groupId, subUrl, RestCancelExtractResponse.class);
        return response;
    }

    public RestSubscribeDeviceStockResponse deviceStockSubscribe(RestSubscribeDeviceStockRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device-stock-subscribe";
        RestSubscribeDeviceStockResponse response = (RestSubscribeDeviceStockResponse)this.restTemplateTools.postEntity((Object)request, groupId, subUrl, RestSubscribeDeviceStockResponse.class);
        return response;
    }

    public RestGetSubscribeDeviceStockResponse getDeviceStockSubscribeInfo(String deviceUn) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (userInfo == null) {
            RestGetSubscribeDeviceStockResponse inventoryResponse = new RestGetSubscribeDeviceStockResponse();
            inventoryResponse.setCode("0");
            return inventoryResponse;
        }
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device-stock-subscribe?deviceUn=" + deviceUn;
        RestGetSubscribeDeviceStockResponse response = (RestGetSubscribeDeviceStockResponse)this.restTemplateTools.getEntity(null, groupId, subUrl, RestGetSubscribeDeviceStockResponse.class);
        return response;
    }

    public RestCancelDeviceStockResponse cancelInventorySubscribe(RestCancelDeviceStockRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device-stock-subscribe";
        RestCancelDeviceStockResponse response = (RestCancelDeviceStockResponse)this.restTemplateTools.deleteEntity((Object)request, groupId, subUrl, RestCancelDeviceStockResponse.class);
        return response;
    }
}

