/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.util.mail;

import com.xforceplus.seller.config.util.mail.AccessClient;
import com.xforceplus.seller.config.util.mail.MsLoginRequest;
import com.xforceplus.seller.config.util.mail.MsMailResponse;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenInterceptor.class);
    private static final Integer SUCCESS = 1;
    private final AccessClient accessClient;
    private final String clientId;
    private final String secret;

    public AccessTokenInterceptor(AccessClient accessClient, String clientId, String secret) {
        this.accessClient = accessClient;
        this.clientId = clientId;
        this.secret = secret;
    }

    public void apply(RequestTemplate template) {
        template.header("x-app-token", new String[]{this.getTokenWithCache()});
    }

    private String getTokenWithCache() {
        String token = null;
        try {
            MsMailResponse loginResponse = this.accessClient.login(new MsLoginRequest(this.clientId, this.secret));
            if (SUCCESS.intValue() == loginResponse.getCode()) {
                token = loginResponse.getData();
            }
            log.info("\u81ea\u52a8\u767b\u5f55\u7528\u6237\u4e2d\u5fc3 clientId: {} secret: {} token: {}", new Object[]{this.clientId, this.secret, token});
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u767b\u5f55\u7528\u6237\u4e2d\u5fc3 clientId: {} secret: {} token: {} \u5f02\u5e38: {}", new Object[]{this.clientId, this.secret, token, e});
        }
        return token;
    }
}

