/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.infrastructure.usercenter.controllers;

import com.xforceplus.phoenix.infrastructure.usercenter.api.UserCenterApi;
import com.xforceplus.phoenix.infrastructure.usercenter.core.MsApiV1InfrastructureUserCenter;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyServicePackageData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyServicePackageQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.ExtensionsDto;
import com.xforceplus.phoenix.infrastructure.usercenter.model.ExtensionsParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgDetaiDTO;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.TenantData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.TenantQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterCompanyService;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterOrgService;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterTenantService;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterUserService;
import com.xforceplus.seller.config.config.DingDingConfig;
import com.xforceplus.seller.config.services.ConfigCompanyService;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@MsApiV1InfrastructureUserCenter
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u0019H\u0016J(\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001c0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010!\u001a\u00020\u0019H\u0016J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010#\u001a\u00020$H\u0016J\"\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010'\u001a\u00020\u0019H\u0016J(\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u001c0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001d\u001a\u00020*H\u0016J(\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010.\u001a\u00020/H\u0016J\"\u00100\u001a\b\u0012\u0004\u0012\u00020 0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u00101\u001a\u00020$H\u0016J\"\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u00103\u001a\u00020\u0019H\u0016J(\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001c0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001d\u001a\u000205H\u0016J(\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002070,0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010#\u001a\u00020$H\u0016J(\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\u001c0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001d\u001a\u00020:H\u0016J\u0018\u0010;\u001a\b\u0012\u0004\u0012\u0002090\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090,0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010'\u001a\u00020\u0019H\u0016J\"\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010#\u001a\u00020$H\u0016J(\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u001c0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001d\u001a\u00020@H\u0016J(\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u001c0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001d\u001a\u00020@H\u0016J:\u0010B\u001a\b\u0012\u0004\u0012\u00020&0\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010'\u001a\u00020\u00192\n\b\u0001\u0010C\u001a\u0004\u0018\u00010$2\n\b\u0001\u0010D\u001a\u0004\u0018\u00010$H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/xforceplus/phoenix/infrastructure/usercenter/controllers/UserCenterController;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/api/UserCenterApi;", "userCenterCompanyService", "Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterCompanyService;", "userCenterOrgService", "Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterOrgService;", "userCenterUserService", "Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterUserService;", "userCenterTenantService", "Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterTenantService;", "configCompanyService", "Lcom/xforceplus/seller/config/services/ConfigCompanyService;", "dingDingConfig", "Lcom/xforceplus/seller/config/config/DingDingConfig;", "dingDingUtils", "Lcom/xforceplus/seller/config/util/DingDingUtils;", "(Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterCompanyService;Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterOrgService;Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterUserService;Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterTenantService;Lcom/xforceplus/seller/config/services/ConfigCompanyService;Lcom/xforceplus/seller/config/config/DingDingConfig;Lcom/xforceplus/seller/config/util/DingDingUtils;)V", "getDingDingConfig", "()Lcom/xforceplus/seller/config/config/DingDingConfig;", "getDingDingUtils", "()Lcom/xforceplus/seller/config/util/DingDingUtils;", "getCompanyById", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterResponse;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyData;", "tenantId", "", "companyId", "getCompanyByParam", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterList;", "param", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyQueryParam;", "getCompanyBySubOrgId", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/OrgData;", "subOrgId", "getCompanyByTaxNo", "taxNo", "", "getCompanyByUserId", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserData;", "userId", "getCompanyServicePackageByParam", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyServicePackageData;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyServicePackageQueryParam;", "getExtensionsByTax", "", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/ExtensionsDto;", "extensionsParam", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/ExtensionsParam;", "getOrgByCode", "orgCode", "getOrgById", "orgId", "getOrgByParams", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/OrgQueryParam;", "getOrgByTaxNum", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/OrgDetaiDTO;", "getTenantByParam", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/TenantData;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/TenantQueryParam;", "getTenantByTenantId", "getTenantByUserId", "getTerminalSwitch", "", "getUserByAccountName", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserQueryParam;", "getUserByParam", "getUserByUserId", "token", "modules", "seller-config-service"})
@SourceDebugExtension(value={"SMAP\nUserCenterController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserCenterController.kt\ncom/xforceplus/phoenix/infrastructure/usercenter/controllers/UserCenterController\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,299:1\n17#2,6:300\n17#2,6:306\n17#2,6:312\n17#2,6:318\n17#2,6:324\n17#2,6:330\n17#2,6:336\n17#2,6:342\n17#2,6:348\n17#2,6:354\n17#2,6:360\n17#2,6:366\n17#2,6:372\n17#2,6:378\n17#2,6:384\n17#2,6:390\n17#2,6:396\n17#2,6:402\n*S KotlinDebug\n*F\n+ 1 UserCenterController.kt\ncom/xforceplus/phoenix/infrastructure/usercenter/controllers/UserCenterController\n*L\n33#1:300,6\n48#1:306,6\n64#1:312,6\n77#1:318,6\n97#1:324,6\n117#1:330,6\n132#1:336,6\n148#1:342,6\n160#1:348,6\n176#1:354,6\n193#1:360,6\n208#1:366,6\n223#1:372,6\n238#1:378,6\n252#1:384,6\n263#1:390,6\n276#1:396,6\n290#1:402,6\n*E\n"})
public class UserCenterController
implements UserCenterApi {
    @NotNull
    private final UserCenterCompanyService userCenterCompanyService;
    @NotNull
    private final UserCenterOrgService userCenterOrgService;
    @NotNull
    private final UserCenterUserService userCenterUserService;
    @NotNull
    private final UserCenterTenantService userCenterTenantService;
    @NotNull
    private final ConfigCompanyService configCompanyService;
    @NotNull
    private final DingDingConfig dingDingConfig;
    @NotNull
    private final DingDingUtils dingDingUtils;

    public UserCenterController(@NotNull UserCenterCompanyService userCenterCompanyService, @NotNull UserCenterOrgService userCenterOrgService, @NotNull UserCenterUserService userCenterUserService, @NotNull UserCenterTenantService userCenterTenantService, @NotNull ConfigCompanyService configCompanyService, @NotNull DingDingConfig dingDingConfig, @NotNull DingDingUtils dingDingUtils) {
        Intrinsics.checkNotNullParameter((Object)userCenterCompanyService, (String)"userCenterCompanyService");
        Intrinsics.checkNotNullParameter((Object)userCenterOrgService, (String)"userCenterOrgService");
        Intrinsics.checkNotNullParameter((Object)userCenterUserService, (String)"userCenterUserService");
        Intrinsics.checkNotNullParameter((Object)userCenterTenantService, (String)"userCenterTenantService");
        Intrinsics.checkNotNullParameter((Object)configCompanyService, (String)"configCompanyService");
        Intrinsics.checkNotNullParameter((Object)dingDingConfig, (String)"dingDingConfig");
        Intrinsics.checkNotNullParameter((Object)dingDingUtils, (String)"dingDingUtils");
        this.userCenterCompanyService = userCenterCompanyService;
        this.userCenterOrgService = userCenterOrgService;
        this.userCenterUserService = userCenterUserService;
        this.userCenterTenantService = userCenterTenantService;
        this.configCompanyService = configCompanyService;
        this.dingDingConfig = dingDingConfig;
        this.dingDingUtils = dingDingUtils;
    }

    @NotNull
    public DingDingConfig getDingDingConfig() {
        return this.dingDingConfig;
    }

    @NotNull
    public DingDingUtils getDingDingUtils() {
        return this.dingDingUtils;
    }

    @NotNull
    public UserCenterResponse<CompanyData> getCompanyById(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="companyId") long companyId) {
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterCompanyService.getCompanyById(tenantId, companyId);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/global/v2/companies/" + companyId + "?byTaxNum=false", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(companyId), "\u79df\u6237id:" + tenantId, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<CompanyData> getCompanyByTaxNo(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="taxNo") @NotNull String taxNo) {
        Intrinsics.checkNotNullParameter((Object)taxNo, (String)"taxNo");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterCompanyService.getCompanyByTaxNo(tenantId, taxNo);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/global/v2/companies/" + taxNo + "?byTaxNum=true", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(taxNo), "\u79df\u6237id:" + tenantId, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<OrgData> getOrgById(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="orgId") long orgId) {
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterOrgService.getOrgById(tenantId, orgId);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/" + tenantId + "/v2/orgs/" + orgId, "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(orgId), "\u79df\u6237id:" + tenantId, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<OrgData> getOrgByCode(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="orgCode") @NotNull String orgCode) {
        Intrinsics.checkNotNullParameter((Object)orgCode, (String)"orgCode");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterOrgService.getOrgByOrgKeyAndTenantKey(String.valueOf(tenantId), orgCode, false, true);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/" + tenantId + "/v2/orgs/" + orgCode + "?byTenantCode=false&byOrgCode=true", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(orgCode), "\u79df\u6237id:" + tenantId, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<OrgData> getCompanyBySubOrgId(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="subOrgId") long subOrgId) {
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = new UserCenterResponse(UserCenterResponse.Companion.getSUCCESS_CODE(), null, (Object)this.configCompanyService.getCompanyBySubOrgId(Long.valueOf(subOrgId), Long.valueOf(tenantId)));
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/" + tenantId + "/v2/orgs/" + subOrgId, "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(subOrgId), "\u79df\u6237id:" + tenantId, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserCenterList<OrgData>> getOrgByParams(@PathVariable(value="tenantId") long tenantId, @RequestBody @NotNull OrgQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterOrgService.getOrgByParams(tenantId, param);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/" + tenantId + "/v2/orgs", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), JsonUtils.writeObjectToFastJson((Object)param), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<List<OrgDetaiDTO>> getOrgByTaxNum(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="taxNo") @NotNull String taxNo) {
        Intrinsics.checkNotNullParameter((Object)taxNo, (String)"taxNo");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterOrgService.getOrgByTaxNum(tenantId, taxNo);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/global/v2/orgs/by-taxnum?taxNum=" + taxNo, "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), taxNo, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserCenterList<TenantData>> getTenantByParam(@PathVariable(value="tenantId") long tenantId, @RequestBody @NotNull TenantQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterTenantService.getTenantByParam(tenantId, param);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/global/v2/tenants/" + tenantId, "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), JsonUtils.writeObjectToFastJson((Object)param), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<TenantData> getTenantByTenantId(@PathVariable(value="tenantId") long tenantId) {
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterTenantService.getTenantByTenantId(tenantId);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/global/v2/tenants/" + tenantId, "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), "", "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserCenterList<UserData>> getUserByParam(@PathVariable(value="tenantId") long tenantId, @RequestBody @NotNull UserQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterUserService.getUserByParam(tenantId, param);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/" + tenantId + "/v2/users", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), JsonUtils.writeObjectToFastJson((Object)param), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserData> getUserByUserId(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="userId") long userId, @RequestHeader(value="x-access-token") @Nullable String token, @RequestParam(value="modules") @Nullable String modules) {
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterUserService.getUserByUserId(tenantId, userId, modules);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/" + tenantId + "/v2/users/" + userId + "?extraInfo=536", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), "modules=" + modules, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserCenterList<CompanyData>> getCompanyByParam(@PathVariable(value="tenantId") long tenantId, @RequestBody @NotNull CompanyQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterCompanyService.getCompanyByParam(tenantId, param);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/{tenantId}/v2/companies", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), JsonUtils.writeObjectToFastJson((Object)param), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<Integer> getTerminalSwitch(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="taxNo") @NotNull String taxNo) {
        Intrinsics.checkNotNullParameter((Object)taxNo, (String)"taxNo");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterCompanyService.getTerminalSwitch(tenantId, taxNo);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/" + tenantId + "/v2/terminal/" + taxNo + "?byTaxNum=true", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), taxNo, "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserCenterList<CompanyServicePackageData>> getCompanyServicePackageByParam(@PathVariable(value="tenantId") long tenantId, @RequestBody @NotNull CompanyServicePackageQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterCompanyService.getCompanyServicePackageByParam(tenantId, param);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/global/v2/companies/packages", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), JsonUtils.writeObjectToFastJson((Object)param), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<List<TenantData>> getTenantByUserId(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="userId") long userId) {
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterTenantService.getTenantByUserId(tenantId, userId);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("/api/{tenantId}/v2/users/{userId}?extraInfo=536", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), String.valueOf(userId), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<List<ExtensionsDto>> getExtensionsByTax(@PathVariable(value="tenantId") long tenantId, @RequestBody @NotNull ExtensionsParam extensionsParam) {
        Intrinsics.checkNotNullParameter((Object)extensionsParam, (String)"extensionsParam");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterOrgService.getExtensionsByTax(tenantId, extensionsParam);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("api/{tenantId}/v2/orgs/extensions/query", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(tenantId), JsonUtils.writeObjectToFastJson((Object)extensionsParam), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserCenterList<UserData>> getUserByAccountName(@PathVariable(value="tenantId") long tenantId, @RequestBody @NotNull UserQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterUserService.getUserByAccountName(tenantId, param);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("api/global/v2/users?accountName=", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", param.getAccountName(), JsonUtils.writeObjectToFastJson((Object)param), "");
        }
        return response2;
    }

    @NotNull
    public UserCenterResponse<UserData> getCompanyByUserId(@PathVariable(value="tenantId") long tenantId, @PathVariable(value="userId") long userId) {
        UserCenterResponse response2 = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        response2 = this.userCenterUserService.getUserByUserId(tenantId, userId, null);
        long millis = System.currentTimeMillis() - start$iv;
        if (millis > this.getDingDingConfig().warningTime) {
            this.getDingDingUtils().sendMsgMarkDownWarn("api/global/v2/users/", "\u8017\u65f6\u5927\u4e8e" + this.getDingDingConfig().warningTime + "ms,\u672c\u6b21\u8017\u65f6:" + millis + "ms", String.valueOf(userId), String.valueOf(userId), "");
        }
        return response2;
    }
}

