/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.infrastructure.usercenter.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xforceplus.phoenix.infrastructure.usercenter.config.CoordinationProperties;
import com.xforceplus.phoenix.infrastructure.usercenter.config.OutsideProperties;
import com.xforceplus.phoenix.infrastructure.usercenter.config.UserCenterProperties;
import com.xforceplus.phoenix.infrastructure.usercenter.helper.UserCenterTokenTask;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CoordinationResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OutsideResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.seller.config.infrastructure.taxware.TaxWareModel;
import io.geewit.web.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJA\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0002\u0010\u0018JA\u0010\u0019\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0002\u0010\u0018JI\u0010\u0019\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0002\u0010\u001cJ[\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u001f0\u001e\"\u0004\b\u0000\u0010\u00112\u0006\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\"2\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u001f0\u001e0%H\u0016\u00a2\u0006\u0002\u0010&J[\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u001f0\u001e\"\u0004\b\u0000\u0010\u00112\u0006\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\"2\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u001f0\u001e0%H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010(\u001a\u00020\u001bH\u0012J0\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001e\"\u0004\b\u0000\u0010\u00112\u0006\u0010 \u001a\u00020\u00132\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u001e0*H\u0016J0\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u00110,\"\u0004\b\u0000\u0010\u00112\u0006\u0010 \u001a\u00020\u00132\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110,0*H\u0016J0\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00110.\"\u0004\b\u0000\u0010\u00112\u0006\u0010 \u001a\u00020\u00132\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110.0*H\u0016J0\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001100\"\u0004\b\u0000\u0010\u00112\u0006\u0010 \u001a\u00020\u00132\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u0011000*H\u0016JO\u00101\u001a\u0002H\u0011\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00103\u001a\u0002H22\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u0011042\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0002\u00105JO\u00106\u001a\u0002H\u0011\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00103\u001a\u0002H22\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0002\u00107JO\u00108\u001a\u0002H\u0011\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00103\u001a\u0002H22\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u00107R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper;", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "userCenterProperties", "Lcom/xforceplus/phoenix/infrastructure/usercenter/config/UserCenterProperties;", "userCenterTokenTask", "Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/UserCenterTokenTask;", "coordinationProperties", "Lcom/xforceplus/phoenix/infrastructure/usercenter/config/CoordinationProperties;", "outsideProperties", "Lcom/xforceplus/phoenix/infrastructure/usercenter/config/OutsideProperties;", "(Lorg/springframework/web/client/RestTemplate;Lcom/xforceplus/phoenix/infrastructure/usercenter/config/UserCenterProperties;Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/UserCenterTokenTask;Lcom/xforceplus/phoenix/infrastructure/usercenter/config/CoordinationProperties;Lcom/xforceplus/phoenix/infrastructure/usercenter/config/OutsideProperties;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getFromOutside", "T", "subUrl", "", "responseClass", "Lorg/springframework/core/ParameterizedTypeReference;", "params", "", "(Ljava/lang/String;Lorg/springframework/core/ParameterizedTypeReference;[Ljava/lang/Object;)Ljava/lang/Object;", "getFromPaas", "requestHeader", "Lorg/springframework/http/HttpHeaders;", "(Ljava/lang/String;Lorg/springframework/http/HttpHeaders;Lorg/springframework/core/ParameterizedTypeReference;[Ljava/lang/Object;)Ljava/lang/Object;", "getListWithExceptionDeal", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterResponse;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterList;", "methodName", "pageNo", "", "pageSize", "applyFunc", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterResponse;", "getPageListWithExceptionDeal", "getUserCenterHeader", "getWithExceptionDeal", "Lkotlin/Function0;", "getWithExceptionDealForCoordination", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CoordinationResponse;", "getWithExceptionDealForOutside", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/OutsideResponse;", "getWithExceptionDealForTaxWare", "Lcom/xforceplus/seller/config/infrastructure/taxware/TaxWareModel$TaxWareResponse;", "post", "R", "request", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "postFromCoordination", "(Ljava/lang/String;Ljava/lang/Object;Lorg/springframework/core/ParameterizedTypeReference;[Ljava/lang/Object;)Ljava/lang/Object;", "postFromPaas", "seller-config-service"})
@SourceDebugExtension(value={"SMAP\nRestTemplateHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestTemplateHelper.kt\ncom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public class RestTemplateHelper {
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private final UserCenterProperties userCenterProperties;
    @NotNull
    private final UserCenterTokenTask userCenterTokenTask;
    @NotNull
    private final CoordinationProperties coordinationProperties;
    @NotNull
    private final OutsideProperties outsideProperties;
    private final Logger log;

    public RestTemplateHelper(@NotNull RestTemplate restTemplate, @NotNull UserCenterProperties userCenterProperties, @Lazy @NotNull UserCenterTokenTask userCenterTokenTask, @NotNull CoordinationProperties coordinationProperties, @NotNull OutsideProperties outsideProperties) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)userCenterProperties, (String)"userCenterProperties");
        Intrinsics.checkNotNullParameter((Object)userCenterTokenTask, (String)"userCenterTokenTask");
        Intrinsics.checkNotNullParameter((Object)coordinationProperties, (String)"coordinationProperties");
        Intrinsics.checkNotNullParameter((Object)outsideProperties, (String)"outsideProperties");
        this.restTemplate = restTemplate;
        this.userCenterProperties = userCenterProperties;
        this.userCenterTokenTask = userCenterTokenTask;
        this.coordinationProperties = coordinationProperties;
        this.outsideProperties = outsideProperties;
        this.log = LoggerFactory.getLogger(RestTemplateHelper.class);
    }

    @Retryable(value={HttpStatusCodeException.class}, maxAttempts=3, backoff=@Backoff(delay=500L))
    public <T> T getFromPaas(@NotNull String subUrl, @NotNull ParameterizedTypeReference<T> responseClass, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)subUrl, (String)"subUrl");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpHeaders headers = this.getUserCenterHeader();
        String url = this.userCenterProperties.getBaseUrl() + subUrl;
        StopWatch stopwatch = new StopWatch();
        this.log.info("getFromPaas, url: " + url + ", params: " + JsonUtils.toJson((Object)params));
        stopwatch.start(url);
        ResponseEntity exchange2 = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), responseClass, Arrays.copyOf(params, params.length));
        stopwatch.stop();
        this.log.info(stopwatch.prettyPrint());
        this.log.info("getFromPaas, response: " + JsonUtils.toJson((Object)exchange2));
        return (T)exchange2.getBody();
    }

    @Retryable(value={HttpStatusCodeException.class}, maxAttempts=3, backoff=@Backoff(delay=500L))
    public <T> T getFromPaas(@NotNull String subUrl, @NotNull HttpHeaders requestHeader, @NotNull ParameterizedTypeReference<T> responseClass, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)subUrl, (String)"subUrl");
        Intrinsics.checkNotNullParameter((Object)requestHeader, (String)"requestHeader");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpHeaders headers = this.getUserCenterHeader();
        headers.addAll((MultiValueMap)requestHeader);
        String url = this.userCenterProperties.getBaseUrl() + subUrl;
        this.log.info("getFromPaas, url: " + url + ", params: " + JsonUtils.toJson((Object)params) + ", headers: " + headers);
        ResponseEntity exchange2 = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), responseClass, Arrays.copyOf(params, params.length));
        this.log.info("getFromPaas, response: " + JsonUtils.toJson((Object)exchange2));
        return (T)exchange2.getBody();
    }

    public <R, T> T postFromPaas(@NotNull String subUrl, R request, @NotNull ParameterizedTypeReference<T> responseClass, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)subUrl, (String)"subUrl");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpHeaders headers = this.getUserCenterHeader();
        String url = this.userCenterProperties.getBaseUrl() + subUrl;
        this.log.info("postFromPaas, url: " + url + ", request: " + JsonUtils.toJson(request));
        ResponseEntity exchange2 = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request, (MultiValueMap)headers), responseClass, Arrays.copyOf(params, params.length));
        this.log.info("postFromPaas, response: " + JsonUtils.toJson((Object)exchange2));
        return (T)exchange2.getBody();
    }

    @Retryable(value={HttpStatusCodeException.class}, maxAttempts=3, backoff=@Backoff(delay=500L))
    public <R, T> T post(@NotNull String subUrl, R request, @NotNull Class<T> responseClass, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)subUrl, (String)"subUrl");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        String url = this.userCenterProperties.getBaseUrl() + subUrl;
        this.log.info("post, url: " + url + ", request: " + JsonUtils.toJson(request));
        ResponseEntity exchange2 = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request, (MultiValueMap)httpHeaders), responseClass, Arrays.copyOf(params, params.length));
        this.log.info("post, response: " + JsonUtils.toJson((Object)exchange2));
        return (T)exchange2.getBody();
    }

    private HttpHeaders getUserCenterHeader() {
        String token = this.userCenterTokenTask.getToken();
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        requestHeaders.add("x-app-token", token);
        return requestHeaders;
    }

    @NotNull
    public <T> UserCenterResponse<T> getWithExceptionDeal(@NotNull String methodName, @NotNull Function0<UserCenterResponse<T>> applyFunc) {
        UserCenterResponse userCenterResponse;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(applyFunc, (String)"applyFunc");
        try {
            userCenterResponse = (UserCenterResponse)applyFunc.invoke();
        }
        catch (HttpStatusCodeException e) {
            this.log.error(methodName + " HttpClientErrorException " + e.getResponseBodyAsString() + ' ' + (Object)((Object)e));
            Object object = JsonUtils.fromJson((String)e.getResponseBodyAsString(), (TypeReference)((TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            log.error(\u2026sponse<T>>(){})\n        }");
            userCenterResponse = (UserCenterResponse)object;
        }
        catch (Exception e) {
            this.log.error(methodName + " exception " + e.getMessage() + ' ' + e);
            userCenterResponse = new UserCenterResponse("0", e.getMessage(), null);
        }
        return userCenterResponse;
    }

    @Retryable(value={HttpStatusCodeException.class}, maxAttempts=3, backoff=@Backoff(delay=500L))
    public <R, T> T postFromCoordination(@NotNull String subUrl, R request, @NotNull ParameterizedTypeReference<T> responseClass, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)subUrl, (String)"subUrl");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        String url = this.coordinationProperties.getBaseUrl() + subUrl;
        this.log.info("postFromCoordination, url: " + url + ", request: " + JsonUtils.toJson(request));
        ResponseEntity exchange2 = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request, (MultiValueMap)httpHeaders), responseClass, Arrays.copyOf(params, params.length));
        this.log.info("postFromCoordination, response: " + JsonUtils.toJson((Object)exchange2));
        return (T)exchange2.getBody();
    }

    @NotNull
    public <T> CoordinationResponse<T> getWithExceptionDealForCoordination(@NotNull String methodName, @NotNull Function0<CoordinationResponse<T>> applyFunc) {
        CoordinationResponse coordinationResponse;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(applyFunc, (String)"applyFunc");
        try {
            coordinationResponse = (CoordinationResponse)applyFunc.invoke();
        }
        catch (HttpStatusCodeException e) {
            this.log.error(methodName + " HttpClientErrorException " + e.getResponseBodyAsString() + ' ' + (Object)((Object)e));
            Object object = JsonUtils.fromJson((String)e.getResponseBodyAsString(), (TypeReference)((TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            log.error(\u2026sponse<T>>(){})\n        }");
            coordinationResponse = (CoordinationResponse)object;
        }
        catch (Exception e) {
            this.log.error(methodName + " exception " + e.getMessage() + ' ' + e);
            coordinationResponse = new CoordinationResponse("0", e.getMessage(), null);
        }
        return coordinationResponse;
    }

    @Retryable(value={HttpStatusCodeException.class}, maxAttempts=3, backoff=@Backoff(delay=500L))
    public <T> T getFromOutside(@NotNull String subUrl, @NotNull ParameterizedTypeReference<T> responseClass, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)subUrl, (String)"subUrl");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        String url = this.outsideProperties.getBaseUrl() + subUrl;
        this.log.info("getFromOutside, url: " + url + ", params: " + JsonUtils.toJson((Object)params));
        ResponseEntity exchange2 = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), responseClass, Arrays.copyOf(params, params.length));
        this.log.info("getFromOutside, response: " + JsonUtils.toJson((Object)exchange2));
        return (T)exchange2.getBody();
    }

    @NotNull
    public <T> OutsideResponse<T> getWithExceptionDealForOutside(@NotNull String methodName, @NotNull Function0<OutsideResponse<T>> applyFunc) {
        OutsideResponse outsideResponse;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(applyFunc, (String)"applyFunc");
        try {
            outsideResponse = (OutsideResponse)applyFunc.invoke();
        }
        catch (HttpStatusCodeException e) {
            this.log.error(methodName + " HttpClientErrorException " + e.getResponseBodyAsString() + ' ' + (Object)((Object)e));
            Object object = JsonUtils.fromJson((String)e.getResponseBodyAsString(), (TypeReference)((TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            log.error(\u2026sponse<T>>(){})\n        }");
            outsideResponse = (OutsideResponse)object;
        }
        catch (Exception e) {
            this.log.error(methodName + " exception " + e.getMessage() + ' ' + e);
            outsideResponse = new OutsideResponse("0", e.getMessage(), null);
        }
        return outsideResponse;
    }

    @NotNull
    public <T> UserCenterResponse<UserCenterList<T>> getListWithExceptionDeal(@NotNull String methodName, @Nullable Integer pageNo, @Nullable Integer pageSize, @NotNull Function1<? super String, UserCenterResponse<UserCenterList<T>>> applyFunc) {
        UserCenterResponse userCenterResponse;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(applyFunc, (String)"applyFunc");
        try {
            List list;
            int page = pageNo == null || pageNo < 1 ? 0 : pageNo - 1;
            int row = pageSize == null || pageSize > 1000 || pageSize < 0 ? 1000 : pageSize;
            List replyList = new ArrayList();
            int total = 0;
            String code = null;
            String message = null;
            UserCenterList reply2 = null;
            do {
                List list2;
                UserCenterResponse result = (UserCenterResponse)applyFunc.invoke((Object)("&page=" + ++page + "&row=" + row));
                code = result.getCode();
                message = result.getMessage();
                reply2 = (UserCenterList)result.getResult();
                UserCenterList userCenterList = reply2;
                if (userCenterList == null) break;
                UserCenterList it = userCenterList;
                boolean bl = false;
                total = it.getTotalElements();
                List r = list2 = it.getContent();
                boolean bl2 = false;
                Collection collection = r;
                List list3 = !(collection == null || collection.isEmpty()) ? list2 : null;
                list = list3 != null ? (List)CollectionsKt.toCollection((Iterable)list3, (Collection)replyList) : null;
                userCenterList = list;
            } while (list != null && replyList.size() < total);
            userCenterResponse = new UserCenterResponse(code, message, (Object)new UserCenterList(0, total, total, replyList));
        }
        catch (HttpStatusCodeException e) {
            this.log.error(methodName + " HttpClientErrorException " + e.getResponseBodyAsString() + ' ' + (Object)((Object)e));
            Object object = JsonUtils.fromJson((String)e.getResponseBodyAsString(), (TypeReference)((TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            log.error(\u2026rList<T>>>(){})\n        }");
            userCenterResponse = (UserCenterResponse)object;
        }
        catch (Exception e) {
            this.log.error(methodName + " exception " + e.getMessage() + ' ' + e);
            userCenterResponse = new UserCenterResponse("0", e.getMessage(), null);
        }
        return userCenterResponse;
    }

    @NotNull
    public <T> UserCenterResponse<UserCenterList<T>> getPageListWithExceptionDeal(@NotNull String methodName, @Nullable Integer pageNo, @Nullable Integer pageSize, @NotNull Function1<? super String, UserCenterResponse<UserCenterList<T>>> applyFunc) {
        UserCenterResponse userCenterResponse;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(applyFunc, (String)"applyFunc");
        try {
            userCenterResponse = (UserCenterResponse)applyFunc.invoke((Object)("&page=" + pageNo + "&row=" + pageSize));
        }
        catch (HttpStatusCodeException e) {
            this.log.error(methodName + " HttpClientErrorException " + e.getResponseBodyAsString() + ' ' + (Object)((Object)e));
            Object object = JsonUtils.fromJson((String)e.getResponseBodyAsString(), (TypeReference)((TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            log.error(\u2026rList<T>>>(){})\n        }");
            userCenterResponse = (UserCenterResponse)object;
        }
        catch (Exception e) {
            this.log.error(methodName + " exception " + e.getMessage() + ' ' + e);
            userCenterResponse = new UserCenterResponse("0", e.getMessage(), null);
        }
        return userCenterResponse;
    }

    @NotNull
    public <T> TaxWareModel.TaxWareResponse<T> getWithExceptionDealForTaxWare(@NotNull String methodName, @NotNull Function0<TaxWareModel.TaxWareResponse<T>> applyFunc) {
        TaxWareModel.TaxWareResponse taxWareResponse;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(applyFunc, (String)"applyFunc");
        try {
            taxWareResponse = (TaxWareModel.TaxWareResponse)applyFunc.invoke();
        }
        catch (HttpStatusCodeException e) {
            this.log.error(methodName + " HttpClientErrorException " + e.getResponseBodyAsString() + ' ' + (Object)((Object)e));
            Object object = JsonUtils.fromJson((String)e.getResponseBodyAsString(), (TypeReference)((TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            log.error(\u2026sponse<T>>(){})\n        }");
            taxWareResponse = (TaxWareModel.TaxWareResponse)object;
        }
        catch (Exception e) {
            this.log.error(methodName + " exception " + e.getMessage() + ' ' + e);
            taxWareResponse = new TaxWareModel.TaxWareResponse("0", e.getMessage(), null);
        }
        return taxWareResponse;
    }
}

