/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.infrastructure.usercenter.helper;

import com.xforceplus.phoenix.infrastructure.usercenter.config.UserCenterProperties;
import com.xforceplus.phoenix.infrastructure.usercenter.helper.RestTemplateHelper;
import com.xforceplus.phoenix.infrastructure.usercenter.model.LoginRequest;
import com.xforceplus.phoenix.infrastructure.usercenter.model.LoginResponse;
import io.geewit.web.utils.JsonUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpStatusCodeException;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0013R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/UserCenterTokenTask;", "", "userCenterProperties", "Lcom/xforceplus/phoenix/infrastructure/usercenter/config/UserCenterProperties;", "restTemplateHelper", "Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper;", "(Lcom/xforceplus/phoenix/infrastructure/usercenter/config/UserCenterProperties;Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "token", "", "getToken", "scheduledGetToken", "", "seller-config-service"})
public class UserCenterTokenTask {
    @NotNull
    private final UserCenterProperties userCenterProperties;
    @NotNull
    private final RestTemplateHelper restTemplateHelper;
    private final Logger log;
    @NotNull
    private String token;

    public UserCenterTokenTask(@NotNull UserCenterProperties userCenterProperties, @NotNull RestTemplateHelper restTemplateHelper) {
        Intrinsics.checkNotNullParameter((Object)userCenterProperties, (String)"userCenterProperties");
        Intrinsics.checkNotNullParameter((Object)restTemplateHelper, (String)"restTemplateHelper");
        this.userCenterProperties = userCenterProperties;
        this.restTemplateHelper = restTemplateHelper;
        this.log = LoggerFactory.getLogger(UserCenterTokenTask.class);
        this.token = "";
    }

    @NotNull
    public String getToken() {
        if (StringsKt.isBlank((CharSequence)this.token)) {
            this.scheduledGetToken();
        }
        return this.token;
    }

    @Scheduled(fixedDelay=3600000L)
    private void scheduledGetToken() {
        LoginResponse loginResponse;
        String subUrl = "/api/client/login";
        LoginRequest request = new LoginRequest(this.userCenterProperties.getClientId(), this.userCenterProperties.getSecret());
        try {
            loginResponse = (LoginResponse)this.restTemplateHelper.post(subUrl, (Object)request, LoginResponse.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            this.log.error("scheduledGetToken HttpClientErrorException " + e.getResponseBodyAsString() + ' ' + (Object)((Object)e));
            loginResponse = (LoginResponse)JsonUtils.fromJson((String)e.getResponseBodyAsString(), LoginResponse.class);
        }
        catch (Exception e) {
            this.log.error("scheduledGetToken exception " + e.getMessage() + ' ' + e);
            loginResponse = new LoginResponse("0", e.getMessage(), null);
        }
        LoginResponse response2 = loginResponse;
        String string = response2.getData();
        if (string == null) {
            string = "";
        }
        this.token = string;
    }
}

