/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.infrastructure.usercenter.services;

import com.xforceplus.phoenix.infrastructure.usercenter.helper.RestTemplateHelper;
import com.xforceplus.phoenix.infrastructure.usercenter.helper.UserCenterHelper;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyServicePackageData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyServicePackageQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterCompanyService;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterUserServiceImpl;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0017J$\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u001e\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J$\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u000f0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u001aH\u0017J\u001e\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u001aH\u0012J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterCompanyServiceImpl;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterCompanyService;", "restTemplateHelper", "Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper;", "(Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getCompanyById", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterResponse;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyData;", "tenantId", "", "companyId", "getCompanyByParam", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterList;", "param", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyQueryParam;", "getCompanyByTaxNo", "taxNo", "", "getCompanyQueryParamMap", "", "", "getCompanyServicePackageByParam", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyServicePackageData;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/CompanyServicePackageQueryParam;", "getCompanyServicePackageQueryParamMap", "getDeviceSwitch", "", "getTerminalSwitch", "seller-config-service"})
public class UserCenterCompanyServiceImpl
implements UserCenterCompanyService {
    @NotNull
    private final RestTemplateHelper restTemplateHelper;
    private final Logger log;

    public UserCenterCompanyServiceImpl(@NotNull RestTemplateHelper restTemplateHelper) {
        Intrinsics.checkNotNullParameter((Object)restTemplateHelper, (String)"restTemplateHelper");
        this.restTemplateHelper = restTemplateHelper;
        this.log = LoggerFactory.getLogger(UserCenterUserServiceImpl.class);
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<CompanyData> getCompanyById(long tenantId, long companyId) {
        String subUrl = "/api/global/v2/companies/{companyId}?byTaxNum=false";
        return this.restTemplateHelper.getWithExceptionDeal("getCompanyById", (Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<CompanyData> getCompanyByTaxNo(long tenantId, @NotNull String taxNo) {
        Intrinsics.checkNotNullParameter((Object)taxNo, (String)"taxNo");
        String subUrl = "/api/global/v2/companies/{companyId}?byTaxNum=true";
        return this.restTemplateHelper.getWithExceptionDeal("getCompanyByTaxNo", (Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<UserCenterList<CompanyData>> getCompanyByParam(long tenantId, @NotNull CompanyQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        this.log.info("getCompanyByParam:{}", (Object)param);
        String subUrl = "/api/{tenantId}/v2/companies";
        if (param.getStatus() == null) {
            param.setStatus(Integer.valueOf(1));
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)subUrl);
        Map map = this.getCompanyQueryParamMap(param);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        UserCenterHelper.Companion.dealParam(map, builder);
        return this.restTemplateHelper.getListWithExceptionDeal("getCompanyByParam", param.getPage(), param.getRow(), (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<Integer> getTerminalSwitch(long tenantId, @NotNull String taxNo) {
        Intrinsics.checkNotNullParameter((Object)taxNo, (String)"taxNo");
        String subUrl = "/api/{tenantId}/v2/terminal/{taxNum}?byTaxNum=true";
        return this.restTemplateHelper.getWithExceptionDeal("getTerminalSwitch", (Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Map<String, Object> getCompanyQueryParamMap(CompanyQueryParam param) {
        Object object = new Pair[]{TuplesKt.to((Object)"companyCode", (Object)param.getCompanyCode()), TuplesKt.to((Object)"companyCodes", (Object)param.getCompanyCodes()), TuplesKt.to((Object)"companyId", (Object)param.getCompanyId()), TuplesKt.to((Object)"companyIds", (Object)param.getCompanyIds()), TuplesKt.to((Object)"companyName", (Object)param.getCompanyName()), TuplesKt.to((Object)"inspectionServiceFlag", (Object)param.getInspectionServiceFlag()), TuplesKt.to((Object)"multipleTenants", (Object)param.getMultipleTenants()), TuplesKt.to((Object)"speedInspectionChannelFlag", (Object)param.getSpeedInspectionChannelFlag()), TuplesKt.to((Object)"taxNum", (Object)param.getTaxNum()), TuplesKt.to((Object)"traditionAuthenFlag", (Object)param.getTraditionAuthenFlag()), TuplesKt.to((Object)"withExtendParams", (Object)param.getWithExtendParams()), TuplesKt.to((Object)"sheets", (Object)param.getSheets()), TuplesKt.to((Object)"status", (Object)param.getStatus()), TuplesKt.to((Object)"tenantId", (Object)param.getTenantId()), TuplesKt.to((Object)"tenantName", (Object)param.getTenantName()), TuplesKt.to((Object)"sort", (Object)param.getSort()), TuplesKt.to((Object)"companyNameLike", (Object)true)};
        Map map = MapsKt.mutableMapOf((Pair[])object);
        object = param.getTaxNumLike();
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            map.put("taxNum", param.getTaxNumLike());
            map.put("taxNumLike", true);
        }
        return map;
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<UserCenterList<CompanyServicePackageData>> getCompanyServicePackageByParam(long tenantId, @NotNull CompanyServicePackageQueryParam param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        String subUrl = "/api/global/v2/companies/packages";
        if (param.getStatus() == null) {
            param.setStatus(Integer.valueOf(1));
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)subUrl);
        Map map = this.getCompanyServicePackageQueryParamMap(param);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        UserCenterHelper.Companion.dealParam(map, builder);
        return this.restTemplateHelper.getListWithExceptionDeal("getCompanyServicePackageByParam", param.getPage(), param.getRow(), (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Map<String, Object> getCompanyServicePackageQueryParamMap(CompanyServicePackageQueryParam param) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"companyId", (Object)param.getCompanyId()), TuplesKt.to((Object)"companyName", (Object)param.getCompanyName()), TuplesKt.to((Object)"servicePackageId", (Object)param.getServicePackageId()), TuplesKt.to((Object)"servicePackageName", (Object)param.getServicePackageName()), TuplesKt.to((Object)"taxNum", (Object)param.getTaxNum()), TuplesKt.to((Object)"status", (Object)param.getStatus()), TuplesKt.to((Object)"tenantCode", (Object)param.getTenantCode()), TuplesKt.to((Object)"tenantId", (Object)param.getTenantId()), TuplesKt.to((Object)"tenantName", (Object)param.getTenantName()), TuplesKt.to((Object)"sort", (Object)param.getSort())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<Integer> getDeviceSwitch(long tenantId, @NotNull String taxNo) {
        Intrinsics.checkNotNullParameter((Object)taxNo, (String)"taxNo");
        String subUrl = "/api/{tenantKey}/v2/device/{taxNum}?byTaxNum=true&byTenantCode=false";
        return this.restTemplateHelper.getWithExceptionDeal("getDeviceSwitch", (Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ RestTemplateHelper access$getRestTemplateHelper$p(UserCenterCompanyServiceImpl $this) {
        return $this.restTemplateHelper;
    }
}

