/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.infrastructure.usercenter.services;

import com.xforceplus.phoenix.infrastructure.usercenter.config.UserCenterProperties;
import com.xforceplus.phoenix.infrastructure.usercenter.helper.RestTemplateHelper;
import com.xforceplus.phoenix.infrastructure.usercenter.helper.UserCenterHelper;
import com.xforceplus.phoenix.infrastructure.usercenter.model.ExtensionsDto;
import com.xforceplus.phoenix.infrastructure.usercenter.model.ExtensionsParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgDetaiDTO;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterOrgService;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0012J$\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0017J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0017J$\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u001d0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J$\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0017H\u0017J\u001e\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010%0$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J$\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u001d0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterOrgServiceImpl;", "Lcom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterOrgService;", "restTemplateHelper", "Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper;", "userCenterProperties", "Lcom/xforceplus/phoenix/infrastructure/usercenter/config/UserCenterProperties;", "(Lcom/xforceplus/phoenix/infrastructure/usercenter/helper/RestTemplateHelper;Lcom/xforceplus/phoenix/infrastructure/usercenter/config/UserCenterProperties;)V", "dealForOrgType", "", "orgData", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/OrgData;", "getExtensionsByTax", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterResponse;", "", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/ExtensionsDto;", "tenantId", "", "extensionsParam", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/ExtensionsParam;", "getOrgById", "orgId", "getOrgByOrgKeyAndTenantKey", "tenantKey", "", "orgKey", "isTenantCode", "", "isOrgCode", "getOrgByParams", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/UserCenterList;", "param", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/OrgQueryParam;", "getOrgByTaxNum", "Lcom/xforceplus/phoenix/infrastructure/usercenter/model/OrgDetaiDTO;", "taxNum", "getOrgQueryParamMap", "", "", "getPageOrgByParams", "seller-config-service"})
@SourceDebugExtension(value={"SMAP\nUserCenterOrgServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserCenterOrgServiceImpl.kt\ncom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterOrgServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1855#2,2:206\n1855#2,2:209\n1855#2,2:211\n1#3:208\n*S KotlinDebug\n*F\n+ 1 UserCenterOrgServiceImpl.kt\ncom/xforceplus/phoenix/infrastructure/usercenter/services/UserCenterOrgServiceImpl\n*L\n41#1:206,2\n79#1:209,2\n151#1:211,2\n*E\n"})
public class UserCenterOrgServiceImpl
implements UserCenterOrgService {
    @NotNull
    private final RestTemplateHelper restTemplateHelper;
    @NotNull
    private final UserCenterProperties userCenterProperties;

    public UserCenterOrgServiceImpl(@NotNull RestTemplateHelper restTemplateHelper, @NotNull UserCenterProperties userCenterProperties) {
        Intrinsics.checkNotNullParameter((Object)restTemplateHelper, (String)"restTemplateHelper");
        Intrinsics.checkNotNullParameter((Object)userCenterProperties, (String)"userCenterProperties");
        this.restTemplateHelper = restTemplateHelper;
        this.userCenterProperties = userCenterProperties;
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<UserCenterList<OrgData>> getOrgByParams(long tenantId, @NotNull OrgQueryParam param) {
        UserCenterResponse response2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            String subUrl = "/api/{tenantId}/v2/orgs";
            if (param.getStatus() == null) {
                param.setStatus(Integer.valueOf(1));
            }
            UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)subUrl);
            Map map = this.getOrgQueryParamMap(param);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            UserCenterHelper.Companion.dealParam(map, builder);
            response2 = this.restTemplateHelper.getListWithExceptionDeal("getOrgByParams", param.getPage(), param.getRow(), (Function1)new /* Unavailable Anonymous Inner Class!! */);
            Object object = (UserCenterList)response2.getResult();
            if (object == null || (object = object.getContent()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrgData it = (OrgData)element$iv;
                boolean bl = false;
                this.dealForOrgType(it);
            }
        }
        return response2;
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<OrgData> getOrgById(long tenantId, long orgId) {
        UserCenterResponse response2;
        block0: {
            String subUrl = "/api/{tenantId}/v2/orgs/{orgId}";
            response2 = this.restTemplateHelper.getWithExceptionDeal("getOrgById", (Function0)new /* Unavailable Anonymous Inner Class!! */);
            OrgData orgData = (OrgData)response2.getResult();
            if (orgData == null) break block0;
            OrgData it = orgData;
            boolean bl = false;
            this.dealForOrgType(it);
        }
        return response2;
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<List<OrgDetaiDTO>> getOrgByTaxNum(long tenantId, @NotNull String taxNum) {
        UserCenterResponse response2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)taxNum, (String)"taxNum");
            String subUrl = "/api/global/v2/orgs/by-taxnum?taxNum=" + taxNum;
            response2 = this.restTemplateHelper.getWithExceptionDeal("getOrgByTaxNum", (Function0)new /* Unavailable Anonymous Inner Class!! */);
            List list = (List)response2.getResult();
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrgDetaiDTO it = (OrgDetaiDTO)element$iv;
                boolean bl = false;
                String string = it.getOrgType();
                Integer orgType = string != null ? StringsKt.toIntOrNull((String)string) : null;
                if (orgType == null || orgType <= 2) continue;
                it.setOrgType("2");
            }
        }
        return response2;
    }

    private Map<String, Object> getOrgQueryParamMap(OrgQueryParam param) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"accountId", (Object)param.getAccountId()), TuplesKt.to((Object)"async", (Object)param.getAsync()), TuplesKt.to((Object)"companyCode", (Object)param.getCompanyCode()), TuplesKt.to((Object)"companyId", (Object)param.getCompanyId()), TuplesKt.to((Object)"companyName", (Object)param.getCompanyName()), TuplesKt.to((Object)"companyNameEqual", (Object)param.getCompanyNameEqual()), TuplesKt.to((Object)"companyNo", (Object)param.getCompanyNo()), TuplesKt.to((Object)"ids", (Object)param.getIds()), TuplesKt.to((Object)"orgId", (Object)param.getOrgId()), TuplesKt.to((Object)"orgCode", (Object)param.getOrgCode()), TuplesKt.to((Object)"orgName", (Object)param.getOrgName()), TuplesKt.to((Object)"orgNameEqual", (Object)param.getOrgNameEqual()), TuplesKt.to((Object)"parentId", (Object)param.getParentId()), TuplesKt.to((Object)"parentIds", (Object)param.getParentIds()), TuplesKt.to((Object)"rootOrg", (Object)param.getRootOrg()), TuplesKt.to((Object)"sheets", (Object)param.getSheets()), TuplesKt.to((Object)"status", (Object)param.getStatus()), TuplesKt.to((Object)"taxNum", (Object)param.getTaxNum()), TuplesKt.to((Object)"tenantCode", (Object)param.getTenantCode()), TuplesKt.to((Object)"tenantId", (Object)param.getTenantId()), TuplesKt.to((Object)"tenantName", (Object)param.getTenantName()), TuplesKt.to((Object)"tenantNameEqual", (Object)param.getTenantNameEqual()), TuplesKt.to((Object)"userBoundFront", (Object)param.getUserBoundFront()), TuplesKt.to((Object)"userId", (Object)param.getUserId()), TuplesKt.to((Object)"userUnBound", (Object)param.getUserUnBound()), TuplesKt.to((Object)"withExtendParams", (Object)param.getWithExtendParams()), TuplesKt.to((Object)"withIsHost", (Object)param.getWithIsHost()), TuplesKt.to((Object)"withNoRootOrg", (Object)param.getWithNoRootOrg()), TuplesKt.to((Object)"withUserBoundFlag", (Object)param.getWithUserBoundFlag()), TuplesKt.to((Object)"recursive", (Object)param.getRecursive()), TuplesKt.to((Object)"sort", (Object)param.getSort()), TuplesKt.to((Object)"orgNameLike", (Object)param.getOrgNameLike()), TuplesKt.to((Object)"orgType", (Object)param.getOrgType())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<UserCenterList<OrgData>> getPageOrgByParams(long tenantId, @NotNull OrgQueryParam param) {
        UserCenterResponse response2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            String subUrl = "/api/{tenantId}/v2/orgs";
            if (param.getStatus() == null) {
                param.setStatus(Integer.valueOf(1));
            }
            UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)subUrl);
            Map map = this.getOrgQueryParamMap(param);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            UserCenterHelper.Companion.dealParam(map, builder);
            response2 = this.restTemplateHelper.getPageListWithExceptionDeal("getPageOrgByParams", param.getPage(), param.getRow(), (Function1)new /* Unavailable Anonymous Inner Class!! */);
            Object object = (UserCenterList)response2.getResult();
            if (object == null || (object = object.getContent()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrgData it = (OrgData)element$iv;
                boolean bl = false;
                this.dealForOrgType(it);
            }
        }
        return response2;
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1] + #root.args[2] + #root.args[3]")
    @NotNull
    public UserCenterResponse<OrgData> getOrgByOrgKeyAndTenantKey(@NotNull String tenantKey, @NotNull String orgKey, boolean isTenantCode, boolean isOrgCode) {
        UserCenterResponse response2;
        block0: {
            Intrinsics.checkNotNullParameter((Object)tenantKey, (String)"tenantKey");
            Intrinsics.checkNotNullParameter((Object)orgKey, (String)"orgKey");
            String subUrl = "/api/" + tenantKey + "/v2/orgs/" + orgKey + "?byTenantCode=" + isTenantCode + "&byOrgCode=" + isOrgCode;
            response2 = this.restTemplateHelper.getWithExceptionDeal("getOrgByStoreNo", (Function0)new /* Unavailable Anonymous Inner Class!! */);
            OrgData orgData = (OrgData)response2.getResult();
            if (orgData == null) break block0;
            OrgData it = orgData;
            boolean bl = false;
            this.dealForOrgType(it);
        }
        return response2;
    }

    private void dealForOrgType(OrgData orgData) {
        Integer orgType = orgData.getOrgType();
        if (orgType != null && orgType > 2) {
            orgData.setOrgType(Integer.valueOf(2));
        }
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    @NotNull
    public UserCenterResponse<List<ExtensionsDto>> getExtensionsByTax(long tenantId, @NotNull ExtensionsParam extensionsParam) {
        Intrinsics.checkNotNullParameter((Object)extensionsParam, (String)"extensionsParam");
        String subUrl = "/api/" + tenantId + "/v2/orgs/extensions/query";
        UserCenterResponse response2 = this.restTemplateHelper.getWithExceptionDeal("getExtensionsByTax", (Function0)new /* Unavailable Anonymous Inner Class!! */);
        return response2;
    }

    public static final /* synthetic */ RestTemplateHelper access$getRestTemplateHelper$p(UserCenterOrgServiceImpl $this) {
        return $this.restTemplateHelper;
    }

    public static final /* synthetic */ UserCenterProperties access$getUserCenterProperties$p(UserCenterOrgServiceImpl $this) {
        return $this.userCenterProperties;
    }
}

