/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.common;

import com.google.common.collect.Lists;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.PageInfo;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryInfo;
import com.xforceplus.phoenix.file.utils.DateUtils;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyServicePackageData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyServicePackageQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserData;
import com.xforceplus.seller.config.client.model.MsCompanyModel;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsResponsePageInfo;
import com.xforceplus.seller.config.models.ConfigBase;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.service.BaseService;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BaseConfigService
extends BaseService {
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    private final Integer DEFAULT_PAGENO = 1;
    private final Integer DEFAULT_PAGESIZE = 9999;
    @Value(value="${invoice.makeout.using.rest.api}")
    private boolean useingRestApi;
    @Autowired
    private UserCenterController userCenterController;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected OperateInfo getUpdateOperateInfo() {
        OperateInfo operateInfo = new OperateInfo();
        UserInfo userInfo = this.getCurrentUserInfo();
        operateInfo.setUpdatedBy(userInfo.getUserId() + "");
        return operateInfo;
    }

    protected OperateInfo getAddOperateInfo() {
        OperateInfo operateInfo = new OperateInfo();
        UserInfo userInfo = this.getCurrentUserInfo();
        operateInfo.setCreatedBy(userInfo.getUserId() + "");
        return operateInfo;
    }

    protected UserInfo getCurrentUserInfo() {
        return (UserInfo)this.userInfoHolder.get();
    }

    protected MsResponsePageInfo getDefaultResponsePageInfo(Integer total) {
        return this.generateResponsePageInfo(this.DEFAULT_PAGENO, total);
    }

    protected PageInfo getDefaultRequestPageInfo() {
        return this.generateRequestPageInfo(this.DEFAULT_PAGENO, this.DEFAULT_PAGESIZE);
    }

    protected MsResponsePageInfo generateResponsePageInfo(Integer pageNo, Integer total) {
        MsResponsePageInfo pageInfo = new MsResponsePageInfo();
        pageInfo.setPageNo(pageNo);
        pageInfo.setTotal(total);
        return pageInfo;
    }

    protected PageInfo generateRequestPageInfo(Integer pageNo, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(pageNo);
        pageInfo.setPageSize(pageSize);
        return pageInfo;
    }

    protected CompanyInfo generateCompanyInfo(CompanyInfo sourceInfo) {
        if (null == sourceInfo) {
            sourceInfo = new CompanyInfo();
        }
        if (null == sourceInfo.getTenantId()) {
            sourceInfo.setTenantId(Long.valueOf(this.getCurrentUserInfo().getGroupId()));
        }
        return sourceInfo;
    }

    protected TerminalQueryInfo generateTerminalQueryInfo(TerminalQueryInfo terminalQueryInfo) {
        if (null == terminalQueryInfo) {
            terminalQueryInfo = new TerminalQueryInfo();
        }
        terminalQueryInfo.setCompanyInfo(this.generateCompanyInfo(terminalQueryInfo.getCompanyInfo()));
        return terminalQueryInfo;
    }

    protected UserCenterList<OrgData> getOrgModel(long groupId, long companyId) {
        OrgQueryParam orgQueryParam = new OrgQueryParam();
        orgQueryParam.setCompanyId(Long.valueOf(companyId));
        orgQueryParam.setTenantId(Long.valueOf(groupId));
        return (UserCenterList)this.userCenterController.getOrgByParams(groupId, orgQueryParam).getResult();
    }

    protected MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest) {
        MsConfigDeviceGetCompanyListResponse msConfigDeviceGetCompanyListResponse = new MsConfigDeviceGetCompanyListResponse();
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            msConfigDeviceGetCompanyListResponse.setCode(Response.Fail);
            msConfigDeviceGetCompanyListResponse.setMessage("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
            return msConfigDeviceGetCompanyListResponse;
        }
        long tenantId = user.getGroupId();
        Consumer<List> consumer = list -> {
            if (this.useingRestApi) {
                String token = Optional.ofNullable(this.contextHolder).map(ContextHolder::get).map(UserContext::getAccessToken).orElse(null);
                UserCenterResponse userReply = this.userCenterController.getUserByUserId(tenantId, user.getUserId(), token, user.getModules());
                if ("1".equals(userReply.getCode()) && userReply.getResult() != null) {
                    List companyIds = ((UserData)userReply.getResult()).getCurrentOrgs().stream().map(OrgData::getCompanyId).distinct().collect(Collectors.toList());
                    list = list.stream().filter(r -> r != null && companyIds.contains(r.getCompanyId())).collect(Collectors.toList());
                }
            }
        };
        CompanyQueryParam param = new CompanyQueryParam();
        param.setTenantId(Long.valueOf(tenantId));
        param.setPage(Integer.valueOf(1));
        param.setRow(Integer.valueOf(10000));
        return this.getCompanyList(param, tenantId, consumer);
    }

    protected MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(long groupId) {
        CompanyQueryParam param = new CompanyQueryParam();
        param.setTenantId(Long.valueOf(groupId));
        param.setPage(Integer.valueOf(1));
        param.setRow(Integer.valueOf(2000));
        return this.getCompanyList(param, groupId, null);
    }

    private MsConfigDeviceGetCompanyListResponse getCompanyList(CompanyQueryParam param, long groupId, Consumer<List<CompanyData>> dealWithCompanyDataList) {
        MsConfigDeviceGetCompanyListResponse response2 = new MsConfigDeviceGetCompanyListResponse();
        UserCenterResponse reply2 = this.userCenterController.getCompanyByParam(groupId, param);
        if (reply2.getResult() == null || CollectionUtils.isEmpty((Collection)((UserCenterList)reply2.getResult()).getContent())) {
            response2.code(Integer.valueOf(0)).message(reply2.getMessage());
            return response2;
        }
        List companyDataList = ((UserCenterList)reply2.getResult()).getContent();
        Optional.ofNullable(dealWithCompanyDataList).ifPresent(r -> r.accept(companyDataList));
        List msCompanyModels = companyDataList.stream().map(r -> {
            MsCompanyModel model = new MsCompanyModel();
            model.setCompanyId(r.getCompanyId());
            model.setCompanyCode(r.getCompanyCode());
            model.setCompanyName(r.getCompanyName());
            model.setTaxNum(r.getTaxNum());
            return model;
        }).collect(Collectors.toList());
        response2.result(msCompanyModels).code(BaseResponse.OK);
        return response2;
    }

    protected UserCenterResponse<UserCenterList<CompanyServicePackageData>> getCompanyServiceInfo(long tenantId, long companyId) {
        CompanyServicePackageQueryParam param = new CompanyServicePackageQueryParam();
        param.setCompanyId(Long.valueOf(companyId));
        return this.userCenterController.getCompanyServicePackageByParam(tenantId, param);
    }

    protected String formatExpireAt(String expireAt) {
        Date sourceDate = DateUtils.toDateTime19((String)expireAt);
        return DateUtils.toDateStr((Date)sourceDate, (String)"yyyy/MM/dd");
    }

    protected List<String> getUserCompanyTaxNos(Long userId, Long groupId) {
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u7ebf\u7a0b\u4e0a\u7ebf\u65870:{},\u7ebf\u7a0bid:{}", this.userInfoHolder.get(), (Object)Thread.currentThread().getId());
        if (Objects.nonNull(userId) && Objects.nonNull(groupId)) {
            String token = Optional.ofNullable(this.contextHolder).map(ContextHolder::get).map(UserContext::getAccessToken).orElse(null);
            UserCenterResponse reply2 = this.userCenterController.getUserByUserId(groupId.longValue(), userId.longValue(), token, (String)Optional.ofNullable(this.userInfoHolder.get()).map(UserInfo::getModules).orElse(null));
            return Optional.ofNullable(reply2.getResult()).map(UserData::getParentCompanies).map(r -> r.stream().map(OrgData::getTaxNum).distinct().collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        return new ArrayList<String>();
    }

    protected String validateSellerOrgValue(ConfigBase base, String sellerOrgType, MsConfigBean msConfigBean) {
        StringBuilder sb = new StringBuilder();
        switch (sellerOrgType) {
            case "2": {
                msConfigBean.setSellerName("");
                msConfigBean.setSellerTaxNo("");
                if (!StringUtils.isNumeric((CharSequence)base.getSellerTaxNo())) {
                    String msgStr = "\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u96c6\u56e2\u65f6\uff0c\u9500\u65b9\u516c\u53f8\u7a0e\u53f7" + base.getSellerTaxNo() + "\u9700\u8981\u586b\u5199\u4e3a\u79df\u6237ID";
                    this.logger.error(msgStr);
                    sb.append(msgStr);
                    break;
                }
                msConfigBean.setSellerGroupId(Long.valueOf(base.getSellerTaxNo()));
                break;
            }
            case "3": {
                msConfigBean.setSellerName("");
                msConfigBean.setSellerTaxNo("");
                if (!StringUtils.isNumeric((CharSequence)base.getSellerTaxNo())) {
                    String msgStr = "\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7ec4\u7ec7\u65f6\uff0c\u9500\u65b9\u516c\u53f8\u7a0e\u53f7" + base.getSellerTaxNo() + "\u9700\u8981\u586b\u5199\u4e3a\u7ec4\u7ec7ID";
                    this.logger.error(msgStr);
                    sb.append(msgStr);
                    break;
                }
                msConfigBean.setSysOrgId(Long.valueOf(base.getSellerTaxNo()));
                break;
            }
        }
        return sb.toString();
    }
}

