/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.config;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfiguration {
    @Value(value="${redis.type:standalone}")
    private String type;
    @Value(value="${redis.standaloneHost:127.0.0.1}")
    private String standaloneHost;
    @Value(value="${redis.standalonePort:6379}")
    private Integer standalonePort;
    @Value(value="${redis.maxActive:20}")
    private int maxActive;
    @Value(value="${redis.minIdle:5}")
    private Integer minIdle;
    @Value(value="${redis.maxTotal:}")
    private Integer maxTotal;
    @Value(value="${redis.maxWaitMillis:}")
    private Integer maxWaitMillis;
    @Value(value="${redis.minEvictableIdleTimeMillis:}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${redis.numTestsPerEvictionRun:}")
    private Integer numTestsPerEvictionRun;
    @Value(value="${redis.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${redis.testWhileIdle:false}")
    private boolean testWhileIdle;
    @Value(value="${redis.sentinelNodes:}")
    private String sentinelNodes;
    @Value(value="${redis.sentinelMaster:}")
    private String sentinelMaster;
    @Value(value="${redis.password:}")
    private String password;
    @Value(value="${redis.connectTimeout:10000}")
    private int connectTimeout;
    @Value(value="${redis.timeout:3000}")
    private Integer timeout;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        if (Objects.equals(this.type, "standalone")) {
            String address = "redis://" + this.standaloneHost + ":" + this.standalonePort;
            SingleServerConfig singleServerConfig = (SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(address).setConnectionPoolSize(this.maxActive).setConnectionMinimumIdleSize(this.minIdle.intValue()).setConnectTimeout(this.connectTimeout)).setTimeout(this.timeout.intValue());
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                singleServerConfig.setPassword(this.password);
            }
        } else {
            String[] sentinelNodeArray;
            StringBuilder sentinelAddressBuilder = new StringBuilder();
            String[] var6 = sentinelNodeArray = StringUtils.split((String)this.sentinelNodes, (String)",");
            int var7 = sentinelNodeArray.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                String node = var6[var8];
                sentinelAddressBuilder.append("redis://").append(node).append(",");
            }
            String sentinelAddress = sentinelAddressBuilder.toString();
            SentinelServersConfig sentinelServersConfig = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.sentinelMaster).addSentinelAddress(new String[]{sentinelAddress.substring(0, sentinelAddress.length() - 1)}).setMasterConnectionPoolSize(this.maxActive)).setMasterConnectionMinimumIdleSize(this.minIdle.intValue())).setSlaveConnectionPoolSize(this.maxActive)).setSlaveConnectionMinimumIdleSize(this.minIdle.intValue())).setConnectTimeout(this.connectTimeout)).setTimeout(this.timeout.intValue());
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                sentinelServersConfig.setPassword(this.password);
            }
        }
        return Redisson.create((Config)config);
    }
}

