/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.config;

import com.xforceplus.seller.config.config.RestTemplateProperties;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Base64Utils;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfiguration {
    private final RestTemplateProperties restTemplateProperties;
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    private String X_PHOENIX_USERINFO = "x-phoenix-userinfo";

    public RestTemplateConfiguration(RestTemplateProperties restTemplateProperties) {
        this.restTemplateProperties = restTemplateProperties;
    }

    @Bean
    RestTemplate restTemplate(ClientHttpRequestFactory simpleClientHttpRequestFactory) {
        RestTemplate restTemplate = new RestTemplate(simpleClientHttpRequestFactory);
        List list = restTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("UTF8"));
            break;
        }
        return restTemplate;
    }

    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(this.restTemplateProperties.getConnectTimeout().intValue());
        factory.setReadTimeout(this.restTemplateProperties.getReadTimeout().intValue());
        return factory;
    }

    @Bean
    public HttpHeaders httpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (userInfo != null) {
            httpHeaders.add(this.X_PHOENIX_USERINFO, Base64Utils.encodeToString((byte[])JsonUtils.writeObjectToFastJson((Object)userInfo).getBytes(StandardCharsets.UTF_8)));
        }
        return httpHeaders;
    }
}

