/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.xforceplus.seller.config.client.model.Config3rdAlipayAuthRequest;
import com.xforceplus.seller.config.config.annotation.APIV1Config3rd;
import com.xforceplus.seller.config.core.enums.AlipayAppStatus;
import com.xforceplus.seller.config.core.enums.AlipayAppType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.repository.model.Cfg3rdAlipayAuthWithBLOBs;
import com.xforceplus.seller.config.services.Cfg3rdAlipayAuthService;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@APIV1Config3rd
public class Config3rdAlipayAuthController
extends BaseAppController {
    private final Cfg3rdAlipayAuthService cfg3rdAlipayAuthService;

    @GetMapping(value={"/alipay/getByAppId"})
    public Response<Cfg3rdAlipayAuthWithBLOBs> getByAppId(String appId) {
        return Response.ok((String)"", (Object)this.cfg3rdAlipayAuthService.getByAppId(appId));
    }

    @GetMapping(value={"/alipay/findByThirdPartyCode"})
    public Response<Cfg3rdAlipayAuthWithBLOBs> findByThirdPartyCode(String thirdPartyCode, Integer type) {
        AlipayAppType alipayAppType = ValueEnum.getEnumByValue(AlipayAppType.class, (Object)type).orElse(null);
        return Response.ok((String)"", (Object)this.cfg3rdAlipayAuthService.findByThirdPartyCode(thirdPartyCode, alipayAppType));
    }

    @GetMapping(value={"/alipay/findByThirdPartyCodes"})
    public Response<Cfg3rdAlipayAuthWithBLOBs> findByThirdPartyCodes(String thirdPartyCodes, Integer type) {
        AlipayAppType alipayAppType = ValueEnum.getEnumByValue(AlipayAppType.class, (Object)type).orElse(null);
        List<String> thirdPartyCodeList = Arrays.asList(thirdPartyCodes.split(","));
        return Response.ok((String)"", (Object)this.cfg3rdAlipayAuthService.findByThirdPartyCodes(thirdPartyCodeList, alipayAppType));
    }

    @PostMapping(value={"/alipay/unauthorized"})
    public Response<Cfg3rdAlipayAuthWithBLOBs> unauthorized(@RequestBody Config3rdAlipayAuthRequest param) {
        this.cfg3rdAlipayAuthService.unauthorized(param.getAppId(), DateTools.parseDate((String)param.getUnauthorizedTime()));
        return Response.ok(null);
    }

    @PostMapping(value={"/alipay/insert"})
    public Response<Void> insert(@RequestBody Config3rdAlipayAuthRequest param) {
        Cfg3rdAlipayAuthWithBLOBs entity = new Cfg3rdAlipayAuthWithBLOBs();
        entity.setAppId(param.getAppId());
        entity.setAuthToken(param.getAuthToken());
        entity.setRefreshToken(param.getRefreshToken());
        entity.setExpiresTime(DateTools.parseDate((String)param.getExpiresTime()));
        entity.setAuthorizedTime(DateTools.parseDate((String)param.getAuthorizedTime()));
        entity.setFuncInfo(JsonUtils.writeObjectToFastJson((Object)param.getFuncInfo()));
        entity.setBaseInfo(JsonUtils.writeObjectToFastJson((Object)param.getBaseInfo()));
        if (!ValueEnum.isValid(AlipayAppType.class, (Object)param.getAppType())) {
            return Response.failed((String)"type \u4e0d\u5408\u6cd5");
        }
        if (!ValueEnum.isValid(AlipayAppStatus.class, (Object)param.getStatus())) {
            return Response.failed((String)"status \u4e0d\u5408\u6cd5");
        }
        entity.setType(param.getAppType());
        entity.setStatus(param.getStatus());
        this.cfg3rdAlipayAuthService.insert(entity);
        return Response.ok(null);
    }

    @PostMapping(value={"/alipay/updateAuthorized"})
    public Response<Cfg3rdAlipayAuthWithBLOBs> updateAuthorized(@RequestBody Config3rdAlipayAuthRequest param) {
        this.cfg3rdAlipayAuthService.updateAuthorized(param.getId(), param.getAuthToken(), param.getRefreshToken(), DateTools.parseDate((String)param.getExpiresTime()), DateTools.parseDate((String)param.getReExpiresTime()), param.getFuncInfo(), param.getBaseInfo());
        return Response.ok(null);
    }

    @PostMapping(value={"/alipay/refreshToken"})
    public Response<Void> refreshToken(@RequestBody Config3rdAlipayAuthRequest param) {
        this.cfg3rdAlipayAuthService.refreshToken(param.getId(), param.getAuthToken(), param.getRefreshToken(), DateTools.parseDate((String)param.getExpiresTime()), DateTools.parseDate((String)param.getReExpiresTime()));
        return Response.ok(null);
    }

    @PostMapping(value={"/alipay/updateTemplates"})
    public Response<Void> updateTemplates(@RequestBody Config3rdAlipayAuthRequest param) {
        this.cfg3rdAlipayAuthService.updateTemplates(param.getAppId(), param.getTemplates());
        return Response.ok(null);
    }

    @PostMapping(value={"/alipay/bindThirdPartyCode"})
    public Response<Void> bindThirdPartyCode(@RequestBody Config3rdAlipayAuthRequest param) {
        this.cfg3rdAlipayAuthService.bindThirdPartyCode(param.getId().longValue(), param.getThirdPartyCode());
        return Response.ok(null);
    }

    public Config3rdAlipayAuthController(Cfg3rdAlipayAuthService cfg3rdAlipayAuthService) {
        this.cfg3rdAlipayAuthService = cfg3rdAlipayAuthService;
    }
}

