/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.xforceplus.seller.config.client.model.Config3rdWxAuthRequest;
import com.xforceplus.seller.config.config.annotation.APIV1Config3rd;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.core.enums.WxAppStatus;
import com.xforceplus.seller.config.core.enums.WxAppType;
import com.xforceplus.seller.config.repository.model.Cfg3rdWxAuthWithBLOBs;
import com.xforceplus.seller.config.services.Cfg3rdWxAuthService;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@APIV1Config3rd
public class Config3rdWxAuthController
extends BaseAppController {
    private final Cfg3rdWxAuthService cfg3rdWxAuthService;

    @GetMapping(value={"/wx/getByAppId"})
    public Response<Cfg3rdWxAuthWithBLOBs> getByAppId(String appId) {
        return Response.ok((String)"", (Object)this.cfg3rdWxAuthService.getByAppId(appId));
    }

    @GetMapping(value={"/wx/findByThirdPartyCode"})
    public Response<Cfg3rdWxAuthWithBLOBs> findByThirdPartyCode(String thirdPartyCode, Integer type) {
        WxAppType wxAppType = ValueEnum.getEnumByValue(WxAppType.class, (Object)type).orElse(null);
        return Response.ok((String)"", (Object)this.cfg3rdWxAuthService.findByThirdPartyCode(thirdPartyCode, wxAppType));
    }

    @GetMapping(value={"/wx/findByThirdPartyCodes"})
    public Response<Cfg3rdWxAuthWithBLOBs> findByThirdPartyCodes(String thirdPartyCodes, Integer type) {
        WxAppType wxAppType = ValueEnum.getEnumByValue(WxAppType.class, (Object)type).orElse(null);
        List<String> thirdPartyCodeList = Arrays.asList(thirdPartyCodes.split(","));
        return Response.ok((String)"", (Object)this.cfg3rdWxAuthService.findByThirdPartyCodes(thirdPartyCodeList, wxAppType));
    }

    @PostMapping(value={"/wx/unauthorized"})
    public Response<Cfg3rdWxAuthWithBLOBs> unauthorized(@RequestBody Config3rdWxAuthRequest param) {
        this.cfg3rdWxAuthService.unauthorized(param.getId(), DateTools.parseDate((String)param.getUnauthorizedTime()));
        return Response.ok(null);
    }

    @PostMapping(value={"/wx/authorized"})
    public Response<Cfg3rdWxAuthWithBLOBs> authorized(@RequestBody Config3rdWxAuthRequest param) {
        this.cfg3rdWxAuthService.authorized(param.getId(), param.getAccessToken(), param.getRefreshToken(), DateTools.parseDate((String)param.getExpiresTime()), param.getFuncInfo(), param.getBaseInfo(), (WxAppType)ValueEnum.getEnumByValue(WxAppType.class, (Object)param.getAppType()).orElse(null));
        return Response.ok(null);
    }

    @PostMapping(value={"/wx/insert"})
    public Response<Void> insert(@RequestBody Config3rdWxAuthRequest param) {
        Cfg3rdWxAuthWithBLOBs entity = new Cfg3rdWxAuthWithBLOBs();
        entity.setAppId(param.getAppId());
        entity.setAccessToken(param.getAccessToken());
        entity.setRefreshToken(param.getRefreshToken());
        entity.setExpiresTime(DateTools.parseDate((String)param.getExpiresTime()));
        entity.setAuthorizedTime(DateTools.parseDate((String)param.getAuthorizedTime()));
        entity.setFuncInfo(JsonUtils.writeObjectToFastJson((Object)param.getFuncInfo()));
        entity.setBaseInfo(JsonUtils.writeObjectToFastJson((Object)param.getBaseInfo()));
        if (!ValueEnum.isValid(WxAppType.class, (Object)param.getAppType())) {
            return Response.failed((String)"type \u4e0d\u5408\u6cd5");
        }
        if (!ValueEnum.isValid(WxAppStatus.class, (Object)param.getStatus())) {
            return Response.failed((String)"status \u4e0d\u5408\u6cd5");
        }
        entity.setType(param.getAppType());
        entity.setStatus(param.getStatus());
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        entity.setIsDeleted(Boolean.valueOf(false));
        this.cfg3rdWxAuthService.insert(entity);
        return Response.ok(null);
    }

    @PostMapping(value={"/wx/refreshToken"})
    public Response<Void> refreshToken(@RequestBody Config3rdWxAuthRequest param) {
        this.cfg3rdWxAuthService.refreshToken(param.getId(), param.getAccessToken(), param.getRefreshToken(), DateTools.parseDate((String)param.getExpiresTime()));
        return Response.ok(null);
    }

    @PostMapping(value={"/wx/updateTemplates"})
    public Response<Void> updateTemplates(@RequestBody Config3rdWxAuthRequest param) {
        this.cfg3rdWxAuthService.updateTemplates(param.getId(), param.getTemplates());
        return Response.ok(null);
    }

    @PostMapping(value={"/wx/bindThirdPartyCode"})
    public Response<Void> bindThirdPartyCode(@RequestBody Config3rdWxAuthRequest param) {
        this.cfg3rdWxAuthService.bindThirdPartyCode(param.getId().longValue(), param.getThirdPartyCode());
        return Response.ok(null);
    }

    @PostMapping(value={"/wx/updateSPappid"})
    public Response<Void> updateSPappid(@RequestBody Config3rdWxAuthRequest param) {
        this.cfg3rdWxAuthService.updateSPappid(param.getAppId(), param.getSPappid());
        return Response.ok(null);
    }

    public Config3rdWxAuthController(Cfg3rdWxAuthService cfg3rdWxAuthService) {
        this.cfg3rdWxAuthService = cfg3rdWxAuthService;
    }
}

