/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.ConfigOperatorInfo;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoAddRequest;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoBatchAddRequest;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoQueryRequest;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoQueryResponse;
import com.xforceplus.seller.config.client.model.ConfigTtitleInfo;
import com.xforceplus.seller.config.client.model.InitSettledTemplateConfigRequest;
import com.xforceplus.seller.config.client.model.PageQueryData;
import com.xforceplus.seller.config.client.model.QueryManualInitConfigRequest;
import com.xforceplus.seller.config.client.model.QuerySettledTemplateRequest;
import com.xforceplus.seller.config.client.model.SettledSalesbillTypeInfoVo;
import com.xforceplus.seller.config.client.model.SettledTemplateConifgVo;
import com.xforceplus.seller.config.client.model.SettledTemplateDataVo;
import com.xforceplus.seller.config.client.model.SettledTemplateDeleteRequest;
import com.xforceplus.seller.config.client.model.SettledTemplateEditRequest;
import com.xforceplus.seller.config.client.model.SettledTemplateQueryRequest;
import com.xforceplus.seller.config.config.annotation.APIV1ConfigAllInOne;
import com.xforceplus.seller.config.core.enums.ErrorCodeEnum;
import com.xforceplus.seller.config.facade.ConfigInfoAllInOneFacade;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.swagger.annotations.ApiParam;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@APIV1ConfigAllInOne
public class ConfigAllInOneController
extends BaseAppController {
    private final ConfigInfoAllInOneFacade configInfoAllInOneFacade;
    private final UserInfoHolder<UserInfo> userInfoHolder;

    @PostMapping(value={"/qianniu/addTitleAndIssueInfo"})
    public Response addTitleAndIssueInfo(@RequestBody ConfigTitleAndIssueInfoAddRequest addRequest) {
        return this.configInfoAllInOneFacade.addOrUpdateTitleAndIssueInfo(addRequest, "qianniu");
    }

    @PostMapping(value={"/qianniu/queryTitleAndIssueInfo"})
    public Response<ConfigTitleAndIssueInfoQueryResponse> queryTitleAndIssueInfo(@RequestBody ConfigTitleAndIssueInfoQueryRequest queryRequest) {
        Tuple2 result = this.configInfoAllInOneFacade.queryTitleAndIssueInfo(queryRequest);
        if (null == result._1 && null == result._2) {
            return Response.failed((String)"\u65e0\u5f00\u7968\u4eba\u548c\u62ac\u5934\u4fe1\u606f");
        }
        ConfigTitleAndIssueInfoQueryResponse queryResponse = new ConfigTitleAndIssueInfoQueryResponse();
        queryResponse.setConfigTitleInfo((ConfigTtitleInfo)result._1);
        queryResponse.setConfigOperatorInfo((ConfigOperatorInfo)result._2);
        return Response.ok((String)"\u67e5\u8be2\u6210\u529f", (Object)queryResponse);
    }

    @PostMapping(value={"/settled/initTemplateConfig"})
    public Response<Boolean> initTemplateConfig(@RequestBody InitSettledTemplateConfigRequest templateConfigRequest) {
        Either eitherResult = this.configInfoAllInOneFacade.initSettledTemplateConfig(templateConfigRequest);
        if (eitherResult.isLeft()) {
            return Response.failed((String)((String)eitherResult.getLeft()));
        }
        return Response.ok((String)"\u521d\u59cb\u5316\u4ea7\u54c1\u5305\u914d\u7f6e\u6210\u529f", (Object)eitherResult.get());
    }

    @PostMapping(value={"/settled/queryTemplateList"})
    public Response<PageQueryData<SettledTemplateDataVo>> querySettledTemplateList(@RequestBody SettledTemplateQueryRequest request) {
        Either eitherResult = this.configInfoAllInOneFacade.querySettledTemplateList(request);
        if (eitherResult.isLeft()) {
            Tuple2 tupleResult = (Tuple2)eitherResult.getLeft();
            return Response.from((Integer)Response.Fail, (String)CommonTools.format((String)((ErrorCodeEnum)tupleResult._1()).getDescription(), (Object[])new Object[]{tupleResult._2()}), null);
        }
        Tuple2 tupleResult = (Tuple2)eitherResult.get();
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)new PageQueryData((Long)tupleResult._1(), (List)tupleResult._2()));
    }

    @PostMapping(value={"/settled/batchDeleteSettledTemplate"})
    public Response<Boolean> batchDeleteSettledTemplate(@RequestBody SettledTemplateDeleteRequest request) {
        Either eitherResult = this.configInfoAllInOneFacade.batchDeleteSettledTemplate(request, Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()), ((UserInfo)this.userInfoHolder.get()).getUserName());
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    @PostMapping(value={"/settled/template/edit"})
    public Response<Boolean> editSettledTemplate(@RequestBody SettledTemplateEditRequest editRequest) {
        Either eitherResult = this.configInfoAllInOneFacade.editSettledTemplate(editRequest);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)((String)eitherResult.get()));
    }

    @PostMapping(value={"/settled/queryTemplateConfigItem"})
    public Response<SettledTemplateConifgVo> queryTemplateConfigItem(@ApiParam(value="\u67e5\u8be2\u624b\u52a8\u914d\u7f6e\u89c4\u5219\u6a21\u7248", required=true) @RequestBody QuerySettledTemplateRequest templateRequest) {
        Either eitherResult = this.configInfoAllInOneFacade.querySettledTemplateConfigItem(templateRequest);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()));
        }
        return Response.from((Integer)Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (Object)eitherResult.get());
    }

    @PostMapping(value={"/settled/queryInitConfigInfo"})
    public Response<List<SettledSalesbillTypeInfoVo>> queryInitConfigInfo(@ApiParam(value="\u67e5\u8be2\u6307\u5b9a\u7c7b\u578b\u89c4\u5219\u521b\u5efa\u4fe1\u606f", required=true) @RequestBody QueryManualInitConfigRequest queryConfigRequest) {
        Either eitherResult = this.configInfoAllInOneFacade.queryInitConfigInfo(queryConfigRequest);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()));
        }
        return Response.from((Integer)Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (Object)eitherResult.get());
    }

    @PostMapping(value={"/settled/addOrUpdateTitleAndIssueInfo"})
    public Response addOrUpdateTitleAndIssueInfo(@RequestBody ConfigTitleAndIssueInfoAddRequest addRequest) {
        return this.configInfoAllInOneFacade.addOrUpdateTitleAndIssueInfo(addRequest, "common");
    }

    @PostMapping(value={"/settled/batchAddTitleAndIssueInfo"})
    public Response<List<String>> batchAddTitleAndIssueInfo(@RequestBody ConfigTitleAndIssueInfoBatchAddRequest batchAddRequest) {
        List errorList;
        Either eitherResult = this.configInfoAllInOneFacade.batchAddTitleAndIssueInfo(batchAddRequest);
        if (eitherResult.isLeft() && CollectionUtils.isNotEmpty(errorList = ((List)eitherResult.getLeft()).stream().filter(r -> !r.contains("\u89c4\u5219\u5df2\u5b58\u5728")).collect(Collectors.toList()))) {
            return Response.from((Integer)Response.Fail, (String)"\u521b\u5efa\u5931\u8d25", (Object)eitherResult.getLeft());
        }
        return Response.ok((String)"\u521b\u5efa\u6210\u529f");
    }

    public ConfigAllInOneController(ConfigInfoAllInOneFacade configInfoAllInOneFacade, UserInfoHolder<UserInfo> userInfoHolder) {
        this.configInfoAllInOneFacade = configInfoAllInOneFacade;
        this.userInfoHolder = userInfoHolder;
    }
}

