/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterCompanyService;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterOrgService;
import com.xforceplus.seller.config.client.ItemAssemble;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.model.BatchQueryQianniuConfigRequest;
import com.xforceplus.seller.config.client.model.ConfigIssueInfoEditRequest;
import com.xforceplus.seller.config.client.model.ConfigIssueSellerInfoDTO;
import com.xforceplus.seller.config.client.model.ConfigIssueUserInfoDTO;
import com.xforceplus.seller.config.client.model.ConfigItemDTO;
import com.xforceplus.seller.config.client.model.ConfigItemDeleteRequest;
import com.xforceplus.seller.config.client.model.ConfigSellerInfoEditRequest;
import com.xforceplus.seller.config.client.model.DiscountQueryRequest;
import com.xforceplus.seller.config.client.model.FilterRelatedQueryData;
import com.xforceplus.seller.config.client.model.ImportDiscountRequest;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequst;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequstWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemResponse;
import com.xforceplus.seller.config.client.model.MsConfigMailRuleResponse;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigResponse;
import com.xforceplus.seller.config.client.model.MsConfigSummaryResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.seller.config.client.model.MsTmpConfigResponse;
import com.xforceplus.seller.config.client.model.PageList;
import com.xforceplus.seller.config.client.model.QianNiuConfigBatchUpdateRequest;
import com.xforceplus.seller.config.client.model.QianNiuConfigInfo;
import com.xforceplus.seller.config.client.model.QianNiuConfigQueryRequest;
import com.xforceplus.seller.config.client.model.QianNiuConfigUpdateRequest;
import com.xforceplus.seller.config.client.model.QueryStoreListRequest;
import com.xforceplus.seller.config.client.model.StoreData;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.InvoiceInfoRlueParser;
import com.xforceplus.seller.config.client.translater.MsConfigQueryRequestTranslater;
import com.xforceplus.seller.config.config.annotation.APIV1Config;
import com.xforceplus.seller.config.controllers.service.MsConfigController;
import com.xforceplus.seller.config.controllers.service.MsConfigTempController;
import com.xforceplus.seller.config.converters.ConfigConverter;
import com.xforceplus.seller.config.core.enums.AliRegisterStatusEnum;
import com.xforceplus.seller.config.core.enums.AliRulesIsConfigEnum;
import com.xforceplus.seller.config.core.enums.TaxInvoiceSource;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.facade.ConfigInfoFacade;
import com.xforceplus.seller.config.models.CompanyData;
import com.xforceplus.seller.config.models.DeviceData;
import com.xforceplus.seller.config.models.InvoiceLimitRequest;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigCompanyService;
import com.xforceplus.seller.config.services.ConfigImportAfter;
import com.xforceplus.seller.config.services.ConfigMetaDataServiceKt;
import com.xforceplus.seller.config.services.DiscountRateService;
import com.xforceplus.seller.config.services.GeneralService;
import com.xforceplus.seller.config.services.ImportReasonTools;
import com.xforceplus.seller.config.util.UserTranslater;
import com.xforceplus.seller.enums.OrgType;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.geewit.web.utils.JsonUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@APIV1Config
public class ConfigController
extends BaseAppController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    MsConfigController msConfigController;
    @Autowired
    MsConfigTempController msConfigTempController;
    @Autowired
    private ItemAssemble itemAssemble;
    @Autowired
    ConfigImportAfter configImportAfter;
    @Autowired
    ImportReasonTools importReasonTools;
    @Autowired
    DiscountRateService discountRateService;
    private final GeneralService generalService;
    private final ConfigMetaDataServiceKt configMetaDataServiceKt;
    private final ConfigCompanyService configCompanyService;
    private final ConfigConverter configConverter;
    private final ConfigInfoFacade configInfoFacade;
    private final UserCenterCompanyService userCenterCompanyService;
    private final UserCenterOrgService userCenterOrgService;
    private final ConfigBizConfigService configBizConfigService;
    private final InvoiceInfoRlueParser invoiceInfoRlueParser;

    public ConfigController(GeneralService generalService, ConfigMetaDataServiceKt configMetaDataServiceKt, ConfigCompanyService configCompanyService, ConfigConverter configConverter, ConfigInfoFacade configInfoFacade, UserCenterCompanyService userCenterCompanyService, UserCenterOrgService userCenterOrgService, ConfigBizConfigService configBizConfigService, InvoiceInfoRlueParser invoiceInfoRlueParser) {
        this.generalService = generalService;
        this.configMetaDataServiceKt = configMetaDataServiceKt;
        this.configCompanyService = configCompanyService;
        this.configConverter = configConverter;
        this.configInfoFacade = configInfoFacade;
        this.userCenterCompanyService = userCenterCompanyService;
        this.userCenterOrgService = userCenterOrgService;
        this.configBizConfigService = configBizConfigService;
        this.invoiceInfoRlueParser = invoiceInfoRlueParser;
    }

    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/queryConfig"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsConfigResponse queryConfig(@ApiParam(value="\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e", required=true) @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsConfigResponse response2 = new MsConfigResponse();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        if (msConfigQueryRequest.getConfigType() == null) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u89c4\u5219\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return response2;
        }
        MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo = MsConfigQueryRequestTranslater.msConfigQueryRequest2MsConfigQueryRequestWithUser((MsConfigQueryRequest)msConfigQueryRequest);
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigQueryRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        MsConfigQueryRequest request = MsConfigQueryRequestTranslater.MsConfigQueryRequestWithUser2MsConfigQueryRequest((MsConfigQueryRequestWithUserInfo)msConfigQueryRequestWithUserInfo);
        MsConfigPageDTO msConfigPageDTO = this.configInfoFacade.queryConfigList(request, msCommonUserInfo.getGroupId());
        response2.setResult(msConfigPageDTO);
        response2.setCode(Response.OK);
        response2.setMessage("\u67e5\u8be2\u6210\u529f");
        return response2;
    }

    @ApiOperation(value="\u67e5\u8be2\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/queryQianNiuConfig"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse queryQianNiuConfig(@ApiParam(value="\u67e5\u8be2\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", required=true) @RequestBody QianNiuConfigQueryRequest queryRequest) {
        if (Optional.ofNullable(this.userInfoHolder.get()).map(UserInfo::getGroupId).orElse(0L) == 0L) {
            return MsResponse.error((String)"\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        }
        if (Objects.isNull(queryRequest) || StringUtils.isBlank((CharSequence)queryRequest.getSellerTaxNo()) || CollectionUtils.isEmpty((Collection)queryRequest.getConfigTypeList()) || Objects.isNull(queryRequest.getStatus()) || StringUtils.isBlank((CharSequence)queryRequest.getSalesbillType())) {
            return MsResponse.error((String)"\u9500\u65b9\u7a0e\u53f7\u3001\u89c4\u5219\u7c7b\u578b\u3001\u72b6\u6001\u53ca\u4e1a\u52a1\u5355\u7c7b\u578b\u5747\u4e3a\u5fc5\u586b\u53c2\u6570!");
        }
        boolean configTypeIsNull = queryRequest.getConfigTypeList().stream().anyMatch(configType -> Objects.isNull(configType));
        if (configTypeIsNull) {
            return MsResponse.error((String)"\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        QianNiuConfigInfo configInfo = this.querySingleQianniuConfig(queryRequest);
        return MsResponse.ok((Object)configInfo);
    }

    private QianNiuConfigInfo querySingleQianniuConfig(QianNiuConfigQueryRequest queryRequest) {
        Optional<Long> invoiceUserConfigOptional;
        Optional<Long> invoiceConfigOptional;
        QianNiuConfigInfo configInfo = new QianNiuConfigInfo();
        configInfo.setTaxInvoiceSourceType(AliRegisterStatusEnum.UN_REGISTERED.getValue());
        configInfo.setMultiTitleConfig(AliRulesIsConfigEnum.NOT_CONFIGURED.getValue());
        configInfo.setInvoicePersonConfig(AliRulesIsConfigEnum.NOT_CONFIGURED.getValue());
        List msResponseList = queryRequest.getConfigTypeList().stream().map(r -> {
            MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
            msConfigQueryRequest.setStatus(queryRequest.getStatus());
            msConfigQueryRequest.setSellerTaxNo(queryRequest.getSellerTaxNo());
            msConfigQueryRequest.setConfigType(r);
            msConfigQueryRequest.setSalesbillType(queryRequest.getSalesbillType());
            msConfigQueryRequest.setPageNo(Integer.valueOf(1));
            msConfigQueryRequest.setPageSize(Integer.valueOf(1));
            MsConfigResponse response2 = this.queryConfig(msConfigQueryRequest);
            if (Response.OK.equals(response2.getCode())) {
                return response2;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msResponseList)) {
            return configInfo;
        }
        List itemDTOLists = msResponseList.stream().filter(response2 -> Objects.nonNull(response2) && Objects.nonNull(response2.getResult()) && CollectionUtils.isNotEmpty((Collection)response2.getResult().getItemDTOList())).flatMap(r -> r.getResult().getItemDTOList().stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemDTOLists)) {
            return configInfo;
        }
        Optional<Long> sysConfigOptional = itemDTOLists.stream().filter(item -> Objects.nonNull(item) && ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType().intValue() == item.getConfigType().intValue()).map(MsConfigBean::getConfigId).findFirst();
        if (sysConfigOptional.isPresent()) {
            Long configId = sysConfigOptional.get();
            MsConfigItemQueryRequest msConfigItemQueryRequest = new MsConfigItemQueryRequest();
            msConfigItemQueryRequest.setConfigId(String.valueOf(configId));
            MsConfigItemResponse msConfigItemResponse = this.msConfigController.queryConfigDetailRule(msConfigItemQueryRequest);
            String taxInvoiceSource = Optional.ofNullable(msConfigItemResponse.getResult()).flatMap(r -> r.stream().filter(t -> StringUtils.equals((CharSequence)t.getConfigItemName(), (CharSequence)"taxInvoiceSource")).findFirst()).filter(r -> CollectionUtils.isNotEmpty((Collection)r.getConfigItemValue())).map(r -> (String)r.getConfigItemValue().get(0)).orElse("");
            if (StringUtils.equals((CharSequence)taxInvoiceSource, (CharSequence)TaxInvoiceSource.QD.getValue())) {
                configInfo.setTaxInvoiceSourceType(AliRegisterStatusEnum.QD_REGISTERED.getValue());
            } else {
                configInfo.setTaxInvoiceSourceType(AliRegisterStatusEnum.SK_REGISTERED.getValue());
            }
        }
        if ((invoiceConfigOptional = itemDTOLists.stream().filter(item -> Objects.nonNull(item) && ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType().intValue() == item.getConfigType().intValue()).map(MsConfigBean::getConfigId).findFirst()).isPresent()) {
            configInfo.setMultiTitleConfig(AliRulesIsConfigEnum.CONFIGURED.getValue());
        }
        if ((invoiceUserConfigOptional = itemDTOLists.stream().filter(item -> Objects.nonNull(item) && ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType().intValue() == item.getConfigType().intValue()).map(MsConfigBean::getConfigId).findFirst()).isPresent()) {
            configInfo.setInvoicePersonConfig(AliRulesIsConfigEnum.CONFIGURED.getValue());
        }
        return configInfo;
    }

    @ApiOperation(value="\u67e5\u8be2\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/batchQueryQianNiuConfig"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse<List<QianNiuConfigInfo>> batchQueryQianNiuConfig(@ApiParam(value="\u67e5\u8be2\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", required=true) @RequestBody BatchQueryQianniuConfigRequest request) {
        if (Optional.ofNullable(this.userInfoHolder.get()).map(UserInfo::getGroupId).orElse(0L) == 0L) {
            MsResponse msResponse = new MsResponse();
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return msResponse;
        }
        if (Objects.isNull(request) || StringUtils.isBlank((CharSequence)request.getSellerTaxNo()) || CollectionUtils.isEmpty((Collection)request.getConfigTypeList()) || Objects.isNull(request.getStatus()) || CollectionUtils.isEmpty((Collection)request.getSalesbillTypeList())) {
            MsResponse msResponse = new MsResponse();
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u9500\u65b9\u7a0e\u53f7\u3001\u89c4\u5219\u7c7b\u578b\u3001\u72b6\u6001\u53ca\u4e1a\u52a1\u5355\u7c7b\u578b\u5747\u4e3a\u5fc5\u586b\u53c2\u6570!");
            return msResponse;
        }
        boolean configTypeIsNull = request.getConfigTypeList().stream().anyMatch(Objects::isNull);
        if (configTypeIsNull) {
            MsResponse msResponse = new MsResponse();
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a!");
            return msResponse;
        }
        if (request.getSalesbillTypeList().stream().anyMatch(StringUtils::isBlank)) {
            MsResponse msResponse = new MsResponse();
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a!");
            return msResponse;
        }
        List resultList = request.getSalesbillTypeList().stream().map(salesbillType -> {
            QianNiuConfigQueryRequest singleRequest = new QianNiuConfigQueryRequest();
            singleRequest.setSalesbillType(salesbillType);
            singleRequest.setConfigTypeList(request.getConfigTypeList());
            singleRequest.setSellerTaxNo(request.getSellerTaxNo());
            singleRequest.setStatus(request.getStatus());
            return this.querySingleQianniuConfig(singleRequest);
        }).collect(Collectors.toList());
        MsResponse msResponse = new MsResponse();
        msResponse.setCode(Response.OK);
        msResponse.setResult(resultList);
        msResponse.setMessage("\u6210\u529f");
        return msResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/updateQianNiuConfig"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse updateQianNiuConfig(@ApiParam(value="\u4fee\u6539\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", required=true) @RequestBody QianNiuConfigUpdateRequest updateRequest) {
        if (Optional.ofNullable(this.userInfoHolder.get()).map(UserInfo::getGroupId).orElse(0L) == 0L) {
            return MsResponse.error((String)"\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        }
        if (StringUtils.isBlank((CharSequence)updateRequest.getSellerTaxNo()) || Objects.isNull(updateRequest.getConfigType()) || Objects.isNull(updateRequest.getStatus()) || StringUtils.isBlank((CharSequence)updateRequest.getSalesbillType()) || StringUtils.isBlank((CharSequence)updateRequest.getTaxInvoiceSource())) {
            return MsResponse.error((String)"\u9500\u65b9\u7a0e\u53f7\u3001\u89c4\u5219\u7c7b\u578b\u3001\u72b6\u6001\u53ca\u4e1a\u52a1\u5355\u7c7b\u578b\u5747\u4e3a\u5fc5\u586b\u53c2\u6570!");
        }
        Optional optionalTaxInvoiceSource = ValueEnum.getEnumByValue(TaxInvoiceSource.class, (Object)updateRequest.getTaxInvoiceSource());
        if (!optionalTaxInvoiceSource.isPresent()) {
            return MsResponse.error((String)"\u56fd\u7a0e\u6765\u6e90\u53c2\u6570\u9519\u8bef, taxInvoiceSource\u53c2\u6570\u3010sk\u3011\u6216\u3010qd\u3011\uff01");
        }
        MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
        msConfigQueryRequest.setStatus(updateRequest.getStatus());
        msConfigQueryRequest.setSellerTaxNo(updateRequest.getSellerTaxNo());
        msConfigQueryRequest.setConfigType(updateRequest.getConfigType());
        msConfigQueryRequest.setSalesbillType(updateRequest.getSalesbillType());
        msConfigQueryRequest.setPageNo(Integer.valueOf(1));
        msConfigQueryRequest.setPageSize(Integer.valueOf(1));
        MsConfigResponse response2 = this.queryConfig(msConfigQueryRequest);
        Long configId = Optional.ofNullable(response2.getResult()).flatMap(r -> r.getItemDTOList().stream().findFirst()).map(MsConfigBean::getConfigId).orElse(0L);
        if (configId == 0L) {
            return MsResponse.error((String)AliRegisterStatusEnum.UN_REGISTERED.desc);
        }
        MsConfigItemQueryRequest msConfigItemQueryRequest = new MsConfigItemQueryRequest();
        msConfigItemQueryRequest.setConfigId(String.valueOf(configId));
        List result = this.configInfoFacade.queryConfigItemList(msConfigItemQueryRequest);
        Optional optionalMsConfigItemBean = Optional.ofNullable(result).flatMap(r -> r.stream().filter(t -> StringUtils.equals((CharSequence)t.getConfigItemName(), (CharSequence)"taxInvoiceSource")).findFirst());
        if (!optionalMsConfigItemBean.isPresent()) {
            return MsResponse.error((String)"\u56fd\u7a0e\u6765\u6e90\u914d\u7f6e\u9879\u4e0d\u5b58\u5728, \u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5165\u4f4f.");
        }
        Long configItemId = ((MsConfigItemBean)optionalMsConfigItemBean.get()).getConfigItemId();
        int updateRet = this.configInfoFacade.upateConfigItemInfo(configItemId, (List)Lists.newArrayList((Object[])new String[]{((TaxInvoiceSource)optionalTaxInvoiceSource.get()).getValue()}));
        if (updateRet > 0) {
            return MsResponse.ok((Object)"\u4fee\u6539\u6210\u529f");
        }
        return MsResponse.ok((Object)"\u4fee\u6539\u5931\u8d25");
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/batchUpdateConfigItem"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse batchUpdateConfigItem(@ApiParam(value="\u6279\u91cf\u4fee\u6539\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u56fd\u7a0e\u6765\u6e90", required=true) @RequestBody QianNiuConfigBatchUpdateRequest updateRequest) {
        if (Optional.ofNullable(this.userInfoHolder.get()).map(UserInfo::getGroupId).orElse(0L) == 0L) {
            return MsResponse.error((String)"\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        }
        Optional optionalTaxInvoiceSource = ValueEnum.getEnumByValue(TaxInvoiceSource.class, (Object)updateRequest.getTaxInvoiceSource());
        if (!optionalTaxInvoiceSource.isPresent()) {
            return MsResponse.error((String)"\u56fd\u7a0e\u6765\u6e90\u53c2\u6570\u9519\u8bef, taxInvoiceSource\u53c2\u6570\u3010sk\u3011\u6216\u3010qd\u3011\uff01");
        }
        if (StringUtils.isBlank((CharSequence)updateRequest.getSellerTaxNo())) {
            return MsResponse.error((String)"\u9500\u65b9\u7a0e\u53f7\u4e3a\u5fc5\u586b\u53c2\u6570!");
        }
        Either billTypeResult = this.configInfoFacade.queryChannelSalesbillType(Integer.valueOf(0));
        if (billTypeResult.isLeft()) {
            return MsResponse.error((String)((String)billTypeResult.getLeft()));
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)billTypeResult.get()))) {
            return MsResponse.error((String)"\u5f53\u524d\u79df\u6237\u4e0b\u65e0\u6709\u6548\u7684\u4e1a\u52a1\u5355\u7c7b\u578b!");
        }
        Either eitherResult = this.configInfoFacade.queryConfigItemIdList((List)billTypeResult.get(), ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType(), Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        if (eitherResult.isLeft()) {
            return MsResponse.error((String)((String)eitherResult.getLeft()));
        }
        int updateRet = this.configInfoFacade.batchUpateConfigItemInfo((List)eitherResult.get(), (List)Lists.newArrayList((Object[])new String[]{((TaxInvoiceSource)optionalTaxInvoiceSource.get()).getValue()}));
        if (updateRet > 0) {
            return MsResponse.ok((Object)"\u4fee\u6539\u6210\u529f");
        }
        return MsResponse.error((String)"\u4fee\u6539\u5931\u8d25");
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/saveConfig"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse saveConfig(@ApiParam(value="\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e", required=true) @RequestBody MsConfigAddRequest msConfigAddRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsResponse response2 = new MsResponse();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
        msConfigAddRequestWithUserInfo.setItemDTOList(msConfigAddRequest.getItemDTOList());
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigAddRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigController.saveConfigRule(msConfigAddRequestWithUserInfo);
    }

    @ApiOperation(value="\u540c\u6b65\u7528\u6237\u4e2d\u5fc3\u5f00\u7968\u9650\u989d", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/invoiceLimit"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse getInvoiceLimit(@ApiParam(value="\u540c\u6b65\u7528\u6237\u4e2d\u5fc3\u5f00\u7968\u9650\u989d", required=true) @RequestBody InvoiceLimitRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsResponse response2 = new MsResponse();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        request.setTenantId(Long.valueOf(userInfo.getGroupId()));
        return this.msConfigController.getInvoiceLimit(request);
    }

    @ApiOperation(value="\u3010\u96f6\u552e\u3011\u9500\u65b9\u4fe1\u606f\u7f16\u8f91", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/seller/edit"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse editOrAdd(@RequestBody ConfigSellerInfoEditRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsResponse response2 = new MsResponse();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        log.info("editOrAdd request: {}", (Object)JsonUtils.toJson((Object)request));
        MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
        MsConfigBean config = this.configConverter.convert(request, userInfo);
        List itemList = this.configConverter.convert(request);
        config.setItemList(itemList);
        log.info("editOrAdd converter request: {}", (Object)JsonUtils.toJson((Object)config));
        msConfigAddRequestWithUserInfo.setItemDTOList(Collections.singletonList(config));
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigAddRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigController.saveConfigRule(msConfigAddRequestWithUserInfo);
    }

    @ApiOperation(value="\u3010\u96f6\u552e\u3011\u9500\u65b9\u4fe1\u606f\u83b7\u53d6", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/seller/sellerInfo"}, produces={"application/json"}, method={RequestMethod.GET})
    public Response<ConfigIssueSellerInfoDTO> getSellerInfo(@RequestParam(value="sellerTaxNo") String sellerTaxNo, @RequestParam(value="sysOrgId") Long sysOrgId, @RequestParam(value="salesbillType") String salesbillType) {
        InvoiceInfoRuleDTO baseRuleBean;
        log.info("getSellerInfo sellerTaxNo {} sysOrgId {} salesbillType {} groupId {}", new Object[]{sellerTaxNo, sysOrgId, salesbillType, ((UserInfo)this.userInfoHolder.get()).getGroupId()});
        if (StringUtils.isEmpty((CharSequence)sellerTaxNo) || Optional.ofNullable(sysOrgId).orElse(0L) <= 0L || StringUtils.isEmpty((CharSequence)salesbillType)) {
            return Response.from((Integer)0, (String)"\u9500\u65b9\u7a0e\u53f7\u3001\u4e1a\u52a1\u5355\u7c7b\u578b\u3001\u7ec4\u7ec7ID\u4e0d\u5408\u6cd5.");
        }
        MsConfigQueryRequest msConfigQueryRequest = this.getMsConfigQueryRequest(sellerTaxNo, sysOrgId, salesbillType, ConfigTypeEnum.INVOICE_CONFIG_TYPE);
        Response msResponse = this.configBizConfigService.getOptimalMatchConfig(msConfigQueryRequest);
        if (null == msResponse || msResponse.getCode().intValue() == Response.Fail.intValue() || null == msResponse.getResult() || JsonUtils.toList((String)((String)msResponse.getResult()), MsConfigItemBean.class).size() != 4) {
            ConfigIssueSellerInfoDTO infoDto = new ConfigIssueSellerInfoDTO();
            UserCenterResponse companyDataResponse = this.userCenterCompanyService.getCompanyByTaxNo(((UserInfo)this.userInfoHolder.get()).getGroupId(), sellerTaxNo);
            log.info("sellerInfo \u67e5\u4e2d\u53f0 {}", (Object)JsonUtils.toJson((Object)companyDataResponse));
            Optional.ofNullable(companyDataResponse.getResult()).ifPresent(r -> {
                infoDto.setSellerAddress(r.getLocationAddr());
                infoDto.setSellerTel(r.getCompanyPhone());
                infoDto.setSellerBankAccount(r.getBankNo());
                infoDto.setSellerBankName(r.getBankName());
            });
            return Response.from((Integer)1, (String)"", (Object)infoDto);
        }
        String itemListString = (String)msResponse.getResult();
        List msConfigItemBeanList = JsonUtils.toList((String)itemListString, MsConfigItemBean.class);
        InvoiceInfoRuleDTO invoiceInfoRuleDTO = baseRuleBean = this.invoiceInfoRlueParser.parse(msConfigItemBeanList);
        ConfigIssueSellerInfoDTO dto = new ConfigIssueSellerInfoDTO();
        BeanUtils.copyProperties((Object)invoiceInfoRuleDTO, (Object)dto);
        return Response.from((Integer)1, (String)"", (Object)dto);
    }

    private MsConfigQueryRequest getMsConfigQueryRequest(String sellerTaxNo, Long sysOrgId, String salesbillType, ConfigTypeEnum configTypeEnum) {
        MsConfigQueryRequest request = new MsConfigQueryRequest();
        Integer configType = configTypeEnum.getConfigType();
        request.setConfigType(configType);
        request.setBusinessBillType("AR");
        request.setSalesbillType(salesbillType);
        request.setSellerGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        request.setSellerTaxNo(sellerTaxNo);
        request.setSysOrgId(sysOrgId);
        request.setPurchaserGroupId(Long.valueOf(0L));
        request.setPurchaserNo("");
        request.setPurchaserName("");
        request.setPurchaserTaxNo("");
        request.setApiVersion(Integer.valueOf(1));
        return request;
    }

    @ApiOperation(value="\u3010\u96f6\u552e\u3011\u7968\u9762\u4eba\u5458\u7f16\u8f91", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/personal/edit"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response editOrAddIssueInfo(@RequestBody ConfigIssueInfoEditRequest request) {
        log.info("editOrAddIssueInfo request {}", (Object)JsonUtils.toJson((Object)request));
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Response response2 = new Response();
        response2.setCode(Response.Fail);
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        if (StringUtils.equalsAny((CharSequence)"", (CharSequence[])new CharSequence[]{Optional.ofNullable(request.getCompanyTaxNo()).orElse(""), Optional.ofNullable(request.getInvoicerName()).orElse("")})) {
            response2.setMessage("\u516c\u53f8\u7a0e\u53f7\u3001\u5f00\u7968\u4eba\u4e0d\u80fd\u4e3a\u7a7a.");
            return response2;
        }
        if (!NumberUtils.isDigits((String)Optional.ofNullable(request.getSysOrgId()).orElse(""))) {
            response2.setMessage("\u7ec4\u7ec7Id\u4e0d\u6b63\u786e.");
            return response2;
        }
        Either either = this.configInfoFacade.editOrAdd(request);
        response2 = either.isRight() ? Response.from((Integer)1, (String)((String)either.get())) : Response.from((Integer)0, (String)((String)either.getLeft()));
        return response2;
    }

    @ApiOperation(value="\u3010\u96f6\u552e\u3011\u5f00\u7968\u4eba\u83b7\u53d6", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/personal/query"}, produces={"application/json"}, method={RequestMethod.GET})
    public Response<ConfigIssueUserInfoDTO> getIssueUserInfo(@RequestParam(value="sellerTaxNo") String sellerTaxNo, @RequestParam(value="sysOrgId") Long sysOrgId, @RequestParam(value="billType") String billType) {
        InvoiceInfoRuleDTO baseRuleBean;
        log.info("getSellerInfo sellerTaxNo {} sysOrgId {} salesbillType {}", new Object[]{sellerTaxNo, sysOrgId, billType});
        Response response2 = new Response();
        response2.setCode(Response.OK);
        if (StringUtils.isEmpty((CharSequence)sellerTaxNo) || Optional.ofNullable(sysOrgId).orElse(0L) <= 0L) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u516c\u53f8\u7a0e\u53f7\u3001\u7ec4\u7ec7ID\u4e0d\u5408\u6cd5.");
            return response2;
        }
        ConfigIssueUserInfoDTO dto = this.configInfoFacade.queryOwnerIssueInfo(sellerTaxNo, sysOrgId);
        if (null != dto) {
            log.info("getIssueUserInfo dto \u67e5\u4e2a\u4eba\u914d\u7f6e\u5e93 {}", (Object)JsonUtils.toJson((Object)dto));
            response2.setResult((Object)dto);
            return response2;
        }
        MsConfigQueryRequest msConfigQueryRequest = this.getMsConfigQueryRequest(sellerTaxNo, sysOrgId, billType, ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE);
        Response msResponse = this.configBizConfigService.getOptimalMatchConfig(msConfigQueryRequest);
        if (null == msResponse.getResult()) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u672a\u67e5\u8be2\u5230\u7968\u9762\u4eba\u5458\u4fe1\u606f.");
            return response2;
        }
        String itemListString = (String)msResponse.getResult();
        List msConfigItemBeanList = JsonUtils.toList((String)itemListString, MsConfigItemBean.class);
        InvoiceInfoRuleDTO invoiceInfoRuleDTO = baseRuleBean = this.invoiceInfoRlueParser.parse(msConfigItemBeanList);
        dto = new ConfigIssueUserInfoDTO();
        dto.setCashierName(Optional.ofNullable(invoiceInfoRuleDTO.getCashierName()).orElse(""));
        dto.setInvoicerName(Optional.ofNullable(invoiceInfoRuleDTO.getInvoicerName()).orElse(""));
        dto.setCheckerName(Optional.ofNullable(invoiceInfoRuleDTO.getCheckerName()).orElse(""));
        response2.setResult((Object)dto);
        return response2;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\u6839\u636e\u5bfc\u5165\u7ed3\u679c\u56de\u6eaf", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/saveConfig/importBatchNo"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse saveConfigsByImportBatchNo(@ApiParam(value="\u5bfc\u5165\u6279\u6b21\u53f7") @RequestParam(value="batchNo", required=false) String batchNo, @ApiParam(value="\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e", required=true) @RequestBody MsConfigAddRequest msConfigAddRequest) {
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return MsResponse.error((String)"batchNo \u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        this.configImportAfter.saveConfigs(batchNo, msConfigAddRequest, msCommonUserInfo);
        return MsResponse.ok(null);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u4e0b\u4e34\u65f6\u7684\u914d\u7f6e", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/queryTempConfig"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsTmpConfigResponse queryTempConfig(@ApiParam(value="\u67e5\u8be2\u7528\u6237\u4e0b\u4e34\u65f6\u7684\u914d\u7f6e", required=true) @RequestBody ConfigItemDTO TempConfigQureyRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsTmpConfigAddRequest msTmpConfigQueryRequest = this.itemAssemble.convert2TmpConfigItemRequest(TempConfigQureyRequest);
        msTmpConfigQueryRequest.setUserId(Long.valueOf(userInfo.getUserId()));
        return this.msConfigTempController.saveTmpConfigRule(msTmpConfigQueryRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u6458\u8981", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/queryConfigSummary"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsConfigSummaryResponse queryConfigSummary(@ApiParam(value="\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u6458\u8981\u6807\u7b7e", required=true) @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsConfigSummaryResponse response2 = new MsConfigSummaryResponse();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        if (msConfigQueryRequest.getConfigType() == null) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u89c4\u5219\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return response2;
        }
        MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo = MsConfigQueryRequestTranslater.msConfigQueryRequest2MsConfigQueryRequestWithUser((MsConfigQueryRequest)msConfigQueryRequest);
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigQueryRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigController.queryConfigSummary(msConfigQueryRequestWithUserInfo);
    }

    @ApiOperation(value="\u914d\u7f6e\u5220\u9664", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/deleteConfig"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse deleteConfig(@ApiParam(value="\u914d\u7f6e\u5220\u9664", required=true) @RequestBody MsConfigDeleteRequst msConfigDeleteRequst) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsConfigDeleteRequstWithUserInfo msConfigDeleteRequstWithUserInfo = new MsConfigDeleteRequstWithUserInfo();
        msConfigDeleteRequstWithUserInfo.setConfigIdList(msConfigDeleteRequst.getConfigIdList());
        msConfigDeleteRequstWithUserInfo.setConfigType(msConfigDeleteRequst.getConfigType());
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msConfigDeleteRequstWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigController.deleteConfig(msConfigDeleteRequstWithUserInfo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f00\u7968\u90ae\u4ef6\u63a8\u9001\u89c4\u5219", notes="", response=MsConfigResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfig"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsConfigResponse.class)})
    @RequestMapping(value={"/queryConfigMailRule"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsConfigMailRuleResponse queryConfigMailRule(@ApiParam(value="\u67e5\u8be2\u5f00\u7968\u63a8\u9001\u89c4\u5219", required=true) @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        return this.msConfigController.queryConfigMailRule(msCommonUserInfo, msConfigQueryRequest);
    }

    @GetMapping(value={"/permitted/companies"})
    public Response<List<CompanyData>> getPermittedCompanies() {
        Either result = this.generalService.queryPermittedCompanies();
        if (result.isRight()) {
            return Response.from((Integer)1, (String)"\u6210\u529f", (Object)result.get());
        }
        return Response.from((Integer)0, (String)((String)result.getLeft()), null);
    }

    @GetMapping(value={"/permitted/devices/{taxNo}"})
    public Response<List<DeviceData>> getPermittedDevices(@PathVariable(value="taxNo") String taxNo) {
        Either result = this.generalService.queryPermittedDevices(taxNo);
        if (result.isRight()) {
            return Response.from((Integer)1, (String)"\u6210\u529f", (Object)result.get());
        }
        return Response.from((Integer)0, (String)((String)result.getLeft()), null);
    }

    @GetMapping(value={"/handle/bill/config/update"})
    public Response<Boolean> handleUpdateBillConfig(@RequestParam(value="templateObjMetadataId") String templateObjMetadataId) {
        Either result = this.configMetaDataServiceKt.updateBillConfigByTemplate(Long.parseLong(templateObjMetadataId));
        if (result.isRight()) {
            return Response.from((Integer)1, (String)"\u6210\u529f", (Object)result.get());
        }
        return Response.from((Integer)0, (String)((String)result.getLeft()), null);
    }

    @PostMapping(value={"/permitted/stores"})
    public Response<PageList<StoreData>> getPermittedStores(@RequestBody QueryStoreListRequest request) {
        Tuple2 tupleResult = this.configCompanyService.queryStores(request);
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)new PageList((Long)tupleResult._1(), (List)tupleResult._2()));
    }

    @GetMapping(value={"/orgs"})
    public Response<List<OrgData>> getOrgByParams(@RequestParam(value="orgCode") String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return Response.from((Integer)Response.Fail, (String)"orgCode\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        OrgQueryParam param = new OrgQueryParam();
        param.setOrgCode(orgCode);
        OrgQueryParam param2 = new OrgQueryParam();
        param2.setOrgNameLike(orgCode);
        List orgDataList = ((Stream)Stream.of(param, param2).parallel()).map(r -> {
            UserCenterResponse orgQueryResponse = this.userCenterOrgService.getOrgByParams(groupId.longValue(), r);
            if (!"1".equals(orgQueryResponse.getCode())) {
                return Lists.newArrayList();
            }
            return Optional.ofNullable(orgQueryResponse.getResult()).map(UserCenterList::getContent).orElse(Lists.newArrayList());
        }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<Long, OrgData> orgMap = orgDataList.stream().collect(Collectors.toMap(OrgData::getOrgId, r -> r));
        orgDataList.stream().filter(r -> OrgType.OtherOrg.value().equals(r.getOrgType()) && (r.getCompanyId() == null || r.getCompanyId() == 0L)).forEach(storeData -> {
            OrgData parentCompanyInfo = this.configCompanyService.getParentCompanyInfo(orgMap, storeData.getParentId(), groupId);
            if (Objects.nonNull(parentCompanyInfo) && OrgType.Company.value().equals(parentCompanyInfo.getOrgType())) {
                storeData.setCompanyName(parentCompanyInfo.getCompanyName());
                storeData.setTaxNum(parentCompanyInfo.getTaxNum());
                storeData.setCompanyId(parentCompanyInfo.getCompanyId());
            }
        });
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", orgDataList);
    }

    @PostMapping(value={"/filter/orgs"})
    public Response<List<FilterRelatedQueryData>> getFilterOrgs(@RequestBody QueryStoreListRequest request) {
        Tuple2 tupleResult = this.configCompanyService.queryStores(request);
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", ((List)tupleResult._2()).stream().map(r -> new FilterRelatedQueryData(r.getStoreName(), String.valueOf(r.getOrgId()))).collect(Collectors.toList()));
    }

    @PostMapping(value={"/export"})
    public Response exportConfig(@ApiParam(value="\u7528\u6237\u67e5\u8be2\u914d\u7f6e") @RequestBody MsConfigQueryRequestWithUserInfo request) {
        if (ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType().equals(request.getConfigType()) || ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType().equals(request.getConfigType()) || ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().equals(request.getConfigType())) {
            this.importReasonTools.exportConfig(request, (UserInfo)this.userInfoHolder.get());
            return Response.ok((String)"\u5bfc\u51fa\u4fe1\u606f\u5df2\u53d1\u9001, \u7a0d\u540e\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b");
        }
        return Response.failed((String)"\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684\u5bfc\u51fa");
    }

    @PostMapping(value={"/discount"})
    public Response queryDiscount(@ApiParam(value="\u67e5\u8be2\u6298\u6263\u7387", required=true) @RequestBody DiscountQueryRequest request) {
        return this.discountRateService.queryDiscount(request);
    }

    @PostMapping(value={"/import"})
    public Response importDiscount(@ApiParam(value="\u67e5\u8be2\u6298\u6263\u7387", required=true) @RequestBody ImportDiscountRequest request) {
        return this.discountRateService.importDiscount(request);
    }

    @PostMapping(value={"/import/template"})
    public Response importTemplate() {
        return this.discountRateService.importTemplate();
    }

    @PostMapping(value={"/delete"})
    public Response deleteDiscount(@ApiParam(value="\u67e5\u8be2\u6298\u6263\u7387", required=true) @RequestBody ConfigItemDeleteRequest request) {
        return this.discountRateService.deleteDiscount(request);
    }

    @PostMapping(value={"match/discount"})
    public Response queryMatchDiscount(@ApiParam(value="\u67e5\u8be2\u6298\u6263\u7387", required=true) @RequestBody DiscountQueryRequest request) {
        return this.discountRateService.queryMatchDiscount(request);
    }

    @GetMapping(value={"/query/channel-salesbillType"})
    public Response<List<String>> queryChannelSalesbillType(@RequestParam(value="objFlag") Integer objFlag) {
        Either eitherResult = this.configInfoFacade.queryChannelSalesbillType(Optional.ofNullable(objFlag).orElse(0));
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }
}

