/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataItemBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeDTO;
import com.xforceplus.seller.config.client.model.MsGroupTypeResponse;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequest;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataDeleteRequest;
import com.xforceplus.seller.config.client.model.MsMataDataDeleteRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataItemDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetaDataResponse;
import com.xforceplus.seller.config.client.model.MsMetaDataSummaryResponse;
import com.xforceplus.seller.config.client.model.MsMetadataItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetadataItemResponse;
import com.xforceplus.seller.config.client.model.MsQueryHighlightFieldListResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.config.annotation.APIV1ConfigMetaData;
import com.xforceplus.seller.config.controllers.service.MsConfigMetaDataController;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.util.UserTranslater;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.Asserts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@APIV1ConfigMetaData
public class ConfigMetaDataController
extends BaseAppController {
    @Autowired
    private ConfigMetaDataService configMetaDataService;
    @Autowired
    MsConfigMetaDataController msConfigMetaDataController;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    @ApiOperation(value="\u67e5\u8be2\u5143\u6570\u636e\u9879", notes="", response=MsMetaDataResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerMetaData"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsMetaDataResponse.class)})
    @RequestMapping(value={"/queryMetaDataObj"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsMetaDataResponse queryMetaDataObj(@ApiParam(value="\u67e5\u8be2\u5143\u6570\u636e\u9879", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        Long groupId = msMataDataQueryRequest.getGroupId();
        if (groupId == null || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
            msMataDataQueryRequest.setGroupId(groupId);
        }
        return this.msConfigMetaDataController.queryMetaData(msMataDataQueryRequest);
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2\u5143\u6570\u636e\u9879", notes="", response=MsResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerMetaData"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsResponse.class)})
    @RequestMapping(value={"/queryMetaDataItemByBusiness"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse<MsBusinessObjMetadataItemBean> queryMetaDataItemByBusiness(@ApiParam(value="\u67e5\u8be2\u5143\u6570\u636e\u9879", required=true) @RequestBody MsMetadataItemQueryRequest request) {
        String objCode = request.getObjCode();
        Asserts.notBlank((CharSequence)objCode, (String)"\u5bf9\u8c61code");
        List businessObjMetadataBeans = this.configMetaDataService.queryTemplateObjMetadataListByCodeAndType(objCode);
        if (CollectionUtils.isEmpty((Collection)businessObjMetadataBeans)) {
            return MsResponse.error((String)"\u5143\u6570\u636e\u4e0d\u5b58\u5728");
        }
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (Objects.isNull(userInfo)) {
            return MsResponse.error((String)"\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MsBusinessObjMetadataItemBean metadataItemBean = new MsBusinessObjMetadataItemBean();
        Long groupId = userInfo.getGroupId();
        List msEnumBeanList = this.configMetaDataService.queryMsEnumBeanList(groupId, request.getSalesbillType());
        if (CollectionUtils.isNotEmpty((Collection)businessObjMetadataBeans)) {
            businessObjMetadataBeans.stream().forEach(msBusinessObjMetadataBean -> {
                if (msBusinessObjMetadataBean.getFieldName().equals("associationCondition")) {
                    if (CollectionUtils.isNotEmpty((Collection)msEnumBeanList)) {
                        msBusinessObjMetadataBean.getFieldEnumValue().addAll(msEnumBeanList);
                    }
                    metadataItemBean.setAssociationFieldEnumValue(msBusinessObjMetadataBean.getFieldEnumValue());
                } else if (msBusinessObjMetadataBean.getFieldName().equals("mergerCondition")) {
                    if (CollectionUtils.isNotEmpty((Collection)msEnumBeanList)) {
                        msBusinessObjMetadataBean.getFieldEnumValue().addAll(msEnumBeanList);
                    }
                    metadataItemBean.setMergerFieldEnumValue(msBusinessObjMetadataBean.getFieldEnumValue());
                } else if (msBusinessObjMetadataBean.getFieldName().equals("secondMergeCondition")) {
                    if (CollectionUtils.isNotEmpty((Collection)msEnumBeanList)) {
                        msBusinessObjMetadataBean.getFieldEnumValue().addAll(msEnumBeanList);
                    }
                    metadataItemBean.setSecondMergeEnumValue(msBusinessObjMetadataBean.getFieldEnumValue());
                }
            });
        }
        return MsResponse.ok((Object)metadataItemBean);
    }

    @ApiOperation(value="\u67e5\u8be2\u6709\u6548\u7684\u5143\u6570\u636e\u9879", notes="", response=MsMetaDataResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerMetaData"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsMetaDataResponse.class)})
    @RequestMapping(value={"/queryEffectiveMetaDataObj"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsMetadataItemResponse queryEffectiveMetaDataObj(@ApiParam(value="\u67e5\u8be2\u5143\u6570\u636e\u9879", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        Long groupId = msMataDataQueryRequest.getGroupId();
        if (groupId == null || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
            msMataDataQueryRequest.setGroupId(groupId);
        }
        Long userId = ((UserInfo)this.userInfoHolder.get()).getUserId();
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryEffectiveMetaDataList(msMataDataQueryRequest, userId);
        MsMetadataItemResponse response2 = new MsMetadataItemResponse();
        response2.setCode(Response.OK);
        response2.setResult(msBusinessObjMetadataBeanList);
        return response2;
    }

    @ApiOperation(value="\u6a21\u677f\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", notes="", response=MsMetadataItemResponse.class, authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")}, tags={"SellerMetaData"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u67e5\u8be2\u54cd\u5e94", response=MsMetadataItemResponse.class)})
    @RequestMapping(value={"/queryTemplateMetaData"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsMetadataItemResponse queryTemplateMetaData(@ApiParam(value="\u67e5\u8be2\u6a21\u677f\u5143\u6570\u636e\u9879\u5217\u8868", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        Long groupId = msMataDataQueryRequest.getGroupId();
        if (groupId == null || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
            msMataDataQueryRequest.setGroupId(groupId);
        }
        return this.msConfigMetaDataController.queryTemplateMetaData(msMataDataQueryRequest);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5143\u6570\u636e\u9879", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerMetaData"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/saveMetaDataObj"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse saveMetaDataObj(@ApiParam(value="\u4fdd\u5b58\u5143\u6570\u636e\u9879", required=true) @RequestBody MsMataDataAddRequest msMataDataAddRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsMataDataAddRequestWithUserInfo msMataDataAddRequestWithUserInfo = new MsMataDataAddRequestWithUserInfo();
        msMataDataAddRequestWithUserInfo.setItemDTOList(msMataDataAddRequest.getItemDTOList());
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msMataDataAddRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigMetaDataController.saveMetaData(msMataDataAddRequestWithUserInfo);
    }

    @ApiOperation(value="\u67e5\u8be2\u516c\u53f8\u4e0b\u7684\u4e1a\u52a1\u7c7b\u578b", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerMetaData"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/queryGroupObjType"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<List<MsEnumBean>> queryGroupObjType(@ApiParam(value="\u4fdd\u5b58\u5143\u6570\u636e\u9879", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        Long group = msMataDataQueryRequest.getGroupId();
        if (group == null || group == 0L) {
            msMataDataQueryRequest.setGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        } else {
            msMataDataQueryRequest.setSkipAuth(Boolean.TRUE);
        }
        MsGroupTypeResponse msGroupTypeResponse = this.msConfigMetaDataController.queryAuthorizationBillTypeList(msMataDataQueryRequest);
        Response response2 = new Response();
        response2.setCode(Response.OK);
        List result = msGroupTypeResponse.getResult();
        List<Object> valueList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            valueList = result.stream().filter(Objects::nonNull).map(arg_0 -> this.tranFromValue(arg_0)).collect(Collectors.toList());
        }
        response2.setResult((Object)valueList);
        return response2;
    }

    private MsEnumBean tranFromValue(MsGroupTypeBean msGroupTypeBean) {
        MsEnumBean msEnumBean = new MsEnumBean();
        msEnumBean.setValue(msGroupTypeBean.getObjId());
        msEnumBean.setText(msGroupTypeBean.getObjType());
        return msEnumBean;
    }

    @ApiOperation(value="\u5143\u6570\u636e\u5220\u9664", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerMetaData"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/deleteMetaData"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsResponse deleteMetaData(@ApiParam(value="\u5143\u6570\u636e\u5220\u9664", required=true) @RequestBody MsMataDataDeleteRequest msMataDataDeleteRequest) {
        MsMataDataDeleteRequestWithUserInfo mataDataDeleteRequestWithUserInfo = new MsMataDataDeleteRequestWithUserInfo();
        mataDataDeleteRequestWithUserInfo.setItems(msMataDataDeleteRequest.getItems());
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)((UserInfo)this.userInfoHolder.get()));
        mataDataDeleteRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        return this.msConfigMetaDataController.metaDataDelete(mataDataDeleteRequestWithUserInfo);
    }

    @ApiOperation(value="\u5143\u6570\u636e\u5bf9\u8c61summary", notes="", response=MsMetaDataSummaryResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"MetaDataDefinitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u67e5\u8be2\u54cd\u5e94", response=MsMetaDataSummaryResponse.class)})
    @RequestMapping(value={"/meta/metaDataSummary"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsMetaDataSummaryResponse metaDataSummary(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61summary", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        mataDataQueryRequest.setGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        return this.msConfigMetaDataController.metaDataSummary(mataDataQueryRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u9ad8\u4eae\u663e\u793a\u7ea6\u675f\u6761\u4ef6List", notes="", response=MsQueryHighlightFieldListResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"MetaDataDefinitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u67e5\u8be2\u54cd\u5e94", response=MsQueryHighlightFieldListResponse.class)})
    @RequestMapping(value={"/meta/queryHighlightFieldList"}, produces={"application/json"}, method={RequestMethod.GET})
    public MsQueryHighlightFieldListResponse queryHighlightFieldList(@NotNull @ApiParam(value="\u6a21\u677f\u7f16\u7801", required=true) @RequestParam(value="objCode", required=true) String objCode, @NotNull @ApiParam(value="\u5355\u636e\u5bf9\u8c61\u7c7b\u578b", required=true) @RequestParam(value="objType", required=true) String objType, @ApiParam(value="\u96c6\u56e2id") @RequestParam(value="groupId", required=false) Long groupId) {
        return this.msConfigMetaDataController.queryHighlightFieldList(objCode, objType, groupId);
    }

    @ApiOperation(value="\u5143\u6570\u636e\u5bf9\u8c61", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"MetaDataDefinitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u67e5\u8be2\u54cd\u5e94", response=Response.class)})
    @RequestMapping(value={"/queryMetaObjMetadata"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response queryMetaObjMetadata(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataItemDataQueryRequest msMataItemDataQueryRequest) {
        return this.msConfigMetaDataController.queryMetaObjMetadata(msMataItemDataQueryRequest);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u5143\u6570\u636e\u5bf9\u8c61", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"MetaDataDefinitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u67e5\u8be2\u54cd\u5e94", response=Response.class)})
    @RequestMapping(value={"/addOrUpdateMetaObjData"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response addOrUpdateMetaObjData(@ApiParam(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u5143\u6570\u636e\u5bf9\u8c61", required=true) @RequestBody MsBusinessObjBean msBusinessObjBean) {
        return this.msConfigMetaDataController.addOrUpdateMetaObjData(msBusinessObjBean);
    }

    @ApiOperation(value="\u7528\u6237\u4e2d\u5fc3\u8c03\u7528\uff1a\u67e5\u8be2\u5143\u6570\u636e", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"MetaDataDefinitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u67e5\u8be2\u54cd\u5e94", response=Response.class)})
    @RequestMapping(value={"/meta/getMetaDataList"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true)})
    public Response<List<MsGroupTypeDTO>> getMetaDataList(Long tenantId) {
        return this.msConfigMetaDataController.getMetaDataList(tenantId, false, false);
    }

    @GetMapping(value={"/init-retail-bill-rule"})
    public Response<Object> initRetailBillRule(@RequestParam(value="billRuleName") String billRuleName) {
        if (StringUtils.isBlank((CharSequence)billRuleName)) {
            return Response.from((Integer)Response.Fail, (String)"\u4e1a\u52a1\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        MsMataDataQueryRequest request = new MsMataDataQueryRequest();
        request.setGroupId(Long.valueOf(userInfo.getGroupId()));
        request.setObjCode("bill");
        List ruleItemList = this.configMetaDataService.queryTemplateMetaDataList(request);
        MsBusinessObjBean bean = new MsBusinessObjBean();
        bean.setObjFlag(Integer.valueOf(1));
        bean.setObjDesc("");
        bean.setObjType(billRuleName);
        bean.setObjName(billRuleName);
        bean.setObjCode("bill");
        ruleItemList.forEach(r -> {
            if ("invoiceType".equals(r.getFieldName()) || "originSalesbillNo".equals(r.getFieldName())) {
                r.setFieldRequired(Integer.valueOf(0));
            }
            if (Objects.isNull(r.getFieldEnumValue())) {
                r.setFieldEnumValue((List)Lists.newArrayList());
            }
        });
        bean.setItems(ruleItemList);
        MsMataDataAddRequestWithUserInfo msMataDataAddRequestWithUserInfo = new MsMataDataAddRequestWithUserInfo();
        msMataDataAddRequestWithUserInfo.setItemDTOList((List)Lists.newArrayList((Object[])new MsBusinessObjBean[]{bean}));
        MsCommonUserInfo msCommonUserInfo = UserTranslater.userInfoTran2CommonUserInfo((UserInfo)userInfo);
        msMataDataAddRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        MsResponse msResponse = this.msConfigMetaDataController.saveMetaData(msMataDataAddRequestWithUserInfo);
        return Response.from((Integer)msResponse.getCode(), (String)msResponse.getMessage(), null);
    }
}

