/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.xforceplus.seller.config.client.api.InvoiceSplitConfigApi;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsConfigBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.SysInfoRuleParser;
import com.xforceplus.seller.config.config.annotation.APIV1Config;
import com.xforceplus.seller.config.facade.ConfigMatchingFacade;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.util.StringUtil;
import com.xforceplus.seller.enums.BusinessBillType;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.swagger.annotations.ApiParam;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;

@APIV1Config
public class ConfigQueryController
implements InvoiceSplitConfigApi {
    private static final Logger logger = LoggerFactory.getLogger(ConfigQueryController.class);
    @Autowired
    private ConfigBizConfigService configBizConfigService;
    @Autowired
    private ConfigMatchingFacade configMatchingFacade;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private ConfigMetaDataService configMetaDataService;
    @Autowired
    private SysInfoRuleParser sysInfoRuleParser;
    @Value(value="${manual.invoiceTitle.source}")
    private String manualInvoiceTitleSource;

    public MsResponse queryAllSysConfig(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u5168\u90e8\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        if (logger.isInfoEnabled()) {
            logger.info("@queryAllSysConfig invoiceTypeList====>{}", (Object)msConfigQueryRequest.getInvoiceType().toString());
        }
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Response response2 = this.configBizConfigService.getOriginalMatchedCfgs(msConfigQueryRequest);
        msResponse.setCode(response2.getCode());
        msResponse.setResult(response2.getResult());
        logger.info("@queryAllSysConfig msResponse====>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msResponse));
        return msResponse;
    }

    public MsResponse<Map<String, List<String>>> batchQueryOptimalMatchConfig(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u5168\u90e8\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigBatchQueryRequest request) {
        List queryList = request.getQueryList();
        MsResponse msResponse = new MsResponse();
        if (CollectionUtils.isEmpty((Collection)queryList)) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u6279\u91cf\u67e5\u8be2\u89c4\u5219\u5165\u53c2\u4e3a\u7a7a");
            return msResponse;
        }
        Map result = queryList.parallelStream().map(r -> Tuple.of((Object)r.getSerialNo(), Optional.ofNullable(this.getOptimalMatchConfigNew(r.getRequest()).getResult()).map(JsonUtils::writeObjectToFastJson).orElse(null))).collect(Collectors.groupingBy(Tuple2::_2, Collectors.mapping(Tuple2::_1, Collectors.toList())));
        msResponse.setCode(Response.OK);
        msResponse.setResult(result);
        return msResponse;
    }

    public MsResponse<MsConfigBean> getOptimalMatchConfigNew(MsConfigQueryRequest msConfigQueryRequest) {
        if (logger.isInfoEnabled()) {
            logger.info("@getOptimalMatchConfig invoiceTypeList====> " + msConfigQueryRequest.getInvoiceType().toString());
        }
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Integer apiVersion = msConfigQueryRequest.getApiVersion();
        if (null == apiVersion) {
            apiVersion = 3;
        }
        logger.info("getOptimalMatchConfig msConfigQueryRequest {}", (Object)StringUtil.describeBean((Object)msConfigQueryRequest));
        MsConfigBean msConfigBean = 3 == apiVersion ? this.configBizConfigService.getOptimalMatchConfigWithAttrNew(msConfigQueryRequest) : null;
        msResponse.setCode(msConfigBean == null ? Response.Fail : Response.OK);
        msResponse.setResult((Object)msConfigBean);
        logger.info("getOptimalMatchConfig response {}", (Object)StringUtil.describeBean((Object)msResponse.getResult()));
        return msResponse;
    }

    public MsResponse getOptimalMatchConfig(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u6700\u4f18\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        if (logger.isInfoEnabled()) {
            logger.info("@getOptimalMatchConfig invoiceTypeList====> " + msConfigQueryRequest.getInvoiceType().toString());
        }
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Integer apiVersion = msConfigQueryRequest.getApiVersion();
        if (null == apiVersion) {
            apiVersion = 3;
        }
        Response response2 = null;
        logger.info("getOptimalMatchConfig msConfigQueryRequest {}", (Object)StringUtil.describeBean((Object)msConfigQueryRequest));
        switch (apiVersion) {
            case 1: {
                response2 = this.configBizConfigService.getOptimalMatchConfig(msConfigQueryRequest);
                break;
            }
            case 2: {
                response2 = this.configBizConfigService.getOriginalCfgs(msConfigQueryRequest);
                break;
            }
            case 3: {
                response2 = this.configBizConfigService.getOptimalMatchConfigWithAttr(msConfigQueryRequest);
                break;
            }
            case 4: {
                response2 = this.configBizConfigService.getOptimalMatchConfigNullable(msConfigQueryRequest);
                break;
            }
            case 5: {
                response2 = this.configBizConfigService.getOptimalMatchConfigWithAttrOfEmail(msConfigQueryRequest);
                break;
            }
            default: {
                response2 = this.configBizConfigService.getOptimalMatchConfigWithAttr(msConfigQueryRequest);
            }
        }
        msResponse.setCode(response2.getCode());
        msResponse.setResult(response2.getResult());
        logger.debug("getOptimalMatchConfig response {}", (Object)StringUtil.describeBean((Object)response2.getResult()));
        return msResponse;
    }

    public MsResponse getOrderOptimalMatchConfig(@RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        Integer apiVersion;
        Long groupId = msConfigQueryRequest.getSellerGroupId();
        if (groupId == null || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        }
        if (null == (apiVersion = msConfigQueryRequest.getApiVersion())) {
            msConfigQueryRequest.setApiVersion(Integer.valueOf(3));
        }
        MsMataDataQueryRequest dataQueryRequest = new MsMataDataQueryRequest();
        dataQueryRequest.setGroupId(groupId);
        dataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
        dataQueryRequest.setPageNo(Integer.valueOf(1));
        dataQueryRequest.setPageSize(Integer.valueOf(5));
        dataQueryRequest.setObjStatus(Integer.valueOf(1));
        dataQueryRequest.setObjFlag(Integer.valueOf(1));
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(dataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjEntities)) {
            return MsResponse.ok(null);
        }
        CfgBusinessObjEntity objEntity = (CfgBusinessObjEntity)cfgBusinessObjEntities.get(0);
        msConfigQueryRequest.setSalesbillType(objEntity.getObjType());
        msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
        msConfigQueryRequest.setSellerGroupId(groupId);
        MsResponse msResponse = new MsResponse();
        if (CollectionUtils.isEmpty((Collection)msConfigQueryRequest.getConfigTypeList())) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        ArrayList<MsResponse> msResponseList = new ArrayList<MsResponse>();
        for (Object configType : msConfigQueryRequest.getConfigTypeList()) {
            msConfigQueryRequest.setConfigType((Integer)configType);
            MsResponse response2 = this.getOptimalMatchConfig(msConfigQueryRequest);
            response2.setSalesbillType(objEntity.getObjType());
            if (!Response.OK.equals(response2.getCode())) continue;
            msResponseList.add(response2);
        }
        if (CollectionUtils.isEmpty(msResponseList)) {
            msResponse.setSalesbillType(objEntity.getObjType());
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return msResponse;
        }
        msResponse = (MsResponse)msResponseList.get(0);
        if (msConfigQueryRequest.getApiVersion() == null || 1 == msConfigQueryRequest.getApiVersion() || 3 == msConfigQueryRequest.getApiVersion()) {
            ArrayList allItemList = new ArrayList();
            for (MsResponse response2 : msResponseList) {
                String itemListString = (String)response2.getResult();
                List itemList = JsonUtils.writeJsonToListObject((String)itemListString, MsConfigItemBean.class);
                logger.info("@itemList {}", (Object)JsonUtils.writeObjectToFastJson((Object)itemList));
                allItemList.addAll(itemList);
            }
            SysInfoRuleDTO baseRuleBean = this.sysInfoRuleParser.parse(allItemList);
            if (this.manualInvoiceTitleSource.contains(String.valueOf(groupId))) {
                baseRuleBean.setManualInvoiceTitleSource("0");
            } else {
                baseRuleBean.setManualInvoiceTitleSource("1");
            }
            msResponse.setResult((Object)baseRuleBean);
        }
        return msResponse;
    }

    public MsResponse<String> getOptimalMatchConfigList(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u6700\u4f18\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        String resultJson;
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Integer apiVersion = msConfigQueryRequest.getApiVersion();
        if (null == apiVersion) {
            apiVersion = 3;
        }
        logger.info("getOptimalMatchConfigList msConfigQueryRequest {}", (Object)StringUtil.describeBean((Object)msConfigQueryRequest));
        switch (apiVersion) {
            case 5: {
                resultJson = this.configMatchingFacade.getOptimalMatchConfigForEmail(msConfigQueryRequest);
                break;
            }
            default: {
                resultJson = null;
            }
        }
        msResponse.setCode(Response.OK);
        msResponse.setResult((Object)resultJson);
        logger.info("getOptimalMatchConfigList response {}", (Object)resultJson);
        return msResponse;
    }

    public MsResponse<List<InvoiceInfoRuleDTO>> getSellerIssueInfoConfig(@ApiParam(value="\u7968\u9762\u4fe1\u606f\u83b7\u53d6") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        MsResponse msResponse = new MsResponse();
        msResponse.setResult((Object)this.configMatchingFacade.getSellerIssueInfoConfig(msConfigQueryRequest));
        return msResponse;
    }

    public MsResponse<List<MsConfigBean>> getConfigByTenantId(MsConfigQueryRequest msConfigQueryRequest) {
        return null;
    }

    public MsResponse<Boolean> getAllowAddIssuerConfig(@ApiParam(value="\u67e5\u8be2\u6dfb\u52a0\u5f00\u7968\u4eba\u6743\u9650\uff08\u9875\u9762\u5f00\u5177\u3001\u7ea2\u51b2\u573a\u666f\uff09") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        MsResponse msResponse = new MsResponse();
        msResponse.setCode(Response.OK);
        Either eitherResult = this.configBizConfigService.getAllowAddIssuerConfig(msConfigQueryRequest);
        if (eitherResult.isRight()) {
            msResponse.setResult(eitherResult.get());
            return msResponse;
        }
        msResponse.setCode(Response.Fail);
        msResponse.setMessage((String)eitherResult.getLeft());
        return msResponse;
    }
}

